/*
 * Copyright 2019 Xilinx Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Filename: input.hpp
 *
 * Description:
 * This network is used to detecting objects from a input image.
 *
 * Please refer to document "xilinx_XILINX_AI_SDK_user_guide.pdf" for more
 * details of these APIs.
 */
#include <iostream>
#include <vector>

static inline std::vector<float> input0 ={-1.0, -1.0, -0.974684, -1.0, -0.949367, -1.0, -0.924051, -1.0, -0.898734, -1.0, -0.873418, -1.0, -0.848101, -1.0, -0.822785, -1.0, 
-0.797468, -1.0, -0.772152, -1.0, -0.746835, -1.0, -0.721519, -1.0, -0.696203, -1.0, -0.670886, -1.0, -0.64557, -1.0, -0.620253, -1.0, 
-0.594937, -1.0, -0.56962, -1.0, -0.544304, -1.0, -0.518987, -1.0, -0.493671, -1.0, -0.468354, -1.0, -0.443038, -1.0, -0.417722, -1.0, 
-0.392405, -1.0, -0.367089, -1.0, -0.341772, -1.0, -0.316456, -1.0, -0.291139, -1.0, -0.265823, -1.0, -0.240506, -1.0, -0.21519, -1.0, 
-0.189873, -1.0, -0.164557, -1.0, -0.13924, -1.0, -0.113924, -1.0, -0.088608, -1.0, -0.063291, -1.0, -0.037975, -1.0, -0.012658, -1.0, 
0.012658, -1.0, 0.037975, -1.0, 0.063291, -1.0, 0.088608, -1.0, 0.113924, -1.0, 0.13924, -1.0, 0.164557, -1.0, 0.189873, -1.0, 
0.21519, -1.0, 0.240506, -1.0, 0.265823, -1.0, 0.291139, -1.0, 0.316456, -1.0, 0.341772, -1.0, 0.367089, -1.0, 0.392405, -1.0, 
0.417722, -1.0, 0.443038, -1.0, 0.468354, -1.0, 0.493671, -1.0, 0.518987, -1.0, 0.544304, -1.0, 0.56962, -1.0, 0.594937, -1.0, 
0.620253, -1.0, 0.64557, -1.0, 0.670886, -1.0, 0.696203, -1.0, 0.721519, -1.0, 0.746835, -1.0, 0.772152, -1.0, 0.797468, -1.0, 
0.822785, -1.0, 0.848101, -1.0, 0.873418, -1.0, 0.898734, -1.0, 0.924051, -1.0, 0.949367, -1.0, 0.974684, -1.0, 1.0, -1.0, 
-1.0, -0.974684, -0.974684, -0.974684, -0.949367, -0.974684, -0.924051, -0.974684, -0.898734, -0.974684, -0.873418, -0.974684, -0.848101, -0.974684, -0.822785, -0.974684, 
-0.797468, -0.974684, -0.772152, -0.974684, -0.746835, -0.974684, -0.721519, -0.974684, -0.696203, -0.974684, -0.670886, -0.974684, -0.64557, -0.974684, -0.620253, -0.974684, 
-0.594937, -0.974684, -0.56962, -0.974684, -0.544304, -0.974684, -0.518987, -0.974684, -0.493671, -0.974684, -0.468354, -0.974684, -0.443038, -0.974684, -0.417722, -0.974684, 
-0.392405, -0.974684, -0.367089, -0.974684, -0.341772, -0.974684, -0.316456, -0.974684, -0.291139, -0.974684, -0.265823, -0.974684, -0.240506, -0.974684, -0.21519, -0.974684, 
-0.189873, -0.974684, -0.164557, -0.974684, -0.13924, -0.974684, -0.113924, -0.974684, -0.088608, -0.974684, -0.063291, -0.974684, -0.037975, -0.974684, -0.012658, -0.974684, 
0.012658, -0.974684, 0.037975, -0.974684, 0.063291, -0.974684, 0.088608, -0.974684, 0.113924, -0.974684, 0.13924, -0.974684, 0.164557, -0.974684, 0.189873, -0.974684, 
0.21519, -0.974684, 0.240506, -0.974684, 0.265823, -0.974684, 0.291139, -0.974684, 0.316456, -0.974684, 0.341772, -0.974684, 0.367089, -0.974684, 0.392405, -0.974684, 
0.417722, -0.974684, 0.443038, -0.974684, 0.468354, -0.974684, 0.493671, -0.974684, 0.518987, -0.974684, 0.544304, -0.974684, 0.56962, -0.974684, 0.594937, -0.974684, 
0.620253, -0.974684, 0.64557, -0.974684, 0.670886, -0.974684, 0.696203, -0.974684, 0.721519, -0.974684, 0.746835, -0.974684, 0.772152, -0.974684, 0.797468, -0.974684, 
0.822785, -0.974684, 0.848101, -0.974684, 0.873418, -0.974684, 0.898734, -0.974684, 0.924051, -0.974684, 0.949367, -0.974684, 0.974684, -0.974684, 1.0, -0.974684, 
-1.0, -0.949367, -0.974684, -0.949367, -0.949367, -0.949367, -0.924051, -0.949367, -0.898734, -0.949367, -0.873418, -0.949367, -0.848101, -0.949367, -0.822785, -0.949367, 
-0.797468, -0.949367, -0.772152, -0.949367, -0.746835, -0.949367, -0.721519, -0.949367, -0.696203, -0.949367, -0.670886, -0.949367, -0.64557, -0.949367, -0.620253, -0.949367, 
-0.594937, -0.949367, -0.56962, -0.949367, -0.544304, -0.949367, -0.518987, -0.949367, -0.493671, -0.949367, -0.468354, -0.949367, -0.443038, -0.949367, -0.417722, -0.949367, 
-0.392405, -0.949367, -0.367089, -0.949367, -0.341772, -0.949367, -0.316456, -0.949367, -0.291139, -0.949367, -0.265823, -0.949367, -0.240506, -0.949367, -0.21519, -0.949367, 
-0.189873, -0.949367, -0.164557, -0.949367, -0.13924, -0.949367, -0.113924, -0.949367, -0.088608, -0.949367, -0.063291, -0.949367, -0.037975, -0.949367, -0.012658, -0.949367, 
0.012658, -0.949367, 0.037975, -0.949367, 0.063291, -0.949367, 0.088608, -0.949367, 0.113924, -0.949367, 0.13924, -0.949367, 0.164557, -0.949367, 0.189873, -0.949367, 
0.21519, -0.949367, 0.240506, -0.949367, 0.265823, -0.949367, 0.291139, -0.949367, 0.316456, -0.949367, 0.341772, -0.949367, 0.367089, -0.949367, 0.392405, -0.949367, 
0.417722, -0.949367, 0.443038, -0.949367, 0.468354, -0.949367, 0.493671, -0.949367, 0.518987, -0.949367, 0.544304, -0.949367, 0.56962, -0.949367, 0.594937, -0.949367, 
0.620253, -0.949367, 0.64557, -0.949367, 0.670886, -0.949367, 0.696203, -0.949367, 0.721519, -0.949367, 0.746835, -0.949367, 0.772152, -0.949367, 0.797468, -0.949367, 
0.822785, -0.949367, 0.848101, -0.949367, 0.873418, -0.949367, 0.898734, -0.949367, 0.924051, -0.949367, 0.949367, -0.949367, 0.974684, -0.949367, 1.0, -0.949367, 
-1.0, -0.924051, -0.974684, -0.924051, -0.949367, -0.924051, -0.924051, -0.924051, -0.898734, -0.924051, -0.873418, -0.924051, -0.848101, -0.924051, -0.822785, -0.924051, 
-0.797468, -0.924051, -0.772152, -0.924051, -0.746835, -0.924051, -0.721519, -0.924051, -0.696203, -0.924051, -0.670886, -0.924051, -0.64557, -0.924051, -0.620253, -0.924051, 
-0.594937, -0.924051, -0.56962, -0.924051, -0.544304, -0.924051, -0.518987, -0.924051, -0.493671, -0.924051, -0.468354, -0.924051, -0.443038, -0.924051, -0.417722, -0.924051, 
-0.392405, -0.924051, -0.367089, -0.924051, -0.341772, -0.924051, -0.316456, -0.924051, -0.291139, -0.924051, -0.265823, -0.924051, -0.240506, -0.924051, -0.21519, -0.924051, 
-0.189873, -0.924051, -0.164557, -0.924051, -0.13924, -0.924051, -0.113924, -0.924051, -0.088608, -0.924051, -0.063291, -0.924051, -0.037975, -0.924051, -0.012658, -0.924051, 
0.012658, -0.924051, 0.037975, -0.924051, 0.063291, -0.924051, 0.088608, -0.924051, 0.113924, -0.924051, 0.13924, -0.924051, 0.164557, -0.924051, 0.189873, -0.924051, 
0.21519, -0.924051, 0.240506, -0.924051, 0.265823, -0.924051, 0.291139, -0.924051, 0.316456, -0.924051, 0.341772, -0.924051, 0.367089, -0.924051, 0.392405, -0.924051, 
0.417722, -0.924051, 0.443038, -0.924051, 0.468354, -0.924051, 0.493671, -0.924051, 0.518987, -0.924051, 0.544304, -0.924051, 0.56962, -0.924051, 0.594937, -0.924051, 
0.620253, -0.924051, 0.64557, -0.924051, 0.670886, -0.924051, 0.696203, -0.924051, 0.721519, -0.924051, 0.746835, -0.924051, 0.772152, -0.924051, 0.797468, -0.924051, 
0.822785, -0.924051, 0.848101, -0.924051, 0.873418, -0.924051, 0.898734, -0.924051, 0.924051, -0.924051, 0.949367, -0.924051, 0.974684, -0.924051, 1.0, -0.924051, 
-1.0, -0.898734, -0.974684, -0.898734, -0.949367, -0.898734, -0.924051, -0.898734, -0.898734, -0.898734, -0.873418, -0.898734, -0.848101, -0.898734, -0.822785, -0.898734, 
-0.797468, -0.898734, -0.772152, -0.898734, -0.746835, -0.898734, -0.721519, -0.898734, -0.696203, -0.898734, -0.670886, -0.898734, -0.64557, -0.898734, -0.620253, -0.898734, 
-0.594937, -0.898734, -0.56962, -0.898734, -0.544304, -0.898734, -0.518987, -0.898734, -0.493671, -0.898734, -0.468354, -0.898734, -0.443038, -0.898734, -0.417722, -0.898734, 
-0.392405, -0.898734, -0.367089, -0.898734, -0.341772, -0.898734, -0.316456, -0.898734, -0.291139, -0.898734, -0.265823, -0.898734, -0.240506, -0.898734, -0.21519, -0.898734, 
-0.189873, -0.898734, -0.164557, -0.898734, -0.13924, -0.898734, -0.113924, -0.898734, -0.088608, -0.898734, -0.063291, -0.898734, -0.037975, -0.898734, -0.012658, -0.898734, 
0.012658, -0.898734, 0.037975, -0.898734, 0.063291, -0.898734, 0.088608, -0.898734, 0.113924, -0.898734, 0.13924, -0.898734, 0.164557, -0.898734, 0.189873, -0.898734, 
0.21519, -0.898734, 0.240506, -0.898734, 0.265823, -0.898734, 0.291139, -0.898734, 0.316456, -0.898734, 0.341772, -0.898734, 0.367089, -0.898734, 0.392405, -0.898734, 
0.417722, -0.898734, 0.443038, -0.898734, 0.468354, -0.898734, 0.493671, -0.898734, 0.518987, -0.898734, 0.544304, -0.898734, 0.56962, -0.898734, 0.594937, -0.898734, 
0.620253, -0.898734, 0.64557, -0.898734, 0.670886, -0.898734, 0.696203, -0.898734, 0.721519, -0.898734, 0.746835, -0.898734, 0.772152, -0.898734, 0.797468, -0.898734, 
0.822785, -0.898734, 0.848101, -0.898734, 0.873418, -0.898734, 0.898734, -0.898734, 0.924051, -0.898734, 0.949367, -0.898734, 0.974684, -0.898734, 1.0, -0.898734, 
-1.0, -0.873418, -0.974684, -0.873418, -0.949367, -0.873418, -0.924051, -0.873418, -0.898734, -0.873418, -0.873418, -0.873418, -0.848101, -0.873418, -0.822785, -0.873418, 
-0.797468, -0.873418, -0.772152, -0.873418, -0.746835, -0.873418, -0.721519, -0.873418, -0.696203, -0.873418, -0.670886, -0.873418, -0.64557, -0.873418, -0.620253, -0.873418, 
-0.594937, -0.873418, -0.56962, -0.873418, -0.544304, -0.873418, -0.518987, -0.873418, -0.493671, -0.873418, -0.468354, -0.873418, -0.443038, -0.873418, -0.417722, -0.873418, 
-0.392405, -0.873418, -0.367089, -0.873418, -0.341772, -0.873418, -0.316456, -0.873418, -0.291139, -0.873418, -0.265823, -0.873418, -0.240506, -0.873418, -0.21519, -0.873418, 
-0.189873, -0.873418, -0.164557, -0.873418, -0.13924, -0.873418, -0.113924, -0.873418, -0.088608, -0.873418, -0.063291, -0.873418, -0.037975, -0.873418, -0.012658, -0.873418, 
0.012658, -0.873418, 0.037975, -0.873418, 0.063291, -0.873418, 0.088608, -0.873418, 0.113924, -0.873418, 0.13924, -0.873418, 0.164557, -0.873418, 0.189873, -0.873418, 
0.21519, -0.873418, 0.240506, -0.873418, 0.265823, -0.873418, 0.291139, -0.873418, 0.316456, -0.873418, 0.341772, -0.873418, 0.367089, -0.873418, 0.392405, -0.873418, 
0.417722, -0.873418, 0.443038, -0.873418, 0.468354, -0.873418, 0.493671, -0.873418, 0.518987, -0.873418, 0.544304, -0.873418, 0.56962, -0.873418, 0.594937, -0.873418, 
0.620253, -0.873418, 0.64557, -0.873418, 0.670886, -0.873418, 0.696203, -0.873418, 0.721519, -0.873418, 0.746835, -0.873418, 0.772152, -0.873418, 0.797468, -0.873418, 
0.822785, -0.873418, 0.848101, -0.873418, 0.873418, -0.873418, 0.898734, -0.873418, 0.924051, -0.873418, 0.949367, -0.873418, 0.974684, -0.873418, 1.0, -0.873418, 
-1.0, -0.848101, -0.974684, -0.848101, -0.949367, -0.848101, -0.924051, -0.848101, -0.898734, -0.848101, -0.873418, -0.848101, -0.848101, -0.848101, -0.822785, -0.848101, 
-0.797468, -0.848101, -0.772152, -0.848101, -0.746835, -0.848101, -0.721519, -0.848101, -0.696203, -0.848101, -0.670886, -0.848101, -0.64557, -0.848101, -0.620253, -0.848101, 
-0.594937, -0.848101, -0.56962, -0.848101, -0.544304, -0.848101, -0.518987, -0.848101, -0.493671, -0.848101, -0.468354, -0.848101, -0.443038, -0.848101, -0.417722, -0.848101, 
-0.392405, -0.848101, -0.367089, -0.848101, -0.341772, -0.848101, -0.316456, -0.848101, -0.291139, -0.848101, -0.265823, -0.848101, -0.240506, -0.848101, -0.21519, -0.848101, 
-0.189873, -0.848101, -0.164557, -0.848101, -0.13924, -0.848101, -0.113924, -0.848101, -0.088608, -0.848101, -0.063291, -0.848101, -0.037975, -0.848101, -0.012658, -0.848101, 
0.012658, -0.848101, 0.037975, -0.848101, 0.063291, -0.848101, 0.088608, -0.848101, 0.113924, -0.848101, 0.13924, -0.848101, 0.164557, -0.848101, 0.189873, -0.848101, 
0.21519, -0.848101, 0.240506, -0.848101, 0.265823, -0.848101, 0.291139, -0.848101, 0.316456, -0.848101, 0.341772, -0.848101, 0.367089, -0.848101, 0.392405, -0.848101, 
0.417722, -0.848101, 0.443038, -0.848101, 0.468354, -0.848101, 0.493671, -0.848101, 0.518987, -0.848101, 0.544304, -0.848101, 0.56962, -0.848101, 0.594937, -0.848101, 
0.620253, -0.848101, 0.64557, -0.848101, 0.670886, -0.848101, 0.696203, -0.848101, 0.721519, -0.848101, 0.746835, -0.848101, 0.772152, -0.848101, 0.797468, -0.848101, 
0.822785, -0.848101, 0.848101, -0.848101, 0.873418, -0.848101, 0.898734, -0.848101, 0.924051, -0.848101, 0.949367, -0.848101, 0.974684, -0.848101, 1.0, -0.848101, 
-1.0, -0.822785, -0.974684, -0.822785, -0.949367, -0.822785, -0.924051, -0.822785, -0.898734, -0.822785, -0.873418, -0.822785, -0.848101, -0.822785, -0.822785, -0.822785, 
-0.797468, -0.822785, -0.772152, -0.822785, -0.746835, -0.822785, -0.721519, -0.822785, -0.696203, -0.822785, -0.670886, -0.822785, -0.64557, -0.822785, -0.620253, -0.822785, 
-0.594937, -0.822785, -0.56962, -0.822785, -0.544304, -0.822785, -0.518987, -0.822785, -0.493671, -0.822785, -0.468354, -0.822785, -0.443038, -0.822785, -0.417722, -0.822785, 
-0.392405, -0.822785, -0.367089, -0.822785, -0.341772, -0.822785, -0.316456, -0.822785, -0.291139, -0.822785, -0.265823, -0.822785, -0.240506, -0.822785, -0.21519, -0.822785, 
-0.189873, -0.822785, -0.164557, -0.822785, -0.13924, -0.822785, -0.113924, -0.822785, -0.088608, -0.822785, -0.063291, -0.822785, -0.037975, -0.822785, -0.012658, -0.822785, 
0.012658, -0.822785, 0.037975, -0.822785, 0.063291, -0.822785, 0.088608, -0.822785, 0.113924, -0.822785, 0.13924, -0.822785, 0.164557, -0.822785, 0.189873, -0.822785, 
0.21519, -0.822785, 0.240506, -0.822785, 0.265823, -0.822785, 0.291139, -0.822785, 0.316456, -0.822785, 0.341772, -0.822785, 0.367089, -0.822785, 0.392405, -0.822785, 
0.417722, -0.822785, 0.443038, -0.822785, 0.468354, -0.822785, 0.493671, -0.822785, 0.518987, -0.822785, 0.544304, -0.822785, 0.56962, -0.822785, 0.594937, -0.822785, 
0.620253, -0.822785, 0.64557, -0.822785, 0.670886, -0.822785, 0.696203, -0.822785, 0.721519, -0.822785, 0.746835, -0.822785, 0.772152, -0.822785, 0.797468, -0.822785, 
0.822785, -0.822785, 0.848101, -0.822785, 0.873418, -0.822785, 0.898734, -0.822785, 0.924051, -0.822785, 0.949367, -0.822785, 0.974684, -0.822785, 1.0, -0.822785, 
-1.0, -0.797468, -0.974684, -0.797468, -0.949367, -0.797468, -0.924051, -0.797468, -0.898734, -0.797468, -0.873418, -0.797468, -0.848101, -0.797468, -0.822785, -0.797468, 
-0.797468, -0.797468, -0.772152, -0.797468, -0.746835, -0.797468, -0.721519, -0.797468, -0.696203, -0.797468, -0.670886, -0.797468, -0.64557, -0.797468, -0.620253, -0.797468, 
-0.594937, -0.797468, -0.56962, -0.797468, -0.544304, -0.797468, -0.518987, -0.797468, -0.493671, -0.797468, -0.468354, -0.797468, -0.443038, -0.797468, -0.417722, -0.797468, 
-0.392405, -0.797468, -0.367089, -0.797468, -0.341772, -0.797468, -0.316456, -0.797468, -0.291139, -0.797468, -0.265823, -0.797468, -0.240506, -0.797468, -0.21519, -0.797468, 
-0.189873, -0.797468, -0.164557, -0.797468, -0.13924, -0.797468, -0.113924, -0.797468, -0.088608, -0.797468, -0.063291, -0.797468, -0.037975, -0.797468, -0.012658, -0.797468, 
0.012658, -0.797468, 0.037975, -0.797468, 0.063291, -0.797468, 0.088608, -0.797468, 0.113924, -0.797468, 0.13924, -0.797468, 0.164557, -0.797468, 0.189873, -0.797468, 
0.21519, -0.797468, 0.240506, -0.797468, 0.265823, -0.797468, 0.291139, -0.797468, 0.316456, -0.797468, 0.341772, -0.797468, 0.367089, -0.797468, 0.392405, -0.797468, 
0.417722, -0.797468, 0.443038, -0.797468, 0.468354, -0.797468, 0.493671, -0.797468, 0.518987, -0.797468, 0.544304, -0.797468, 0.56962, -0.797468, 0.594937, -0.797468, 
0.620253, -0.797468, 0.64557, -0.797468, 0.670886, -0.797468, 0.696203, -0.797468, 0.721519, -0.797468, 0.746835, -0.797468, 0.772152, -0.797468, 0.797468, -0.797468, 
0.822785, -0.797468, 0.848101, -0.797468, 0.873418, -0.797468, 0.898734, -0.797468, 0.924051, -0.797468, 0.949367, -0.797468, 0.974684, -0.797468, 1.0, -0.797468, 
-1.0, -0.772152, -0.974684, -0.772152, -0.949367, -0.772152, -0.924051, -0.772152, -0.898734, -0.772152, -0.873418, -0.772152, -0.848101, -0.772152, -0.822785, -0.772152, 
-0.797468, -0.772152, -0.772152, -0.772152, -0.746835, -0.772152, -0.721519, -0.772152, -0.696203, -0.772152, -0.670886, -0.772152, -0.64557, -0.772152, -0.620253, -0.772152, 
-0.594937, -0.772152, -0.56962, -0.772152, -0.544304, -0.772152, -0.518987, -0.772152, -0.493671, -0.772152, -0.468354, -0.772152, -0.443038, -0.772152, -0.417722, -0.772152, 
-0.392405, -0.772152, -0.367089, -0.772152, -0.341772, -0.772152, -0.316456, -0.772152, -0.291139, -0.772152, -0.265823, -0.772152, -0.240506, -0.772152, -0.21519, -0.772152, 
-0.189873, -0.772152, -0.164557, -0.772152, -0.13924, -0.772152, -0.113924, -0.772152, -0.088608, -0.772152, -0.063291, -0.772152, -0.037975, -0.772152, -0.012658, -0.772152, 
0.012658, -0.772152, 0.037975, -0.772152, 0.063291, -0.772152, 0.088608, -0.772152, 0.113924, -0.772152, 0.13924, -0.772152, 0.164557, -0.772152, 0.189873, -0.772152, 
0.21519, -0.772152, 0.240506, -0.772152, 0.265823, -0.772152, 0.291139, -0.772152, 0.316456, -0.772152, 0.341772, -0.772152, 0.367089, -0.772152, 0.392405, -0.772152, 
0.417722, -0.772152, 0.443038, -0.772152, 0.468354, -0.772152, 0.493671, -0.772152, 0.518987, -0.772152, 0.544304, -0.772152, 0.56962, -0.772152, 0.594937, -0.772152, 
0.620253, -0.772152, 0.64557, -0.772152, 0.670886, -0.772152, 0.696203, -0.772152, 0.721519, -0.772152, 0.746835, -0.772152, 0.772152, -0.772152, 0.797468, -0.772152, 
0.822785, -0.772152, 0.848101, -0.772152, 0.873418, -0.772152, 0.898734, -0.772152, 0.924051, -0.772152, 0.949367, -0.772152, 0.974684, -0.772152, 1.0, -0.772152, 
-1.0, -0.746835, -0.974684, -0.746835, -0.949367, -0.746835, -0.924051, -0.746835, -0.898734, -0.746835, -0.873418, -0.746835, -0.848101, -0.746835, -0.822785, -0.746835, 
-0.797468, -0.746835, -0.772152, -0.746835, -0.746835, -0.746835, -0.721519, -0.746835, -0.696203, -0.746835, -0.670886, -0.746835, -0.64557, -0.746835, -0.620253, -0.746835, 
-0.594937, -0.746835, -0.56962, -0.746835, -0.544304, -0.746835, -0.518987, -0.746835, -0.493671, -0.746835, -0.468354, -0.746835, -0.443038, -0.746835, -0.417722, -0.746835, 
-0.392405, -0.746835, -0.367089, -0.746835, -0.341772, -0.746835, -0.316456, -0.746835, -0.291139, -0.746835, -0.265823, -0.746835, -0.240506, -0.746835, -0.21519, -0.746835, 
-0.189873, -0.746835, -0.164557, -0.746835, -0.13924, -0.746835, -0.113924, -0.746835, -0.088608, -0.746835, -0.063291, -0.746835, -0.037975, -0.746835, -0.012658, -0.746835, 
0.012658, -0.746835, 0.037975, -0.746835, 0.063291, -0.746835, 0.088608, -0.746835, 0.113924, -0.746835, 0.13924, -0.746835, 0.164557, -0.746835, 0.189873, -0.746835, 
0.21519, -0.746835, 0.240506, -0.746835, 0.265823, -0.746835, 0.291139, -0.746835, 0.316456, -0.746835, 0.341772, -0.746835, 0.367089, -0.746835, 0.392405, -0.746835, 
0.417722, -0.746835, 0.443038, -0.746835, 0.468354, -0.746835, 0.493671, -0.746835, 0.518987, -0.746835, 0.544304, -0.746835, 0.56962, -0.746835, 0.594937, -0.746835, 
0.620253, -0.746835, 0.64557, -0.746835, 0.670886, -0.746835, 0.696203, -0.746835, 0.721519, -0.746835, 0.746835, -0.746835, 0.772152, -0.746835, 0.797468, -0.746835, 
0.822785, -0.746835, 0.848101, -0.746835, 0.873418, -0.746835, 0.898734, -0.746835, 0.924051, -0.746835, 0.949367, -0.746835, 0.974684, -0.746835, 1.0, -0.746835, 
-1.0, -0.721519, -0.974684, -0.721519, -0.949367, -0.721519, -0.924051, -0.721519, -0.898734, -0.721519, -0.873418, -0.721519, -0.848101, -0.721519, -0.822785, -0.721519, 
-0.797468, -0.721519, -0.772152, -0.721519, -0.746835, -0.721519, -0.721519, -0.721519, -0.696203, -0.721519, -0.670886, -0.721519, -0.64557, -0.721519, -0.620253, -0.721519, 
-0.594937, -0.721519, -0.56962, -0.721519, -0.544304, -0.721519, -0.518987, -0.721519, -0.493671, -0.721519, -0.468354, -0.721519, -0.443038, -0.721519, -0.417722, -0.721519, 
-0.392405, -0.721519, -0.367089, -0.721519, -0.341772, -0.721519, -0.316456, -0.721519, -0.291139, -0.721519, -0.265823, -0.721519, -0.240506, -0.721519, -0.21519, -0.721519, 
-0.189873, -0.721519, -0.164557, -0.721519, -0.13924, -0.721519, -0.113924, -0.721519, -0.088608, -0.721519, -0.063291, -0.721519, -0.037975, -0.721519, -0.012658, -0.721519, 
0.012658, -0.721519, 0.037975, -0.721519, 0.063291, -0.721519, 0.088608, -0.721519, 0.113924, -0.721519, 0.13924, -0.721519, 0.164557, -0.721519, 0.189873, -0.721519, 
0.21519, -0.721519, 0.240506, -0.721519, 0.265823, -0.721519, 0.291139, -0.721519, 0.316456, -0.721519, 0.341772, -0.721519, 0.367089, -0.721519, 0.392405, -0.721519, 
0.417722, -0.721519, 0.443038, -0.721519, 0.468354, -0.721519, 0.493671, -0.721519, 0.518987, -0.721519, 0.544304, -0.721519, 0.56962, -0.721519, 0.594937, -0.721519, 
0.620253, -0.721519, 0.64557, -0.721519, 0.670886, -0.721519, 0.696203, -0.721519, 0.721519, -0.721519, 0.746835, -0.721519, 0.772152, -0.721519, 0.797468, -0.721519, 
0.822785, -0.721519, 0.848101, -0.721519, 0.873418, -0.721519, 0.898734, -0.721519, 0.924051, -0.721519, 0.949367, -0.721519, 0.974684, -0.721519, 1.0, -0.721519, 
-1.0, -0.696203, -0.974684, -0.696203, -0.949367, -0.696203, -0.924051, -0.696203, -0.898734, -0.696203, -0.873418, -0.696203, -0.848101, -0.696203, -0.822785, -0.696203, 
-0.797468, -0.696203, -0.772152, -0.696203, -0.746835, -0.696203, -0.721519, -0.696203, -0.696203, -0.696203, -0.670886, -0.696203, -0.64557, -0.696203, -0.620253, -0.696203, 
-0.594937, -0.696203, -0.56962, -0.696203, -0.544304, -0.696203, -0.518987, -0.696203, -0.493671, -0.696203, -0.468354, -0.696203, -0.443038, -0.696203, -0.417722, -0.696203, 
-0.392405, -0.696203, -0.367089, -0.696203, -0.341772, -0.696203, -0.316456, -0.696203, -0.291139, -0.696203, -0.265823, -0.696203, -0.240506, -0.696203, -0.21519, -0.696203, 
-0.189873, -0.696203, -0.164557, -0.696203, -0.13924, -0.696203, -0.113924, -0.696203, -0.088608, -0.696203, -0.063291, -0.696203, -0.037975, -0.696203, -0.012658, -0.696203, 
0.012658, -0.696203, 0.037975, -0.696203, 0.063291, -0.696203, 0.088608, -0.696203, 0.113924, -0.696203, 0.13924, -0.696203, 0.164557, -0.696203, 0.189873, -0.696203, 
0.21519, -0.696203, 0.240506, -0.696203, 0.265823, -0.696203, 0.291139, -0.696203, 0.316456, -0.696203, 0.341772, -0.696203, 0.367089, -0.696203, 0.392405, -0.696203, 
0.417722, -0.696203, 0.443038, -0.696203, 0.468354, -0.696203, 0.493671, -0.696203, 0.518987, -0.696203, 0.544304, -0.696203, 0.56962, -0.696203, 0.594937, -0.696203, 
0.620253, -0.696203, 0.64557, -0.696203, 0.670886, -0.696203, 0.696203, -0.696203, 0.721519, -0.696203, 0.746835, -0.696203, 0.772152, -0.696203, 0.797468, -0.696203, 
0.822785, -0.696203, 0.848101, -0.696203, 0.873418, -0.696203, 0.898734, -0.696203, 0.924051, -0.696203, 0.949367, -0.696203, 0.974684, -0.696203, 1.0, -0.696203, 
-1.0, -0.670886, -0.974684, -0.670886, -0.949367, -0.670886, -0.924051, -0.670886, -0.898734, -0.670886, -0.873418, -0.670886, -0.848101, -0.670886, -0.822785, -0.670886, 
-0.797468, -0.670886, -0.772152, -0.670886, -0.746835, -0.670886, -0.721519, -0.670886, -0.696203, -0.670886, -0.670886, -0.670886, -0.64557, -0.670886, -0.620253, -0.670886, 
-0.594937, -0.670886, -0.56962, -0.670886, -0.544304, -0.670886, -0.518987, -0.670886, -0.493671, -0.670886, -0.468354, -0.670886, -0.443038, -0.670886, -0.417722, -0.670886, 
-0.392405, -0.670886, -0.367089, -0.670886, -0.341772, -0.670886, -0.316456, -0.670886, -0.291139, -0.670886, -0.265823, -0.670886, -0.240506, -0.670886, -0.21519, -0.670886, 
-0.189873, -0.670886, -0.164557, -0.670886, -0.13924, -0.670886, -0.113924, -0.670886, -0.088608, -0.670886, -0.063291, -0.670886, -0.037975, -0.670886, -0.012658, -0.670886, 
0.012658, -0.670886, 0.037975, -0.670886, 0.063291, -0.670886, 0.088608, -0.670886, 0.113924, -0.670886, 0.13924, -0.670886, 0.164557, -0.670886, 0.189873, -0.670886, 
0.21519, -0.670886, 0.240506, -0.670886, 0.265823, -0.670886, 0.291139, -0.670886, 0.316456, -0.670886, 0.341772, -0.670886, 0.367089, -0.670886, 0.392405, -0.670886, 
0.417722, -0.670886, 0.443038, -0.670886, 0.468354, -0.670886, 0.493671, -0.670886, 0.518987, -0.670886, 0.544304, -0.670886, 0.56962, -0.670886, 0.594937, -0.670886, 
0.620253, -0.670886, 0.64557, -0.670886, 0.670886, -0.670886, 0.696203, -0.670886, 0.721519, -0.670886, 0.746835, -0.670886, 0.772152, -0.670886, 0.797468, -0.670886, 
0.822785, -0.670886, 0.848101, -0.670886, 0.873418, -0.670886, 0.898734, -0.670886, 0.924051, -0.670886, 0.949367, -0.670886, 0.974684, -0.670886, 1.0, -0.670886, 
-1.0, -0.64557, -0.974684, -0.64557, -0.949367, -0.64557, -0.924051, -0.64557, -0.898734, -0.64557, -0.873418, -0.64557, -0.848101, -0.64557, -0.822785, -0.64557, 
-0.797468, -0.64557, -0.772152, -0.64557, -0.746835, -0.64557, -0.721519, -0.64557, -0.696203, -0.64557, -0.670886, -0.64557, -0.64557, -0.64557, -0.620253, -0.64557, 
-0.594937, -0.64557, -0.56962, -0.64557, -0.544304, -0.64557, -0.518987, -0.64557, -0.493671, -0.64557, -0.468354, -0.64557, -0.443038, -0.64557, -0.417722, -0.64557, 
-0.392405, -0.64557, -0.367089, -0.64557, -0.341772, -0.64557, -0.316456, -0.64557, -0.291139, -0.64557, -0.265823, -0.64557, -0.240506, -0.64557, -0.21519, -0.64557, 
-0.189873, -0.64557, -0.164557, -0.64557, -0.13924, -0.64557, -0.113924, -0.64557, -0.088608, -0.64557, -0.063291, -0.64557, -0.037975, -0.64557, -0.012658, -0.64557, 
0.012658, -0.64557, 0.037975, -0.64557, 0.063291, -0.64557, 0.088608, -0.64557, 0.113924, -0.64557, 0.13924, -0.64557, 0.164557, -0.64557, 0.189873, -0.64557, 
0.21519, -0.64557, 0.240506, -0.64557, 0.265823, -0.64557, 0.291139, -0.64557, 0.316456, -0.64557, 0.341772, -0.64557, 0.367089, -0.64557, 0.392405, -0.64557, 
0.417722, -0.64557, 0.443038, -0.64557, 0.468354, -0.64557, 0.493671, -0.64557, 0.518987, -0.64557, 0.544304, -0.64557, 0.56962, -0.64557, 0.594937, -0.64557, 
0.620253, -0.64557, 0.64557, -0.64557, 0.670886, -0.64557, 0.696203, -0.64557, 0.721519, -0.64557, 0.746835, -0.64557, 0.772152, -0.64557, 0.797468, -0.64557, 
0.822785, -0.64557, 0.848101, -0.64557, 0.873418, -0.64557, 0.898734, -0.64557, 0.924051, -0.64557, 0.949367, -0.64557, 0.974684, -0.64557, 1.0, -0.64557, 
-1.0, -0.620253, -0.974684, -0.620253, -0.949367, -0.620253, -0.924051, -0.620253, -0.898734, -0.620253, -0.873418, -0.620253, -0.848101, -0.620253, -0.822785, -0.620253, 
-0.797468, -0.620253, -0.772152, -0.620253, -0.746835, -0.620253, -0.721519, -0.620253, -0.696203, -0.620253, -0.670886, -0.620253, -0.64557, -0.620253, -0.620253, -0.620253, 
-0.594937, -0.620253, -0.56962, -0.620253, -0.544304, -0.620253, -0.518987, -0.620253, -0.493671, -0.620253, -0.468354, -0.620253, -0.443038, -0.620253, -0.417722, -0.620253, 
-0.392405, -0.620253, -0.367089, -0.620253, -0.341772, -0.620253, -0.316456, -0.620253, -0.291139, -0.620253, -0.265823, -0.620253, -0.240506, -0.620253, -0.21519, -0.620253, 
-0.189873, -0.620253, -0.164557, -0.620253, -0.13924, -0.620253, -0.113924, -0.620253, -0.088608, -0.620253, -0.063291, -0.620253, -0.037975, -0.620253, -0.012658, -0.620253, 
0.012658, -0.620253, 0.037975, -0.620253, 0.063291, -0.620253, 0.088608, -0.620253, 0.113924, -0.620253, 0.13924, -0.620253, 0.164557, -0.620253, 0.189873, -0.620253, 
0.21519, -0.620253, 0.240506, -0.620253, 0.265823, -0.620253, 0.291139, -0.620253, 0.316456, -0.620253, 0.341772, -0.620253, 0.367089, -0.620253, 0.392405, -0.620253, 
0.417722, -0.620253, 0.443038, -0.620253, 0.468354, -0.620253, 0.493671, -0.620253, 0.518987, -0.620253, 0.544304, -0.620253, 0.56962, -0.620253, 0.594937, -0.620253, 
0.620253, -0.620253, 0.64557, -0.620253, 0.670886, -0.620253, 0.696203, -0.620253, 0.721519, -0.620253, 0.746835, -0.620253, 0.772152, -0.620253, 0.797468, -0.620253, 
0.822785, -0.620253, 0.848101, -0.620253, 0.873418, -0.620253, 0.898734, -0.620253, 0.924051, -0.620253, 0.949367, -0.620253, 0.974684, -0.620253, 1.0, -0.620253, 
-1.0, -0.594937, -0.974684, -0.594937, -0.949367, -0.594937, -0.924051, -0.594937, -0.898734, -0.594937, -0.873418, -0.594937, -0.848101, -0.594937, -0.822785, -0.594937, 
-0.797468, -0.594937, -0.772152, -0.594937, -0.746835, -0.594937, -0.721519, -0.594937, -0.696203, -0.594937, -0.670886, -0.594937, -0.64557, -0.594937, -0.620253, -0.594937, 
-0.594937, -0.594937, -0.56962, -0.594937, -0.544304, -0.594937, -0.518987, -0.594937, -0.493671, -0.594937, -0.468354, -0.594937, -0.443038, -0.594937, -0.417722, -0.594937, 
-0.392405, -0.594937, -0.367089, -0.594937, -0.341772, -0.594937, -0.316456, -0.594937, -0.291139, -0.594937, -0.265823, -0.594937, -0.240506, -0.594937, -0.21519, -0.594937, 
-0.189873, -0.594937, -0.164557, -0.594937, -0.13924, -0.594937, -0.113924, -0.594937, -0.088608, -0.594937, -0.063291, -0.594937, -0.037975, -0.594937, -0.012658, -0.594937, 
0.012658, -0.594937, 0.037975, -0.594937, 0.063291, -0.594937, 0.088608, -0.594937, 0.113924, -0.594937, 0.13924, -0.594937, 0.164557, -0.594937, 0.189873, -0.594937, 
0.21519, -0.594937, 0.240506, -0.594937, 0.265823, -0.594937, 0.291139, -0.594937, 0.316456, -0.594937, 0.341772, -0.594937, 0.367089, -0.594937, 0.392405, -0.594937, 
0.417722, -0.594937, 0.443038, -0.594937, 0.468354, -0.594937, 0.493671, -0.594937, 0.518987, -0.594937, 0.544304, -0.594937, 0.56962, -0.594937, 0.594937, -0.594937, 
0.620253, -0.594937, 0.64557, -0.594937, 0.670886, -0.594937, 0.696203, -0.594937, 0.721519, -0.594937, 0.746835, -0.594937, 0.772152, -0.594937, 0.797468, -0.594937, 
0.822785, -0.594937, 0.848101, -0.594937, 0.873418, -0.594937, 0.898734, -0.594937, 0.924051, -0.594937, 0.949367, -0.594937, 0.974684, -0.594937, 1.0, -0.594937, 
-1.0, -0.56962, -0.974684, -0.56962, -0.949367, -0.56962, -0.924051, -0.56962, -0.898734, -0.56962, -0.873418, -0.56962, -0.848101, -0.56962, -0.822785, -0.56962, 
-0.797468, -0.56962, -0.772152, -0.56962, -0.746835, -0.56962, -0.721519, -0.56962, -0.696203, -0.56962, -0.670886, -0.56962, -0.64557, -0.56962, -0.620253, -0.56962, 
-0.594937, -0.56962, -0.56962, -0.56962, -0.544304, -0.56962, -0.518987, -0.56962, -0.493671, -0.56962, -0.468354, -0.56962, -0.443038, -0.56962, -0.417722, -0.56962, 
-0.392405, -0.56962, -0.367089, -0.56962, -0.341772, -0.56962, -0.316456, -0.56962, -0.291139, -0.56962, -0.265823, -0.56962, -0.240506, -0.56962, -0.21519, -0.56962, 
-0.189873, -0.56962, -0.164557, -0.56962, -0.13924, -0.56962, -0.113924, -0.56962, -0.088608, -0.56962, -0.063291, -0.56962, -0.037975, -0.56962, -0.012658, -0.56962, 
0.012658, -0.56962, 0.037975, -0.56962, 0.063291, -0.56962, 0.088608, -0.56962, 0.113924, -0.56962, 0.13924, -0.56962, 0.164557, -0.56962, 0.189873, -0.56962, 
0.21519, -0.56962, 0.240506, -0.56962, 0.265823, -0.56962, 0.291139, -0.56962, 0.316456, -0.56962, 0.341772, -0.56962, 0.367089, -0.56962, 0.392405, -0.56962, 
0.417722, -0.56962, 0.443038, -0.56962, 0.468354, -0.56962, 0.493671, -0.56962, 0.518987, -0.56962, 0.544304, -0.56962, 0.56962, -0.56962, 0.594937, -0.56962, 
0.620253, -0.56962, 0.64557, -0.56962, 0.670886, -0.56962, 0.696203, -0.56962, 0.721519, -0.56962, 0.746835, -0.56962, 0.772152, -0.56962, 0.797468, -0.56962, 
0.822785, -0.56962, 0.848101, -0.56962, 0.873418, -0.56962, 0.898734, -0.56962, 0.924051, -0.56962, 0.949367, -0.56962, 0.974684, -0.56962, 1.0, -0.56962, 
-1.0, -0.544304, -0.974684, -0.544304, -0.949367, -0.544304, -0.924051, -0.544304, -0.898734, -0.544304, -0.873418, -0.544304, -0.848101, -0.544304, -0.822785, -0.544304, 
-0.797468, -0.544304, -0.772152, -0.544304, -0.746835, -0.544304, -0.721519, -0.544304, -0.696203, -0.544304, -0.670886, -0.544304, -0.64557, -0.544304, -0.620253, -0.544304, 
-0.594937, -0.544304, -0.56962, -0.544304, -0.544304, -0.544304, -0.518987, -0.544304, -0.493671, -0.544304, -0.468354, -0.544304, -0.443038, -0.544304, -0.417722, -0.544304, 
-0.392405, -0.544304, -0.367089, -0.544304, -0.341772, -0.544304, -0.316456, -0.544304, -0.291139, -0.544304, -0.265823, -0.544304, -0.240506, -0.544304, -0.21519, -0.544304, 
-0.189873, -0.544304, -0.164557, -0.544304, -0.13924, -0.544304, -0.113924, -0.544304, -0.088608, -0.544304, -0.063291, -0.544304, -0.037975, -0.544304, -0.012658, -0.544304, 
0.012658, -0.544304, 0.037975, -0.544304, 0.063291, -0.544304, 0.088608, -0.544304, 0.113924, -0.544304, 0.13924, -0.544304, 0.164557, -0.544304, 0.189873, -0.544304, 
0.21519, -0.544304, 0.240506, -0.544304, 0.265823, -0.544304, 0.291139, -0.544304, 0.316456, -0.544304, 0.341772, -0.544304, 0.367089, -0.544304, 0.392405, -0.544304, 
0.417722, -0.544304, 0.443038, -0.544304, 0.468354, -0.544304, 0.493671, -0.544304, 0.518987, -0.544304, 0.544304, -0.544304, 0.56962, -0.544304, 0.594937, -0.544304, 
0.620253, -0.544304, 0.64557, -0.544304, 0.670886, -0.544304, 0.696203, -0.544304, 0.721519, -0.544304, 0.746835, -0.544304, 0.772152, -0.544304, 0.797468, -0.544304, 
0.822785, -0.544304, 0.848101, -0.544304, 0.873418, -0.544304, 0.898734, -0.544304, 0.924051, -0.544304, 0.949367, -0.544304, 0.974684, -0.544304, 1.0, -0.544304, 
-1.0, -0.518987, -0.974684, -0.518987, -0.949367, -0.518987, -0.924051, -0.518987, -0.898734, -0.518987, -0.873418, -0.518987, -0.848101, -0.518987, -0.822785, -0.518987, 
-0.797468, -0.518987, -0.772152, -0.518987, -0.746835, -0.518987, -0.721519, -0.518987, -0.696203, -0.518987, -0.670886, -0.518987, -0.64557, -0.518987, -0.620253, -0.518987, 
-0.594937, -0.518987, -0.56962, -0.518987, -0.544304, -0.518987, -0.518987, -0.518987, -0.493671, -0.518987, -0.468354, -0.518987, -0.443038, -0.518987, -0.417722, -0.518987, 
-0.392405, -0.518987, -0.367089, -0.518987, -0.341772, -0.518987, -0.316456, -0.518987, -0.291139, -0.518987, -0.265823, -0.518987, -0.240506, -0.518987, -0.21519, -0.518987, 
-0.189873, -0.518987, -0.164557, -0.518987, -0.13924, -0.518987, -0.113924, -0.518987, -0.088608, -0.518987, -0.063291, -0.518987, -0.037975, -0.518987, -0.012658, -0.518987, 
0.012658, -0.518987, 0.037975, -0.518987, 0.063291, -0.518987, 0.088608, -0.518987, 0.113924, -0.518987, 0.13924, -0.518987, 0.164557, -0.518987, 0.189873, -0.518987, 
0.21519, -0.518987, 0.240506, -0.518987, 0.265823, -0.518987, 0.291139, -0.518987, 0.316456, -0.518987, 0.341772, -0.518987, 0.367089, -0.518987, 0.392405, -0.518987, 
0.417722, -0.518987, 0.443038, -0.518987, 0.468354, -0.518987, 0.493671, -0.518987, 0.518987, -0.518987, 0.544304, -0.518987, 0.56962, -0.518987, 0.594937, -0.518987, 
0.620253, -0.518987, 0.64557, -0.518987, 0.670886, -0.518987, 0.696203, -0.518987, 0.721519, -0.518987, 0.746835, -0.518987, 0.772152, -0.518987, 0.797468, -0.518987, 
0.822785, -0.518987, 0.848101, -0.518987, 0.873418, -0.518987, 0.898734, -0.518987, 0.924051, -0.518987, 0.949367, -0.518987, 0.974684, -0.518987, 1.0, -0.518987, 
-1.0, -0.493671, -0.974684, -0.493671, -0.949367, -0.493671, -0.924051, -0.493671, -0.898734, -0.493671, -0.873418, -0.493671, -0.848101, -0.493671, -0.822785, -0.493671, 
-0.797468, -0.493671, -0.772152, -0.493671, -0.746835, -0.493671, -0.721519, -0.493671, -0.696203, -0.493671, -0.670886, -0.493671, -0.64557, -0.493671, -0.620253, -0.493671, 
-0.594937, -0.493671, -0.56962, -0.493671, -0.544304, -0.493671, -0.518987, -0.493671, -0.493671, -0.493671, -0.468354, -0.493671, -0.443038, -0.493671, -0.417722, -0.493671, 
-0.392405, -0.493671, -0.367089, -0.493671, -0.341772, -0.493671, -0.316456, -0.493671, -0.291139, -0.493671, -0.265823, -0.493671, -0.240506, -0.493671, -0.21519, -0.493671, 
-0.189873, -0.493671, -0.164557, -0.493671, -0.13924, -0.493671, -0.113924, -0.493671, -0.088608, -0.493671, -0.063291, -0.493671, -0.037975, -0.493671, -0.012658, -0.493671, 
0.012658, -0.493671, 0.037975, -0.493671, 0.063291, -0.493671, 0.088608, -0.493671, 0.113924, -0.493671, 0.13924, -0.493671, 0.164557, -0.493671, 0.189873, -0.493671, 
0.21519, -0.493671, 0.240506, -0.493671, 0.265823, -0.493671, 0.291139, -0.493671, 0.316456, -0.493671, 0.341772, -0.493671, 0.367089, -0.493671, 0.392405, -0.493671, 
0.417722, -0.493671, 0.443038, -0.493671, 0.468354, -0.493671, 0.493671, -0.493671, 0.518987, -0.493671, 0.544304, -0.493671, 0.56962, -0.493671, 0.594937, -0.493671, 
0.620253, -0.493671, 0.64557, -0.493671, 0.670886, -0.493671, 0.696203, -0.493671, 0.721519, -0.493671, 0.746835, -0.493671, 0.772152, -0.493671, 0.797468, -0.493671, 
0.822785, -0.493671, 0.848101, -0.493671, 0.873418, -0.493671, 0.898734, -0.493671, 0.924051, -0.493671, 0.949367, -0.493671, 0.974684, -0.493671, 1.0, -0.493671, 
-1.0, -0.468354, -0.974684, -0.468354, -0.949367, -0.468354, -0.924051, -0.468354, -0.898734, -0.468354, -0.873418, -0.468354, -0.848101, -0.468354, -0.822785, -0.468354, 
-0.797468, -0.468354, -0.772152, -0.468354, -0.746835, -0.468354, -0.721519, -0.468354, -0.696203, -0.468354, -0.670886, -0.468354, -0.64557, -0.468354, -0.620253, -0.468354, 
-0.594937, -0.468354, -0.56962, -0.468354, -0.544304, -0.468354, -0.518987, -0.468354, -0.493671, -0.468354, -0.468354, -0.468354, -0.443038, -0.468354, -0.417722, -0.468354, 
-0.392405, -0.468354, -0.367089, -0.468354, -0.341772, -0.468354, -0.316456, -0.468354, -0.291139, -0.468354, -0.265823, -0.468354, -0.240506, -0.468354, -0.21519, -0.468354, 
-0.189873, -0.468354, -0.164557, -0.468354, -0.13924, -0.468354, -0.113924, -0.468354, -0.088608, -0.468354, -0.063291, -0.468354, -0.037975, -0.468354, -0.012658, -0.468354, 
0.012658, -0.468354, 0.037975, -0.468354, 0.063291, -0.468354, 0.088608, -0.468354, 0.113924, -0.468354, 0.13924, -0.468354, 0.164557, -0.468354, 0.189873, -0.468354, 
0.21519, -0.468354, 0.240506, -0.468354, 0.265823, -0.468354, 0.291139, -0.468354, 0.316456, -0.468354, 0.341772, -0.468354, 0.367089, -0.468354, 0.392405, -0.468354, 
0.417722, -0.468354, 0.443038, -0.468354, 0.468354, -0.468354, 0.493671, -0.468354, 0.518987, -0.468354, 0.544304, -0.468354, 0.56962, -0.468354, 0.594937, -0.468354, 
0.620253, -0.468354, 0.64557, -0.468354, 0.670886, -0.468354, 0.696203, -0.468354, 0.721519, -0.468354, 0.746835, -0.468354, 0.772152, -0.468354, 0.797468, -0.468354, 
0.822785, -0.468354, 0.848101, -0.468354, 0.873418, -0.468354, 0.898734, -0.468354, 0.924051, -0.468354, 0.949367, -0.468354, 0.974684, -0.468354, 1.0, -0.468354, 
-1.0, -0.443038, -0.974684, -0.443038, -0.949367, -0.443038, -0.924051, -0.443038, -0.898734, -0.443038, -0.873418, -0.443038, -0.848101, -0.443038, -0.822785, -0.443038, 
-0.797468, -0.443038, -0.772152, -0.443038, -0.746835, -0.443038, -0.721519, -0.443038, -0.696203, -0.443038, -0.670886, -0.443038, -0.64557, -0.443038, -0.620253, -0.443038, 
-0.594937, -0.443038, -0.56962, -0.443038, -0.544304, -0.443038, -0.518987, -0.443038, -0.493671, -0.443038, -0.468354, -0.443038, -0.443038, -0.443038, -0.417722, -0.443038, 
-0.392405, -0.443038, -0.367089, -0.443038, -0.341772, -0.443038, -0.316456, -0.443038, -0.291139, -0.443038, -0.265823, -0.443038, -0.240506, -0.443038, -0.21519, -0.443038, 
-0.189873, -0.443038, -0.164557, -0.443038, -0.13924, -0.443038, -0.113924, -0.443038, -0.088608, -0.443038, -0.063291, -0.443038, -0.037975, -0.443038, -0.012658, -0.443038, 
0.012658, -0.443038, 0.037975, -0.443038, 0.063291, -0.443038, 0.088608, -0.443038, 0.113924, -0.443038, 0.13924, -0.443038, 0.164557, -0.443038, 0.189873, -0.443038, 
0.21519, -0.443038, 0.240506, -0.443038, 0.265823, -0.443038, 0.291139, -0.443038, 0.316456, -0.443038, 0.341772, -0.443038, 0.367089, -0.443038, 0.392405, -0.443038, 
0.417722, -0.443038, 0.443038, -0.443038, 0.468354, -0.443038, 0.493671, -0.443038, 0.518987, -0.443038, 0.544304, -0.443038, 0.56962, -0.443038, 0.594937, -0.443038, 
0.620253, -0.443038, 0.64557, -0.443038, 0.670886, -0.443038, 0.696203, -0.443038, 0.721519, -0.443038, 0.746835, -0.443038, 0.772152, -0.443038, 0.797468, -0.443038, 
0.822785, -0.443038, 0.848101, -0.443038, 0.873418, -0.443038, 0.898734, -0.443038, 0.924051, -0.443038, 0.949367, -0.443038, 0.974684, -0.443038, 1.0, -0.443038, 
-1.0, -0.417722, -0.974684, -0.417722, -0.949367, -0.417722, -0.924051, -0.417722, -0.898734, -0.417722, -0.873418, -0.417722, -0.848101, -0.417722, -0.822785, -0.417722, 
-0.797468, -0.417722, -0.772152, -0.417722, -0.746835, -0.417722, -0.721519, -0.417722, -0.696203, -0.417722, -0.670886, -0.417722, -0.64557, -0.417722, -0.620253, -0.417722, 
-0.594937, -0.417722, -0.56962, -0.417722, -0.544304, -0.417722, -0.518987, -0.417722, -0.493671, -0.417722, -0.468354, -0.417722, -0.443038, -0.417722, -0.417722, -0.417722, 
-0.392405, -0.417722, -0.367089, -0.417722, -0.341772, -0.417722, -0.316456, -0.417722, -0.291139, -0.417722, -0.265823, -0.417722, -0.240506, -0.417722, -0.21519, -0.417722, 
-0.189873, -0.417722, -0.164557, -0.417722, -0.13924, -0.417722, -0.113924, -0.417722, -0.088608, -0.417722, -0.063291, -0.417722, -0.037975, -0.417722, -0.012658, -0.417722, 
0.012658, -0.417722, 0.037975, -0.417722, 0.063291, -0.417722, 0.088608, -0.417722, 0.113924, -0.417722, 0.13924, -0.417722, 0.164557, -0.417722, 0.189873, -0.417722, 
0.21519, -0.417722, 0.240506, -0.417722, 0.265823, -0.417722, 0.291139, -0.417722, 0.316456, -0.417722, 0.341772, -0.417722, 0.367089, -0.417722, 0.392405, -0.417722, 
0.417722, -0.417722, 0.443038, -0.417722, 0.468354, -0.417722, 0.493671, -0.417722, 0.518987, -0.417722, 0.544304, -0.417722, 0.56962, -0.417722, 0.594937, -0.417722, 
0.620253, -0.417722, 0.64557, -0.417722, 0.670886, -0.417722, 0.696203, -0.417722, 0.721519, -0.417722, 0.746835, -0.417722, 0.772152, -0.417722, 0.797468, -0.417722, 
0.822785, -0.417722, 0.848101, -0.417722, 0.873418, -0.417722, 0.898734, -0.417722, 0.924051, -0.417722, 0.949367, -0.417722, 0.974684, -0.417722, 1.0, -0.417722, 
-1.0, -0.392405, -0.974684, -0.392405, -0.949367, -0.392405, -0.924051, -0.392405, -0.898734, -0.392405, -0.873418, -0.392405, -0.848101, -0.392405, -0.822785, -0.392405, 
-0.797468, -0.392405, -0.772152, -0.392405, -0.746835, -0.392405, -0.721519, -0.392405, -0.696203, -0.392405, -0.670886, -0.392405, -0.64557, -0.392405, -0.620253, -0.392405, 
-0.594937, -0.392405, -0.56962, -0.392405, -0.544304, -0.392405, -0.518987, -0.392405, -0.493671, -0.392405, -0.468354, -0.392405, -0.443038, -0.392405, -0.417722, -0.392405, 
-0.392405, -0.392405, -0.367089, -0.392405, -0.341772, -0.392405, -0.316456, -0.392405, -0.291139, -0.392405, -0.265823, -0.392405, -0.240506, -0.392405, -0.21519, -0.392405, 
-0.189873, -0.392405, -0.164557, -0.392405, -0.13924, -0.392405, -0.113924, -0.392405, -0.088608, -0.392405, -0.063291, -0.392405, -0.037975, -0.392405, -0.012658, -0.392405, 
0.012658, -0.392405, 0.037975, -0.392405, 0.063291, -0.392405, 0.088608, -0.392405, 0.113924, -0.392405, 0.13924, -0.392405, 0.164557, -0.392405, 0.189873, -0.392405, 
0.21519, -0.392405, 0.240506, -0.392405, 0.265823, -0.392405, 0.291139, -0.392405, 0.316456, -0.392405, 0.341772, -0.392405, 0.367089, -0.392405, 0.392405, -0.392405, 
0.417722, -0.392405, 0.443038, -0.392405, 0.468354, -0.392405, 0.493671, -0.392405, 0.518987, -0.392405, 0.544304, -0.392405, 0.56962, -0.392405, 0.594937, -0.392405, 
0.620253, -0.392405, 0.64557, -0.392405, 0.670886, -0.392405, 0.696203, -0.392405, 0.721519, -0.392405, 0.746835, -0.392405, 0.772152, -0.392405, 0.797468, -0.392405, 
0.822785, -0.392405, 0.848101, -0.392405, 0.873418, -0.392405, 0.898734, -0.392405, 0.924051, -0.392405, 0.949367, -0.392405, 0.974684, -0.392405, 1.0, -0.392405, 
-1.0, -0.367089, -0.974684, -0.367089, -0.949367, -0.367089, -0.924051, -0.367089, -0.898734, -0.367089, -0.873418, -0.367089, -0.848101, -0.367089, -0.822785, -0.367089, 
-0.797468, -0.367089, -0.772152, -0.367089, -0.746835, -0.367089, -0.721519, -0.367089, -0.696203, -0.367089, -0.670886, -0.367089, -0.64557, -0.367089, -0.620253, -0.367089, 
-0.594937, -0.367089, -0.56962, -0.367089, -0.544304, -0.367089, -0.518987, -0.367089, -0.493671, -0.367089, -0.468354, -0.367089, -0.443038, -0.367089, -0.417722, -0.367089, 
-0.392405, -0.367089, -0.367089, -0.367089, -0.341772, -0.367089, -0.316456, -0.367089, -0.291139, -0.367089, -0.265823, -0.367089, -0.240506, -0.367089, -0.21519, -0.367089, 
-0.189873, -0.367089, -0.164557, -0.367089, -0.13924, -0.367089, -0.113924, -0.367089, -0.088608, -0.367089, -0.063291, -0.367089, -0.037975, -0.367089, -0.012658, -0.367089, 
0.012658, -0.367089, 0.037975, -0.367089, 0.063291, -0.367089, 0.088608, -0.367089, 0.113924, -0.367089, 0.13924, -0.367089, 0.164557, -0.367089, 0.189873, -0.367089, 
0.21519, -0.367089, 0.240506, -0.367089, 0.265823, -0.367089, 0.291139, -0.367089, 0.316456, -0.367089, 0.341772, -0.367089, 0.367089, -0.367089, 0.392405, -0.367089, 
0.417722, -0.367089, 0.443038, -0.367089, 0.468354, -0.367089, 0.493671, -0.367089, 0.518987, -0.367089, 0.544304, -0.367089, 0.56962, -0.367089, 0.594937, -0.367089, 
0.620253, -0.367089, 0.64557, -0.367089, 0.670886, -0.367089, 0.696203, -0.367089, 0.721519, -0.367089, 0.746835, -0.367089, 0.772152, -0.367089, 0.797468, -0.367089, 
0.822785, -0.367089, 0.848101, -0.367089, 0.873418, -0.367089, 0.898734, -0.367089, 0.924051, -0.367089, 0.949367, -0.367089, 0.974684, -0.367089, 1.0, -0.367089, 
-1.0, -0.341772, -0.974684, -0.341772, -0.949367, -0.341772, -0.924051, -0.341772, -0.898734, -0.341772, -0.873418, -0.341772, -0.848101, -0.341772, -0.822785, -0.341772, 
-0.797468, -0.341772, -0.772152, -0.341772, -0.746835, -0.341772, -0.721519, -0.341772, -0.696203, -0.341772, -0.670886, -0.341772, -0.64557, -0.341772, -0.620253, -0.341772, 
-0.594937, -0.341772, -0.56962, -0.341772, -0.544304, -0.341772, -0.518987, -0.341772, -0.493671, -0.341772, -0.468354, -0.341772, -0.443038, -0.341772, -0.417722, -0.341772, 
-0.392405, -0.341772, -0.367089, -0.341772, -0.341772, -0.341772, -0.316456, -0.341772, -0.291139, -0.341772, -0.265823, -0.341772, -0.240506, -0.341772, -0.21519, -0.341772, 
-0.189873, -0.341772, -0.164557, -0.341772, -0.13924, -0.341772, -0.113924, -0.341772, -0.088608, -0.341772, -0.063291, -0.341772, -0.037975, -0.341772, -0.012658, -0.341772, 
0.012658, -0.341772, 0.037975, -0.341772, 0.063291, -0.341772, 0.088608, -0.341772, 0.113924, -0.341772, 0.13924, -0.341772, 0.164557, -0.341772, 0.189873, -0.341772, 
0.21519, -0.341772, 0.240506, -0.341772, 0.265823, -0.341772, 0.291139, -0.341772, 0.316456, -0.341772, 0.341772, -0.341772, 0.367089, -0.341772, 0.392405, -0.341772, 
0.417722, -0.341772, 0.443038, -0.341772, 0.468354, -0.341772, 0.493671, -0.341772, 0.518987, -0.341772, 0.544304, -0.341772, 0.56962, -0.341772, 0.594937, -0.341772, 
0.620253, -0.341772, 0.64557, -0.341772, 0.670886, -0.341772, 0.696203, -0.341772, 0.721519, -0.341772, 0.746835, -0.341772, 0.772152, -0.341772, 0.797468, -0.341772, 
0.822785, -0.341772, 0.848101, -0.341772, 0.873418, -0.341772, 0.898734, -0.341772, 0.924051, -0.341772, 0.949367, -0.341772, 0.974684, -0.341772, 1.0, -0.341772, 
-1.0, -0.316456, -0.974684, -0.316456, -0.949367, -0.316456, -0.924051, -0.316456, -0.898734, -0.316456, -0.873418, -0.316456, -0.848101, -0.316456, -0.822785, -0.316456, 
-0.797468, -0.316456, -0.772152, -0.316456, -0.746835, -0.316456, -0.721519, -0.316456, -0.696203, -0.316456, -0.670886, -0.316456, -0.64557, -0.316456, -0.620253, -0.316456, 
-0.594937, -0.316456, -0.56962, -0.316456, -0.544304, -0.316456, -0.518987, -0.316456, -0.493671, -0.316456, -0.468354, -0.316456, -0.443038, -0.316456, -0.417722, -0.316456, 
-0.392405, -0.316456, -0.367089, -0.316456, -0.341772, -0.316456, -0.316456, -0.316456, -0.291139, -0.316456, -0.265823, -0.316456, -0.240506, -0.316456, -0.21519, -0.316456, 
-0.189873, -0.316456, -0.164557, -0.316456, -0.13924, -0.316456, -0.113924, -0.316456, -0.088608, -0.316456, -0.063291, -0.316456, -0.037975, -0.316456, -0.012658, -0.316456, 
0.012658, -0.316456, 0.037975, -0.316456, 0.063291, -0.316456, 0.088608, -0.316456, 0.113924, -0.316456, 0.13924, -0.316456, 0.164557, -0.316456, 0.189873, -0.316456, 
0.21519, -0.316456, 0.240506, -0.316456, 0.265823, -0.316456, 0.291139, -0.316456, 0.316456, -0.316456, 0.341772, -0.316456, 0.367089, -0.316456, 0.392405, -0.316456, 
0.417722, -0.316456, 0.443038, -0.316456, 0.468354, -0.316456, 0.493671, -0.316456, 0.518987, -0.316456, 0.544304, -0.316456, 0.56962, -0.316456, 0.594937, -0.316456, 
0.620253, -0.316456, 0.64557, -0.316456, 0.670886, -0.316456, 0.696203, -0.316456, 0.721519, -0.316456, 0.746835, -0.316456, 0.772152, -0.316456, 0.797468, -0.316456, 
0.822785, -0.316456, 0.848101, -0.316456, 0.873418, -0.316456, 0.898734, -0.316456, 0.924051, -0.316456, 0.949367, -0.316456, 0.974684, -0.316456, 1.0, -0.316456, 
-1.0, -0.291139, -0.974684, -0.291139, -0.949367, -0.291139, -0.924051, -0.291139, -0.898734, -0.291139, -0.873418, -0.291139, -0.848101, -0.291139, -0.822785, -0.291139, 
-0.797468, -0.291139, -0.772152, -0.291139, -0.746835, -0.291139, -0.721519, -0.291139, -0.696203, -0.291139, -0.670886, -0.291139, -0.64557, -0.291139, -0.620253, -0.291139, 
-0.594937, -0.291139, -0.56962, -0.291139, -0.544304, -0.291139, -0.518987, -0.291139, -0.493671, -0.291139, -0.468354, -0.291139, -0.443038, -0.291139, -0.417722, -0.291139, 
-0.392405, -0.291139, -0.367089, -0.291139, -0.341772, -0.291139, -0.316456, -0.291139, -0.291139, -0.291139, -0.265823, -0.291139, -0.240506, -0.291139, -0.21519, -0.291139, 
-0.189873, -0.291139, -0.164557, -0.291139, -0.13924, -0.291139, -0.113924, -0.291139, -0.088608, -0.291139, -0.063291, -0.291139, -0.037975, -0.291139, -0.012658, -0.291139, 
0.012658, -0.291139, 0.037975, -0.291139, 0.063291, -0.291139, 0.088608, -0.291139, 0.113924, -0.291139, 0.13924, -0.291139, 0.164557, -0.291139, 0.189873, -0.291139, 
0.21519, -0.291139, 0.240506, -0.291139, 0.265823, -0.291139, 0.291139, -0.291139, 0.316456, -0.291139, 0.341772, -0.291139, 0.367089, -0.291139, 0.392405, -0.291139, 
0.417722, -0.291139, 0.443038, -0.291139, 0.468354, -0.291139, 0.493671, -0.291139, 0.518987, -0.291139, 0.544304, -0.291139, 0.56962, -0.291139, 0.594937, -0.291139, 
0.620253, -0.291139, 0.64557, -0.291139, 0.670886, -0.291139, 0.696203, -0.291139, 0.721519, -0.291139, 0.746835, -0.291139, 0.772152, -0.291139, 0.797468, -0.291139, 
0.822785, -0.291139, 0.848101, -0.291139, 0.873418, -0.291139, 0.898734, -0.291139, 0.924051, -0.291139, 0.949367, -0.291139, 0.974684, -0.291139, 1.0, -0.291139, 
-1.0, -0.265823, -0.974684, -0.265823, -0.949367, -0.265823, -0.924051, -0.265823, -0.898734, -0.265823, -0.873418, -0.265823, -0.848101, -0.265823, -0.822785, -0.265823, 
-0.797468, -0.265823, -0.772152, -0.265823, -0.746835, -0.265823, -0.721519, -0.265823, -0.696203, -0.265823, -0.670886, -0.265823, -0.64557, -0.265823, -0.620253, -0.265823, 
-0.594937, -0.265823, -0.56962, -0.265823, -0.544304, -0.265823, -0.518987, -0.265823, -0.493671, -0.265823, -0.468354, -0.265823, -0.443038, -0.265823, -0.417722, -0.265823, 
-0.392405, -0.265823, -0.367089, -0.265823, -0.341772, -0.265823, -0.316456, -0.265823, -0.291139, -0.265823, -0.265823, -0.265823, -0.240506, -0.265823, -0.21519, -0.265823, 
-0.189873, -0.265823, -0.164557, -0.265823, -0.13924, -0.265823, -0.113924, -0.265823, -0.088608, -0.265823, -0.063291, -0.265823, -0.037975, -0.265823, -0.012658, -0.265823, 
0.012658, -0.265823, 0.037975, -0.265823, 0.063291, -0.265823, 0.088608, -0.265823, 0.113924, -0.265823, 0.13924, -0.265823, 0.164557, -0.265823, 0.189873, -0.265823, 
0.21519, -0.265823, 0.240506, -0.265823, 0.265823, -0.265823, 0.291139, -0.265823, 0.316456, -0.265823, 0.341772, -0.265823, 0.367089, -0.265823, 0.392405, -0.265823, 
0.417722, -0.265823, 0.443038, -0.265823, 0.468354, -0.265823, 0.493671, -0.265823, 0.518987, -0.265823, 0.544304, -0.265823, 0.56962, -0.265823, 0.594937, -0.265823, 
0.620253, -0.265823, 0.64557, -0.265823, 0.670886, -0.265823, 0.696203, -0.265823, 0.721519, -0.265823, 0.746835, -0.265823, 0.772152, -0.265823, 0.797468, -0.265823, 
0.822785, -0.265823, 0.848101, -0.265823, 0.873418, -0.265823, 0.898734, -0.265823, 0.924051, -0.265823, 0.949367, -0.265823, 0.974684, -0.265823, 1.0, -0.265823, 
-1.0, -0.240506, -0.974684, -0.240506, -0.949367, -0.240506, -0.924051, -0.240506, -0.898734, -0.240506, -0.873418, -0.240506, -0.848101, -0.240506, -0.822785, -0.240506, 
-0.797468, -0.240506, -0.772152, -0.240506, -0.746835, -0.240506, -0.721519, -0.240506, -0.696203, -0.240506, -0.670886, -0.240506, -0.64557, -0.240506, -0.620253, -0.240506, 
-0.594937, -0.240506, -0.56962, -0.240506, -0.544304, -0.240506, -0.518987, -0.240506, -0.493671, -0.240506, -0.468354, -0.240506, -0.443038, -0.240506, -0.417722, -0.240506, 
-0.392405, -0.240506, -0.367089, -0.240506, -0.341772, -0.240506, -0.316456, -0.240506, -0.291139, -0.240506, -0.265823, -0.240506, -0.240506, -0.240506, -0.21519, -0.240506, 
-0.189873, -0.240506, -0.164557, -0.240506, -0.13924, -0.240506, -0.113924, -0.240506, -0.088608, -0.240506, -0.063291, -0.240506, -0.037975, -0.240506, -0.012658, -0.240506, 
0.012658, -0.240506, 0.037975, -0.240506, 0.063291, -0.240506, 0.088608, -0.240506, 0.113924, -0.240506, 0.13924, -0.240506, 0.164557, -0.240506, 0.189873, -0.240506, 
0.21519, -0.240506, 0.240506, -0.240506, 0.265823, -0.240506, 0.291139, -0.240506, 0.316456, -0.240506, 0.341772, -0.240506, 0.367089, -0.240506, 0.392405, -0.240506, 
0.417722, -0.240506, 0.443038, -0.240506, 0.468354, -0.240506, 0.493671, -0.240506, 0.518987, -0.240506, 0.544304, -0.240506, 0.56962, -0.240506, 0.594937, -0.240506, 
0.620253, -0.240506, 0.64557, -0.240506, 0.670886, -0.240506, 0.696203, -0.240506, 0.721519, -0.240506, 0.746835, -0.240506, 0.772152, -0.240506, 0.797468, -0.240506, 
0.822785, -0.240506, 0.848101, -0.240506, 0.873418, -0.240506, 0.898734, -0.240506, 0.924051, -0.240506, 0.949367, -0.240506, 0.974684, -0.240506, 1.0, -0.240506, 
-1.0, -0.21519, -0.974684, -0.21519, -0.949367, -0.21519, -0.924051, -0.21519, -0.898734, -0.21519, -0.873418, -0.21519, -0.848101, -0.21519, -0.822785, -0.21519, 
-0.797468, -0.21519, -0.772152, -0.21519, -0.746835, -0.21519, -0.721519, -0.21519, -0.696203, -0.21519, -0.670886, -0.21519, -0.64557, -0.21519, -0.620253, -0.21519, 
-0.594937, -0.21519, -0.56962, -0.21519, -0.544304, -0.21519, -0.518987, -0.21519, -0.493671, -0.21519, -0.468354, -0.21519, -0.443038, -0.21519, -0.417722, -0.21519, 
-0.392405, -0.21519, -0.367089, -0.21519, -0.341772, -0.21519, -0.316456, -0.21519, -0.291139, -0.21519, -0.265823, -0.21519, -0.240506, -0.21519, -0.21519, -0.21519, 
-0.189873, -0.21519, -0.164557, -0.21519, -0.13924, -0.21519, -0.113924, -0.21519, -0.088608, -0.21519, -0.063291, -0.21519, -0.037975, -0.21519, -0.012658, -0.21519, 
0.012658, -0.21519, 0.037975, -0.21519, 0.063291, -0.21519, 0.088608, -0.21519, 0.113924, -0.21519, 0.13924, -0.21519, 0.164557, -0.21519, 0.189873, -0.21519, 
0.21519, -0.21519, 0.240506, -0.21519, 0.265823, -0.21519, 0.291139, -0.21519, 0.316456, -0.21519, 0.341772, -0.21519, 0.367089, -0.21519, 0.392405, -0.21519, 
0.417722, -0.21519, 0.443038, -0.21519, 0.468354, -0.21519, 0.493671, -0.21519, 0.518987, -0.21519, 0.544304, -0.21519, 0.56962, -0.21519, 0.594937, -0.21519, 
0.620253, -0.21519, 0.64557, -0.21519, 0.670886, -0.21519, 0.696203, -0.21519, 0.721519, -0.21519, 0.746835, -0.21519, 0.772152, -0.21519, 0.797468, -0.21519, 
0.822785, -0.21519, 0.848101, -0.21519, 0.873418, -0.21519, 0.898734, -0.21519, 0.924051, -0.21519, 0.949367, -0.21519, 0.974684, -0.21519, 1.0, -0.21519, 
-1.0, -0.189873, -0.974684, -0.189873, -0.949367, -0.189873, -0.924051, -0.189873, -0.898734, -0.189873, -0.873418, -0.189873, -0.848101, -0.189873, -0.822785, -0.189873, 
-0.797468, -0.189873, -0.772152, -0.189873, -0.746835, -0.189873, -0.721519, -0.189873, -0.696203, -0.189873, -0.670886, -0.189873, -0.64557, -0.189873, -0.620253, -0.189873, 
-0.594937, -0.189873, -0.56962, -0.189873, -0.544304, -0.189873, -0.518987, -0.189873, -0.493671, -0.189873, -0.468354, -0.189873, -0.443038, -0.189873, -0.417722, -0.189873, 
-0.392405, -0.189873, -0.367089, -0.189873, -0.341772, -0.189873, -0.316456, -0.189873, -0.291139, -0.189873, -0.265823, -0.189873, -0.240506, -0.189873, -0.21519, -0.189873, 
-0.189873, -0.189873, -0.164557, -0.189873, -0.13924, -0.189873, -0.113924, -0.189873, -0.088608, -0.189873, -0.063291, -0.189873, -0.037975, -0.189873, -0.012658, -0.189873, 
0.012658, -0.189873, 0.037975, -0.189873, 0.063291, -0.189873, 0.088608, -0.189873, 0.113924, -0.189873, 0.13924, -0.189873, 0.164557, -0.189873, 0.189873, -0.189873, 
0.21519, -0.189873, 0.240506, -0.189873, 0.265823, -0.189873, 0.291139, -0.189873, 0.316456, -0.189873, 0.341772, -0.189873, 0.367089, -0.189873, 0.392405, -0.189873, 
0.417722, -0.189873, 0.443038, -0.189873, 0.468354, -0.189873, 0.493671, -0.189873, 0.518987, -0.189873, 0.544304, -0.189873, 0.56962, -0.189873, 0.594937, -0.189873, 
0.620253, -0.189873, 0.64557, -0.189873, 0.670886, -0.189873, 0.696203, -0.189873, 0.721519, -0.189873, 0.746835, -0.189873, 0.772152, -0.189873, 0.797468, -0.189873, 
0.822785, -0.189873, 0.848101, -0.189873, 0.873418, -0.189873, 0.898734, -0.189873, 0.924051, -0.189873, 0.949367, -0.189873, 0.974684, -0.189873, 1.0, -0.189873, 
-1.0, -0.164557, -0.974684, -0.164557, -0.949367, -0.164557, -0.924051, -0.164557, -0.898734, -0.164557, -0.873418, -0.164557, -0.848101, -0.164557, -0.822785, -0.164557, 
-0.797468, -0.164557, -0.772152, -0.164557, -0.746835, -0.164557, -0.721519, -0.164557, -0.696203, -0.164557, -0.670886, -0.164557, -0.64557, -0.164557, -0.620253, -0.164557, 
-0.594937, -0.164557, -0.56962, -0.164557, -0.544304, -0.164557, -0.518987, -0.164557, -0.493671, -0.164557, -0.468354, -0.164557, -0.443038, -0.164557, -0.417722, -0.164557, 
-0.392405, -0.164557, -0.367089, -0.164557, -0.341772, -0.164557, -0.316456, -0.164557, -0.291139, -0.164557, -0.265823, -0.164557, -0.240506, -0.164557, -0.21519, -0.164557, 
-0.189873, -0.164557, -0.164557, -0.164557, -0.13924, -0.164557, -0.113924, -0.164557, -0.088608, -0.164557, -0.063291, -0.164557, -0.037975, -0.164557, -0.012658, -0.164557, 
0.012658, -0.164557, 0.037975, -0.164557, 0.063291, -0.164557, 0.088608, -0.164557, 0.113924, -0.164557, 0.13924, -0.164557, 0.164557, -0.164557, 0.189873, -0.164557, 
0.21519, -0.164557, 0.240506, -0.164557, 0.265823, -0.164557, 0.291139, -0.164557, 0.316456, -0.164557, 0.341772, -0.164557, 0.367089, -0.164557, 0.392405, -0.164557, 
0.417722, -0.164557, 0.443038, -0.164557, 0.468354, -0.164557, 0.493671, -0.164557, 0.518987, -0.164557, 0.544304, -0.164557, 0.56962, -0.164557, 0.594937, -0.164557, 
0.620253, -0.164557, 0.64557, -0.164557, 0.670886, -0.164557, 0.696203, -0.164557, 0.721519, -0.164557, 0.746835, -0.164557, 0.772152, -0.164557, 0.797468, -0.164557, 
0.822785, -0.164557, 0.848101, -0.164557, 0.873418, -0.164557, 0.898734, -0.164557, 0.924051, -0.164557, 0.949367, -0.164557, 0.974684, -0.164557, 1.0, -0.164557, 
-1.0, -0.13924, -0.974684, -0.13924, -0.949367, -0.13924, -0.924051, -0.13924, -0.898734, -0.13924, -0.873418, -0.13924, -0.848101, -0.13924, -0.822785, -0.13924, 
-0.797468, -0.13924, -0.772152, -0.13924, -0.746835, -0.13924, -0.721519, -0.13924, -0.696203, -0.13924, -0.670886, -0.13924, -0.64557, -0.13924, -0.620253, -0.13924, 
-0.594937, -0.13924, -0.56962, -0.13924, -0.544304, -0.13924, -0.518987, -0.13924, -0.493671, -0.13924, -0.468354, -0.13924, -0.443038, -0.13924, -0.417722, -0.13924, 
-0.392405, -0.13924, -0.367089, -0.13924, -0.341772, -0.13924, -0.316456, -0.13924, -0.291139, -0.13924, -0.265823, -0.13924, -0.240506, -0.13924, -0.21519, -0.13924, 
-0.189873, -0.13924, -0.164557, -0.13924, -0.13924, -0.13924, -0.113924, -0.13924, -0.088608, -0.13924, -0.063291, -0.13924, -0.037975, -0.13924, -0.012658, -0.13924, 
0.012658, -0.13924, 0.037975, -0.13924, 0.063291, -0.13924, 0.088608, -0.13924, 0.113924, -0.13924, 0.13924, -0.13924, 0.164557, -0.13924, 0.189873, -0.13924, 
0.21519, -0.13924, 0.240506, -0.13924, 0.265823, -0.13924, 0.291139, -0.13924, 0.316456, -0.13924, 0.341772, -0.13924, 0.367089, -0.13924, 0.392405, -0.13924, 
0.417722, -0.13924, 0.443038, -0.13924, 0.468354, -0.13924, 0.493671, -0.13924, 0.518987, -0.13924, 0.544304, -0.13924, 0.56962, -0.13924, 0.594937, -0.13924, 
0.620253, -0.13924, 0.64557, -0.13924, 0.670886, -0.13924, 0.696203, -0.13924, 0.721519, -0.13924, 0.746835, -0.13924, 0.772152, -0.13924, 0.797468, -0.13924, 
0.822785, -0.13924, 0.848101, -0.13924, 0.873418, -0.13924, 0.898734, -0.13924, 0.924051, -0.13924, 0.949367, -0.13924, 0.974684, -0.13924, 1.0, -0.13924, 
-1.0, -0.113924, -0.974684, -0.113924, -0.949367, -0.113924, -0.924051, -0.113924, -0.898734, -0.113924, -0.873418, -0.113924, -0.848101, -0.113924, -0.822785, -0.113924, 
-0.797468, -0.113924, -0.772152, -0.113924, -0.746835, -0.113924, -0.721519, -0.113924, -0.696203, -0.113924, -0.670886, -0.113924, -0.64557, -0.113924, -0.620253, -0.113924, 
-0.594937, -0.113924, -0.56962, -0.113924, -0.544304, -0.113924, -0.518987, -0.113924, -0.493671, -0.113924, -0.468354, -0.113924, -0.443038, -0.113924, -0.417722, -0.113924, 
-0.392405, -0.113924, -0.367089, -0.113924, -0.341772, -0.113924, -0.316456, -0.113924, -0.291139, -0.113924, -0.265823, -0.113924, -0.240506, -0.113924, -0.21519, -0.113924, 
-0.189873, -0.113924, -0.164557, -0.113924, -0.13924, -0.113924, -0.113924, -0.113924, -0.088608, -0.113924, -0.063291, -0.113924, -0.037975, -0.113924, -0.012658, -0.113924, 
0.012658, -0.113924, 0.037975, -0.113924, 0.063291, -0.113924, 0.088608, -0.113924, 0.113924, -0.113924, 0.13924, -0.113924, 0.164557, -0.113924, 0.189873, -0.113924, 
0.21519, -0.113924, 0.240506, -0.113924, 0.265823, -0.113924, 0.291139, -0.113924, 0.316456, -0.113924, 0.341772, -0.113924, 0.367089, -0.113924, 0.392405, -0.113924, 
0.417722, -0.113924, 0.443038, -0.113924, 0.468354, -0.113924, 0.493671, -0.113924, 0.518987, -0.113924, 0.544304, -0.113924, 0.56962, -0.113924, 0.594937, -0.113924, 
0.620253, -0.113924, 0.64557, -0.113924, 0.670886, -0.113924, 0.696203, -0.113924, 0.721519, -0.113924, 0.746835, -0.113924, 0.772152, -0.113924, 0.797468, -0.113924, 
0.822785, -0.113924, 0.848101, -0.113924, 0.873418, -0.113924, 0.898734, -0.113924, 0.924051, -0.113924, 0.949367, -0.113924, 0.974684, -0.113924, 1.0, -0.113924, 
-1.0, -0.088608, -0.974684, -0.088608, -0.949367, -0.088608, -0.924051, -0.088608, -0.898734, -0.088608, -0.873418, -0.088608, -0.848101, -0.088608, -0.822785, -0.088608, 
-0.797468, -0.088608, -0.772152, -0.088608, -0.746835, -0.088608, -0.721519, -0.088608, -0.696203, -0.088608, -0.670886, -0.088608, -0.64557, -0.088608, -0.620253, -0.088608, 
-0.594937, -0.088608, -0.56962, -0.088608, -0.544304, -0.088608, -0.518987, -0.088608, -0.493671, -0.088608, -0.468354, -0.088608, -0.443038, -0.088608, -0.417722, -0.088608, 
-0.392405, -0.088608, -0.367089, -0.088608, -0.341772, -0.088608, -0.316456, -0.088608, -0.291139, -0.088608, -0.265823, -0.088608, -0.240506, -0.088608, -0.21519, -0.088608, 
-0.189873, -0.088608, -0.164557, -0.088608, -0.13924, -0.088608, -0.113924, -0.088608, -0.088608, -0.088608, -0.063291, -0.088608, -0.037975, -0.088608, -0.012658, -0.088608, 
0.012658, -0.088608, 0.037975, -0.088608, 0.063291, -0.088608, 0.088608, -0.088608, 0.113924, -0.088608, 0.13924, -0.088608, 0.164557, -0.088608, 0.189873, -0.088608, 
0.21519, -0.088608, 0.240506, -0.088608, 0.265823, -0.088608, 0.291139, -0.088608, 0.316456, -0.088608, 0.341772, -0.088608, 0.367089, -0.088608, 0.392405, -0.088608, 
0.417722, -0.088608, 0.443038, -0.088608, 0.468354, -0.088608, 0.493671, -0.088608, 0.518987, -0.088608, 0.544304, -0.088608, 0.56962, -0.088608, 0.594937, -0.088608, 
0.620253, -0.088608, 0.64557, -0.088608, 0.670886, -0.088608, 0.696203, -0.088608, 0.721519, -0.088608, 0.746835, -0.088608, 0.772152, -0.088608, 0.797468, -0.088608, 
0.822785, -0.088608, 0.848101, -0.088608, 0.873418, -0.088608, 0.898734, -0.088608, 0.924051, -0.088608, 0.949367, -0.088608, 0.974684, -0.088608, 1.0, -0.088608, 
-1.0, -0.063291, -0.974684, -0.063291, -0.949367, -0.063291, -0.924051, -0.063291, -0.898734, -0.063291, -0.873418, -0.063291, -0.848101, -0.063291, -0.822785, -0.063291, 
-0.797468, -0.063291, -0.772152, -0.063291, -0.746835, -0.063291, -0.721519, -0.063291, -0.696203, -0.063291, -0.670886, -0.063291, -0.64557, -0.063291, -0.620253, -0.063291, 
-0.594937, -0.063291, -0.56962, -0.063291, -0.544304, -0.063291, -0.518987, -0.063291, -0.493671, -0.063291, -0.468354, -0.063291, -0.443038, -0.063291, -0.417722, -0.063291, 
-0.392405, -0.063291, -0.367089, -0.063291, -0.341772, -0.063291, -0.316456, -0.063291, -0.291139, -0.063291, -0.265823, -0.063291, -0.240506, -0.063291, -0.21519, -0.063291, 
-0.189873, -0.063291, -0.164557, -0.063291, -0.13924, -0.063291, -0.113924, -0.063291, -0.088608, -0.063291, -0.063291, -0.063291, -0.037975, -0.063291, -0.012658, -0.063291, 
0.012658, -0.063291, 0.037975, -0.063291, 0.063291, -0.063291, 0.088608, -0.063291, 0.113924, -0.063291, 0.13924, -0.063291, 0.164557, -0.063291, 0.189873, -0.063291, 
0.21519, -0.063291, 0.240506, -0.063291, 0.265823, -0.063291, 0.291139, -0.063291, 0.316456, -0.063291, 0.341772, -0.063291, 0.367089, -0.063291, 0.392405, -0.063291, 
0.417722, -0.063291, 0.443038, -0.063291, 0.468354, -0.063291, 0.493671, -0.063291, 0.518987, -0.063291, 0.544304, -0.063291, 0.56962, -0.063291, 0.594937, -0.063291, 
0.620253, -0.063291, 0.64557, -0.063291, 0.670886, -0.063291, 0.696203, -0.063291, 0.721519, -0.063291, 0.746835, -0.063291, 0.772152, -0.063291, 0.797468, -0.063291, 
0.822785, -0.063291, 0.848101, -0.063291, 0.873418, -0.063291, 0.898734, -0.063291, 0.924051, -0.063291, 0.949367, -0.063291, 0.974684, -0.063291, 1.0, -0.063291, 
-1.0, -0.037975, -0.974684, -0.037975, -0.949367, -0.037975, -0.924051, -0.037975, -0.898734, -0.037975, -0.873418, -0.037975, -0.848101, -0.037975, -0.822785, -0.037975, 
-0.797468, -0.037975, -0.772152, -0.037975, -0.746835, -0.037975, -0.721519, -0.037975, -0.696203, -0.037975, -0.670886, -0.037975, -0.64557, -0.037975, -0.620253, -0.037975, 
-0.594937, -0.037975, -0.56962, -0.037975, -0.544304, -0.037975, -0.518987, -0.037975, -0.493671, -0.037975, -0.468354, -0.037975, -0.443038, -0.037975, -0.417722, -0.037975, 
-0.392405, -0.037975, -0.367089, -0.037975, -0.341772, -0.037975, -0.316456, -0.037975, -0.291139, -0.037975, -0.265823, -0.037975, -0.240506, -0.037975, -0.21519, -0.037975, 
-0.189873, -0.037975, -0.164557, -0.037975, -0.13924, -0.037975, -0.113924, -0.037975, -0.088608, -0.037975, -0.063291, -0.037975, -0.037975, -0.037975, -0.012658, -0.037975, 
0.012658, -0.037975, 0.037975, -0.037975, 0.063291, -0.037975, 0.088608, -0.037975, 0.113924, -0.037975, 0.13924, -0.037975, 0.164557, -0.037975, 0.189873, -0.037975, 
0.21519, -0.037975, 0.240506, -0.037975, 0.265823, -0.037975, 0.291139, -0.037975, 0.316456, -0.037975, 0.341772, -0.037975, 0.367089, -0.037975, 0.392405, -0.037975, 
0.417722, -0.037975, 0.443038, -0.037975, 0.468354, -0.037975, 0.493671, -0.037975, 0.518987, -0.037975, 0.544304, -0.037975, 0.56962, -0.037975, 0.594937, -0.037975, 
0.620253, -0.037975, 0.64557, -0.037975, 0.670886, -0.037975, 0.696203, -0.037975, 0.721519, -0.037975, 0.746835, -0.037975, 0.772152, -0.037975, 0.797468, -0.037975, 
0.822785, -0.037975, 0.848101, -0.037975, 0.873418, -0.037975, 0.898734, -0.037975, 0.924051, -0.037975, 0.949367, -0.037975, 0.974684, -0.037975, 1.0, -0.037975, 
-1.0, -0.012658, -0.974684, -0.012658, -0.949367, -0.012658, -0.924051, -0.012658, -0.898734, -0.012658, -0.873418, -0.012658, -0.848101, -0.012658, -0.822785, -0.012658, 
-0.797468, -0.012658, -0.772152, -0.012658, -0.746835, -0.012658, -0.721519, -0.012658, -0.696203, -0.012658, -0.670886, -0.012658, -0.64557, -0.012658, -0.620253, -0.012658, 
-0.594937, -0.012658, -0.56962, -0.012658, -0.544304, -0.012658, -0.518987, -0.012658, -0.493671, -0.012658, -0.468354, -0.012658, -0.443038, -0.012658, -0.417722, -0.012658, 
-0.392405, -0.012658, -0.367089, -0.012658, -0.341772, -0.012658, -0.316456, -0.012658, -0.291139, -0.012658, -0.265823, -0.012658, -0.240506, -0.012658, -0.21519, -0.012658, 
-0.189873, -0.012658, -0.164557, -0.012658, -0.13924, -0.012658, -0.113924, -0.012658, -0.088608, -0.012658, -0.063291, -0.012658, -0.037975, -0.012658, -0.012658, -0.012658, 
0.012658, -0.012658, 0.037975, -0.012658, 0.063291, -0.012658, 0.088608, -0.012658, 0.113924, -0.012658, 0.13924, -0.012658, 0.164557, -0.012658, 0.189873, -0.012658, 
0.21519, -0.012658, 0.240506, -0.012658, 0.265823, -0.012658, 0.291139, -0.012658, 0.316456, -0.012658, 0.341772, -0.012658, 0.367089, -0.012658, 0.392405, -0.012658, 
0.417722, -0.012658, 0.443038, -0.012658, 0.468354, -0.012658, 0.493671, -0.012658, 0.518987, -0.012658, 0.544304, -0.012658, 0.56962, -0.012658, 0.594937, -0.012658, 
0.620253, -0.012658, 0.64557, -0.012658, 0.670886, -0.012658, 0.696203, -0.012658, 0.721519, -0.012658, 0.746835, -0.012658, 0.772152, -0.012658, 0.797468, -0.012658, 
0.822785, -0.012658, 0.848101, -0.012658, 0.873418, -0.012658, 0.898734, -0.012658, 0.924051, -0.012658, 0.949367, -0.012658, 0.974684, -0.012658, 1.0, -0.012658, 
-1.0, 0.012658, -0.974684, 0.012658, -0.949367, 0.012658, -0.924051, 0.012658, -0.898734, 0.012658, -0.873418, 0.012658, -0.848101, 0.012658, -0.822785, 0.012658, 
-0.797468, 0.012658, -0.772152, 0.012658, -0.746835, 0.012658, -0.721519, 0.012658, -0.696203, 0.012658, -0.670886, 0.012658, -0.64557, 0.012658, -0.620253, 0.012658, 
-0.594937, 0.012658, -0.56962, 0.012658, -0.544304, 0.012658, -0.518987, 0.012658, -0.493671, 0.012658, -0.468354, 0.012658, -0.443038, 0.012658, -0.417722, 0.012658, 
-0.392405, 0.012658, -0.367089, 0.012658, -0.341772, 0.012658, -0.316456, 0.012658, -0.291139, 0.012658, -0.265823, 0.012658, -0.240506, 0.012658, -0.21519, 0.012658, 
-0.189873, 0.012658, -0.164557, 0.012658, -0.13924, 0.012658, -0.113924, 0.012658, -0.088608, 0.012658, -0.063291, 0.012658, -0.037975, 0.012658, -0.012658, 0.012658, 
0.012658, 0.012658, 0.037975, 0.012658, 0.063291, 0.012658, 0.088608, 0.012658, 0.113924, 0.012658, 0.13924, 0.012658, 0.164557, 0.012658, 0.189873, 0.012658, 
0.21519, 0.012658, 0.240506, 0.012658, 0.265823, 0.012658, 0.291139, 0.012658, 0.316456, 0.012658, 0.341772, 0.012658, 0.367089, 0.012658, 0.392405, 0.012658, 
0.417722, 0.012658, 0.443038, 0.012658, 0.468354, 0.012658, 0.493671, 0.012658, 0.518987, 0.012658, 0.544304, 0.012658, 0.56962, 0.012658, 0.594937, 0.012658, 
0.620253, 0.012658, 0.64557, 0.012658, 0.670886, 0.012658, 0.696203, 0.012658, 0.721519, 0.012658, 0.746835, 0.012658, 0.772152, 0.012658, 0.797468, 0.012658, 
0.822785, 0.012658, 0.848101, 0.012658, 0.873418, 0.012658, 0.898734, 0.012658, 0.924051, 0.012658, 0.949367, 0.012658, 0.974684, 0.012658, 1.0, 0.012658, 
-1.0, 0.037975, -0.974684, 0.037975, -0.949367, 0.037975, -0.924051, 0.037975, -0.898734, 0.037975, -0.873418, 0.037975, -0.848101, 0.037975, -0.822785, 0.037975, 
-0.797468, 0.037975, -0.772152, 0.037975, -0.746835, 0.037975, -0.721519, 0.037975, -0.696203, 0.037975, -0.670886, 0.037975, -0.64557, 0.037975, -0.620253, 0.037975, 
-0.594937, 0.037975, -0.56962, 0.037975, -0.544304, 0.037975, -0.518987, 0.037975, -0.493671, 0.037975, -0.468354, 0.037975, -0.443038, 0.037975, -0.417722, 0.037975, 
-0.392405, 0.037975, -0.367089, 0.037975, -0.341772, 0.037975, -0.316456, 0.037975, -0.291139, 0.037975, -0.265823, 0.037975, -0.240506, 0.037975, -0.21519, 0.037975, 
-0.189873, 0.037975, -0.164557, 0.037975, -0.13924, 0.037975, -0.113924, 0.037975, -0.088608, 0.037975, -0.063291, 0.037975, -0.037975, 0.037975, -0.012658, 0.037975, 
0.012658, 0.037975, 0.037975, 0.037975, 0.063291, 0.037975, 0.088608, 0.037975, 0.113924, 0.037975, 0.13924, 0.037975, 0.164557, 0.037975, 0.189873, 0.037975, 
0.21519, 0.037975, 0.240506, 0.037975, 0.265823, 0.037975, 0.291139, 0.037975, 0.316456, 0.037975, 0.341772, 0.037975, 0.367089, 0.037975, 0.392405, 0.037975, 
0.417722, 0.037975, 0.443038, 0.037975, 0.468354, 0.037975, 0.493671, 0.037975, 0.518987, 0.037975, 0.544304, 0.037975, 0.56962, 0.037975, 0.594937, 0.037975, 
0.620253, 0.037975, 0.64557, 0.037975, 0.670886, 0.037975, 0.696203, 0.037975, 0.721519, 0.037975, 0.746835, 0.037975, 0.772152, 0.037975, 0.797468, 0.037975, 
0.822785, 0.037975, 0.848101, 0.037975, 0.873418, 0.037975, 0.898734, 0.037975, 0.924051, 0.037975, 0.949367, 0.037975, 0.974684, 0.037975, 1.0, 0.037975, 
-1.0, 0.063291, -0.974684, 0.063291, -0.949367, 0.063291, -0.924051, 0.063291, -0.898734, 0.063291, -0.873418, 0.063291, -0.848101, 0.063291, -0.822785, 0.063291, 
-0.797468, 0.063291, -0.772152, 0.063291, -0.746835, 0.063291, -0.721519, 0.063291, -0.696203, 0.063291, -0.670886, 0.063291, -0.64557, 0.063291, -0.620253, 0.063291, 
-0.594937, 0.063291, -0.56962, 0.063291, -0.544304, 0.063291, -0.518987, 0.063291, -0.493671, 0.063291, -0.468354, 0.063291, -0.443038, 0.063291, -0.417722, 0.063291, 
-0.392405, 0.063291, -0.367089, 0.063291, -0.341772, 0.063291, -0.316456, 0.063291, -0.291139, 0.063291, -0.265823, 0.063291, -0.240506, 0.063291, -0.21519, 0.063291, 
-0.189873, 0.063291, -0.164557, 0.063291, -0.13924, 0.063291, -0.113924, 0.063291, -0.088608, 0.063291, -0.063291, 0.063291, -0.037975, 0.063291, -0.012658, 0.063291, 
0.012658, 0.063291, 0.037975, 0.063291, 0.063291, 0.063291, 0.088608, 0.063291, 0.113924, 0.063291, 0.13924, 0.063291, 0.164557, 0.063291, 0.189873, 0.063291, 
0.21519, 0.063291, 0.240506, 0.063291, 0.265823, 0.063291, 0.291139, 0.063291, 0.316456, 0.063291, 0.341772, 0.063291, 0.367089, 0.063291, 0.392405, 0.063291, 
0.417722, 0.063291, 0.443038, 0.063291, 0.468354, 0.063291, 0.493671, 0.063291, 0.518987, 0.063291, 0.544304, 0.063291, 0.56962, 0.063291, 0.594937, 0.063291, 
0.620253, 0.063291, 0.64557, 0.063291, 0.670886, 0.063291, 0.696203, 0.063291, 0.721519, 0.063291, 0.746835, 0.063291, 0.772152, 0.063291, 0.797468, 0.063291, 
0.822785, 0.063291, 0.848101, 0.063291, 0.873418, 0.063291, 0.898734, 0.063291, 0.924051, 0.063291, 0.949367, 0.063291, 0.974684, 0.063291, 1.0, 0.063291, 
-1.0, 0.088608, -0.974684, 0.088608, -0.949367, 0.088608, -0.924051, 0.088608, -0.898734, 0.088608, -0.873418, 0.088608, -0.848101, 0.088608, -0.822785, 0.088608, 
-0.797468, 0.088608, -0.772152, 0.088608, -0.746835, 0.088608, -0.721519, 0.088608, -0.696203, 0.088608, -0.670886, 0.088608, -0.64557, 0.088608, -0.620253, 0.088608, 
-0.594937, 0.088608, -0.56962, 0.088608, -0.544304, 0.088608, -0.518987, 0.088608, -0.493671, 0.088608, -0.468354, 0.088608, -0.443038, 0.088608, -0.417722, 0.088608, 
-0.392405, 0.088608, -0.367089, 0.088608, -0.341772, 0.088608, -0.316456, 0.088608, -0.291139, 0.088608, -0.265823, 0.088608, -0.240506, 0.088608, -0.21519, 0.088608, 
-0.189873, 0.088608, -0.164557, 0.088608, -0.13924, 0.088608, -0.113924, 0.088608, -0.088608, 0.088608, -0.063291, 0.088608, -0.037975, 0.088608, -0.012658, 0.088608, 
0.012658, 0.088608, 0.037975, 0.088608, 0.063291, 0.088608, 0.088608, 0.088608, 0.113924, 0.088608, 0.13924, 0.088608, 0.164557, 0.088608, 0.189873, 0.088608, 
0.21519, 0.088608, 0.240506, 0.088608, 0.265823, 0.088608, 0.291139, 0.088608, 0.316456, 0.088608, 0.341772, 0.088608, 0.367089, 0.088608, 0.392405, 0.088608, 
0.417722, 0.088608, 0.443038, 0.088608, 0.468354, 0.088608, 0.493671, 0.088608, 0.518987, 0.088608, 0.544304, 0.088608, 0.56962, 0.088608, 0.594937, 0.088608, 
0.620253, 0.088608, 0.64557, 0.088608, 0.670886, 0.088608, 0.696203, 0.088608, 0.721519, 0.088608, 0.746835, 0.088608, 0.772152, 0.088608, 0.797468, 0.088608, 
0.822785, 0.088608, 0.848101, 0.088608, 0.873418, 0.088608, 0.898734, 0.088608, 0.924051, 0.088608, 0.949367, 0.088608, 0.974684, 0.088608, 1.0, 0.088608, 
-1.0, 0.113924, -0.974684, 0.113924, -0.949367, 0.113924, -0.924051, 0.113924, -0.898734, 0.113924, -0.873418, 0.113924, -0.848101, 0.113924, -0.822785, 0.113924, 
-0.797468, 0.113924, -0.772152, 0.113924, -0.746835, 0.113924, -0.721519, 0.113924, -0.696203, 0.113924, -0.670886, 0.113924, -0.64557, 0.113924, -0.620253, 0.113924, 
-0.594937, 0.113924, -0.56962, 0.113924, -0.544304, 0.113924, -0.518987, 0.113924, -0.493671, 0.113924, -0.468354, 0.113924, -0.443038, 0.113924, -0.417722, 0.113924, 
-0.392405, 0.113924, -0.367089, 0.113924, -0.341772, 0.113924, -0.316456, 0.113924, -0.291139, 0.113924, -0.265823, 0.113924, -0.240506, 0.113924, -0.21519, 0.113924, 
-0.189873, 0.113924, -0.164557, 0.113924, -0.13924, 0.113924, -0.113924, 0.113924, -0.088608, 0.113924, -0.063291, 0.113924, -0.037975, 0.113924, -0.012658, 0.113924, 
0.012658, 0.113924, 0.037975, 0.113924, 0.063291, 0.113924, 0.088608, 0.113924, 0.113924, 0.113924, 0.13924, 0.113924, 0.164557, 0.113924, 0.189873, 0.113924, 
0.21519, 0.113924, 0.240506, 0.113924, 0.265823, 0.113924, 0.291139, 0.113924, 0.316456, 0.113924, 0.341772, 0.113924, 0.367089, 0.113924, 0.392405, 0.113924, 
0.417722, 0.113924, 0.443038, 0.113924, 0.468354, 0.113924, 0.493671, 0.113924, 0.518987, 0.113924, 0.544304, 0.113924, 0.56962, 0.113924, 0.594937, 0.113924, 
0.620253, 0.113924, 0.64557, 0.113924, 0.670886, 0.113924, 0.696203, 0.113924, 0.721519, 0.113924, 0.746835, 0.113924, 0.772152, 0.113924, 0.797468, 0.113924, 
0.822785, 0.113924, 0.848101, 0.113924, 0.873418, 0.113924, 0.898734, 0.113924, 0.924051, 0.113924, 0.949367, 0.113924, 0.974684, 0.113924, 1.0, 0.113924, 
-1.0, 0.13924, -0.974684, 0.13924, -0.949367, 0.13924, -0.924051, 0.13924, -0.898734, 0.13924, -0.873418, 0.13924, -0.848101, 0.13924, -0.822785, 0.13924, 
-0.797468, 0.13924, -0.772152, 0.13924, -0.746835, 0.13924, -0.721519, 0.13924, -0.696203, 0.13924, -0.670886, 0.13924, -0.64557, 0.13924, -0.620253, 0.13924, 
-0.594937, 0.13924, -0.56962, 0.13924, -0.544304, 0.13924, -0.518987, 0.13924, -0.493671, 0.13924, -0.468354, 0.13924, -0.443038, 0.13924, -0.417722, 0.13924, 
-0.392405, 0.13924, -0.367089, 0.13924, -0.341772, 0.13924, -0.316456, 0.13924, -0.291139, 0.13924, -0.265823, 0.13924, -0.240506, 0.13924, -0.21519, 0.13924, 
-0.189873, 0.13924, -0.164557, 0.13924, -0.13924, 0.13924, -0.113924, 0.13924, -0.088608, 0.13924, -0.063291, 0.13924, -0.037975, 0.13924, -0.012658, 0.13924, 
0.012658, 0.13924, 0.037975, 0.13924, 0.063291, 0.13924, 0.088608, 0.13924, 0.113924, 0.13924, 0.13924, 0.13924, 0.164557, 0.13924, 0.189873, 0.13924, 
0.21519, 0.13924, 0.240506, 0.13924, 0.265823, 0.13924, 0.291139, 0.13924, 0.316456, 0.13924, 0.341772, 0.13924, 0.367089, 0.13924, 0.392405, 0.13924, 
0.417722, 0.13924, 0.443038, 0.13924, 0.468354, 0.13924, 0.493671, 0.13924, 0.518987, 0.13924, 0.544304, 0.13924, 0.56962, 0.13924, 0.594937, 0.13924, 
0.620253, 0.13924, 0.64557, 0.13924, 0.670886, 0.13924, 0.696203, 0.13924, 0.721519, 0.13924, 0.746835, 0.13924, 0.772152, 0.13924, 0.797468, 0.13924, 
0.822785, 0.13924, 0.848101, 0.13924, 0.873418, 0.13924, 0.898734, 0.13924, 0.924051, 0.13924, 0.949367, 0.13924, 0.974684, 0.13924, 1.0, 0.13924, 
-1.0, 0.164557, -0.974684, 0.164557, -0.949367, 0.164557, -0.924051, 0.164557, -0.898734, 0.164557, -0.873418, 0.164557, -0.848101, 0.164557, -0.822785, 0.164557, 
-0.797468, 0.164557, -0.772152, 0.164557, -0.746835, 0.164557, -0.721519, 0.164557, -0.696203, 0.164557, -0.670886, 0.164557, -0.64557, 0.164557, -0.620253, 0.164557, 
-0.594937, 0.164557, -0.56962, 0.164557, -0.544304, 0.164557, -0.518987, 0.164557, -0.493671, 0.164557, -0.468354, 0.164557, -0.443038, 0.164557, -0.417722, 0.164557, 
-0.392405, 0.164557, -0.367089, 0.164557, -0.341772, 0.164557, -0.316456, 0.164557, -0.291139, 0.164557, -0.265823, 0.164557, -0.240506, 0.164557, -0.21519, 0.164557, 
-0.189873, 0.164557, -0.164557, 0.164557, -0.13924, 0.164557, -0.113924, 0.164557, -0.088608, 0.164557, -0.063291, 0.164557, -0.037975, 0.164557, -0.012658, 0.164557, 
0.012658, 0.164557, 0.037975, 0.164557, 0.063291, 0.164557, 0.088608, 0.164557, 0.113924, 0.164557, 0.13924, 0.164557, 0.164557, 0.164557, 0.189873, 0.164557, 
0.21519, 0.164557, 0.240506, 0.164557, 0.265823, 0.164557, 0.291139, 0.164557, 0.316456, 0.164557, 0.341772, 0.164557, 0.367089, 0.164557, 0.392405, 0.164557, 
0.417722, 0.164557, 0.443038, 0.164557, 0.468354, 0.164557, 0.493671, 0.164557, 0.518987, 0.164557, 0.544304, 0.164557, 0.56962, 0.164557, 0.594937, 0.164557, 
0.620253, 0.164557, 0.64557, 0.164557, 0.670886, 0.164557, 0.696203, 0.164557, 0.721519, 0.164557, 0.746835, 0.164557, 0.772152, 0.164557, 0.797468, 0.164557, 
0.822785, 0.164557, 0.848101, 0.164557, 0.873418, 0.164557, 0.898734, 0.164557, 0.924051, 0.164557, 0.949367, 0.164557, 0.974684, 0.164557, 1.0, 0.164557, 
-1.0, 0.189873, -0.974684, 0.189873, -0.949367, 0.189873, -0.924051, 0.189873, -0.898734, 0.189873, -0.873418, 0.189873, -0.848101, 0.189873, -0.822785, 0.189873, 
-0.797468, 0.189873, -0.772152, 0.189873, -0.746835, 0.189873, -0.721519, 0.189873, -0.696203, 0.189873, -0.670886, 0.189873, -0.64557, 0.189873, -0.620253, 0.189873, 
-0.594937, 0.189873, -0.56962, 0.189873, -0.544304, 0.189873, -0.518987, 0.189873, -0.493671, 0.189873, -0.468354, 0.189873, -0.443038, 0.189873, -0.417722, 0.189873, 
-0.392405, 0.189873, -0.367089, 0.189873, -0.341772, 0.189873, -0.316456, 0.189873, -0.291139, 0.189873, -0.265823, 0.189873, -0.240506, 0.189873, -0.21519, 0.189873, 
-0.189873, 0.189873, -0.164557, 0.189873, -0.13924, 0.189873, -0.113924, 0.189873, -0.088608, 0.189873, -0.063291, 0.189873, -0.037975, 0.189873, -0.012658, 0.189873, 
0.012658, 0.189873, 0.037975, 0.189873, 0.063291, 0.189873, 0.088608, 0.189873, 0.113924, 0.189873, 0.13924, 0.189873, 0.164557, 0.189873, 0.189873, 0.189873, 
0.21519, 0.189873, 0.240506, 0.189873, 0.265823, 0.189873, 0.291139, 0.189873, 0.316456, 0.189873, 0.341772, 0.189873, 0.367089, 0.189873, 0.392405, 0.189873, 
0.417722, 0.189873, 0.443038, 0.189873, 0.468354, 0.189873, 0.493671, 0.189873, 0.518987, 0.189873, 0.544304, 0.189873, 0.56962, 0.189873, 0.594937, 0.189873, 
0.620253, 0.189873, 0.64557, 0.189873, 0.670886, 0.189873, 0.696203, 0.189873, 0.721519, 0.189873, 0.746835, 0.189873, 0.772152, 0.189873, 0.797468, 0.189873, 
0.822785, 0.189873, 0.848101, 0.189873, 0.873418, 0.189873, 0.898734, 0.189873, 0.924051, 0.189873, 0.949367, 0.189873, 0.974684, 0.189873, 1.0, 0.189873, 
-1.0, 0.21519, -0.974684, 0.21519, -0.949367, 0.21519, -0.924051, 0.21519, -0.898734, 0.21519, -0.873418, 0.21519, -0.848101, 0.21519, -0.822785, 0.21519, 
-0.797468, 0.21519, -0.772152, 0.21519, -0.746835, 0.21519, -0.721519, 0.21519, -0.696203, 0.21519, -0.670886, 0.21519, -0.64557, 0.21519, -0.620253, 0.21519, 
-0.594937, 0.21519, -0.56962, 0.21519, -0.544304, 0.21519, -0.518987, 0.21519, -0.493671, 0.21519, -0.468354, 0.21519, -0.443038, 0.21519, -0.417722, 0.21519, 
-0.392405, 0.21519, -0.367089, 0.21519, -0.341772, 0.21519, -0.316456, 0.21519, -0.291139, 0.21519, -0.265823, 0.21519, -0.240506, 0.21519, -0.21519, 0.21519, 
-0.189873, 0.21519, -0.164557, 0.21519, -0.13924, 0.21519, -0.113924, 0.21519, -0.088608, 0.21519, -0.063291, 0.21519, -0.037975, 0.21519, -0.012658, 0.21519, 
0.012658, 0.21519, 0.037975, 0.21519, 0.063291, 0.21519, 0.088608, 0.21519, 0.113924, 0.21519, 0.13924, 0.21519, 0.164557, 0.21519, 0.189873, 0.21519, 
0.21519, 0.21519, 0.240506, 0.21519, 0.265823, 0.21519, 0.291139, 0.21519, 0.316456, 0.21519, 0.341772, 0.21519, 0.367089, 0.21519, 0.392405, 0.21519, 
0.417722, 0.21519, 0.443038, 0.21519, 0.468354, 0.21519, 0.493671, 0.21519, 0.518987, 0.21519, 0.544304, 0.21519, 0.56962, 0.21519, 0.594937, 0.21519, 
0.620253, 0.21519, 0.64557, 0.21519, 0.670886, 0.21519, 0.696203, 0.21519, 0.721519, 0.21519, 0.746835, 0.21519, 0.772152, 0.21519, 0.797468, 0.21519, 
0.822785, 0.21519, 0.848101, 0.21519, 0.873418, 0.21519, 0.898734, 0.21519, 0.924051, 0.21519, 0.949367, 0.21519, 0.974684, 0.21519, 1.0, 0.21519, 
-1.0, 0.240506, -0.974684, 0.240506, -0.949367, 0.240506, -0.924051, 0.240506, -0.898734, 0.240506, -0.873418, 0.240506, -0.848101, 0.240506, -0.822785, 0.240506, 
-0.797468, 0.240506, -0.772152, 0.240506, -0.746835, 0.240506, -0.721519, 0.240506, -0.696203, 0.240506, -0.670886, 0.240506, -0.64557, 0.240506, -0.620253, 0.240506, 
-0.594937, 0.240506, -0.56962, 0.240506, -0.544304, 0.240506, -0.518987, 0.240506, -0.493671, 0.240506, -0.468354, 0.240506, -0.443038, 0.240506, -0.417722, 0.240506, 
-0.392405, 0.240506, -0.367089, 0.240506, -0.341772, 0.240506, -0.316456, 0.240506, -0.291139, 0.240506, -0.265823, 0.240506, -0.240506, 0.240506, -0.21519, 0.240506, 
-0.189873, 0.240506, -0.164557, 0.240506, -0.13924, 0.240506, -0.113924, 0.240506, -0.088608, 0.240506, -0.063291, 0.240506, -0.037975, 0.240506, -0.012658, 0.240506, 
0.012658, 0.240506, 0.037975, 0.240506, 0.063291, 0.240506, 0.088608, 0.240506, 0.113924, 0.240506, 0.13924, 0.240506, 0.164557, 0.240506, 0.189873, 0.240506, 
0.21519, 0.240506, 0.240506, 0.240506, 0.265823, 0.240506, 0.291139, 0.240506, 0.316456, 0.240506, 0.341772, 0.240506, 0.367089, 0.240506, 0.392405, 0.240506, 
0.417722, 0.240506, 0.443038, 0.240506, 0.468354, 0.240506, 0.493671, 0.240506, 0.518987, 0.240506, 0.544304, 0.240506, 0.56962, 0.240506, 0.594937, 0.240506, 
0.620253, 0.240506, 0.64557, 0.240506, 0.670886, 0.240506, 0.696203, 0.240506, 0.721519, 0.240506, 0.746835, 0.240506, 0.772152, 0.240506, 0.797468, 0.240506, 
0.822785, 0.240506, 0.848101, 0.240506, 0.873418, 0.240506, 0.898734, 0.240506, 0.924051, 0.240506, 0.949367, 0.240506, 0.974684, 0.240506, 1.0, 0.240506, 
-1.0, 0.265823, -0.974684, 0.265823, -0.949367, 0.265823, -0.924051, 0.265823, -0.898734, 0.265823, -0.873418, 0.265823, -0.848101, 0.265823, -0.822785, 0.265823, 
-0.797468, 0.265823, -0.772152, 0.265823, -0.746835, 0.265823, -0.721519, 0.265823, -0.696203, 0.265823, -0.670886, 0.265823, -0.64557, 0.265823, -0.620253, 0.265823, 
-0.594937, 0.265823, -0.56962, 0.265823, -0.544304, 0.265823, -0.518987, 0.265823, -0.493671, 0.265823, -0.468354, 0.265823, -0.443038, 0.265823, -0.417722, 0.265823, 
-0.392405, 0.265823, -0.367089, 0.265823, -0.341772, 0.265823, -0.316456, 0.265823, -0.291139, 0.265823, -0.265823, 0.265823, -0.240506, 0.265823, -0.21519, 0.265823, 
-0.189873, 0.265823, -0.164557, 0.265823, -0.13924, 0.265823, -0.113924, 0.265823, -0.088608, 0.265823, -0.063291, 0.265823, -0.037975, 0.265823, -0.012658, 0.265823, 
0.012658, 0.265823, 0.037975, 0.265823, 0.063291, 0.265823, 0.088608, 0.265823, 0.113924, 0.265823, 0.13924, 0.265823, 0.164557, 0.265823, 0.189873, 0.265823, 
0.21519, 0.265823, 0.240506, 0.265823, 0.265823, 0.265823, 0.291139, 0.265823, 0.316456, 0.265823, 0.341772, 0.265823, 0.367089, 0.265823, 0.392405, 0.265823, 
0.417722, 0.265823, 0.443038, 0.265823, 0.468354, 0.265823, 0.493671, 0.265823, 0.518987, 0.265823, 0.544304, 0.265823, 0.56962, 0.265823, 0.594937, 0.265823, 
0.620253, 0.265823, 0.64557, 0.265823, 0.670886, 0.265823, 0.696203, 0.265823, 0.721519, 0.265823, 0.746835, 0.265823, 0.772152, 0.265823, 0.797468, 0.265823, 
0.822785, 0.265823, 0.848101, 0.265823, 0.873418, 0.265823, 0.898734, 0.265823, 0.924051, 0.265823, 0.949367, 0.265823, 0.974684, 0.265823, 1.0, 0.265823, 
-1.0, 0.291139, -0.974684, 0.291139, -0.949367, 0.291139, -0.924051, 0.291139, -0.898734, 0.291139, -0.873418, 0.291139, -0.848101, 0.291139, -0.822785, 0.291139, 
-0.797468, 0.291139, -0.772152, 0.291139, -0.746835, 0.291139, -0.721519, 0.291139, -0.696203, 0.291139, -0.670886, 0.291139, -0.64557, 0.291139, -0.620253, 0.291139, 
-0.594937, 0.291139, -0.56962, 0.291139, -0.544304, 0.291139, -0.518987, 0.291139, -0.493671, 0.291139, -0.468354, 0.291139, -0.443038, 0.291139, -0.417722, 0.291139, 
-0.392405, 0.291139, -0.367089, 0.291139, -0.341772, 0.291139, -0.316456, 0.291139, -0.291139, 0.291139, -0.265823, 0.291139, -0.240506, 0.291139, -0.21519, 0.291139, 
-0.189873, 0.291139, -0.164557, 0.291139, -0.13924, 0.291139, -0.113924, 0.291139, -0.088608, 0.291139, -0.063291, 0.291139, -0.037975, 0.291139, -0.012658, 0.291139, 
0.012658, 0.291139, 0.037975, 0.291139, 0.063291, 0.291139, 0.088608, 0.291139, 0.113924, 0.291139, 0.13924, 0.291139, 0.164557, 0.291139, 0.189873, 0.291139, 
0.21519, 0.291139, 0.240506, 0.291139, 0.265823, 0.291139, 0.291139, 0.291139, 0.316456, 0.291139, 0.341772, 0.291139, 0.367089, 0.291139, 0.392405, 0.291139, 
0.417722, 0.291139, 0.443038, 0.291139, 0.468354, 0.291139, 0.493671, 0.291139, 0.518987, 0.291139, 0.544304, 0.291139, 0.56962, 0.291139, 0.594937, 0.291139, 
0.620253, 0.291139, 0.64557, 0.291139, 0.670886, 0.291139, 0.696203, 0.291139, 0.721519, 0.291139, 0.746835, 0.291139, 0.772152, 0.291139, 0.797468, 0.291139, 
0.822785, 0.291139, 0.848101, 0.291139, 0.873418, 0.291139, 0.898734, 0.291139, 0.924051, 0.291139, 0.949367, 0.291139, 0.974684, 0.291139, 1.0, 0.291139, 
-1.0, 0.316456, -0.974684, 0.316456, -0.949367, 0.316456, -0.924051, 0.316456, -0.898734, 0.316456, -0.873418, 0.316456, -0.848101, 0.316456, -0.822785, 0.316456, 
-0.797468, 0.316456, -0.772152, 0.316456, -0.746835, 0.316456, -0.721519, 0.316456, -0.696203, 0.316456, -0.670886, 0.316456, -0.64557, 0.316456, -0.620253, 0.316456, 
-0.594937, 0.316456, -0.56962, 0.316456, -0.544304, 0.316456, -0.518987, 0.316456, -0.493671, 0.316456, -0.468354, 0.316456, -0.443038, 0.316456, -0.417722, 0.316456, 
-0.392405, 0.316456, -0.367089, 0.316456, -0.341772, 0.316456, -0.316456, 0.316456, -0.291139, 0.316456, -0.265823, 0.316456, -0.240506, 0.316456, -0.21519, 0.316456, 
-0.189873, 0.316456, -0.164557, 0.316456, -0.13924, 0.316456, -0.113924, 0.316456, -0.088608, 0.316456, -0.063291, 0.316456, -0.037975, 0.316456, -0.012658, 0.316456, 
0.012658, 0.316456, 0.037975, 0.316456, 0.063291, 0.316456, 0.088608, 0.316456, 0.113924, 0.316456, 0.13924, 0.316456, 0.164557, 0.316456, 0.189873, 0.316456, 
0.21519, 0.316456, 0.240506, 0.316456, 0.265823, 0.316456, 0.291139, 0.316456, 0.316456, 0.316456, 0.341772, 0.316456, 0.367089, 0.316456, 0.392405, 0.316456, 
0.417722, 0.316456, 0.443038, 0.316456, 0.468354, 0.316456, 0.493671, 0.316456, 0.518987, 0.316456, 0.544304, 0.316456, 0.56962, 0.316456, 0.594937, 0.316456, 
0.620253, 0.316456, 0.64557, 0.316456, 0.670886, 0.316456, 0.696203, 0.316456, 0.721519, 0.316456, 0.746835, 0.316456, 0.772152, 0.316456, 0.797468, 0.316456, 
0.822785, 0.316456, 0.848101, 0.316456, 0.873418, 0.316456, 0.898734, 0.316456, 0.924051, 0.316456, 0.949367, 0.316456, 0.974684, 0.316456, 1.0, 0.316456, 
-1.0, 0.341772, -0.974684, 0.341772, -0.949367, 0.341772, -0.924051, 0.341772, -0.898734, 0.341772, -0.873418, 0.341772, -0.848101, 0.341772, -0.822785, 0.341772, 
-0.797468, 0.341772, -0.772152, 0.341772, -0.746835, 0.341772, -0.721519, 0.341772, -0.696203, 0.341772, -0.670886, 0.341772, -0.64557, 0.341772, -0.620253, 0.341772, 
-0.594937, 0.341772, -0.56962, 0.341772, -0.544304, 0.341772, -0.518987, 0.341772, -0.493671, 0.341772, -0.468354, 0.341772, -0.443038, 0.341772, -0.417722, 0.341772, 
-0.392405, 0.341772, -0.367089, 0.341772, -0.341772, 0.341772, -0.316456, 0.341772, -0.291139, 0.341772, -0.265823, 0.341772, -0.240506, 0.341772, -0.21519, 0.341772, 
-0.189873, 0.341772, -0.164557, 0.341772, -0.13924, 0.341772, -0.113924, 0.341772, -0.088608, 0.341772, -0.063291, 0.341772, -0.037975, 0.341772, -0.012658, 0.341772, 
0.012658, 0.341772, 0.037975, 0.341772, 0.063291, 0.341772, 0.088608, 0.341772, 0.113924, 0.341772, 0.13924, 0.341772, 0.164557, 0.341772, 0.189873, 0.341772, 
0.21519, 0.341772, 0.240506, 0.341772, 0.265823, 0.341772, 0.291139, 0.341772, 0.316456, 0.341772, 0.341772, 0.341772, 0.367089, 0.341772, 0.392405, 0.341772, 
0.417722, 0.341772, 0.443038, 0.341772, 0.468354, 0.341772, 0.493671, 0.341772, 0.518987, 0.341772, 0.544304, 0.341772, 0.56962, 0.341772, 0.594937, 0.341772, 
0.620253, 0.341772, 0.64557, 0.341772, 0.670886, 0.341772, 0.696203, 0.341772, 0.721519, 0.341772, 0.746835, 0.341772, 0.772152, 0.341772, 0.797468, 0.341772, 
0.822785, 0.341772, 0.848101, 0.341772, 0.873418, 0.341772, 0.898734, 0.341772, 0.924051, 0.341772, 0.949367, 0.341772, 0.974684, 0.341772, 1.0, 0.341772, 
-1.0, 0.367089, -0.974684, 0.367089, -0.949367, 0.367089, -0.924051, 0.367089, -0.898734, 0.367089, -0.873418, 0.367089, -0.848101, 0.367089, -0.822785, 0.367089, 
-0.797468, 0.367089, -0.772152, 0.367089, -0.746835, 0.367089, -0.721519, 0.367089, -0.696203, 0.367089, -0.670886, 0.367089, -0.64557, 0.367089, -0.620253, 0.367089, 
-0.594937, 0.367089, -0.56962, 0.367089, -0.544304, 0.367089, -0.518987, 0.367089, -0.493671, 0.367089, -0.468354, 0.367089, -0.443038, 0.367089, -0.417722, 0.367089, 
-0.392405, 0.367089, -0.367089, 0.367089, -0.341772, 0.367089, -0.316456, 0.367089, -0.291139, 0.367089, -0.265823, 0.367089, -0.240506, 0.367089, -0.21519, 0.367089, 
-0.189873, 0.367089, -0.164557, 0.367089, -0.13924, 0.367089, -0.113924, 0.367089, -0.088608, 0.367089, -0.063291, 0.367089, -0.037975, 0.367089, -0.012658, 0.367089, 
0.012658, 0.367089, 0.037975, 0.367089, 0.063291, 0.367089, 0.088608, 0.367089, 0.113924, 0.367089, 0.13924, 0.367089, 0.164557, 0.367089, 0.189873, 0.367089, 
0.21519, 0.367089, 0.240506, 0.367089, 0.265823, 0.367089, 0.291139, 0.367089, 0.316456, 0.367089, 0.341772, 0.367089, 0.367089, 0.367089, 0.392405, 0.367089, 
0.417722, 0.367089, 0.443038, 0.367089, 0.468354, 0.367089, 0.493671, 0.367089, 0.518987, 0.367089, 0.544304, 0.367089, 0.56962, 0.367089, 0.594937, 0.367089, 
0.620253, 0.367089, 0.64557, 0.367089, 0.670886, 0.367089, 0.696203, 0.367089, 0.721519, 0.367089, 0.746835, 0.367089, 0.772152, 0.367089, 0.797468, 0.367089, 
0.822785, 0.367089, 0.848101, 0.367089, 0.873418, 0.367089, 0.898734, 0.367089, 0.924051, 0.367089, 0.949367, 0.367089, 0.974684, 0.367089, 1.0, 0.367089, 
-1.0, 0.392405, -0.974684, 0.392405, -0.949367, 0.392405, -0.924051, 0.392405, -0.898734, 0.392405, -0.873418, 0.392405, -0.848101, 0.392405, -0.822785, 0.392405, 
-0.797468, 0.392405, -0.772152, 0.392405, -0.746835, 0.392405, -0.721519, 0.392405, -0.696203, 0.392405, -0.670886, 0.392405, -0.64557, 0.392405, -0.620253, 0.392405, 
-0.594937, 0.392405, -0.56962, 0.392405, -0.544304, 0.392405, -0.518987, 0.392405, -0.493671, 0.392405, -0.468354, 0.392405, -0.443038, 0.392405, -0.417722, 0.392405, 
-0.392405, 0.392405, -0.367089, 0.392405, -0.341772, 0.392405, -0.316456, 0.392405, -0.291139, 0.392405, -0.265823, 0.392405, -0.240506, 0.392405, -0.21519, 0.392405, 
-0.189873, 0.392405, -0.164557, 0.392405, -0.13924, 0.392405, -0.113924, 0.392405, -0.088608, 0.392405, -0.063291, 0.392405, -0.037975, 0.392405, -0.012658, 0.392405, 
0.012658, 0.392405, 0.037975, 0.392405, 0.063291, 0.392405, 0.088608, 0.392405, 0.113924, 0.392405, 0.13924, 0.392405, 0.164557, 0.392405, 0.189873, 0.392405, 
0.21519, 0.392405, 0.240506, 0.392405, 0.265823, 0.392405, 0.291139, 0.392405, 0.316456, 0.392405, 0.341772, 0.392405, 0.367089, 0.392405, 0.392405, 0.392405, 
0.417722, 0.392405, 0.443038, 0.392405, 0.468354, 0.392405, 0.493671, 0.392405, 0.518987, 0.392405, 0.544304, 0.392405, 0.56962, 0.392405, 0.594937, 0.392405, 
0.620253, 0.392405, 0.64557, 0.392405, 0.670886, 0.392405, 0.696203, 0.392405, 0.721519, 0.392405, 0.746835, 0.392405, 0.772152, 0.392405, 0.797468, 0.392405, 
0.822785, 0.392405, 0.848101, 0.392405, 0.873418, 0.392405, 0.898734, 0.392405, 0.924051, 0.392405, 0.949367, 0.392405, 0.974684, 0.392405, 1.0, 0.392405, 
-1.0, 0.417722, -0.974684, 0.417722, -0.949367, 0.417722, -0.924051, 0.417722, -0.898734, 0.417722, -0.873418, 0.417722, -0.848101, 0.417722, -0.822785, 0.417722, 
-0.797468, 0.417722, -0.772152, 0.417722, -0.746835, 0.417722, -0.721519, 0.417722, -0.696203, 0.417722, -0.670886, 0.417722, -0.64557, 0.417722, -0.620253, 0.417722, 
-0.594937, 0.417722, -0.56962, 0.417722, -0.544304, 0.417722, -0.518987, 0.417722, -0.493671, 0.417722, -0.468354, 0.417722, -0.443038, 0.417722, -0.417722, 0.417722, 
-0.392405, 0.417722, -0.367089, 0.417722, -0.341772, 0.417722, -0.316456, 0.417722, -0.291139, 0.417722, -0.265823, 0.417722, -0.240506, 0.417722, -0.21519, 0.417722, 
-0.189873, 0.417722, -0.164557, 0.417722, -0.13924, 0.417722, -0.113924, 0.417722, -0.088608, 0.417722, -0.063291, 0.417722, -0.037975, 0.417722, -0.012658, 0.417722, 
0.012658, 0.417722, 0.037975, 0.417722, 0.063291, 0.417722, 0.088608, 0.417722, 0.113924, 0.417722, 0.13924, 0.417722, 0.164557, 0.417722, 0.189873, 0.417722, 
0.21519, 0.417722, 0.240506, 0.417722, 0.265823, 0.417722, 0.291139, 0.417722, 0.316456, 0.417722, 0.341772, 0.417722, 0.367089, 0.417722, 0.392405, 0.417722, 
0.417722, 0.417722, 0.443038, 0.417722, 0.468354, 0.417722, 0.493671, 0.417722, 0.518987, 0.417722, 0.544304, 0.417722, 0.56962, 0.417722, 0.594937, 0.417722, 
0.620253, 0.417722, 0.64557, 0.417722, 0.670886, 0.417722, 0.696203, 0.417722, 0.721519, 0.417722, 0.746835, 0.417722, 0.772152, 0.417722, 0.797468, 0.417722, 
0.822785, 0.417722, 0.848101, 0.417722, 0.873418, 0.417722, 0.898734, 0.417722, 0.924051, 0.417722, 0.949367, 0.417722, 0.974684, 0.417722, 1.0, 0.417722, 
-1.0, 0.443038, -0.974684, 0.443038, -0.949367, 0.443038, -0.924051, 0.443038, -0.898734, 0.443038, -0.873418, 0.443038, -0.848101, 0.443038, -0.822785, 0.443038, 
-0.797468, 0.443038, -0.772152, 0.443038, -0.746835, 0.443038, -0.721519, 0.443038, -0.696203, 0.443038, -0.670886, 0.443038, -0.64557, 0.443038, -0.620253, 0.443038, 
-0.594937, 0.443038, -0.56962, 0.443038, -0.544304, 0.443038, -0.518987, 0.443038, -0.493671, 0.443038, -0.468354, 0.443038, -0.443038, 0.443038, -0.417722, 0.443038, 
-0.392405, 0.443038, -0.367089, 0.443038, -0.341772, 0.443038, -0.316456, 0.443038, -0.291139, 0.443038, -0.265823, 0.443038, -0.240506, 0.443038, -0.21519, 0.443038, 
-0.189873, 0.443038, -0.164557, 0.443038, -0.13924, 0.443038, -0.113924, 0.443038, -0.088608, 0.443038, -0.063291, 0.443038, -0.037975, 0.443038, -0.012658, 0.443038, 
0.012658, 0.443038, 0.037975, 0.443038, 0.063291, 0.443038, 0.088608, 0.443038, 0.113924, 0.443038, 0.13924, 0.443038, 0.164557, 0.443038, 0.189873, 0.443038, 
0.21519, 0.443038, 0.240506, 0.443038, 0.265823, 0.443038, 0.291139, 0.443038, 0.316456, 0.443038, 0.341772, 0.443038, 0.367089, 0.443038, 0.392405, 0.443038, 
0.417722, 0.443038, 0.443038, 0.443038, 0.468354, 0.443038, 0.493671, 0.443038, 0.518987, 0.443038, 0.544304, 0.443038, 0.56962, 0.443038, 0.594937, 0.443038, 
0.620253, 0.443038, 0.64557, 0.443038, 0.670886, 0.443038, 0.696203, 0.443038, 0.721519, 0.443038, 0.746835, 0.443038, 0.772152, 0.443038, 0.797468, 0.443038, 
0.822785, 0.443038, 0.848101, 0.443038, 0.873418, 0.443038, 0.898734, 0.443038, 0.924051, 0.443038, 0.949367, 0.443038, 0.974684, 0.443038, 1.0, 0.443038, 
-1.0, 0.468354, -0.974684, 0.468354, -0.949367, 0.468354, -0.924051, 0.468354, -0.898734, 0.468354, -0.873418, 0.468354, -0.848101, 0.468354, -0.822785, 0.468354, 
-0.797468, 0.468354, -0.772152, 0.468354, -0.746835, 0.468354, -0.721519, 0.468354, -0.696203, 0.468354, -0.670886, 0.468354, -0.64557, 0.468354, -0.620253, 0.468354, 
-0.594937, 0.468354, -0.56962, 0.468354, -0.544304, 0.468354, -0.518987, 0.468354, -0.493671, 0.468354, -0.468354, 0.468354, -0.443038, 0.468354, -0.417722, 0.468354, 
-0.392405, 0.468354, -0.367089, 0.468354, -0.341772, 0.468354, -0.316456, 0.468354, -0.291139, 0.468354, -0.265823, 0.468354, -0.240506, 0.468354, -0.21519, 0.468354, 
-0.189873, 0.468354, -0.164557, 0.468354, -0.13924, 0.468354, -0.113924, 0.468354, -0.088608, 0.468354, -0.063291, 0.468354, -0.037975, 0.468354, -0.012658, 0.468354, 
0.012658, 0.468354, 0.037975, 0.468354, 0.063291, 0.468354, 0.088608, 0.468354, 0.113924, 0.468354, 0.13924, 0.468354, 0.164557, 0.468354, 0.189873, 0.468354, 
0.21519, 0.468354, 0.240506, 0.468354, 0.265823, 0.468354, 0.291139, 0.468354, 0.316456, 0.468354, 0.341772, 0.468354, 0.367089, 0.468354, 0.392405, 0.468354, 
0.417722, 0.468354, 0.443038, 0.468354, 0.468354, 0.468354, 0.493671, 0.468354, 0.518987, 0.468354, 0.544304, 0.468354, 0.56962, 0.468354, 0.594937, 0.468354, 
0.620253, 0.468354, 0.64557, 0.468354, 0.670886, 0.468354, 0.696203, 0.468354, 0.721519, 0.468354, 0.746835, 0.468354, 0.772152, 0.468354, 0.797468, 0.468354, 
0.822785, 0.468354, 0.848101, 0.468354, 0.873418, 0.468354, 0.898734, 0.468354, 0.924051, 0.468354, 0.949367, 0.468354, 0.974684, 0.468354, 1.0, 0.468354, 
-1.0, 0.493671, -0.974684, 0.493671, -0.949367, 0.493671, -0.924051, 0.493671, -0.898734, 0.493671, -0.873418, 0.493671, -0.848101, 0.493671, -0.822785, 0.493671, 
-0.797468, 0.493671, -0.772152, 0.493671, -0.746835, 0.493671, -0.721519, 0.493671, -0.696203, 0.493671, -0.670886, 0.493671, -0.64557, 0.493671, -0.620253, 0.493671, 
-0.594937, 0.493671, -0.56962, 0.493671, -0.544304, 0.493671, -0.518987, 0.493671, -0.493671, 0.493671, -0.468354, 0.493671, -0.443038, 0.493671, -0.417722, 0.493671, 
-0.392405, 0.493671, -0.367089, 0.493671, -0.341772, 0.493671, -0.316456, 0.493671, -0.291139, 0.493671, -0.265823, 0.493671, -0.240506, 0.493671, -0.21519, 0.493671, 
-0.189873, 0.493671, -0.164557, 0.493671, -0.13924, 0.493671, -0.113924, 0.493671, -0.088608, 0.493671, -0.063291, 0.493671, -0.037975, 0.493671, -0.012658, 0.493671, 
0.012658, 0.493671, 0.037975, 0.493671, 0.063291, 0.493671, 0.088608, 0.493671, 0.113924, 0.493671, 0.13924, 0.493671, 0.164557, 0.493671, 0.189873, 0.493671, 
0.21519, 0.493671, 0.240506, 0.493671, 0.265823, 0.493671, 0.291139, 0.493671, 0.316456, 0.493671, 0.341772, 0.493671, 0.367089, 0.493671, 0.392405, 0.493671, 
0.417722, 0.493671, 0.443038, 0.493671, 0.468354, 0.493671, 0.493671, 0.493671, 0.518987, 0.493671, 0.544304, 0.493671, 0.56962, 0.493671, 0.594937, 0.493671, 
0.620253, 0.493671, 0.64557, 0.493671, 0.670886, 0.493671, 0.696203, 0.493671, 0.721519, 0.493671, 0.746835, 0.493671, 0.772152, 0.493671, 0.797468, 0.493671, 
0.822785, 0.493671, 0.848101, 0.493671, 0.873418, 0.493671, 0.898734, 0.493671, 0.924051, 0.493671, 0.949367, 0.493671, 0.974684, 0.493671, 1.0, 0.493671, 
-1.0, 0.518987, -0.974684, 0.518987, -0.949367, 0.518987, -0.924051, 0.518987, -0.898734, 0.518987, -0.873418, 0.518987, -0.848101, 0.518987, -0.822785, 0.518987, 
-0.797468, 0.518987, -0.772152, 0.518987, -0.746835, 0.518987, -0.721519, 0.518987, -0.696203, 0.518987, -0.670886, 0.518987, -0.64557, 0.518987, -0.620253, 0.518987, 
-0.594937, 0.518987, -0.56962, 0.518987, -0.544304, 0.518987, -0.518987, 0.518987, -0.493671, 0.518987, -0.468354, 0.518987, -0.443038, 0.518987, -0.417722, 0.518987, 
-0.392405, 0.518987, -0.367089, 0.518987, -0.341772, 0.518987, -0.316456, 0.518987, -0.291139, 0.518987, -0.265823, 0.518987, -0.240506, 0.518987, -0.21519, 0.518987, 
-0.189873, 0.518987, -0.164557, 0.518987, -0.13924, 0.518987, -0.113924, 0.518987, -0.088608, 0.518987, -0.063291, 0.518987, -0.037975, 0.518987, -0.012658, 0.518987, 
0.012658, 0.518987, 0.037975, 0.518987, 0.063291, 0.518987, 0.088608, 0.518987, 0.113924, 0.518987, 0.13924, 0.518987, 0.164557, 0.518987, 0.189873, 0.518987, 
0.21519, 0.518987, 0.240506, 0.518987, 0.265823, 0.518987, 0.291139, 0.518987, 0.316456, 0.518987, 0.341772, 0.518987, 0.367089, 0.518987, 0.392405, 0.518987, 
0.417722, 0.518987, 0.443038, 0.518987, 0.468354, 0.518987, 0.493671, 0.518987, 0.518987, 0.518987, 0.544304, 0.518987, 0.56962, 0.518987, 0.594937, 0.518987, 
0.620253, 0.518987, 0.64557, 0.518987, 0.670886, 0.518987, 0.696203, 0.518987, 0.721519, 0.518987, 0.746835, 0.518987, 0.772152, 0.518987, 0.797468, 0.518987, 
0.822785, 0.518987, 0.848101, 0.518987, 0.873418, 0.518987, 0.898734, 0.518987, 0.924051, 0.518987, 0.949367, 0.518987, 0.974684, 0.518987, 1.0, 0.518987, 
-1.0, 0.544304, -0.974684, 0.544304, -0.949367, 0.544304, -0.924051, 0.544304, -0.898734, 0.544304, -0.873418, 0.544304, -0.848101, 0.544304, -0.822785, 0.544304, 
-0.797468, 0.544304, -0.772152, 0.544304, -0.746835, 0.544304, -0.721519, 0.544304, -0.696203, 0.544304, -0.670886, 0.544304, -0.64557, 0.544304, -0.620253, 0.544304, 
-0.594937, 0.544304, -0.56962, 0.544304, -0.544304, 0.544304, -0.518987, 0.544304, -0.493671, 0.544304, -0.468354, 0.544304, -0.443038, 0.544304, -0.417722, 0.544304, 
-0.392405, 0.544304, -0.367089, 0.544304, -0.341772, 0.544304, -0.316456, 0.544304, -0.291139, 0.544304, -0.265823, 0.544304, -0.240506, 0.544304, -0.21519, 0.544304, 
-0.189873, 0.544304, -0.164557, 0.544304, -0.13924, 0.544304, -0.113924, 0.544304, -0.088608, 0.544304, -0.063291, 0.544304, -0.037975, 0.544304, -0.012658, 0.544304, 
0.012658, 0.544304, 0.037975, 0.544304, 0.063291, 0.544304, 0.088608, 0.544304, 0.113924, 0.544304, 0.13924, 0.544304, 0.164557, 0.544304, 0.189873, 0.544304, 
0.21519, 0.544304, 0.240506, 0.544304, 0.265823, 0.544304, 0.291139, 0.544304, 0.316456, 0.544304, 0.341772, 0.544304, 0.367089, 0.544304, 0.392405, 0.544304, 
0.417722, 0.544304, 0.443038, 0.544304, 0.468354, 0.544304, 0.493671, 0.544304, 0.518987, 0.544304, 0.544304, 0.544304, 0.56962, 0.544304, 0.594937, 0.544304, 
0.620253, 0.544304, 0.64557, 0.544304, 0.670886, 0.544304, 0.696203, 0.544304, 0.721519, 0.544304, 0.746835, 0.544304, 0.772152, 0.544304, 0.797468, 0.544304, 
0.822785, 0.544304, 0.848101, 0.544304, 0.873418, 0.544304, 0.898734, 0.544304, 0.924051, 0.544304, 0.949367, 0.544304, 0.974684, 0.544304, 1.0, 0.544304, 
-1.0, 0.56962, -0.974684, 0.56962, -0.949367, 0.56962, -0.924051, 0.56962, -0.898734, 0.56962, -0.873418, 0.56962, -0.848101, 0.56962, -0.822785, 0.56962, 
-0.797468, 0.56962, -0.772152, 0.56962, -0.746835, 0.56962, -0.721519, 0.56962, -0.696203, 0.56962, -0.670886, 0.56962, -0.64557, 0.56962, -0.620253, 0.56962, 
-0.594937, 0.56962, -0.56962, 0.56962, -0.544304, 0.56962, -0.518987, 0.56962, -0.493671, 0.56962, -0.468354, 0.56962, -0.443038, 0.56962, -0.417722, 0.56962, 
-0.392405, 0.56962, -0.367089, 0.56962, -0.341772, 0.56962, -0.316456, 0.56962, -0.291139, 0.56962, -0.265823, 0.56962, -0.240506, 0.56962, -0.21519, 0.56962, 
-0.189873, 0.56962, -0.164557, 0.56962, -0.13924, 0.56962, -0.113924, 0.56962, -0.088608, 0.56962, -0.063291, 0.56962, -0.037975, 0.56962, -0.012658, 0.56962, 
0.012658, 0.56962, 0.037975, 0.56962, 0.063291, 0.56962, 0.088608, 0.56962, 0.113924, 0.56962, 0.13924, 0.56962, 0.164557, 0.56962, 0.189873, 0.56962, 
0.21519, 0.56962, 0.240506, 0.56962, 0.265823, 0.56962, 0.291139, 0.56962, 0.316456, 0.56962, 0.341772, 0.56962, 0.367089, 0.56962, 0.392405, 0.56962, 
0.417722, 0.56962, 0.443038, 0.56962, 0.468354, 0.56962, 0.493671, 0.56962, 0.518987, 0.56962, 0.544304, 0.56962, 0.56962, 0.56962, 0.594937, 0.56962, 
0.620253, 0.56962, 0.64557, 0.56962, 0.670886, 0.56962, 0.696203, 0.56962, 0.721519, 0.56962, 0.746835, 0.56962, 0.772152, 0.56962, 0.797468, 0.56962, 
0.822785, 0.56962, 0.848101, 0.56962, 0.873418, 0.56962, 0.898734, 0.56962, 0.924051, 0.56962, 0.949367, 0.56962, 0.974684, 0.56962, 1.0, 0.56962, 
-1.0, 0.594937, -0.974684, 0.594937, -0.949367, 0.594937, -0.924051, 0.594937, -0.898734, 0.594937, -0.873418, 0.594937, -0.848101, 0.594937, -0.822785, 0.594937, 
-0.797468, 0.594937, -0.772152, 0.594937, -0.746835, 0.594937, -0.721519, 0.594937, -0.696203, 0.594937, -0.670886, 0.594937, -0.64557, 0.594937, -0.620253, 0.594937, 
-0.594937, 0.594937, -0.56962, 0.594937, -0.544304, 0.594937, -0.518987, 0.594937, -0.493671, 0.594937, -0.468354, 0.594937, -0.443038, 0.594937, -0.417722, 0.594937, 
-0.392405, 0.594937, -0.367089, 0.594937, -0.341772, 0.594937, -0.316456, 0.594937, -0.291139, 0.594937, -0.265823, 0.594937, -0.240506, 0.594937, -0.21519, 0.594937, 
-0.189873, 0.594937, -0.164557, 0.594937, -0.13924, 0.594937, -0.113924, 0.594937, -0.088608, 0.594937, -0.063291, 0.594937, -0.037975, 0.594937, -0.012658, 0.594937, 
0.012658, 0.594937, 0.037975, 0.594937, 0.063291, 0.594937, 0.088608, 0.594937, 0.113924, 0.594937, 0.13924, 0.594937, 0.164557, 0.594937, 0.189873, 0.594937, 
0.21519, 0.594937, 0.240506, 0.594937, 0.265823, 0.594937, 0.291139, 0.594937, 0.316456, 0.594937, 0.341772, 0.594937, 0.367089, 0.594937, 0.392405, 0.594937, 
0.417722, 0.594937, 0.443038, 0.594937, 0.468354, 0.594937, 0.493671, 0.594937, 0.518987, 0.594937, 0.544304, 0.594937, 0.56962, 0.594937, 0.594937, 0.594937, 
0.620253, 0.594937, 0.64557, 0.594937, 0.670886, 0.594937, 0.696203, 0.594937, 0.721519, 0.594937, 0.746835, 0.594937, 0.772152, 0.594937, 0.797468, 0.594937, 
0.822785, 0.594937, 0.848101, 0.594937, 0.873418, 0.594937, 0.898734, 0.594937, 0.924051, 0.594937, 0.949367, 0.594937, 0.974684, 0.594937, 1.0, 0.594937, 
-1.0, 0.620253, -0.974684, 0.620253, -0.949367, 0.620253, -0.924051, 0.620253, -0.898734, 0.620253, -0.873418, 0.620253, -0.848101, 0.620253, -0.822785, 0.620253, 
-0.797468, 0.620253, -0.772152, 0.620253, -0.746835, 0.620253, -0.721519, 0.620253, -0.696203, 0.620253, -0.670886, 0.620253, -0.64557, 0.620253, -0.620253, 0.620253, 
-0.594937, 0.620253, -0.56962, 0.620253, -0.544304, 0.620253, -0.518987, 0.620253, -0.493671, 0.620253, -0.468354, 0.620253, -0.443038, 0.620253, -0.417722, 0.620253, 
-0.392405, 0.620253, -0.367089, 0.620253, -0.341772, 0.620253, -0.316456, 0.620253, -0.291139, 0.620253, -0.265823, 0.620253, -0.240506, 0.620253, -0.21519, 0.620253, 
-0.189873, 0.620253, -0.164557, 0.620253, -0.13924, 0.620253, -0.113924, 0.620253, -0.088608, 0.620253, -0.063291, 0.620253, -0.037975, 0.620253, -0.012658, 0.620253, 
0.012658, 0.620253, 0.037975, 0.620253, 0.063291, 0.620253, 0.088608, 0.620253, 0.113924, 0.620253, 0.13924, 0.620253, 0.164557, 0.620253, 0.189873, 0.620253, 
0.21519, 0.620253, 0.240506, 0.620253, 0.265823, 0.620253, 0.291139, 0.620253, 0.316456, 0.620253, 0.341772, 0.620253, 0.367089, 0.620253, 0.392405, 0.620253, 
0.417722, 0.620253, 0.443038, 0.620253, 0.468354, 0.620253, 0.493671, 0.620253, 0.518987, 0.620253, 0.544304, 0.620253, 0.56962, 0.620253, 0.594937, 0.620253, 
0.620253, 0.620253, 0.64557, 0.620253, 0.670886, 0.620253, 0.696203, 0.620253, 0.721519, 0.620253, 0.746835, 0.620253, 0.772152, 0.620253, 0.797468, 0.620253, 
0.822785, 0.620253, 0.848101, 0.620253, 0.873418, 0.620253, 0.898734, 0.620253, 0.924051, 0.620253, 0.949367, 0.620253, 0.974684, 0.620253, 1.0, 0.620253, 
-1.0, 0.64557, -0.974684, 0.64557, -0.949367, 0.64557, -0.924051, 0.64557, -0.898734, 0.64557, -0.873418, 0.64557, -0.848101, 0.64557, -0.822785, 0.64557, 
-0.797468, 0.64557, -0.772152, 0.64557, -0.746835, 0.64557, -0.721519, 0.64557, -0.696203, 0.64557, -0.670886, 0.64557, -0.64557, 0.64557, -0.620253, 0.64557, 
-0.594937, 0.64557, -0.56962, 0.64557, -0.544304, 0.64557, -0.518987, 0.64557, -0.493671, 0.64557, -0.468354, 0.64557, -0.443038, 0.64557, -0.417722, 0.64557, 
-0.392405, 0.64557, -0.367089, 0.64557, -0.341772, 0.64557, -0.316456, 0.64557, -0.291139, 0.64557, -0.265823, 0.64557, -0.240506, 0.64557, -0.21519, 0.64557, 
-0.189873, 0.64557, -0.164557, 0.64557, -0.13924, 0.64557, -0.113924, 0.64557, -0.088608, 0.64557, -0.063291, 0.64557, -0.037975, 0.64557, -0.012658, 0.64557, 
0.012658, 0.64557, 0.037975, 0.64557, 0.063291, 0.64557, 0.088608, 0.64557, 0.113924, 0.64557, 0.13924, 0.64557, 0.164557, 0.64557, 0.189873, 0.64557, 
0.21519, 0.64557, 0.240506, 0.64557, 0.265823, 0.64557, 0.291139, 0.64557, 0.316456, 0.64557, 0.341772, 0.64557, 0.367089, 0.64557, 0.392405, 0.64557, 
0.417722, 0.64557, 0.443038, 0.64557, 0.468354, 0.64557, 0.493671, 0.64557, 0.518987, 0.64557, 0.544304, 0.64557, 0.56962, 0.64557, 0.594937, 0.64557, 
0.620253, 0.64557, 0.64557, 0.64557, 0.670886, 0.64557, 0.696203, 0.64557, 0.721519, 0.64557, 0.746835, 0.64557, 0.772152, 0.64557, 0.797468, 0.64557, 
0.822785, 0.64557, 0.848101, 0.64557, 0.873418, 0.64557, 0.898734, 0.64557, 0.924051, 0.64557, 0.949367, 0.64557, 0.974684, 0.64557, 1.0, 0.64557, 
-1.0, 0.670886, -0.974684, 0.670886, -0.949367, 0.670886, -0.924051, 0.670886, -0.898734, 0.670886, -0.873418, 0.670886, -0.848101, 0.670886, -0.822785, 0.670886, 
-0.797468, 0.670886, -0.772152, 0.670886, -0.746835, 0.670886, -0.721519, 0.670886, -0.696203, 0.670886, -0.670886, 0.670886, -0.64557, 0.670886, -0.620253, 0.670886, 
-0.594937, 0.670886, -0.56962, 0.670886, -0.544304, 0.670886, -0.518987, 0.670886, -0.493671, 0.670886, -0.468354, 0.670886, -0.443038, 0.670886, -0.417722, 0.670886, 
-0.392405, 0.670886, -0.367089, 0.670886, -0.341772, 0.670886, -0.316456, 0.670886, -0.291139, 0.670886, -0.265823, 0.670886, -0.240506, 0.670886, -0.21519, 0.670886, 
-0.189873, 0.670886, -0.164557, 0.670886, -0.13924, 0.670886, -0.113924, 0.670886, -0.088608, 0.670886, -0.063291, 0.670886, -0.037975, 0.670886, -0.012658, 0.670886, 
0.012658, 0.670886, 0.037975, 0.670886, 0.063291, 0.670886, 0.088608, 0.670886, 0.113924, 0.670886, 0.13924, 0.670886, 0.164557, 0.670886, 0.189873, 0.670886, 
0.21519, 0.670886, 0.240506, 0.670886, 0.265823, 0.670886, 0.291139, 0.670886, 0.316456, 0.670886, 0.341772, 0.670886, 0.367089, 0.670886, 0.392405, 0.670886, 
0.417722, 0.670886, 0.443038, 0.670886, 0.468354, 0.670886, 0.493671, 0.670886, 0.518987, 0.670886, 0.544304, 0.670886, 0.56962, 0.670886, 0.594937, 0.670886, 
0.620253, 0.670886, 0.64557, 0.670886, 0.670886, 0.670886, 0.696203, 0.670886, 0.721519, 0.670886, 0.746835, 0.670886, 0.772152, 0.670886, 0.797468, 0.670886, 
0.822785, 0.670886, 0.848101, 0.670886, 0.873418, 0.670886, 0.898734, 0.670886, 0.924051, 0.670886, 0.949367, 0.670886, 0.974684, 0.670886, 1.0, 0.670886, 
-1.0, 0.696203, -0.974684, 0.696203, -0.949367, 0.696203, -0.924051, 0.696203, -0.898734, 0.696203, -0.873418, 0.696203, -0.848101, 0.696203, -0.822785, 0.696203, 
-0.797468, 0.696203, -0.772152, 0.696203, -0.746835, 0.696203, -0.721519, 0.696203, -0.696203, 0.696203, -0.670886, 0.696203, -0.64557, 0.696203, -0.620253, 0.696203, 
-0.594937, 0.696203, -0.56962, 0.696203, -0.544304, 0.696203, -0.518987, 0.696203, -0.493671, 0.696203, -0.468354, 0.696203, -0.443038, 0.696203, -0.417722, 0.696203, 
-0.392405, 0.696203, -0.367089, 0.696203, -0.341772, 0.696203, -0.316456, 0.696203, -0.291139, 0.696203, -0.265823, 0.696203, -0.240506, 0.696203, -0.21519, 0.696203, 
-0.189873, 0.696203, -0.164557, 0.696203, -0.13924, 0.696203, -0.113924, 0.696203, -0.088608, 0.696203, -0.063291, 0.696203, -0.037975, 0.696203, -0.012658, 0.696203, 
0.012658, 0.696203, 0.037975, 0.696203, 0.063291, 0.696203, 0.088608, 0.696203, 0.113924, 0.696203, 0.13924, 0.696203, 0.164557, 0.696203, 0.189873, 0.696203, 
0.21519, 0.696203, 0.240506, 0.696203, 0.265823, 0.696203, 0.291139, 0.696203, 0.316456, 0.696203, 0.341772, 0.696203, 0.367089, 0.696203, 0.392405, 0.696203, 
0.417722, 0.696203, 0.443038, 0.696203, 0.468354, 0.696203, 0.493671, 0.696203, 0.518987, 0.696203, 0.544304, 0.696203, 0.56962, 0.696203, 0.594937, 0.696203, 
0.620253, 0.696203, 0.64557, 0.696203, 0.670886, 0.696203, 0.696203, 0.696203, 0.721519, 0.696203, 0.746835, 0.696203, 0.772152, 0.696203, 0.797468, 0.696203, 
0.822785, 0.696203, 0.848101, 0.696203, 0.873418, 0.696203, 0.898734, 0.696203, 0.924051, 0.696203, 0.949367, 0.696203, 0.974684, 0.696203, 1.0, 0.696203, 
-1.0, 0.721519, -0.974684, 0.721519, -0.949367, 0.721519, -0.924051, 0.721519, -0.898734, 0.721519, -0.873418, 0.721519, -0.848101, 0.721519, -0.822785, 0.721519, 
-0.797468, 0.721519, -0.772152, 0.721519, -0.746835, 0.721519, -0.721519, 0.721519, -0.696203, 0.721519, -0.670886, 0.721519, -0.64557, 0.721519, -0.620253, 0.721519, 
-0.594937, 0.721519, -0.56962, 0.721519, -0.544304, 0.721519, -0.518987, 0.721519, -0.493671, 0.721519, -0.468354, 0.721519, -0.443038, 0.721519, -0.417722, 0.721519, 
-0.392405, 0.721519, -0.367089, 0.721519, -0.341772, 0.721519, -0.316456, 0.721519, -0.291139, 0.721519, -0.265823, 0.721519, -0.240506, 0.721519, -0.21519, 0.721519, 
-0.189873, 0.721519, -0.164557, 0.721519, -0.13924, 0.721519, -0.113924, 0.721519, -0.088608, 0.721519, -0.063291, 0.721519, -0.037975, 0.721519, -0.012658, 0.721519, 
0.012658, 0.721519, 0.037975, 0.721519, 0.063291, 0.721519, 0.088608, 0.721519, 0.113924, 0.721519, 0.13924, 0.721519, 0.164557, 0.721519, 0.189873, 0.721519, 
0.21519, 0.721519, 0.240506, 0.721519, 0.265823, 0.721519, 0.291139, 0.721519, 0.316456, 0.721519, 0.341772, 0.721519, 0.367089, 0.721519, 0.392405, 0.721519, 
0.417722, 0.721519, 0.443038, 0.721519, 0.468354, 0.721519, 0.493671, 0.721519, 0.518987, 0.721519, 0.544304, 0.721519, 0.56962, 0.721519, 0.594937, 0.721519, 
0.620253, 0.721519, 0.64557, 0.721519, 0.670886, 0.721519, 0.696203, 0.721519, 0.721519, 0.721519, 0.746835, 0.721519, 0.772152, 0.721519, 0.797468, 0.721519, 
0.822785, 0.721519, 0.848101, 0.721519, 0.873418, 0.721519, 0.898734, 0.721519, 0.924051, 0.721519, 0.949367, 0.721519, 0.974684, 0.721519, 1.0, 0.721519, 
-1.0, 0.746835, -0.974684, 0.746835, -0.949367, 0.746835, -0.924051, 0.746835, -0.898734, 0.746835, -0.873418, 0.746835, -0.848101, 0.746835, -0.822785, 0.746835, 
-0.797468, 0.746835, -0.772152, 0.746835, -0.746835, 0.746835, -0.721519, 0.746835, -0.696203, 0.746835, -0.670886, 0.746835, -0.64557, 0.746835, -0.620253, 0.746835, 
-0.594937, 0.746835, -0.56962, 0.746835, -0.544304, 0.746835, -0.518987, 0.746835, -0.493671, 0.746835, -0.468354, 0.746835, -0.443038, 0.746835, -0.417722, 0.746835, 
-0.392405, 0.746835, -0.367089, 0.746835, -0.341772, 0.746835, -0.316456, 0.746835, -0.291139, 0.746835, -0.265823, 0.746835, -0.240506, 0.746835, -0.21519, 0.746835, 
-0.189873, 0.746835, -0.164557, 0.746835, -0.13924, 0.746835, -0.113924, 0.746835, -0.088608, 0.746835, -0.063291, 0.746835, -0.037975, 0.746835, -0.012658, 0.746835, 
0.012658, 0.746835, 0.037975, 0.746835, 0.063291, 0.746835, 0.088608, 0.746835, 0.113924, 0.746835, 0.13924, 0.746835, 0.164557, 0.746835, 0.189873, 0.746835, 
0.21519, 0.746835, 0.240506, 0.746835, 0.265823, 0.746835, 0.291139, 0.746835, 0.316456, 0.746835, 0.341772, 0.746835, 0.367089, 0.746835, 0.392405, 0.746835, 
0.417722, 0.746835, 0.443038, 0.746835, 0.468354, 0.746835, 0.493671, 0.746835, 0.518987, 0.746835, 0.544304, 0.746835, 0.56962, 0.746835, 0.594937, 0.746835, 
0.620253, 0.746835, 0.64557, 0.746835, 0.670886, 0.746835, 0.696203, 0.746835, 0.721519, 0.746835, 0.746835, 0.746835, 0.772152, 0.746835, 0.797468, 0.746835, 
0.822785, 0.746835, 0.848101, 0.746835, 0.873418, 0.746835, 0.898734, 0.746835, 0.924051, 0.746835, 0.949367, 0.746835, 0.974684, 0.746835, 1.0, 0.746835, 
-1.0, 0.772152, -0.974684, 0.772152, -0.949367, 0.772152, -0.924051, 0.772152, -0.898734, 0.772152, -0.873418, 0.772152, -0.848101, 0.772152, -0.822785, 0.772152, 
-0.797468, 0.772152, -0.772152, 0.772152, -0.746835, 0.772152, -0.721519, 0.772152, -0.696203, 0.772152, -0.670886, 0.772152, -0.64557, 0.772152, -0.620253, 0.772152, 
-0.594937, 0.772152, -0.56962, 0.772152, -0.544304, 0.772152, -0.518987, 0.772152, -0.493671, 0.772152, -0.468354, 0.772152, -0.443038, 0.772152, -0.417722, 0.772152, 
-0.392405, 0.772152, -0.367089, 0.772152, -0.341772, 0.772152, -0.316456, 0.772152, -0.291139, 0.772152, -0.265823, 0.772152, -0.240506, 0.772152, -0.21519, 0.772152, 
-0.189873, 0.772152, -0.164557, 0.772152, -0.13924, 0.772152, -0.113924, 0.772152, -0.088608, 0.772152, -0.063291, 0.772152, -0.037975, 0.772152, -0.012658, 0.772152, 
0.012658, 0.772152, 0.037975, 0.772152, 0.063291, 0.772152, 0.088608, 0.772152, 0.113924, 0.772152, 0.13924, 0.772152, 0.164557, 0.772152, 0.189873, 0.772152, 
0.21519, 0.772152, 0.240506, 0.772152, 0.265823, 0.772152, 0.291139, 0.772152, 0.316456, 0.772152, 0.341772, 0.772152, 0.367089, 0.772152, 0.392405, 0.772152, 
0.417722, 0.772152, 0.443038, 0.772152, 0.468354, 0.772152, 0.493671, 0.772152, 0.518987, 0.772152, 0.544304, 0.772152, 0.56962, 0.772152, 0.594937, 0.772152, 
0.620253, 0.772152, 0.64557, 0.772152, 0.670886, 0.772152, 0.696203, 0.772152, 0.721519, 0.772152, 0.746835, 0.772152, 0.772152, 0.772152, 0.797468, 0.772152, 
0.822785, 0.772152, 0.848101, 0.772152, 0.873418, 0.772152, 0.898734, 0.772152, 0.924051, 0.772152, 0.949367, 0.772152, 0.974684, 0.772152, 1.0, 0.772152, 
-1.0, 0.797468, -0.974684, 0.797468, -0.949367, 0.797468, -0.924051, 0.797468, -0.898734, 0.797468, -0.873418, 0.797468, -0.848101, 0.797468, -0.822785, 0.797468, 
-0.797468, 0.797468, -0.772152, 0.797468, -0.746835, 0.797468, -0.721519, 0.797468, -0.696203, 0.797468, -0.670886, 0.797468, -0.64557, 0.797468, -0.620253, 0.797468, 
-0.594937, 0.797468, -0.56962, 0.797468, -0.544304, 0.797468, -0.518987, 0.797468, -0.493671, 0.797468, -0.468354, 0.797468, -0.443038, 0.797468, -0.417722, 0.797468, 
-0.392405, 0.797468, -0.367089, 0.797468, -0.341772, 0.797468, -0.316456, 0.797468, -0.291139, 0.797468, -0.265823, 0.797468, -0.240506, 0.797468, -0.21519, 0.797468, 
-0.189873, 0.797468, -0.164557, 0.797468, -0.13924, 0.797468, -0.113924, 0.797468, -0.088608, 0.797468, -0.063291, 0.797468, -0.037975, 0.797468, -0.012658, 0.797468, 
0.012658, 0.797468, 0.037975, 0.797468, 0.063291, 0.797468, 0.088608, 0.797468, 0.113924, 0.797468, 0.13924, 0.797468, 0.164557, 0.797468, 0.189873, 0.797468, 
0.21519, 0.797468, 0.240506, 0.797468, 0.265823, 0.797468, 0.291139, 0.797468, 0.316456, 0.797468, 0.341772, 0.797468, 0.367089, 0.797468, 0.392405, 0.797468, 
0.417722, 0.797468, 0.443038, 0.797468, 0.468354, 0.797468, 0.493671, 0.797468, 0.518987, 0.797468, 0.544304, 0.797468, 0.56962, 0.797468, 0.594937, 0.797468, 
0.620253, 0.797468, 0.64557, 0.797468, 0.670886, 0.797468, 0.696203, 0.797468, 0.721519, 0.797468, 0.746835, 0.797468, 0.772152, 0.797468, 0.797468, 0.797468, 
0.822785, 0.797468, 0.848101, 0.797468, 0.873418, 0.797468, 0.898734, 0.797468, 0.924051, 0.797468, 0.949367, 0.797468, 0.974684, 0.797468, 1.0, 0.797468, 
-1.0, 0.822785, -0.974684, 0.822785, -0.949367, 0.822785, -0.924051, 0.822785, -0.898734, 0.822785, -0.873418, 0.822785, -0.848101, 0.822785, -0.822785, 0.822785, 
-0.797468, 0.822785, -0.772152, 0.822785, -0.746835, 0.822785, -0.721519, 0.822785, -0.696203, 0.822785, -0.670886, 0.822785, -0.64557, 0.822785, -0.620253, 0.822785, 
-0.594937, 0.822785, -0.56962, 0.822785, -0.544304, 0.822785, -0.518987, 0.822785, -0.493671, 0.822785, -0.468354, 0.822785, -0.443038, 0.822785, -0.417722, 0.822785, 
-0.392405, 0.822785, -0.367089, 0.822785, -0.341772, 0.822785, -0.316456, 0.822785, -0.291139, 0.822785, -0.265823, 0.822785, -0.240506, 0.822785, -0.21519, 0.822785, 
-0.189873, 0.822785, -0.164557, 0.822785, -0.13924, 0.822785, -0.113924, 0.822785, -0.088608, 0.822785, -0.063291, 0.822785, -0.037975, 0.822785, -0.012658, 0.822785, 
0.012658, 0.822785, 0.037975, 0.822785, 0.063291, 0.822785, 0.088608, 0.822785, 0.113924, 0.822785, 0.13924, 0.822785, 0.164557, 0.822785, 0.189873, 0.822785, 
0.21519, 0.822785, 0.240506, 0.822785, 0.265823, 0.822785, 0.291139, 0.822785, 0.316456, 0.822785, 0.341772, 0.822785, 0.367089, 0.822785, 0.392405, 0.822785, 
0.417722, 0.822785, 0.443038, 0.822785, 0.468354, 0.822785, 0.493671, 0.822785, 0.518987, 0.822785, 0.544304, 0.822785, 0.56962, 0.822785, 0.594937, 0.822785, 
0.620253, 0.822785, 0.64557, 0.822785, 0.670886, 0.822785, 0.696203, 0.822785, 0.721519, 0.822785, 0.746835, 0.822785, 0.772152, 0.822785, 0.797468, 0.822785, 
0.822785, 0.822785, 0.848101, 0.822785, 0.873418, 0.822785, 0.898734, 0.822785, 0.924051, 0.822785, 0.949367, 0.822785, 0.974684, 0.822785, 1.0, 0.822785, 
-1.0, 0.848101, -0.974684, 0.848101, -0.949367, 0.848101, -0.924051, 0.848101, -0.898734, 0.848101, -0.873418, 0.848101, -0.848101, 0.848101, -0.822785, 0.848101, 
-0.797468, 0.848101, -0.772152, 0.848101, -0.746835, 0.848101, -0.721519, 0.848101, -0.696203, 0.848101, -0.670886, 0.848101, -0.64557, 0.848101, -0.620253, 0.848101, 
-0.594937, 0.848101, -0.56962, 0.848101, -0.544304, 0.848101, -0.518987, 0.848101, -0.493671, 0.848101, -0.468354, 0.848101, -0.443038, 0.848101, -0.417722, 0.848101, 
-0.392405, 0.848101, -0.367089, 0.848101, -0.341772, 0.848101, -0.316456, 0.848101, -0.291139, 0.848101, -0.265823, 0.848101, -0.240506, 0.848101, -0.21519, 0.848101, 
-0.189873, 0.848101, -0.164557, 0.848101, -0.13924, 0.848101, -0.113924, 0.848101, -0.088608, 0.848101, -0.063291, 0.848101, -0.037975, 0.848101, -0.012658, 0.848101, 
0.012658, 0.848101, 0.037975, 0.848101, 0.063291, 0.848101, 0.088608, 0.848101, 0.113924, 0.848101, 0.13924, 0.848101, 0.164557, 0.848101, 0.189873, 0.848101, 
0.21519, 0.848101, 0.240506, 0.848101, 0.265823, 0.848101, 0.291139, 0.848101, 0.316456, 0.848101, 0.341772, 0.848101, 0.367089, 0.848101, 0.392405, 0.848101, 
0.417722, 0.848101, 0.443038, 0.848101, 0.468354, 0.848101, 0.493671, 0.848101, 0.518987, 0.848101, 0.544304, 0.848101, 0.56962, 0.848101, 0.594937, 0.848101, 
0.620253, 0.848101, 0.64557, 0.848101, 0.670886, 0.848101, 0.696203, 0.848101, 0.721519, 0.848101, 0.746835, 0.848101, 0.772152, 0.848101, 0.797468, 0.848101, 
0.822785, 0.848101, 0.848101, 0.848101, 0.873418, 0.848101, 0.898734, 0.848101, 0.924051, 0.848101, 0.949367, 0.848101, 0.974684, 0.848101, 1.0, 0.848101, 
-1.0, 0.873418, -0.974684, 0.873418, -0.949367, 0.873418, -0.924051, 0.873418, -0.898734, 0.873418, -0.873418, 0.873418, -0.848101, 0.873418, -0.822785, 0.873418, 
-0.797468, 0.873418, -0.772152, 0.873418, -0.746835, 0.873418, -0.721519, 0.873418, -0.696203, 0.873418, -0.670886, 0.873418, -0.64557, 0.873418, -0.620253, 0.873418, 
-0.594937, 0.873418, -0.56962, 0.873418, -0.544304, 0.873418, -0.518987, 0.873418, -0.493671, 0.873418, -0.468354, 0.873418, -0.443038, 0.873418, -0.417722, 0.873418, 
-0.392405, 0.873418, -0.367089, 0.873418, -0.341772, 0.873418, -0.316456, 0.873418, -0.291139, 0.873418, -0.265823, 0.873418, -0.240506, 0.873418, -0.21519, 0.873418, 
-0.189873, 0.873418, -0.164557, 0.873418, -0.13924, 0.873418, -0.113924, 0.873418, -0.088608, 0.873418, -0.063291, 0.873418, -0.037975, 0.873418, -0.012658, 0.873418, 
0.012658, 0.873418, 0.037975, 0.873418, 0.063291, 0.873418, 0.088608, 0.873418, 0.113924, 0.873418, 0.13924, 0.873418, 0.164557, 0.873418, 0.189873, 0.873418, 
0.21519, 0.873418, 0.240506, 0.873418, 0.265823, 0.873418, 0.291139, 0.873418, 0.316456, 0.873418, 0.341772, 0.873418, 0.367089, 0.873418, 0.392405, 0.873418, 
0.417722, 0.873418, 0.443038, 0.873418, 0.468354, 0.873418, 0.493671, 0.873418, 0.518987, 0.873418, 0.544304, 0.873418, 0.56962, 0.873418, 0.594937, 0.873418, 
0.620253, 0.873418, 0.64557, 0.873418, 0.670886, 0.873418, 0.696203, 0.873418, 0.721519, 0.873418, 0.746835, 0.873418, 0.772152, 0.873418, 0.797468, 0.873418, 
0.822785, 0.873418, 0.848101, 0.873418, 0.873418, 0.873418, 0.898734, 0.873418, 0.924051, 0.873418, 0.949367, 0.873418, 0.974684, 0.873418, 1.0, 0.873418, 
-1.0, 0.898734, -0.974684, 0.898734, -0.949367, 0.898734, -0.924051, 0.898734, -0.898734, 0.898734, -0.873418, 0.898734, -0.848101, 0.898734, -0.822785, 0.898734, 
-0.797468, 0.898734, -0.772152, 0.898734, -0.746835, 0.898734, -0.721519, 0.898734, -0.696203, 0.898734, -0.670886, 0.898734, -0.64557, 0.898734, -0.620253, 0.898734, 
-0.594937, 0.898734, -0.56962, 0.898734, -0.544304, 0.898734, -0.518987, 0.898734, -0.493671, 0.898734, -0.468354, 0.898734, -0.443038, 0.898734, -0.417722, 0.898734, 
-0.392405, 0.898734, -0.367089, 0.898734, -0.341772, 0.898734, -0.316456, 0.898734, -0.291139, 0.898734, -0.265823, 0.898734, -0.240506, 0.898734, -0.21519, 0.898734, 
-0.189873, 0.898734, -0.164557, 0.898734, -0.13924, 0.898734, -0.113924, 0.898734, -0.088608, 0.898734, -0.063291, 0.898734, -0.037975, 0.898734, -0.012658, 0.898734, 
0.012658, 0.898734, 0.037975, 0.898734, 0.063291, 0.898734, 0.088608, 0.898734, 0.113924, 0.898734, 0.13924, 0.898734, 0.164557, 0.898734, 0.189873, 0.898734, 
0.21519, 0.898734, 0.240506, 0.898734, 0.265823, 0.898734, 0.291139, 0.898734, 0.316456, 0.898734, 0.341772, 0.898734, 0.367089, 0.898734, 0.392405, 0.898734, 
0.417722, 0.898734, 0.443038, 0.898734, 0.468354, 0.898734, 0.493671, 0.898734, 0.518987, 0.898734, 0.544304, 0.898734, 0.56962, 0.898734, 0.594937, 0.898734, 
0.620253, 0.898734, 0.64557, 0.898734, 0.670886, 0.898734, 0.696203, 0.898734, 0.721519, 0.898734, 0.746835, 0.898734, 0.772152, 0.898734, 0.797468, 0.898734, 
0.822785, 0.898734, 0.848101, 0.898734, 0.873418, 0.898734, 0.898734, 0.898734, 0.924051, 0.898734, 0.949367, 0.898734, 0.974684, 0.898734, 1.0, 0.898734, 
-1.0, 0.924051, -0.974684, 0.924051, -0.949367, 0.924051, -0.924051, 0.924051, -0.898734, 0.924051, -0.873418, 0.924051, -0.848101, 0.924051, -0.822785, 0.924051, 
-0.797468, 0.924051, -0.772152, 0.924051, -0.746835, 0.924051, -0.721519, 0.924051, -0.696203, 0.924051, -0.670886, 0.924051, -0.64557, 0.924051, -0.620253, 0.924051, 
-0.594937, 0.924051, -0.56962, 0.924051, -0.544304, 0.924051, -0.518987, 0.924051, -0.493671, 0.924051, -0.468354, 0.924051, -0.443038, 0.924051, -0.417722, 0.924051, 
-0.392405, 0.924051, -0.367089, 0.924051, -0.341772, 0.924051, -0.316456, 0.924051, -0.291139, 0.924051, -0.265823, 0.924051, -0.240506, 0.924051, -0.21519, 0.924051, 
-0.189873, 0.924051, -0.164557, 0.924051, -0.13924, 0.924051, -0.113924, 0.924051, -0.088608, 0.924051, -0.063291, 0.924051, -0.037975, 0.924051, -0.012658, 0.924051, 
0.012658, 0.924051, 0.037975, 0.924051, 0.063291, 0.924051, 0.088608, 0.924051, 0.113924, 0.924051, 0.13924, 0.924051, 0.164557, 0.924051, 0.189873, 0.924051, 
0.21519, 0.924051, 0.240506, 0.924051, 0.265823, 0.924051, 0.291139, 0.924051, 0.316456, 0.924051, 0.341772, 0.924051, 0.367089, 0.924051, 0.392405, 0.924051, 
0.417722, 0.924051, 0.443038, 0.924051, 0.468354, 0.924051, 0.493671, 0.924051, 0.518987, 0.924051, 0.544304, 0.924051, 0.56962, 0.924051, 0.594937, 0.924051, 
0.620253, 0.924051, 0.64557, 0.924051, 0.670886, 0.924051, 0.696203, 0.924051, 0.721519, 0.924051, 0.746835, 0.924051, 0.772152, 0.924051, 0.797468, 0.924051, 
0.822785, 0.924051, 0.848101, 0.924051, 0.873418, 0.924051, 0.898734, 0.924051, 0.924051, 0.924051, 0.949367, 0.924051, 0.974684, 0.924051, 1.0, 0.924051, 
-1.0, 0.949367, -0.974684, 0.949367, -0.949367, 0.949367, -0.924051, 0.949367, -0.898734, 0.949367, -0.873418, 0.949367, -0.848101, 0.949367, -0.822785, 0.949367, 
-0.797468, 0.949367, -0.772152, 0.949367, -0.746835, 0.949367, -0.721519, 0.949367, -0.696203, 0.949367, -0.670886, 0.949367, -0.64557, 0.949367, -0.620253, 0.949367, 
-0.594937, 0.949367, -0.56962, 0.949367, -0.544304, 0.949367, -0.518987, 0.949367, -0.493671, 0.949367, -0.468354, 0.949367, -0.443038, 0.949367, -0.417722, 0.949367, 
-0.392405, 0.949367, -0.367089, 0.949367, -0.341772, 0.949367, -0.316456, 0.949367, -0.291139, 0.949367, -0.265823, 0.949367, -0.240506, 0.949367, -0.21519, 0.949367, 
-0.189873, 0.949367, -0.164557, 0.949367, -0.13924, 0.949367, -0.113924, 0.949367, -0.088608, 0.949367, -0.063291, 0.949367, -0.037975, 0.949367, -0.012658, 0.949367, 
0.012658, 0.949367, 0.037975, 0.949367, 0.063291, 0.949367, 0.088608, 0.949367, 0.113924, 0.949367, 0.13924, 0.949367, 0.164557, 0.949367, 0.189873, 0.949367, 
0.21519, 0.949367, 0.240506, 0.949367, 0.265823, 0.949367, 0.291139, 0.949367, 0.316456, 0.949367, 0.341772, 0.949367, 0.367089, 0.949367, 0.392405, 0.949367, 
0.417722, 0.949367, 0.443038, 0.949367, 0.468354, 0.949367, 0.493671, 0.949367, 0.518987, 0.949367, 0.544304, 0.949367, 0.56962, 0.949367, 0.594937, 0.949367, 
0.620253, 0.949367, 0.64557, 0.949367, 0.670886, 0.949367, 0.696203, 0.949367, 0.721519, 0.949367, 0.746835, 0.949367, 0.772152, 0.949367, 0.797468, 0.949367, 
0.822785, 0.949367, 0.848101, 0.949367, 0.873418, 0.949367, 0.898734, 0.949367, 0.924051, 0.949367, 0.949367, 0.949367, 0.974684, 0.949367, 1.0, 0.949367, 
-1.0, 0.974684, -0.974684, 0.974684, -0.949367, 0.974684, -0.924051, 0.974684, -0.898734, 0.974684, -0.873418, 0.974684, -0.848101, 0.974684, -0.822785, 0.974684, 
-0.797468, 0.974684, -0.772152, 0.974684, -0.746835, 0.974684, -0.721519, 0.974684, -0.696203, 0.974684, -0.670886, 0.974684, -0.64557, 0.974684, -0.620253, 0.974684, 
-0.594937, 0.974684, -0.56962, 0.974684, -0.544304, 0.974684, -0.518987, 0.974684, -0.493671, 0.974684, -0.468354, 0.974684, -0.443038, 0.974684, -0.417722, 0.974684, 
-0.392405, 0.974684, -0.367089, 0.974684, -0.341772, 0.974684, -0.316456, 0.974684, -0.291139, 0.974684, -0.265823, 0.974684, -0.240506, 0.974684, -0.21519, 0.974684, 
-0.189873, 0.974684, -0.164557, 0.974684, -0.13924, 0.974684, -0.113924, 0.974684, -0.088608, 0.974684, -0.063291, 0.974684, -0.037975, 0.974684, -0.012658, 0.974684, 
0.012658, 0.974684, 0.037975, 0.974684, 0.063291, 0.974684, 0.088608, 0.974684, 0.113924, 0.974684, 0.13924, 0.974684, 0.164557, 0.974684, 0.189873, 0.974684, 
0.21519, 0.974684, 0.240506, 0.974684, 0.265823, 0.974684, 0.291139, 0.974684, 0.316456, 0.974684, 0.341772, 0.974684, 0.367089, 0.974684, 0.392405, 0.974684, 
0.417722, 0.974684, 0.443038, 0.974684, 0.468354, 0.974684, 0.493671, 0.974684, 0.518987, 0.974684, 0.544304, 0.974684, 0.56962, 0.974684, 0.594937, 0.974684, 
0.620253, 0.974684, 0.64557, 0.974684, 0.670886, 0.974684, 0.696203, 0.974684, 0.721519, 0.974684, 0.746835, 0.974684, 0.772152, 0.974684, 0.797468, 0.974684, 
0.822785, 0.974684, 0.848101, 0.974684, 0.873418, 0.974684, 0.898734, 0.974684, 0.924051, 0.974684, 0.949367, 0.974684, 0.974684, 0.974684, 1.0, 0.974684, 
-1.0, 1.0, -0.974684, 1.0, -0.949367, 1.0, -0.924051, 1.0, -0.898734, 1.0, -0.873418, 1.0, -0.848101, 1.0, -0.822785, 1.0, 
-0.797468, 1.0, -0.772152, 1.0, -0.746835, 1.0, -0.721519, 1.0, -0.696203, 1.0, -0.670886, 1.0, -0.64557, 1.0, -0.620253, 1.0, 
-0.594937, 1.0, -0.56962, 1.0, -0.544304, 1.0, -0.518987, 1.0, -0.493671, 1.0, -0.468354, 1.0, -0.443038, 1.0, -0.417722, 1.0, 
-0.392405, 1.0, -0.367089, 1.0, -0.341772, 1.0, -0.316456, 1.0, -0.291139, 1.0, -0.265823, 1.0, -0.240506, 1.0, -0.21519, 1.0, 
-0.189873, 1.0, -0.164557, 1.0, -0.13924, 1.0, -0.113924, 1.0, -0.088608, 1.0, -0.063291, 1.0, -0.037975, 1.0, -0.012658, 1.0, 
0.012658, 1.0, 0.037975, 1.0, 0.063291, 1.0, 0.088608, 1.0, 0.113924, 1.0, 0.13924, 1.0, 0.164557, 1.0, 0.189873, 1.0, 
0.21519, 1.0, 0.240506, 1.0, 0.265823, 1.0, 0.291139, 1.0, 0.316456, 1.0, 0.341772, 1.0, 0.367089, 1.0, 0.392405, 1.0, 
0.417722, 1.0, 0.443038, 1.0, 0.468354, 1.0, 0.493671, 1.0, 0.518987, 1.0, 0.544304, 1.0, 0.56962, 1.0, 0.594937, 1.0, 
0.620253, 1.0, 0.64557, 1.0, 0.670886, 1.0, 0.696203, 1.0, 0.721519, 1.0, 0.746835, 1.0, 0.772152, 1.0, 0.797468, 1.0, 
0.822785, 1.0, 0.848101, 1.0, 0.873418, 1.0, 0.898734, 1.0, 0.924051, 1.0, 0.949367, 1.0, 0.974684, 1.0, 1.0, 1.0
};

static inline std::vector<float> input1 ={-1.0, -1.0, -0.974684, -1.0, -0.949367, -1.0, -0.924051, -1.0, -0.898734, -1.0, -0.873418, -1.0, -0.848101, -1.0, -0.822785, -1.0, 
-0.797468, -1.0, -0.772152, -1.0, -0.746835, -1.0, -0.721519, -1.0, -0.696203, -1.0, -0.670886, -1.0, -0.64557, -1.0, -0.620253, -1.0, 
-0.594937, -1.0, -0.56962, -1.0, -0.544304, -1.0, -0.518987, -1.0, -0.493671, -1.0, -0.468354, -1.0, -0.443038, -1.0, -0.417722, -1.0, 
-0.392405, -1.0, -0.367089, -1.0, -0.341772, -1.0, -0.316456, -1.0, -0.291139, -1.0, -0.265823, -1.0, -0.240506, -1.0, -0.21519, -1.0, 
-0.189873, -1.0, -0.164557, -1.0, -0.13924, -1.0, -0.113924, -1.0, -0.088608, -1.0, -0.063291, -1.0, -0.037975, -1.0, -0.012658, -1.0, 
0.012658, -1.0, 0.037975, -1.0, 0.063291, -1.0, 0.088608, -1.0, 0.113924, -1.0, 0.13924, -1.0, 0.164557, -1.0, 0.189873, -1.0, 
0.21519, -1.0, 0.240506, -1.0, 0.265823, -1.0, 0.291139, -1.0, 0.316456, -1.0, 0.341772, -1.0, 0.367089, -1.0, 0.392405, -1.0, 
0.417722, -1.0, 0.443038, -1.0, 0.468354, -1.0, 0.493671, -1.0, 0.518987, -1.0, 0.544304, -1.0, 0.56962, -1.0, 0.594937, -1.0, 
0.620253, -1.0, 0.64557, -1.0, 0.670886, -1.0, 0.696203, -1.0, 0.721519, -1.0, 0.746835, -1.0, 0.772152, -1.0, 0.797468, -1.0, 
0.822785, -1.0, 0.848101, -1.0, 0.873418, -1.0, 0.898734, -1.0, 0.924051, -1.0, 0.949367, -1.0, 0.974684, -1.0, 1.0, -1.0, 
-1.0, -0.974684, -0.974684, -0.974684, -0.949367, -0.974684, -0.924051, -0.974684, -0.898734, -0.974684, -0.873418, -0.974684, -0.848101, -0.974684, -0.822785, -0.974684, 
-0.797468, -0.974684, -0.772152, -0.974684, -0.746835, -0.974684, -0.721519, -0.974684, -0.696203, -0.974684, -0.670886, -0.974684, -0.64557, -0.974684, -0.620253, -0.974684, 
-0.594937, -0.974684, -0.56962, -0.974684, -0.544304, -0.974684, -0.518987, -0.974684, -0.493671, -0.974684, -0.468354, -0.974684, -0.443038, -0.974684, -0.417722, -0.974684, 
-0.392405, -0.974684, -0.367089, -0.974684, -0.341772, -0.974684, -0.316456, -0.974684, -0.291139, -0.974684, -0.265823, -0.974684, -0.240506, -0.974684, -0.21519, -0.974684, 
-0.189873, -0.974684, -0.164557, -0.974684, -0.13924, -0.974684, -0.113924, -0.974684, -0.088608, -0.974684, -0.063291, -0.974684, -0.037975, -0.974684, -0.012658, -0.974684, 
0.012658, -0.974684, 0.037975, -0.974684, 0.063291, -0.974684, 0.088608, -0.974684, 0.113924, -0.974684, 0.13924, -0.974684, 0.164557, -0.974684, 0.189873, -0.974684, 
0.21519, -0.974684, 0.240506, -0.974684, 0.265823, -0.974684, 0.291139, -0.974684, 0.316456, -0.974684, 0.341772, -0.974684, 0.367089, -0.974684, 0.392405, -0.974684, 
0.417722, -0.974684, 0.443038, -0.974684, 0.468354, -0.974684, 0.493671, -0.974684, 0.518987, -0.974684, 0.544304, -0.974684, 0.56962, -0.974684, 0.594937, -0.974684, 
0.620253, -0.974684, 0.64557, -0.974684, 0.670886, -0.974684, 0.696203, -0.974684, 0.721519, -0.974684, 0.746835, -0.974684, 0.772152, -0.974684, 0.797468, -0.974684, 
0.822785, -0.974684, 0.848101, -0.974684, 0.873418, -0.974684, 0.898734, -0.974684, 0.924051, -0.974684, 0.949367, -0.974684, 0.974684, -0.974684, 1.0, -0.974684, 
-1.0, -0.949367, -0.974684, -0.949367, -0.949367, -0.949367, -0.924051, -0.949367, -0.898734, -0.949367, -0.873418, -0.949367, -0.848101, -0.949367, -0.822785, -0.949367, 
-0.797468, -0.949367, -0.772152, -0.949367, -0.746835, -0.949367, -0.721519, -0.949367, -0.696203, -0.949367, -0.670886, -0.949367, -0.64557, -0.949367, -0.620253, -0.949367, 
-0.594937, -0.949367, -0.56962, -0.949367, -0.544304, -0.949367, -0.518987, -0.949367, -0.493671, -0.949367, -0.468354, -0.949367, -0.443038, -0.949367, -0.417722, -0.949367, 
-0.392405, -0.949367, -0.367089, -0.949367, -0.341772, -0.949367, -0.316456, -0.949367, -0.291139, -0.949367, -0.265823, -0.949367, -0.240506, -0.949367, -0.21519, -0.949367, 
-0.189873, -0.949367, -0.164557, -0.949367, -0.13924, -0.949367, -0.113924, -0.949367, -0.088608, -0.949367, -0.063291, -0.949367, -0.037975, -0.949367, -0.012658, -0.949367, 
0.012658, -0.949367, 0.037975, -0.949367, 0.063291, -0.949367, 0.088608, -0.949367, 0.113924, -0.949367, 0.13924, -0.949367, 0.164557, -0.949367, 0.189873, -0.949367, 
0.21519, -0.949367, 0.240506, -0.949367, 0.265823, -0.949367, 0.291139, -0.949367, 0.316456, -0.949367, 0.341772, -0.949367, 0.367089, -0.949367, 0.392405, -0.949367, 
0.417722, -0.949367, 0.443038, -0.949367, 0.468354, -0.949367, 0.493671, -0.949367, 0.518987, -0.949367, 0.544304, -0.949367, 0.56962, -0.949367, 0.594937, -0.949367, 
0.620253, -0.949367, 0.64557, -0.949367, 0.670886, -0.949367, 0.696203, -0.949367, 0.721519, -0.949367, 0.746835, -0.949367, 0.772152, -0.949367, 0.797468, -0.949367, 
0.822785, -0.949367, 0.848101, -0.949367, 0.873418, -0.949367, 0.898734, -0.949367, 0.924051, -0.949367, 0.949367, -0.949367, 0.974684, -0.949367, 1.0, -0.949367, 
-1.0, -0.924051, -0.974684, -0.924051, -0.949367, -0.924051, -0.924051, -0.924051, -0.898734, -0.924051, -0.873418, -0.924051, -0.848101, -0.924051, -0.822785, -0.924051, 
-0.797468, -0.924051, -0.772152, -0.924051, -0.746835, -0.924051, -0.721519, -0.924051, -0.696203, -0.924051, -0.670886, -0.924051, -0.64557, -0.924051, -0.620253, -0.924051, 
-0.594937, -0.924051, -0.56962, -0.924051, -0.544304, -0.924051, -0.518987, -0.924051, -0.493671, -0.924051, -0.468354, -0.924051, -0.443038, -0.924051, -0.417722, -0.924051, 
-0.392405, -0.924051, -0.367089, -0.924051, -0.341772, -0.924051, -0.316456, -0.924051, -0.291139, -0.924051, -0.265823, -0.924051, -0.240506, -0.924051, -0.21519, -0.924051, 
-0.189873, -0.924051, -0.164557, -0.924051, -0.13924, -0.924051, -0.113924, -0.924051, -0.088608, -0.924051, -0.063291, -0.924051, -0.037975, -0.924051, -0.012658, -0.924051, 
0.012658, -0.924051, 0.037975, -0.924051, 0.063291, -0.924051, 0.088608, -0.924051, 0.113924, -0.924051, 0.13924, -0.924051, 0.164557, -0.924051, 0.189873, -0.924051, 
0.21519, -0.924051, 0.240506, -0.924051, 0.265823, -0.924051, 0.291139, -0.924051, 0.316456, -0.924051, 0.341772, -0.924051, 0.367089, -0.924051, 0.392405, -0.924051, 
0.417722, -0.924051, 0.443038, -0.924051, 0.468354, -0.924051, 0.493671, -0.924051, 0.518987, -0.924051, 0.544304, -0.924051, 0.56962, -0.924051, 0.594937, -0.924051, 
0.620253, -0.924051, 0.64557, -0.924051, 0.670886, -0.924051, 0.696203, -0.924051, 0.721519, -0.924051, 0.746835, -0.924051, 0.772152, -0.924051, 0.797468, -0.924051, 
0.822785, -0.924051, 0.848101, -0.924051, 0.873418, -0.924051, 0.898734, -0.924051, 0.924051, -0.924051, 0.949367, -0.924051, 0.974684, -0.924051, 1.0, -0.924051, 
-1.0, -0.898734, -0.974684, -0.898734, -0.949367, -0.898734, -0.924051, -0.898734, -0.898734, -0.898734, -0.873418, -0.898734, -0.848101, -0.898734, -0.822785, -0.898734, 
-0.797468, -0.898734, -0.772152, -0.898734, -0.746835, -0.898734, -0.721519, -0.898734, -0.696203, -0.898734, -0.670886, -0.898734, -0.64557, -0.898734, -0.620253, -0.898734, 
-0.594937, -0.898734, -0.56962, -0.898734, -0.544304, -0.898734, -0.518987, -0.898734, -0.493671, -0.898734, -0.468354, -0.898734, -0.443038, -0.898734, -0.417722, -0.898734, 
-0.392405, -0.898734, -0.367089, -0.898734, -0.341772, -0.898734, -0.316456, -0.898734, -0.291139, -0.898734, -0.265823, -0.898734, -0.240506, -0.898734, -0.21519, -0.898734, 
-0.189873, -0.898734, -0.164557, -0.898734, -0.13924, -0.898734, -0.113924, -0.898734, -0.088608, -0.898734, -0.063291, -0.898734, -0.037975, -0.898734, -0.012658, -0.898734, 
0.012658, -0.898734, 0.037975, -0.898734, 0.063291, -0.898734, 0.088608, -0.898734, 0.113924, -0.898734, 0.13924, -0.898734, 0.164557, -0.898734, 0.189873, -0.898734, 
0.21519, -0.898734, 0.240506, -0.898734, 0.265823, -0.898734, 0.291139, -0.898734, 0.316456, -0.898734, 0.341772, -0.898734, 0.367089, -0.898734, 0.392405, -0.898734, 
0.417722, -0.898734, 0.443038, -0.898734, 0.468354, -0.898734, 0.493671, -0.898734, 0.518987, -0.898734, 0.544304, -0.898734, 0.56962, -0.898734, 0.594937, -0.898734, 
0.620253, -0.898734, 0.64557, -0.898734, 0.670886, -0.898734, 0.696203, -0.898734, 0.721519, -0.898734, 0.746835, -0.898734, 0.772152, -0.898734, 0.797468, -0.898734, 
0.822785, -0.898734, 0.848101, -0.898734, 0.873418, -0.898734, 0.898734, -0.898734, 0.924051, -0.898734, 0.949367, -0.898734, 0.974684, -0.898734, 1.0, -0.898734, 
-1.0, -0.873418, -0.974684, -0.873418, -0.949367, -0.873418, -0.924051, -0.873418, -0.898734, -0.873418, -0.873418, -0.873418, -0.848101, -0.873418, -0.822785, -0.873418, 
-0.797468, -0.873418, -0.772152, -0.873418, -0.746835, -0.873418, -0.721519, -0.873418, -0.696203, -0.873418, -0.670886, -0.873418, -0.64557, -0.873418, -0.620253, -0.873418, 
-0.594937, -0.873418, -0.56962, -0.873418, -0.544304, -0.873418, -0.518987, -0.873418, -0.493671, -0.873418, -0.468354, -0.873418, -0.443038, -0.873418, -0.417722, -0.873418, 
-0.392405, -0.873418, -0.367089, -0.873418, -0.341772, -0.873418, -0.316456, -0.873418, -0.291139, -0.873418, -0.265823, -0.873418, -0.240506, -0.873418, -0.21519, -0.873418, 
-0.189873, -0.873418, -0.164557, -0.873418, -0.13924, -0.873418, -0.113924, -0.873418, -0.088608, -0.873418, -0.063291, -0.873418, -0.037975, -0.873418, -0.012658, -0.873418, 
0.012658, -0.873418, 0.037975, -0.873418, 0.063291, -0.873418, 0.088608, -0.873418, 0.113924, -0.873418, 0.13924, -0.873418, 0.164557, -0.873418, 0.189873, -0.873418, 
0.21519, -0.873418, 0.240506, -0.873418, 0.265823, -0.873418, 0.291139, -0.873418, 0.316456, -0.873418, 0.341772, -0.873418, 0.367089, -0.873418, 0.392405, -0.873418, 
0.417722, -0.873418, 0.443038, -0.873418, 0.468354, -0.873418, 0.493671, -0.873418, 0.518987, -0.873418, 0.544304, -0.873418, 0.56962, -0.873418, 0.594937, -0.873418, 
0.620253, -0.873418, 0.64557, -0.873418, 0.670886, -0.873418, 0.696203, -0.873418, 0.721519, -0.873418, 0.746835, -0.873418, 0.772152, -0.873418, 0.797468, -0.873418, 
0.822785, -0.873418, 0.848101, -0.873418, 0.873418, -0.873418, 0.898734, -0.873418, 0.924051, -0.873418, 0.949367, -0.873418, 0.974684, -0.873418, 1.0, -0.873418, 
-1.0, -0.848101, -0.974684, -0.848101, -0.949367, -0.848101, -0.924051, -0.848101, -0.898734, -0.848101, -0.873418, -0.848101, -0.848101, -0.848101, -0.822785, -0.848101, 
-0.797468, -0.848101, -0.772152, -0.848101, -0.746835, -0.848101, -0.721519, -0.848101, -0.696203, -0.848101, -0.670886, -0.848101, -0.64557, -0.848101, -0.620253, -0.848101, 
-0.594937, -0.848101, -0.56962, -0.848101, -0.544304, -0.848101, -0.518987, -0.848101, -0.493671, -0.848101, -0.468354, -0.848101, -0.443038, -0.848101, -0.417722, -0.848101, 
-0.392405, -0.848101, -0.367089, -0.848101, -0.341772, -0.848101, -0.316456, -0.848101, -0.291139, -0.848101, -0.265823, -0.848101, -0.240506, -0.848101, -0.21519, -0.848101, 
-0.189873, -0.848101, -0.164557, -0.848101, -0.13924, -0.848101, -0.113924, -0.848101, -0.088608, -0.848101, -0.063291, -0.848101, -0.037975, -0.848101, -0.012658, -0.848101, 
0.012658, -0.848101, 0.037975, -0.848101, 0.063291, -0.848101, 0.088608, -0.848101, 0.113924, -0.848101, 0.13924, -0.848101, 0.164557, -0.848101, 0.189873, -0.848101, 
0.21519, -0.848101, 0.240506, -0.848101, 0.265823, -0.848101, 0.291139, -0.848101, 0.316456, -0.848101, 0.341772, -0.848101, 0.367089, -0.848101, 0.392405, -0.848101, 
0.417722, -0.848101, 0.443038, -0.848101, 0.468354, -0.848101, 0.493671, -0.848101, 0.518987, -0.848101, 0.544304, -0.848101, 0.56962, -0.848101, 0.594937, -0.848101, 
0.620253, -0.848101, 0.64557, -0.848101, 0.670886, -0.848101, 0.696203, -0.848101, 0.721519, -0.848101, 0.746835, -0.848101, 0.772152, -0.848101, 0.797468, -0.848101, 
0.822785, -0.848101, 0.848101, -0.848101, 0.873418, -0.848101, 0.898734, -0.848101, 0.924051, -0.848101, 0.949367, -0.848101, 0.974684, -0.848101, 1.0, -0.848101, 
-1.0, -0.822785, -0.974684, -0.822785, -0.949367, -0.822785, -0.924051, -0.822785, -0.898734, -0.822785, -0.873418, -0.822785, -0.848101, -0.822785, -0.822785, -0.822785, 
-0.797468, -0.822785, -0.772152, -0.822785, -0.746835, -0.822785, -0.721519, -0.822785, -0.696203, -0.822785, -0.670886, -0.822785, -0.64557, -0.822785, -0.620253, -0.822785, 
-0.594937, -0.822785, -0.56962, -0.822785, -0.544304, -0.822785, -0.518987, -0.822785, -0.493671, -0.822785, -0.468354, -0.822785, -0.443038, -0.822785, -0.417722, -0.822785, 
-0.392405, -0.822785, -0.367089, -0.822785, -0.341772, -0.822785, -0.316456, -0.822785, -0.291139, -0.822785, -0.265823, -0.822785, -0.240506, -0.822785, -0.21519, -0.822785, 
-0.189873, -0.822785, -0.164557, -0.822785, -0.13924, -0.822785, -0.113924, -0.822785, -0.088608, -0.822785, -0.063291, -0.822785, -0.037975, -0.822785, -0.012658, -0.822785, 
0.012658, -0.822785, 0.037975, -0.822785, 0.063291, -0.822785, 0.088608, -0.822785, 0.113924, -0.822785, 0.13924, -0.822785, 0.164557, -0.822785, 0.189873, -0.822785, 
0.21519, -0.822785, 0.240506, -0.822785, 0.265823, -0.822785, 0.291139, -0.822785, 0.316456, -0.822785, 0.341772, -0.822785, 0.367089, -0.822785, 0.392405, -0.822785, 
0.417722, -0.822785, 0.443038, -0.822785, 0.468354, -0.822785, 0.493671, -0.822785, 0.518987, -0.822785, 0.544304, -0.822785, 0.56962, -0.822785, 0.594937, -0.822785, 
0.620253, -0.822785, 0.64557, -0.822785, 0.670886, -0.822785, 0.696203, -0.822785, 0.721519, -0.822785, 0.746835, -0.822785, 0.772152, -0.822785, 0.797468, -0.822785, 
0.822785, -0.822785, 0.848101, -0.822785, 0.873418, -0.822785, 0.898734, -0.822785, 0.924051, -0.822785, 0.949367, -0.822785, 0.974684, -0.822785, 1.0, -0.822785, 
-1.0, -0.797468, -0.974684, -0.797468, -0.949367, -0.797468, -0.924051, -0.797468, -0.898734, -0.797468, -0.873418, -0.797468, -0.848101, -0.797468, -0.822785, -0.797468, 
-0.797468, -0.797468, -0.772152, -0.797468, -0.746835, -0.797468, -0.721519, -0.797468, -0.696203, -0.797468, -0.670886, -0.797468, -0.64557, -0.797468, -0.620253, -0.797468, 
-0.594937, -0.797468, -0.56962, -0.797468, -0.544304, -0.797468, -0.518987, -0.797468, -0.493671, -0.797468, -0.468354, -0.797468, -0.443038, -0.797468, -0.417722, -0.797468, 
-0.392405, -0.797468, -0.367089, -0.797468, -0.341772, -0.797468, -0.316456, -0.797468, -0.291139, -0.797468, -0.265823, -0.797468, -0.240506, -0.797468, -0.21519, -0.797468, 
-0.189873, -0.797468, -0.164557, -0.797468, -0.13924, -0.797468, -0.113924, -0.797468, -0.088608, -0.797468, -0.063291, -0.797468, -0.037975, -0.797468, -0.012658, -0.797468, 
0.012658, -0.797468, 0.037975, -0.797468, 0.063291, -0.797468, 0.088608, -0.797468, 0.113924, -0.797468, 0.13924, -0.797468, 0.164557, -0.797468, 0.189873, -0.797468, 
0.21519, -0.797468, 0.240506, -0.797468, 0.265823, -0.797468, 0.291139, -0.797468, 0.316456, -0.797468, 0.341772, -0.797468, 0.367089, -0.797468, 0.392405, -0.797468, 
0.417722, -0.797468, 0.443038, -0.797468, 0.468354, -0.797468, 0.493671, -0.797468, 0.518987, -0.797468, 0.544304, -0.797468, 0.56962, -0.797468, 0.594937, -0.797468, 
0.620253, -0.797468, 0.64557, -0.797468, 0.670886, -0.797468, 0.696203, -0.797468, 0.721519, -0.797468, 0.746835, -0.797468, 0.772152, -0.797468, 0.797468, -0.797468, 
0.822785, -0.797468, 0.848101, -0.797468, 0.873418, -0.797468, 0.898734, -0.797468, 0.924051, -0.797468, 0.949367, -0.797468, 0.974684, -0.797468, 1.0, -0.797468, 
-1.0, -0.772152, -0.974684, -0.772152, -0.949367, -0.772152, -0.924051, -0.772152, -0.898734, -0.772152, -0.873418, -0.772152, -0.848101, -0.772152, -0.822785, -0.772152, 
-0.797468, -0.772152, -0.772152, -0.772152, -0.746835, -0.772152, -0.721519, -0.772152, -0.696203, -0.772152, -0.670886, -0.772152, -0.64557, -0.772152, -0.620253, -0.772152, 
-0.594937, -0.772152, -0.56962, -0.772152, -0.544304, -0.772152, -0.518987, -0.772152, -0.493671, -0.772152, -0.468354, -0.772152, -0.443038, -0.772152, -0.417722, -0.772152, 
-0.392405, -0.772152, -0.367089, -0.772152, -0.341772, -0.772152, -0.316456, -0.772152, -0.291139, -0.772152, -0.265823, -0.772152, -0.240506, -0.772152, -0.21519, -0.772152, 
-0.189873, -0.772152, -0.164557, -0.772152, -0.13924, -0.772152, -0.113924, -0.772152, -0.088608, -0.772152, -0.063291, -0.772152, -0.037975, -0.772152, -0.012658, -0.772152, 
0.012658, -0.772152, 0.037975, -0.772152, 0.063291, -0.772152, 0.088608, -0.772152, 0.113924, -0.772152, 0.13924, -0.772152, 0.164557, -0.772152, 0.189873, -0.772152, 
0.21519, -0.772152, 0.240506, -0.772152, 0.265823, -0.772152, 0.291139, -0.772152, 0.316456, -0.772152, 0.341772, -0.772152, 0.367089, -0.772152, 0.392405, -0.772152, 
0.417722, -0.772152, 0.443038, -0.772152, 0.468354, -0.772152, 0.493671, -0.772152, 0.518987, -0.772152, 0.544304, -0.772152, 0.56962, -0.772152, 0.594937, -0.772152, 
0.620253, -0.772152, 0.64557, -0.772152, 0.670886, -0.772152, 0.696203, -0.772152, 0.721519, -0.772152, 0.746835, -0.772152, 0.772152, -0.772152, 0.797468, -0.772152, 
0.822785, -0.772152, 0.848101, -0.772152, 0.873418, -0.772152, 0.898734, -0.772152, 0.924051, -0.772152, 0.949367, -0.772152, 0.974684, -0.772152, 1.0, -0.772152, 
-1.0, -0.746835, -0.974684, -0.746835, -0.949367, -0.746835, -0.924051, -0.746835, -0.898734, -0.746835, -0.873418, -0.746835, -0.848101, -0.746835, -0.822785, -0.746835, 
-0.797468, -0.746835, -0.772152, -0.746835, -0.746835, -0.746835, -0.721519, -0.746835, -0.696203, -0.746835, -0.670886, -0.746835, -0.64557, -0.746835, -0.620253, -0.746835, 
-0.594937, -0.746835, -0.56962, -0.746835, -0.544304, -0.746835, -0.518987, -0.746835, -0.493671, -0.746835, -0.468354, -0.746835, -0.443038, -0.746835, -0.417722, -0.746835, 
-0.392405, -0.746835, -0.367089, -0.746835, -0.341772, -0.746835, -0.316456, -0.746835, -0.291139, -0.746835, -0.265823, -0.746835, -0.240506, -0.746835, -0.21519, -0.746835, 
-0.189873, -0.746835, -0.164557, -0.746835, -0.13924, -0.746835, -0.113924, -0.746835, -0.088608, -0.746835, -0.063291, -0.746835, -0.037975, -0.746835, -0.012658, -0.746835, 
0.012658, -0.746835, 0.037975, -0.746835, 0.063291, -0.746835, 0.088608, -0.746835, 0.113924, -0.746835, 0.13924, -0.746835, 0.164557, -0.746835, 0.189873, -0.746835, 
0.21519, -0.746835, 0.240506, -0.746835, 0.265823, -0.746835, 0.291139, -0.746835, 0.316456, -0.746835, 0.341772, -0.746835, 0.367089, -0.746835, 0.392405, -0.746835, 
0.417722, -0.746835, 0.443038, -0.746835, 0.468354, -0.746835, 0.493671, -0.746835, 0.518987, -0.746835, 0.544304, -0.746835, 0.56962, -0.746835, 0.594937, -0.746835, 
0.620253, -0.746835, 0.64557, -0.746835, 0.670886, -0.746835, 0.696203, -0.746835, 0.721519, -0.746835, 0.746835, -0.746835, 0.772152, -0.746835, 0.797468, -0.746835, 
0.822785, -0.746835, 0.848101, -0.746835, 0.873418, -0.746835, 0.898734, -0.746835, 0.924051, -0.746835, 0.949367, -0.746835, 0.974684, -0.746835, 1.0, -0.746835, 
-1.0, -0.721519, -0.974684, -0.721519, -0.949367, -0.721519, -0.924051, -0.721519, -0.898734, -0.721519, -0.873418, -0.721519, -0.848101, -0.721519, -0.822785, -0.721519, 
-0.797468, -0.721519, -0.772152, -0.721519, -0.746835, -0.721519, -0.721519, -0.721519, -0.696203, -0.721519, -0.670886, -0.721519, -0.64557, -0.721519, -0.620253, -0.721519, 
-0.594937, -0.721519, -0.56962, -0.721519, -0.544304, -0.721519, -0.518987, -0.721519, -0.493671, -0.721519, -0.468354, -0.721519, -0.443038, -0.721519, -0.417722, -0.721519, 
-0.392405, -0.721519, -0.367089, -0.721519, -0.341772, -0.721519, -0.316456, -0.721519, -0.291139, -0.721519, -0.265823, -0.721519, -0.240506, -0.721519, -0.21519, -0.721519, 
-0.189873, -0.721519, -0.164557, -0.721519, -0.13924, -0.721519, -0.113924, -0.721519, -0.088608, -0.721519, -0.063291, -0.721519, -0.037975, -0.721519, -0.012658, -0.721519, 
0.012658, -0.721519, 0.037975, -0.721519, 0.063291, -0.721519, 0.088608, -0.721519, 0.113924, -0.721519, 0.13924, -0.721519, 0.164557, -0.721519, 0.189873, -0.721519, 
0.21519, -0.721519, 0.240506, -0.721519, 0.265823, -0.721519, 0.291139, -0.721519, 0.316456, -0.721519, 0.341772, -0.721519, 0.367089, -0.721519, 0.392405, -0.721519, 
0.417722, -0.721519, 0.443038, -0.721519, 0.468354, -0.721519, 0.493671, -0.721519, 0.518987, -0.721519, 0.544304, -0.721519, 0.56962, -0.721519, 0.594937, -0.721519, 
0.620253, -0.721519, 0.64557, -0.721519, 0.670886, -0.721519, 0.696203, -0.721519, 0.721519, -0.721519, 0.746835, -0.721519, 0.772152, -0.721519, 0.797468, -0.721519, 
0.822785, -0.721519, 0.848101, -0.721519, 0.873418, -0.721519, 0.898734, -0.721519, 0.924051, -0.721519, 0.949367, -0.721519, 0.974684, -0.721519, 1.0, -0.721519, 
-1.0, -0.696203, -0.974684, -0.696203, -0.949367, -0.696203, -0.924051, -0.696203, -0.898734, -0.696203, -0.873418, -0.696203, -0.848101, -0.696203, -0.822785, -0.696203, 
-0.797468, -0.696203, -0.772152, -0.696203, -0.746835, -0.696203, -0.721519, -0.696203, -0.696203, -0.696203, -0.670886, -0.696203, -0.64557, -0.696203, -0.620253, -0.696203, 
-0.594937, -0.696203, -0.56962, -0.696203, -0.544304, -0.696203, -0.518987, -0.696203, -0.493671, -0.696203, -0.468354, -0.696203, -0.443038, -0.696203, -0.417722, -0.696203, 
-0.392405, -0.696203, -0.367089, -0.696203, -0.341772, -0.696203, -0.316456, -0.696203, -0.291139, -0.696203, -0.265823, -0.696203, -0.240506, -0.696203, -0.21519, -0.696203, 
-0.189873, -0.696203, -0.164557, -0.696203, -0.13924, -0.696203, -0.113924, -0.696203, -0.088608, -0.696203, -0.063291, -0.696203, -0.037975, -0.696203, -0.012658, -0.696203, 
0.012658, -0.696203, 0.037975, -0.696203, 0.063291, -0.696203, 0.088608, -0.696203, 0.113924, -0.696203, 0.13924, -0.696203, 0.164557, -0.696203, 0.189873, -0.696203, 
0.21519, -0.696203, 0.240506, -0.696203, 0.265823, -0.696203, 0.291139, -0.696203, 0.316456, -0.696203, 0.341772, -0.696203, 0.367089, -0.696203, 0.392405, -0.696203, 
0.417722, -0.696203, 0.443038, -0.696203, 0.468354, -0.696203, 0.493671, -0.696203, 0.518987, -0.696203, 0.544304, -0.696203, 0.56962, -0.696203, 0.594937, -0.696203, 
0.620253, -0.696203, 0.64557, -0.696203, 0.670886, -0.696203, 0.696203, -0.696203, 0.721519, -0.696203, 0.746835, -0.696203, 0.772152, -0.696203, 0.797468, -0.696203, 
0.822785, -0.696203, 0.848101, -0.696203, 0.873418, -0.696203, 0.898734, -0.696203, 0.924051, -0.696203, 0.949367, -0.696203, 0.974684, -0.696203, 1.0, -0.696203, 
-1.0, -0.670886, -0.974684, -0.670886, -0.949367, -0.670886, -0.924051, -0.670886, -0.898734, -0.670886, -0.873418, -0.670886, -0.848101, -0.670886, -0.822785, -0.670886, 
-0.797468, -0.670886, -0.772152, -0.670886, -0.746835, -0.670886, -0.721519, -0.670886, -0.696203, -0.670886, -0.670886, -0.670886, -0.64557, -0.670886, -0.620253, -0.670886, 
-0.594937, -0.670886, -0.56962, -0.670886, -0.544304, -0.670886, -0.518987, -0.670886, -0.493671, -0.670886, -0.468354, -0.670886, -0.443038, -0.670886, -0.417722, -0.670886, 
-0.392405, -0.670886, -0.367089, -0.670886, -0.341772, -0.670886, -0.316456, -0.670886, -0.291139, -0.670886, -0.265823, -0.670886, -0.240506, -0.670886, -0.21519, -0.670886, 
-0.189873, -0.670886, -0.164557, -0.670886, -0.13924, -0.670886, -0.113924, -0.670886, -0.088608, -0.670886, -0.063291, -0.670886, -0.037975, -0.670886, -0.012658, -0.670886, 
0.012658, -0.670886, 0.037975, -0.670886, 0.063291, -0.670886, 0.088608, -0.670886, 0.113924, -0.670886, 0.13924, -0.670886, 0.164557, -0.670886, 0.189873, -0.670886, 
0.21519, -0.670886, 0.240506, -0.670886, 0.265823, -0.670886, 0.291139, -0.670886, 0.316456, -0.670886, 0.341772, -0.670886, 0.367089, -0.670886, 0.392405, -0.670886, 
0.417722, -0.670886, 0.443038, -0.670886, 0.468354, -0.670886, 0.493671, -0.670886, 0.518987, -0.670886, 0.544304, -0.670886, 0.56962, -0.670886, 0.594937, -0.670886, 
0.620253, -0.670886, 0.64557, -0.670886, 0.670886, -0.670886, 0.696203, -0.670886, 0.721519, -0.670886, 0.746835, -0.670886, 0.772152, -0.670886, 0.797468, -0.670886, 
0.822785, -0.670886, 0.848101, -0.670886, 0.873418, -0.670886, 0.898734, -0.670886, 0.924051, -0.670886, 0.949367, -0.670886, 0.974684, -0.670886, 1.0, -0.670886, 
-1.0, -0.64557, -0.974684, -0.64557, -0.949367, -0.64557, -0.924051, -0.64557, -0.898734, -0.64557, -0.873418, -0.64557, -0.848101, -0.64557, -0.822785, -0.64557, 
-0.797468, -0.64557, -0.772152, -0.64557, -0.746835, -0.64557, -0.721519, -0.64557, -0.696203, -0.64557, -0.670886, -0.64557, -0.64557, -0.64557, -0.620253, -0.64557, 
-0.594937, -0.64557, -0.56962, -0.64557, -0.544304, -0.64557, -0.518987, -0.64557, -0.493671, -0.64557, -0.468354, -0.64557, -0.443038, -0.64557, -0.417722, -0.64557, 
-0.392405, -0.64557, -0.367089, -0.64557, -0.341772, -0.64557, -0.316456, -0.64557, -0.291139, -0.64557, -0.265823, -0.64557, -0.240506, -0.64557, -0.21519, -0.64557, 
-0.189873, -0.64557, -0.164557, -0.64557, -0.13924, -0.64557, -0.113924, -0.64557, -0.088608, -0.64557, -0.063291, -0.64557, -0.037975, -0.64557, -0.012658, -0.64557, 
0.012658, -0.64557, 0.037975, -0.64557, 0.063291, -0.64557, 0.088608, -0.64557, 0.113924, -0.64557, 0.13924, -0.64557, 0.164557, -0.64557, 0.189873, -0.64557, 
0.21519, -0.64557, 0.240506, -0.64557, 0.265823, -0.64557, 0.291139, -0.64557, 0.316456, -0.64557, 0.341772, -0.64557, 0.367089, -0.64557, 0.392405, -0.64557, 
0.417722, -0.64557, 0.443038, -0.64557, 0.468354, -0.64557, 0.493671, -0.64557, 0.518987, -0.64557, 0.544304, -0.64557, 0.56962, -0.64557, 0.594937, -0.64557, 
0.620253, -0.64557, 0.64557, -0.64557, 0.670886, -0.64557, 0.696203, -0.64557, 0.721519, -0.64557, 0.746835, -0.64557, 0.772152, -0.64557, 0.797468, -0.64557, 
0.822785, -0.64557, 0.848101, -0.64557, 0.873418, -0.64557, 0.898734, -0.64557, 0.924051, -0.64557, 0.949367, -0.64557, 0.974684, -0.64557, 1.0, -0.64557, 
-1.0, -0.620253, -0.974684, -0.620253, -0.949367, -0.620253, -0.924051, -0.620253, -0.898734, -0.620253, -0.873418, -0.620253, -0.848101, -0.620253, -0.822785, -0.620253, 
-0.797468, -0.620253, -0.772152, -0.620253, -0.746835, -0.620253, -0.721519, -0.620253, -0.696203, -0.620253, -0.670886, -0.620253, -0.64557, -0.620253, -0.620253, -0.620253, 
-0.594937, -0.620253, -0.56962, -0.620253, -0.544304, -0.620253, -0.518987, -0.620253, -0.493671, -0.620253, -0.468354, -0.620253, -0.443038, -0.620253, -0.417722, -0.620253, 
-0.392405, -0.620253, -0.367089, -0.620253, -0.341772, -0.620253, -0.316456, -0.620253, -0.291139, -0.620253, -0.265823, -0.620253, -0.240506, -0.620253, -0.21519, -0.620253, 
-0.189873, -0.620253, -0.164557, -0.620253, -0.13924, -0.620253, -0.113924, -0.620253, -0.088608, -0.620253, -0.063291, -0.620253, -0.037975, -0.620253, -0.012658, -0.620253, 
0.012658, -0.620253, 0.037975, -0.620253, 0.063291, -0.620253, 0.088608, -0.620253, 0.113924, -0.620253, 0.13924, -0.620253, 0.164557, -0.620253, 0.189873, -0.620253, 
0.21519, -0.620253, 0.240506, -0.620253, 0.265823, -0.620253, 0.291139, -0.620253, 0.316456, -0.620253, 0.341772, -0.620253, 0.367089, -0.620253, 0.392405, -0.620253, 
0.417722, -0.620253, 0.443038, -0.620253, 0.468354, -0.620253, 0.493671, -0.620253, 0.518987, -0.620253, 0.544304, -0.620253, 0.56962, -0.620253, 0.594937, -0.620253, 
0.620253, -0.620253, 0.64557, -0.620253, 0.670886, -0.620253, 0.696203, -0.620253, 0.721519, -0.620253, 0.746835, -0.620253, 0.772152, -0.620253, 0.797468, -0.620253, 
0.822785, -0.620253, 0.848101, -0.620253, 0.873418, -0.620253, 0.898734, -0.620253, 0.924051, -0.620253, 0.949367, -0.620253, 0.974684, -0.620253, 1.0, -0.620253, 
-1.0, -0.594937, -0.974684, -0.594937, -0.949367, -0.594937, -0.924051, -0.594937, -0.898734, -0.594937, -0.873418, -0.594937, -0.848101, -0.594937, -0.822785, -0.594937, 
-0.797468, -0.594937, -0.772152, -0.594937, -0.746835, -0.594937, -0.721519, -0.594937, -0.696203, -0.594937, -0.670886, -0.594937, -0.64557, -0.594937, -0.620253, -0.594937, 
-0.594937, -0.594937, -0.56962, -0.594937, -0.544304, -0.594937, -0.518987, -0.594937, -0.493671, -0.594937, -0.468354, -0.594937, -0.443038, -0.594937, -0.417722, -0.594937, 
-0.392405, -0.594937, -0.367089, -0.594937, -0.341772, -0.594937, -0.316456, -0.594937, -0.291139, -0.594937, -0.265823, -0.594937, -0.240506, -0.594937, -0.21519, -0.594937, 
-0.189873, -0.594937, -0.164557, -0.594937, -0.13924, -0.594937, -0.113924, -0.594937, -0.088608, -0.594937, -0.063291, -0.594937, -0.037975, -0.594937, -0.012658, -0.594937, 
0.012658, -0.594937, 0.037975, -0.594937, 0.063291, -0.594937, 0.088608, -0.594937, 0.113924, -0.594937, 0.13924, -0.594937, 0.164557, -0.594937, 0.189873, -0.594937, 
0.21519, -0.594937, 0.240506, -0.594937, 0.265823, -0.594937, 0.291139, -0.594937, 0.316456, -0.594937, 0.341772, -0.594937, 0.367089, -0.594937, 0.392405, -0.594937, 
0.417722, -0.594937, 0.443038, -0.594937, 0.468354, -0.594937, 0.493671, -0.594937, 0.518987, -0.594937, 0.544304, -0.594937, 0.56962, -0.594937, 0.594937, -0.594937, 
0.620253, -0.594937, 0.64557, -0.594937, 0.670886, -0.594937, 0.696203, -0.594937, 0.721519, -0.594937, 0.746835, -0.594937, 0.772152, -0.594937, 0.797468, -0.594937, 
0.822785, -0.594937, 0.848101, -0.594937, 0.873418, -0.594937, 0.898734, -0.594937, 0.924051, -0.594937, 0.949367, -0.594937, 0.974684, -0.594937, 1.0, -0.594937, 
-1.0, -0.56962, -0.974684, -0.56962, -0.949367, -0.56962, -0.924051, -0.56962, -0.898734, -0.56962, -0.873418, -0.56962, -0.848101, -0.56962, -0.822785, -0.56962, 
-0.797468, -0.56962, -0.772152, -0.56962, -0.746835, -0.56962, -0.721519, -0.56962, -0.696203, -0.56962, -0.670886, -0.56962, -0.64557, -0.56962, -0.620253, -0.56962, 
-0.594937, -0.56962, -0.56962, -0.56962, -0.544304, -0.56962, -0.518987, -0.56962, -0.493671, -0.56962, -0.468354, -0.56962, -0.443038, -0.56962, -0.417722, -0.56962, 
-0.392405, -0.56962, -0.367089, -0.56962, -0.341772, -0.56962, -0.316456, -0.56962, -0.291139, -0.56962, -0.265823, -0.56962, -0.240506, -0.56962, -0.21519, -0.56962, 
-0.189873, -0.56962, -0.164557, -0.56962, -0.13924, -0.56962, -0.113924, -0.56962, -0.088608, -0.56962, -0.063291, -0.56962, -0.037975, -0.56962, -0.012658, -0.56962, 
0.012658, -0.56962, 0.037975, -0.56962, 0.063291, -0.56962, 0.088608, -0.56962, 0.113924, -0.56962, 0.13924, -0.56962, 0.164557, -0.56962, 0.189873, -0.56962, 
0.21519, -0.56962, 0.240506, -0.56962, 0.265823, -0.56962, 0.291139, -0.56962, 0.316456, -0.56962, 0.341772, -0.56962, 0.367089, -0.56962, 0.392405, -0.56962, 
0.417722, -0.56962, 0.443038, -0.56962, 0.468354, -0.56962, 0.493671, -0.56962, 0.518987, -0.56962, 0.544304, -0.56962, 0.56962, -0.56962, 0.594937, -0.56962, 
0.620253, -0.56962, 0.64557, -0.56962, 0.670886, -0.56962, 0.696203, -0.56962, 0.721519, -0.56962, 0.746835, -0.56962, 0.772152, -0.56962, 0.797468, -0.56962, 
0.822785, -0.56962, 0.848101, -0.56962, 0.873418, -0.56962, 0.898734, -0.56962, 0.924051, -0.56962, 0.949367, -0.56962, 0.974684, -0.56962, 1.0, -0.56962, 
-1.0, -0.544304, -0.974684, -0.544304, -0.949367, -0.544304, -0.924051, -0.544304, -0.898734, -0.544304, -0.873418, -0.544304, -0.848101, -0.544304, -0.822785, -0.544304, 
-0.797468, -0.544304, -0.772152, -0.544304, -0.746835, -0.544304, -0.721519, -0.544304, -0.696203, -0.544304, -0.670886, -0.544304, -0.64557, -0.544304, -0.620253, -0.544304, 
-0.594937, -0.544304, -0.56962, -0.544304, -0.544304, -0.544304, -0.518987, -0.544304, -0.493671, -0.544304, -0.468354, -0.544304, -0.443038, -0.544304, -0.417722, -0.544304, 
-0.392405, -0.544304, -0.367089, -0.544304, -0.341772, -0.544304, -0.316456, -0.544304, -0.291139, -0.544304, -0.265823, -0.544304, -0.240506, -0.544304, -0.21519, -0.544304, 
-0.189873, -0.544304, -0.164557, -0.544304, -0.13924, -0.544304, -0.113924, -0.544304, -0.088608, -0.544304, -0.063291, -0.544304, -0.037975, -0.544304, -0.012658, -0.544304, 
0.012658, -0.544304, 0.037975, -0.544304, 0.063291, -0.544304, 0.088608, -0.544304, 0.113924, -0.544304, 0.13924, -0.544304, 0.164557, -0.544304, 0.189873, -0.544304, 
0.21519, -0.544304, 0.240506, -0.544304, 0.265823, -0.544304, 0.291139, -0.544304, 0.316456, -0.544304, 0.341772, -0.544304, 0.367089, -0.544304, 0.392405, -0.544304, 
0.417722, -0.544304, 0.443038, -0.544304, 0.468354, -0.544304, 0.493671, -0.544304, 0.518987, -0.544304, 0.544304, -0.544304, 0.56962, -0.544304, 0.594937, -0.544304, 
0.620253, -0.544304, 0.64557, -0.544304, 0.670886, -0.544304, 0.696203, -0.544304, 0.721519, -0.544304, 0.746835, -0.544304, 0.772152, -0.544304, 0.797468, -0.544304, 
0.822785, -0.544304, 0.848101, -0.544304, 0.873418, -0.544304, 0.898734, -0.544304, 0.924051, -0.544304, 0.949367, -0.544304, 0.974684, -0.544304, 1.0, -0.544304, 
-1.0, -0.518987, -0.974684, -0.518987, -0.949367, -0.518987, -0.924051, -0.518987, -0.898734, -0.518987, -0.873418, -0.518987, -0.848101, -0.518987, -0.822785, -0.518987, 
-0.797468, -0.518987, -0.772152, -0.518987, -0.746835, -0.518987, -0.721519, -0.518987, -0.696203, -0.518987, -0.670886, -0.518987, -0.64557, -0.518987, -0.620253, -0.518987, 
-0.594937, -0.518987, -0.56962, -0.518987, -0.544304, -0.518987, -0.518987, -0.518987, -0.493671, -0.518987, -0.468354, -0.518987, -0.443038, -0.518987, -0.417722, -0.518987, 
-0.392405, -0.518987, -0.367089, -0.518987, -0.341772, -0.518987, -0.316456, -0.518987, -0.291139, -0.518987, -0.265823, -0.518987, -0.240506, -0.518987, -0.21519, -0.518987, 
-0.189873, -0.518987, -0.164557, -0.518987, -0.13924, -0.518987, -0.113924, -0.518987, -0.088608, -0.518987, -0.063291, -0.518987, -0.037975, -0.518987, -0.012658, -0.518987, 
0.012658, -0.518987, 0.037975, -0.518987, 0.063291, -0.518987, 0.088608, -0.518987, 0.113924, -0.518987, 0.13924, -0.518987, 0.164557, -0.518987, 0.189873, -0.518987, 
0.21519, -0.518987, 0.240506, -0.518987, 0.265823, -0.518987, 0.291139, -0.518987, 0.316456, -0.518987, 0.341772, -0.518987, 0.367089, -0.518987, 0.392405, -0.518987, 
0.417722, -0.518987, 0.443038, -0.518987, 0.468354, -0.518987, 0.493671, -0.518987, 0.518987, -0.518987, 0.544304, -0.518987, 0.56962, -0.518987, 0.594937, -0.518987, 
0.620253, -0.518987, 0.64557, -0.518987, 0.670886, -0.518987, 0.696203, -0.518987, 0.721519, -0.518987, 0.746835, -0.518987, 0.772152, -0.518987, 0.797468, -0.518987, 
0.822785, -0.518987, 0.848101, -0.518987, 0.873418, -0.518987, 0.898734, -0.518987, 0.924051, -0.518987, 0.949367, -0.518987, 0.974684, -0.518987, 1.0, -0.518987, 
-1.0, -0.493671, -0.974684, -0.493671, -0.949367, -0.493671, -0.924051, -0.493671, -0.898734, -0.493671, -0.873418, -0.493671, -0.848101, -0.493671, -0.822785, -0.493671, 
-0.797468, -0.493671, -0.772152, -0.493671, -0.746835, -0.493671, -0.721519, -0.493671, -0.696203, -0.493671, -0.670886, -0.493671, -0.64557, -0.493671, -0.620253, -0.493671, 
-0.594937, -0.493671, -0.56962, -0.493671, -0.544304, -0.493671, -0.518987, -0.493671, -0.493671, -0.493671, -0.468354, -0.493671, -0.443038, -0.493671, -0.417722, -0.493671, 
-0.392405, -0.493671, -0.367089, -0.493671, -0.341772, -0.493671, -0.316456, -0.493671, -0.291139, -0.493671, -0.265823, -0.493671, -0.240506, -0.493671, -0.21519, -0.493671, 
-0.189873, -0.493671, -0.164557, -0.493671, -0.13924, -0.493671, -0.113924, -0.493671, -0.088608, -0.493671, -0.063291, -0.493671, -0.037975, -0.493671, -0.012658, -0.493671, 
0.012658, -0.493671, 0.037975, -0.493671, 0.063291, -0.493671, 0.088608, -0.493671, 0.113924, -0.493671, 0.13924, -0.493671, 0.164557, -0.493671, 0.189873, -0.493671, 
0.21519, -0.493671, 0.240506, -0.493671, 0.265823, -0.493671, 0.291139, -0.493671, 0.316456, -0.493671, 0.341772, -0.493671, 0.367089, -0.493671, 0.392405, -0.493671, 
0.417722, -0.493671, 0.443038, -0.493671, 0.468354, -0.493671, 0.493671, -0.493671, 0.518987, -0.493671, 0.544304, -0.493671, 0.56962, -0.493671, 0.594937, -0.493671, 
0.620253, -0.493671, 0.64557, -0.493671, 0.670886, -0.493671, 0.696203, -0.493671, 0.721519, -0.493671, 0.746835, -0.493671, 0.772152, -0.493671, 0.797468, -0.493671, 
0.822785, -0.493671, 0.848101, -0.493671, 0.873418, -0.493671, 0.898734, -0.493671, 0.924051, -0.493671, 0.949367, -0.493671, 0.974684, -0.493671, 1.0, -0.493671, 
-1.0, -0.468354, -0.974684, -0.468354, -0.949367, -0.468354, -0.924051, -0.468354, -0.898734, -0.468354, -0.873418, -0.468354, -0.848101, -0.468354, -0.822785, -0.468354, 
-0.797468, -0.468354, -0.772152, -0.468354, -0.746835, -0.468354, -0.721519, -0.468354, -0.696203, -0.468354, -0.670886, -0.468354, -0.64557, -0.468354, -0.620253, -0.468354, 
-0.594937, -0.468354, -0.56962, -0.468354, -0.544304, -0.468354, -0.518987, -0.468354, -0.493671, -0.468354, -0.468354, -0.468354, -0.443038, -0.468354, -0.417722, -0.468354, 
-0.392405, -0.468354, -0.367089, -0.468354, -0.341772, -0.468354, -0.316456, -0.468354, -0.291139, -0.468354, -0.265823, -0.468354, -0.240506, -0.468354, -0.21519, -0.468354, 
-0.189873, -0.468354, -0.164557, -0.468354, -0.13924, -0.468354, -0.113924, -0.468354, -0.088608, -0.468354, -0.063291, -0.468354, -0.037975, -0.468354, -0.012658, -0.468354, 
0.012658, -0.468354, 0.037975, -0.468354, 0.063291, -0.468354, 0.088608, -0.468354, 0.113924, -0.468354, 0.13924, -0.468354, 0.164557, -0.468354, 0.189873, -0.468354, 
0.21519, -0.468354, 0.240506, -0.468354, 0.265823, -0.468354, 0.291139, -0.468354, 0.316456, -0.468354, 0.341772, -0.468354, 0.367089, -0.468354, 0.392405, -0.468354, 
0.417722, -0.468354, 0.443038, -0.468354, 0.468354, -0.468354, 0.493671, -0.468354, 0.518987, -0.468354, 0.544304, -0.468354, 0.56962, -0.468354, 0.594937, -0.468354, 
0.620253, -0.468354, 0.64557, -0.468354, 0.670886, -0.468354, 0.696203, -0.468354, 0.721519, -0.468354, 0.746835, -0.468354, 0.772152, -0.468354, 0.797468, -0.468354, 
0.822785, -0.468354, 0.848101, -0.468354, 0.873418, -0.468354, 0.898734, -0.468354, 0.924051, -0.468354, 0.949367, -0.468354, 0.974684, -0.468354, 1.0, -0.468354, 
-1.0, -0.443038, -0.974684, -0.443038, -0.949367, -0.443038, -0.924051, -0.443038, -0.898734, -0.443038, -0.873418, -0.443038, -0.848101, -0.443038, -0.822785, -0.443038, 
-0.797468, -0.443038, -0.772152, -0.443038, -0.746835, -0.443038, -0.721519, -0.443038, -0.696203, -0.443038, -0.670886, -0.443038, -0.64557, -0.443038, -0.620253, -0.443038, 
-0.594937, -0.443038, -0.56962, -0.443038, -0.544304, -0.443038, -0.518987, -0.443038, -0.493671, -0.443038, -0.468354, -0.443038, -0.443038, -0.443038, -0.417722, -0.443038, 
-0.392405, -0.443038, -0.367089, -0.443038, -0.341772, -0.443038, -0.316456, -0.443038, -0.291139, -0.443038, -0.265823, -0.443038, -0.240506, -0.443038, -0.21519, -0.443038, 
-0.189873, -0.443038, -0.164557, -0.443038, -0.13924, -0.443038, -0.113924, -0.443038, -0.088608, -0.443038, -0.063291, -0.443038, -0.037975, -0.443038, -0.012658, -0.443038, 
0.012658, -0.443038, 0.037975, -0.443038, 0.063291, -0.443038, 0.088608, -0.443038, 0.113924, -0.443038, 0.13924, -0.443038, 0.164557, -0.443038, 0.189873, -0.443038, 
0.21519, -0.443038, 0.240506, -0.443038, 0.265823, -0.443038, 0.291139, -0.443038, 0.316456, -0.443038, 0.341772, -0.443038, 0.367089, -0.443038, 0.392405, -0.443038, 
0.417722, -0.443038, 0.443038, -0.443038, 0.468354, -0.443038, 0.493671, -0.443038, 0.518987, -0.443038, 0.544304, -0.443038, 0.56962, -0.443038, 0.594937, -0.443038, 
0.620253, -0.443038, 0.64557, -0.443038, 0.670886, -0.443038, 0.696203, -0.443038, 0.721519, -0.443038, 0.746835, -0.443038, 0.772152, -0.443038, 0.797468, -0.443038, 
0.822785, -0.443038, 0.848101, -0.443038, 0.873418, -0.443038, 0.898734, -0.443038, 0.924051, -0.443038, 0.949367, -0.443038, 0.974684, -0.443038, 1.0, -0.443038, 
-1.0, -0.417722, -0.974684, -0.417722, -0.949367, -0.417722, -0.924051, -0.417722, -0.898734, -0.417722, -0.873418, -0.417722, -0.848101, -0.417722, -0.822785, -0.417722, 
-0.797468, -0.417722, -0.772152, -0.417722, -0.746835, -0.417722, -0.721519, -0.417722, -0.696203, -0.417722, -0.670886, -0.417722, -0.64557, -0.417722, -0.620253, -0.417722, 
-0.594937, -0.417722, -0.56962, -0.417722, -0.544304, -0.417722, -0.518987, -0.417722, -0.493671, -0.417722, -0.468354, -0.417722, -0.443038, -0.417722, -0.417722, -0.417722, 
-0.392405, -0.417722, -0.367089, -0.417722, -0.341772, -0.417722, -0.316456, -0.417722, -0.291139, -0.417722, -0.265823, -0.417722, -0.240506, -0.417722, -0.21519, -0.417722, 
-0.189873, -0.417722, -0.164557, -0.417722, -0.13924, -0.417722, -0.113924, -0.417722, -0.088608, -0.417722, -0.063291, -0.417722, -0.037975, -0.417722, -0.012658, -0.417722, 
0.012658, -0.417722, 0.037975, -0.417722, 0.063291, -0.417722, 0.088608, -0.417722, 0.113924, -0.417722, 0.13924, -0.417722, 0.164557, -0.417722, 0.189873, -0.417722, 
0.21519, -0.417722, 0.240506, -0.417722, 0.265823, -0.417722, 0.291139, -0.417722, 0.316456, -0.417722, 0.341772, -0.417722, 0.367089, -0.417722, 0.392405, -0.417722, 
0.417722, -0.417722, 0.443038, -0.417722, 0.468354, -0.417722, 0.493671, -0.417722, 0.518987, -0.417722, 0.544304, -0.417722, 0.56962, -0.417722, 0.594937, -0.417722, 
0.620253, -0.417722, 0.64557, -0.417722, 0.670886, -0.417722, 0.696203, -0.417722, 0.721519, -0.417722, 0.746835, -0.417722, 0.772152, -0.417722, 0.797468, -0.417722, 
0.822785, -0.417722, 0.848101, -0.417722, 0.873418, -0.417722, 0.898734, -0.417722, 0.924051, -0.417722, 0.949367, -0.417722, 0.974684, -0.417722, 1.0, -0.417722, 
-1.0, -0.392405, -0.974684, -0.392405, -0.949367, -0.392405, -0.924051, -0.392405, -0.898734, -0.392405, -0.873418, -0.392405, -0.848101, -0.392405, -0.822785, -0.392405, 
-0.797468, -0.392405, -0.772152, -0.392405, -0.746835, -0.392405, -0.721519, -0.392405, -0.696203, -0.392405, -0.670886, -0.392405, -0.64557, -0.392405, -0.620253, -0.392405, 
-0.594937, -0.392405, -0.56962, -0.392405, -0.544304, -0.392405, -0.518987, -0.392405, -0.493671, -0.392405, -0.468354, -0.392405, -0.443038, -0.392405, -0.417722, -0.392405, 
-0.392405, -0.392405, -0.367089, -0.392405, -0.341772, -0.392405, -0.316456, -0.392405, -0.291139, -0.392405, -0.265823, -0.392405, -0.240506, -0.392405, -0.21519, -0.392405, 
-0.189873, -0.392405, -0.164557, -0.392405, -0.13924, -0.392405, -0.113924, -0.392405, -0.088608, -0.392405, -0.063291, -0.392405, -0.037975, -0.392405, -0.012658, -0.392405, 
0.012658, -0.392405, 0.037975, -0.392405, 0.063291, -0.392405, 0.088608, -0.392405, 0.113924, -0.392405, 0.13924, -0.392405, 0.164557, -0.392405, 0.189873, -0.392405, 
0.21519, -0.392405, 0.240506, -0.392405, 0.265823, -0.392405, 0.291139, -0.392405, 0.316456, -0.392405, 0.341772, -0.392405, 0.367089, -0.392405, 0.392405, -0.392405, 
0.417722, -0.392405, 0.443038, -0.392405, 0.468354, -0.392405, 0.493671, -0.392405, 0.518987, -0.392405, 0.544304, -0.392405, 0.56962, -0.392405, 0.594937, -0.392405, 
0.620253, -0.392405, 0.64557, -0.392405, 0.670886, -0.392405, 0.696203, -0.392405, 0.721519, -0.392405, 0.746835, -0.392405, 0.772152, -0.392405, 0.797468, -0.392405, 
0.822785, -0.392405, 0.848101, -0.392405, 0.873418, -0.392405, 0.898734, -0.392405, 0.924051, -0.392405, 0.949367, -0.392405, 0.974684, -0.392405, 1.0, -0.392405, 
-1.0, -0.367089, -0.974684, -0.367089, -0.949367, -0.367089, -0.924051, -0.367089, -0.898734, -0.367089, -0.873418, -0.367089, -0.848101, -0.367089, -0.822785, -0.367089, 
-0.797468, -0.367089, -0.772152, -0.367089, -0.746835, -0.367089, -0.721519, -0.367089, -0.696203, -0.367089, -0.670886, -0.367089, -0.64557, -0.367089, -0.620253, -0.367089, 
-0.594937, -0.367089, -0.56962, -0.367089, -0.544304, -0.367089, -0.518987, -0.367089, -0.493671, -0.367089, -0.468354, -0.367089, -0.443038, -0.367089, -0.417722, -0.367089, 
-0.392405, -0.367089, -0.367089, -0.367089, -0.341772, -0.367089, -0.316456, -0.367089, -0.291139, -0.367089, -0.265823, -0.367089, -0.240506, -0.367089, -0.21519, -0.367089, 
-0.189873, -0.367089, -0.164557, -0.367089, -0.13924, -0.367089, -0.113924, -0.367089, -0.088608, -0.367089, -0.063291, -0.367089, -0.037975, -0.367089, -0.012658, -0.367089, 
0.012658, -0.367089, 0.037975, -0.367089, 0.063291, -0.367089, 0.088608, -0.367089, 0.113924, -0.367089, 0.13924, -0.367089, 0.164557, -0.367089, 0.189873, -0.367089, 
0.21519, -0.367089, 0.240506, -0.367089, 0.265823, -0.367089, 0.291139, -0.367089, 0.316456, -0.367089, 0.341772, -0.367089, 0.367089, -0.367089, 0.392405, -0.367089, 
0.417722, -0.367089, 0.443038, -0.367089, 0.468354, -0.367089, 0.493671, -0.367089, 0.518987, -0.367089, 0.544304, -0.367089, 0.56962, -0.367089, 0.594937, -0.367089, 
0.620253, -0.367089, 0.64557, -0.367089, 0.670886, -0.367089, 0.696203, -0.367089, 0.721519, -0.367089, 0.746835, -0.367089, 0.772152, -0.367089, 0.797468, -0.367089, 
0.822785, -0.367089, 0.848101, -0.367089, 0.873418, -0.367089, 0.898734, -0.367089, 0.924051, -0.367089, 0.949367, -0.367089, 0.974684, -0.367089, 1.0, -0.367089, 
-1.0, -0.341772, -0.974684, -0.341772, -0.949367, -0.341772, -0.924051, -0.341772, -0.898734, -0.341772, -0.873418, -0.341772, -0.848101, -0.341772, -0.822785, -0.341772, 
-0.797468, -0.341772, -0.772152, -0.341772, -0.746835, -0.341772, -0.721519, -0.341772, -0.696203, -0.341772, -0.670886, -0.341772, -0.64557, -0.341772, -0.620253, -0.341772, 
-0.594937, -0.341772, -0.56962, -0.341772, -0.544304, -0.341772, -0.518987, -0.341772, -0.493671, -0.341772, -0.468354, -0.341772, -0.443038, -0.341772, -0.417722, -0.341772, 
-0.392405, -0.341772, -0.367089, -0.341772, -0.341772, -0.341772, -0.316456, -0.341772, -0.291139, -0.341772, -0.265823, -0.341772, -0.240506, -0.341772, -0.21519, -0.341772, 
-0.189873, -0.341772, -0.164557, -0.341772, -0.13924, -0.341772, -0.113924, -0.341772, -0.088608, -0.341772, -0.063291, -0.341772, -0.037975, -0.341772, -0.012658, -0.341772, 
0.012658, -0.341772, 0.037975, -0.341772, 0.063291, -0.341772, 0.088608, -0.341772, 0.113924, -0.341772, 0.13924, -0.341772, 0.164557, -0.341772, 0.189873, -0.341772, 
0.21519, -0.341772, 0.240506, -0.341772, 0.265823, -0.341772, 0.291139, -0.341772, 0.316456, -0.341772, 0.341772, -0.341772, 0.367089, -0.341772, 0.392405, -0.341772, 
0.417722, -0.341772, 0.443038, -0.341772, 0.468354, -0.341772, 0.493671, -0.341772, 0.518987, -0.341772, 0.544304, -0.341772, 0.56962, -0.341772, 0.594937, -0.341772, 
0.620253, -0.341772, 0.64557, -0.341772, 0.670886, -0.341772, 0.696203, -0.341772, 0.721519, -0.341772, 0.746835, -0.341772, 0.772152, -0.341772, 0.797468, -0.341772, 
0.822785, -0.341772, 0.848101, -0.341772, 0.873418, -0.341772, 0.898734, -0.341772, 0.924051, -0.341772, 0.949367, -0.341772, 0.974684, -0.341772, 1.0, -0.341772, 
-1.0, -0.316456, -0.974684, -0.316456, -0.949367, -0.316456, -0.924051, -0.316456, -0.898734, -0.316456, -0.873418, -0.316456, -0.848101, -0.316456, -0.822785, -0.316456, 
-0.797468, -0.316456, -0.772152, -0.316456, -0.746835, -0.316456, -0.721519, -0.316456, -0.696203, -0.316456, -0.670886, -0.316456, -0.64557, -0.316456, -0.620253, -0.316456, 
-0.594937, -0.316456, -0.56962, -0.316456, -0.544304, -0.316456, -0.518987, -0.316456, -0.493671, -0.316456, -0.468354, -0.316456, -0.443038, -0.316456, -0.417722, -0.316456, 
-0.392405, -0.316456, -0.367089, -0.316456, -0.341772, -0.316456, -0.316456, -0.316456, -0.291139, -0.316456, -0.265823, -0.316456, -0.240506, -0.316456, -0.21519, -0.316456, 
-0.189873, -0.316456, -0.164557, -0.316456, -0.13924, -0.316456, -0.113924, -0.316456, -0.088608, -0.316456, -0.063291, -0.316456, -0.037975, -0.316456, -0.012658, -0.316456, 
0.012658, -0.316456, 0.037975, -0.316456, 0.063291, -0.316456, 0.088608, -0.316456, 0.113924, -0.316456, 0.13924, -0.316456, 0.164557, -0.316456, 0.189873, -0.316456, 
0.21519, -0.316456, 0.240506, -0.316456, 0.265823, -0.316456, 0.291139, -0.316456, 0.316456, -0.316456, 0.341772, -0.316456, 0.367089, -0.316456, 0.392405, -0.316456, 
0.417722, -0.316456, 0.443038, -0.316456, 0.468354, -0.316456, 0.493671, -0.316456, 0.518987, -0.316456, 0.544304, -0.316456, 0.56962, -0.316456, 0.594937, -0.316456, 
0.620253, -0.316456, 0.64557, -0.316456, 0.670886, -0.316456, 0.696203, -0.316456, 0.721519, -0.316456, 0.746835, -0.316456, 0.772152, -0.316456, 0.797468, -0.316456, 
0.822785, -0.316456, 0.848101, -0.316456, 0.873418, -0.316456, 0.898734, -0.316456, 0.924051, -0.316456, 0.949367, -0.316456, 0.974684, -0.316456, 1.0, -0.316456, 
-1.0, -0.291139, -0.974684, -0.291139, -0.949367, -0.291139, -0.924051, -0.291139, -0.898734, -0.291139, -0.873418, -0.291139, -0.848101, -0.291139, -0.822785, -0.291139, 
-0.797468, -0.291139, -0.772152, -0.291139, -0.746835, -0.291139, -0.721519, -0.291139, -0.696203, -0.291139, -0.670886, -0.291139, -0.64557, -0.291139, -0.620253, -0.291139, 
-0.594937, -0.291139, -0.56962, -0.291139, -0.544304, -0.291139, -0.518987, -0.291139, -0.493671, -0.291139, -0.468354, -0.291139, -0.443038, -0.291139, -0.417722, -0.291139, 
-0.392405, -0.291139, -0.367089, -0.291139, -0.341772, -0.291139, -0.316456, -0.291139, -0.291139, -0.291139, -0.265823, -0.291139, -0.240506, -0.291139, -0.21519, -0.291139, 
-0.189873, -0.291139, -0.164557, -0.291139, -0.13924, -0.291139, -0.113924, -0.291139, -0.088608, -0.291139, -0.063291, -0.291139, -0.037975, -0.291139, -0.012658, -0.291139, 
0.012658, -0.291139, 0.037975, -0.291139, 0.063291, -0.291139, 0.088608, -0.291139, 0.113924, -0.291139, 0.13924, -0.291139, 0.164557, -0.291139, 0.189873, -0.291139, 
0.21519, -0.291139, 0.240506, -0.291139, 0.265823, -0.291139, 0.291139, -0.291139, 0.316456, -0.291139, 0.341772, -0.291139, 0.367089, -0.291139, 0.392405, -0.291139, 
0.417722, -0.291139, 0.443038, -0.291139, 0.468354, -0.291139, 0.493671, -0.291139, 0.518987, -0.291139, 0.544304, -0.291139, 0.56962, -0.291139, 0.594937, -0.291139, 
0.620253, -0.291139, 0.64557, -0.291139, 0.670886, -0.291139, 0.696203, -0.291139, 0.721519, -0.291139, 0.746835, -0.291139, 0.772152, -0.291139, 0.797468, -0.291139, 
0.822785, -0.291139, 0.848101, -0.291139, 0.873418, -0.291139, 0.898734, -0.291139, 0.924051, -0.291139, 0.949367, -0.291139, 0.974684, -0.291139, 1.0, -0.291139, 
-1.0, -0.265823, -0.974684, -0.265823, -0.949367, -0.265823, -0.924051, -0.265823, -0.898734, -0.265823, -0.873418, -0.265823, -0.848101, -0.265823, -0.822785, -0.265823, 
-0.797468, -0.265823, -0.772152, -0.265823, -0.746835, -0.265823, -0.721519, -0.265823, -0.696203, -0.265823, -0.670886, -0.265823, -0.64557, -0.265823, -0.620253, -0.265823, 
-0.594937, -0.265823, -0.56962, -0.265823, -0.544304, -0.265823, -0.518987, -0.265823, -0.493671, -0.265823, -0.468354, -0.265823, -0.443038, -0.265823, -0.417722, -0.265823, 
-0.392405, -0.265823, -0.367089, -0.265823, -0.341772, -0.265823, -0.316456, -0.265823, -0.291139, -0.265823, -0.265823, -0.265823, -0.240506, -0.265823, -0.21519, -0.265823, 
-0.189873, -0.265823, -0.164557, -0.265823, -0.13924, -0.265823, -0.113924, -0.265823, -0.088608, -0.265823, -0.063291, -0.265823, -0.037975, -0.265823, -0.012658, -0.265823, 
0.012658, -0.265823, 0.037975, -0.265823, 0.063291, -0.265823, 0.088608, -0.265823, 0.113924, -0.265823, 0.13924, -0.265823, 0.164557, -0.265823, 0.189873, -0.265823, 
0.21519, -0.265823, 0.240506, -0.265823, 0.265823, -0.265823, 0.291139, -0.265823, 0.316456, -0.265823, 0.341772, -0.265823, 0.367089, -0.265823, 0.392405, -0.265823, 
0.417722, -0.265823, 0.443038, -0.265823, 0.468354, -0.265823, 0.493671, -0.265823, 0.518987, -0.265823, 0.544304, -0.265823, 0.56962, -0.265823, 0.594937, -0.265823, 
0.620253, -0.265823, 0.64557, -0.265823, 0.670886, -0.265823, 0.696203, -0.265823, 0.721519, -0.265823, 0.746835, -0.265823, 0.772152, -0.265823, 0.797468, -0.265823, 
0.822785, -0.265823, 0.848101, -0.265823, 0.873418, -0.265823, 0.898734, -0.265823, 0.924051, -0.265823, 0.949367, -0.265823, 0.974684, -0.265823, 1.0, -0.265823, 
-1.0, -0.240506, -0.974684, -0.240506, -0.949367, -0.240506, -0.924051, -0.240506, -0.898734, -0.240506, -0.873418, -0.240506, -0.848101, -0.240506, -0.822785, -0.240506, 
-0.797468, -0.240506, -0.772152, -0.240506, -0.746835, -0.240506, -0.721519, -0.240506, -0.696203, -0.240506, -0.670886, -0.240506, -0.64557, -0.240506, -0.620253, -0.240506, 
-0.594937, -0.240506, -0.56962, -0.240506, -0.544304, -0.240506, -0.518987, -0.240506, -0.493671, -0.240506, -0.468354, -0.240506, -0.443038, -0.240506, -0.417722, -0.240506, 
-0.392405, -0.240506, -0.367089, -0.240506, -0.341772, -0.240506, -0.316456, -0.240506, -0.291139, -0.240506, -0.265823, -0.240506, -0.240506, -0.240506, -0.21519, -0.240506, 
-0.189873, -0.240506, -0.164557, -0.240506, -0.13924, -0.240506, -0.113924, -0.240506, -0.088608, -0.240506, -0.063291, -0.240506, -0.037975, -0.240506, -0.012658, -0.240506, 
0.012658, -0.240506, 0.037975, -0.240506, 0.063291, -0.240506, 0.088608, -0.240506, 0.113924, -0.240506, 0.13924, -0.240506, 0.164557, -0.240506, 0.189873, -0.240506, 
0.21519, -0.240506, 0.240506, -0.240506, 0.265823, -0.240506, 0.291139, -0.240506, 0.316456, -0.240506, 0.341772, -0.240506, 0.367089, -0.240506, 0.392405, -0.240506, 
0.417722, -0.240506, 0.443038, -0.240506, 0.468354, -0.240506, 0.493671, -0.240506, 0.518987, -0.240506, 0.544304, -0.240506, 0.56962, -0.240506, 0.594937, -0.240506, 
0.620253, -0.240506, 0.64557, -0.240506, 0.670886, -0.240506, 0.696203, -0.240506, 0.721519, -0.240506, 0.746835, -0.240506, 0.772152, -0.240506, 0.797468, -0.240506, 
0.822785, -0.240506, 0.848101, -0.240506, 0.873418, -0.240506, 0.898734, -0.240506, 0.924051, -0.240506, 0.949367, -0.240506, 0.974684, -0.240506, 1.0, -0.240506, 
-1.0, -0.21519, -0.974684, -0.21519, -0.949367, -0.21519, -0.924051, -0.21519, -0.898734, -0.21519, -0.873418, -0.21519, -0.848101, -0.21519, -0.822785, -0.21519, 
-0.797468, -0.21519, -0.772152, -0.21519, -0.746835, -0.21519, -0.721519, -0.21519, -0.696203, -0.21519, -0.670886, -0.21519, -0.64557, -0.21519, -0.620253, -0.21519, 
-0.594937, -0.21519, -0.56962, -0.21519, -0.544304, -0.21519, -0.518987, -0.21519, -0.493671, -0.21519, -0.468354, -0.21519, -0.443038, -0.21519, -0.417722, -0.21519, 
-0.392405, -0.21519, -0.367089, -0.21519, -0.341772, -0.21519, -0.316456, -0.21519, -0.291139, -0.21519, -0.265823, -0.21519, -0.240506, -0.21519, -0.21519, -0.21519, 
-0.189873, -0.21519, -0.164557, -0.21519, -0.13924, -0.21519, -0.113924, -0.21519, -0.088608, -0.21519, -0.063291, -0.21519, -0.037975, -0.21519, -0.012658, -0.21519, 
0.012658, -0.21519, 0.037975, -0.21519, 0.063291, -0.21519, 0.088608, -0.21519, 0.113924, -0.21519, 0.13924, -0.21519, 0.164557, -0.21519, 0.189873, -0.21519, 
0.21519, -0.21519, 0.240506, -0.21519, 0.265823, -0.21519, 0.291139, -0.21519, 0.316456, -0.21519, 0.341772, -0.21519, 0.367089, -0.21519, 0.392405, -0.21519, 
0.417722, -0.21519, 0.443038, -0.21519, 0.468354, -0.21519, 0.493671, -0.21519, 0.518987, -0.21519, 0.544304, -0.21519, 0.56962, -0.21519, 0.594937, -0.21519, 
0.620253, -0.21519, 0.64557, -0.21519, 0.670886, -0.21519, 0.696203, -0.21519, 0.721519, -0.21519, 0.746835, -0.21519, 0.772152, -0.21519, 0.797468, -0.21519, 
0.822785, -0.21519, 0.848101, -0.21519, 0.873418, -0.21519, 0.898734, -0.21519, 0.924051, -0.21519, 0.949367, -0.21519, 0.974684, -0.21519, 1.0, -0.21519, 
-1.0, -0.189873, -0.974684, -0.189873, -0.949367, -0.189873, -0.924051, -0.189873, -0.898734, -0.189873, -0.873418, -0.189873, -0.848101, -0.189873, -0.822785, -0.189873, 
-0.797468, -0.189873, -0.772152, -0.189873, -0.746835, -0.189873, -0.721519, -0.189873, -0.696203, -0.189873, -0.670886, -0.189873, -0.64557, -0.189873, -0.620253, -0.189873, 
-0.594937, -0.189873, -0.56962, -0.189873, -0.544304, -0.189873, -0.518987, -0.189873, -0.493671, -0.189873, -0.468354, -0.189873, -0.443038, -0.189873, -0.417722, -0.189873, 
-0.392405, -0.189873, -0.367089, -0.189873, -0.341772, -0.189873, -0.316456, -0.189873, -0.291139, -0.189873, -0.265823, -0.189873, -0.240506, -0.189873, -0.21519, -0.189873, 
-0.189873, -0.189873, -0.164557, -0.189873, -0.13924, -0.189873, -0.113924, -0.189873, -0.088608, -0.189873, -0.063291, -0.189873, -0.037975, -0.189873, -0.012658, -0.189873, 
0.012658, -0.189873, 0.037975, -0.189873, 0.063291, -0.189873, 0.088608, -0.189873, 0.113924, -0.189873, 0.13924, -0.189873, 0.164557, -0.189873, 0.189873, -0.189873, 
0.21519, -0.189873, 0.240506, -0.189873, 0.265823, -0.189873, 0.291139, -0.189873, 0.316456, -0.189873, 0.341772, -0.189873, 0.367089, -0.189873, 0.392405, -0.189873, 
0.417722, -0.189873, 0.443038, -0.189873, 0.468354, -0.189873, 0.493671, -0.189873, 0.518987, -0.189873, 0.544304, -0.189873, 0.56962, -0.189873, 0.594937, -0.189873, 
0.620253, -0.189873, 0.64557, -0.189873, 0.670886, -0.189873, 0.696203, -0.189873, 0.721519, -0.189873, 0.746835, -0.189873, 0.772152, -0.189873, 0.797468, -0.189873, 
0.822785, -0.189873, 0.848101, -0.189873, 0.873418, -0.189873, 0.898734, -0.189873, 0.924051, -0.189873, 0.949367, -0.189873, 0.974684, -0.189873, 1.0, -0.189873, 
-1.0, -0.164557, -0.974684, -0.164557, -0.949367, -0.164557, -0.924051, -0.164557, -0.898734, -0.164557, -0.873418, -0.164557, -0.848101, -0.164557, -0.822785, -0.164557, 
-0.797468, -0.164557, -0.772152, -0.164557, -0.746835, -0.164557, -0.721519, -0.164557, -0.696203, -0.164557, -0.670886, -0.164557, -0.64557, -0.164557, -0.620253, -0.164557, 
-0.594937, -0.164557, -0.56962, -0.164557, -0.544304, -0.164557, -0.518987, -0.164557, -0.493671, -0.164557, -0.468354, -0.164557, -0.443038, -0.164557, -0.417722, -0.164557, 
-0.392405, -0.164557, -0.367089, -0.164557, -0.341772, -0.164557, -0.316456, -0.164557, -0.291139, -0.164557, -0.265823, -0.164557, -0.240506, -0.164557, -0.21519, -0.164557, 
-0.189873, -0.164557, -0.164557, -0.164557, -0.13924, -0.164557, -0.113924, -0.164557, -0.088608, -0.164557, -0.063291, -0.164557, -0.037975, -0.164557, -0.012658, -0.164557, 
0.012658, -0.164557, 0.037975, -0.164557, 0.063291, -0.164557, 0.088608, -0.164557, 0.113924, -0.164557, 0.13924, -0.164557, 0.164557, -0.164557, 0.189873, -0.164557, 
0.21519, -0.164557, 0.240506, -0.164557, 0.265823, -0.164557, 0.291139, -0.164557, 0.316456, -0.164557, 0.341772, -0.164557, 0.367089, -0.164557, 0.392405, -0.164557, 
0.417722, -0.164557, 0.443038, -0.164557, 0.468354, -0.164557, 0.493671, -0.164557, 0.518987, -0.164557, 0.544304, -0.164557, 0.56962, -0.164557, 0.594937, -0.164557, 
0.620253, -0.164557, 0.64557, -0.164557, 0.670886, -0.164557, 0.696203, -0.164557, 0.721519, -0.164557, 0.746835, -0.164557, 0.772152, -0.164557, 0.797468, -0.164557, 
0.822785, -0.164557, 0.848101, -0.164557, 0.873418, -0.164557, 0.898734, -0.164557, 0.924051, -0.164557, 0.949367, -0.164557, 0.974684, -0.164557, 1.0, -0.164557, 
-1.0, -0.13924, -0.974684, -0.13924, -0.949367, -0.13924, -0.924051, -0.13924, -0.898734, -0.13924, -0.873418, -0.13924, -0.848101, -0.13924, -0.822785, -0.13924, 
-0.797468, -0.13924, -0.772152, -0.13924, -0.746835, -0.13924, -0.721519, -0.13924, -0.696203, -0.13924, -0.670886, -0.13924, -0.64557, -0.13924, -0.620253, -0.13924, 
-0.594937, -0.13924, -0.56962, -0.13924, -0.544304, -0.13924, -0.518987, -0.13924, -0.493671, -0.13924, -0.468354, -0.13924, -0.443038, -0.13924, -0.417722, -0.13924, 
-0.392405, -0.13924, -0.367089, -0.13924, -0.341772, -0.13924, -0.316456, -0.13924, -0.291139, -0.13924, -0.265823, -0.13924, -0.240506, -0.13924, -0.21519, -0.13924, 
-0.189873, -0.13924, -0.164557, -0.13924, -0.13924, -0.13924, -0.113924, -0.13924, -0.088608, -0.13924, -0.063291, -0.13924, -0.037975, -0.13924, -0.012658, -0.13924, 
0.012658, -0.13924, 0.037975, -0.13924, 0.063291, -0.13924, 0.088608, -0.13924, 0.113924, -0.13924, 0.13924, -0.13924, 0.164557, -0.13924, 0.189873, -0.13924, 
0.21519, -0.13924, 0.240506, -0.13924, 0.265823, -0.13924, 0.291139, -0.13924, 0.316456, -0.13924, 0.341772, -0.13924, 0.367089, -0.13924, 0.392405, -0.13924, 
0.417722, -0.13924, 0.443038, -0.13924, 0.468354, -0.13924, 0.493671, -0.13924, 0.518987, -0.13924, 0.544304, -0.13924, 0.56962, -0.13924, 0.594937, -0.13924, 
0.620253, -0.13924, 0.64557, -0.13924, 0.670886, -0.13924, 0.696203, -0.13924, 0.721519, -0.13924, 0.746835, -0.13924, 0.772152, -0.13924, 0.797468, -0.13924, 
0.822785, -0.13924, 0.848101, -0.13924, 0.873418, -0.13924, 0.898734, -0.13924, 0.924051, -0.13924, 0.949367, -0.13924, 0.974684, -0.13924, 1.0, -0.13924, 
-1.0, -0.113924, -0.974684, -0.113924, -0.949367, -0.113924, -0.924051, -0.113924, -0.898734, -0.113924, -0.873418, -0.113924, -0.848101, -0.113924, -0.822785, -0.113924, 
-0.797468, -0.113924, -0.772152, -0.113924, -0.746835, -0.113924, -0.721519, -0.113924, -0.696203, -0.113924, -0.670886, -0.113924, -0.64557, -0.113924, -0.620253, -0.113924, 
-0.594937, -0.113924, -0.56962, -0.113924, -0.544304, -0.113924, -0.518987, -0.113924, -0.493671, -0.113924, -0.468354, -0.113924, -0.443038, -0.113924, -0.417722, -0.113924, 
-0.392405, -0.113924, -0.367089, -0.113924, -0.341772, -0.113924, -0.316456, -0.113924, -0.291139, -0.113924, -0.265823, -0.113924, -0.240506, -0.113924, -0.21519, -0.113924, 
-0.189873, -0.113924, -0.164557, -0.113924, -0.13924, -0.113924, -0.113924, -0.113924, -0.088608, -0.113924, -0.063291, -0.113924, -0.037975, -0.113924, -0.012658, -0.113924, 
0.012658, -0.113924, 0.037975, -0.113924, 0.063291, -0.113924, 0.088608, -0.113924, 0.113924, -0.113924, 0.13924, -0.113924, 0.164557, -0.113924, 0.189873, -0.113924, 
0.21519, -0.113924, 0.240506, -0.113924, 0.265823, -0.113924, 0.291139, -0.113924, 0.316456, -0.113924, 0.341772, -0.113924, 0.367089, -0.113924, 0.392405, -0.113924, 
0.417722, -0.113924, 0.443038, -0.113924, 0.468354, -0.113924, 0.493671, -0.113924, 0.518987, -0.113924, 0.544304, -0.113924, 0.56962, -0.113924, 0.594937, -0.113924, 
0.620253, -0.113924, 0.64557, -0.113924, 0.670886, -0.113924, 0.696203, -0.113924, 0.721519, -0.113924, 0.746835, -0.113924, 0.772152, -0.113924, 0.797468, -0.113924, 
0.822785, -0.113924, 0.848101, -0.113924, 0.873418, -0.113924, 0.898734, -0.113924, 0.924051, -0.113924, 0.949367, -0.113924, 0.974684, -0.113924, 1.0, -0.113924, 
-1.0, -0.088608, -0.974684, -0.088608, -0.949367, -0.088608, -0.924051, -0.088608, -0.898734, -0.088608, -0.873418, -0.088608, -0.848101, -0.088608, -0.822785, -0.088608, 
-0.797468, -0.088608, -0.772152, -0.088608, -0.746835, -0.088608, -0.721519, -0.088608, -0.696203, -0.088608, -0.670886, -0.088608, -0.64557, -0.088608, -0.620253, -0.088608, 
-0.594937, -0.088608, -0.56962, -0.088608, -0.544304, -0.088608, -0.518987, -0.088608, -0.493671, -0.088608, -0.468354, -0.088608, -0.443038, -0.088608, -0.417722, -0.088608, 
-0.392405, -0.088608, -0.367089, -0.088608, -0.341772, -0.088608, -0.316456, -0.088608, -0.291139, -0.088608, -0.265823, -0.088608, -0.240506, -0.088608, -0.21519, -0.088608, 
-0.189873, -0.088608, -0.164557, -0.088608, -0.13924, -0.088608, -0.113924, -0.088608, -0.088608, -0.088608, -0.063291, -0.088608, -0.037975, -0.088608, -0.012658, -0.088608, 
0.012658, -0.088608, 0.037975, -0.088608, 0.063291, -0.088608, 0.088608, -0.088608, 0.113924, -0.088608, 0.13924, -0.088608, 0.164557, -0.088608, 0.189873, -0.088608, 
0.21519, -0.088608, 0.240506, -0.088608, 0.265823, -0.088608, 0.291139, -0.088608, 0.316456, -0.088608, 0.341772, -0.088608, 0.367089, -0.088608, 0.392405, -0.088608, 
0.417722, -0.088608, 0.443038, -0.088608, 0.468354, -0.088608, 0.493671, -0.088608, 0.518987, -0.088608, 0.544304, -0.088608, 0.56962, -0.088608, 0.594937, -0.088608, 
0.620253, -0.088608, 0.64557, -0.088608, 0.670886, -0.088608, 0.696203, -0.088608, 0.721519, -0.088608, 0.746835, -0.088608, 0.772152, -0.088608, 0.797468, -0.088608, 
0.822785, -0.088608, 0.848101, -0.088608, 0.873418, -0.088608, 0.898734, -0.088608, 0.924051, -0.088608, 0.949367, -0.088608, 0.974684, -0.088608, 1.0, -0.088608, 
-1.0, -0.063291, -0.974684, -0.063291, -0.949367, -0.063291, -0.924051, -0.063291, -0.898734, -0.063291, -0.873418, -0.063291, -0.848101, -0.063291, -0.822785, -0.063291, 
-0.797468, -0.063291, -0.772152, -0.063291, -0.746835, -0.063291, -0.721519, -0.063291, -0.696203, -0.063291, -0.670886, -0.063291, -0.64557, -0.063291, -0.620253, -0.063291, 
-0.594937, -0.063291, -0.56962, -0.063291, -0.544304, -0.063291, -0.518987, -0.063291, -0.493671, -0.063291, -0.468354, -0.063291, -0.443038, -0.063291, -0.417722, -0.063291, 
-0.392405, -0.063291, -0.367089, -0.063291, -0.341772, -0.063291, -0.316456, -0.063291, -0.291139, -0.063291, -0.265823, -0.063291, -0.240506, -0.063291, -0.21519, -0.063291, 
-0.189873, -0.063291, -0.164557, -0.063291, -0.13924, -0.063291, -0.113924, -0.063291, -0.088608, -0.063291, -0.063291, -0.063291, -0.037975, -0.063291, -0.012658, -0.063291, 
0.012658, -0.063291, 0.037975, -0.063291, 0.063291, -0.063291, 0.088608, -0.063291, 0.113924, -0.063291, 0.13924, -0.063291, 0.164557, -0.063291, 0.189873, -0.063291, 
0.21519, -0.063291, 0.240506, -0.063291, 0.265823, -0.063291, 0.291139, -0.063291, 0.316456, -0.063291, 0.341772, -0.063291, 0.367089, -0.063291, 0.392405, -0.063291, 
0.417722, -0.063291, 0.443038, -0.063291, 0.468354, -0.063291, 0.493671, -0.063291, 0.518987, -0.063291, 0.544304, -0.063291, 0.56962, -0.063291, 0.594937, -0.063291, 
0.620253, -0.063291, 0.64557, -0.063291, 0.670886, -0.063291, 0.696203, -0.063291, 0.721519, -0.063291, 0.746835, -0.063291, 0.772152, -0.063291, 0.797468, -0.063291, 
0.822785, -0.063291, 0.848101, -0.063291, 0.873418, -0.063291, 0.898734, -0.063291, 0.924051, -0.063291, 0.949367, -0.063291, 0.974684, -0.063291, 1.0, -0.063291, 
-1.0, -0.037975, -0.974684, -0.037975, -0.949367, -0.037975, -0.924051, -0.037975, -0.898734, -0.037975, -0.873418, -0.037975, -0.848101, -0.037975, -0.822785, -0.037975, 
-0.797468, -0.037975, -0.772152, -0.037975, -0.746835, -0.037975, -0.721519, -0.037975, -0.696203, -0.037975, -0.670886, -0.037975, -0.64557, -0.037975, -0.620253, -0.037975, 
-0.594937, -0.037975, -0.56962, -0.037975, -0.544304, -0.037975, -0.518987, -0.037975, -0.493671, -0.037975, -0.468354, -0.037975, -0.443038, -0.037975, -0.417722, -0.037975, 
-0.392405, -0.037975, -0.367089, -0.037975, -0.341772, -0.037975, -0.316456, -0.037975, -0.291139, -0.037975, -0.265823, -0.037975, -0.240506, -0.037975, -0.21519, -0.037975, 
-0.189873, -0.037975, -0.164557, -0.037975, -0.13924, -0.037975, -0.113924, -0.037975, -0.088608, -0.037975, -0.063291, -0.037975, -0.037975, -0.037975, -0.012658, -0.037975, 
0.012658, -0.037975, 0.037975, -0.037975, 0.063291, -0.037975, 0.088608, -0.037975, 0.113924, -0.037975, 0.13924, -0.037975, 0.164557, -0.037975, 0.189873, -0.037975, 
0.21519, -0.037975, 0.240506, -0.037975, 0.265823, -0.037975, 0.291139, -0.037975, 0.316456, -0.037975, 0.341772, -0.037975, 0.367089, -0.037975, 0.392405, -0.037975, 
0.417722, -0.037975, 0.443038, -0.037975, 0.468354, -0.037975, 0.493671, -0.037975, 0.518987, -0.037975, 0.544304, -0.037975, 0.56962, -0.037975, 0.594937, -0.037975, 
0.620253, -0.037975, 0.64557, -0.037975, 0.670886, -0.037975, 0.696203, -0.037975, 0.721519, -0.037975, 0.746835, -0.037975, 0.772152, -0.037975, 0.797468, -0.037975, 
0.822785, -0.037975, 0.848101, -0.037975, 0.873418, -0.037975, 0.898734, -0.037975, 0.924051, -0.037975, 0.949367, -0.037975, 0.974684, -0.037975, 1.0, -0.037975, 
-1.0, -0.012658, -0.974684, -0.012658, -0.949367, -0.012658, -0.924051, -0.012658, -0.898734, -0.012658, -0.873418, -0.012658, -0.848101, -0.012658, -0.822785, -0.012658, 
-0.797468, -0.012658, -0.772152, -0.012658, -0.746835, -0.012658, -0.721519, -0.012658, -0.696203, -0.012658, -0.670886, -0.012658, -0.64557, -0.012658, -0.620253, -0.012658, 
-0.594937, -0.012658, -0.56962, -0.012658, -0.544304, -0.012658, -0.518987, -0.012658, -0.493671, -0.012658, -0.468354, -0.012658, -0.443038, -0.012658, -0.417722, -0.012658, 
-0.392405, -0.012658, -0.367089, -0.012658, -0.341772, -0.012658, -0.316456, -0.012658, -0.291139, -0.012658, -0.265823, -0.012658, -0.240506, -0.012658, -0.21519, -0.012658, 
-0.189873, -0.012658, -0.164557, -0.012658, -0.13924, -0.012658, -0.113924, -0.012658, -0.088608, -0.012658, -0.063291, -0.012658, -0.037975, -0.012658, -0.012658, -0.012658, 
0.012658, -0.012658, 0.037975, -0.012658, 0.063291, -0.012658, 0.088608, -0.012658, 0.113924, -0.012658, 0.13924, -0.012658, 0.164557, -0.012658, 0.189873, -0.012658, 
0.21519, -0.012658, 0.240506, -0.012658, 0.265823, -0.012658, 0.291139, -0.012658, 0.316456, -0.012658, 0.341772, -0.012658, 0.367089, -0.012658, 0.392405, -0.012658, 
0.417722, -0.012658, 0.443038, -0.012658, 0.468354, -0.012658, 0.493671, -0.012658, 0.518987, -0.012658, 0.544304, -0.012658, 0.56962, -0.012658, 0.594937, -0.012658, 
0.620253, -0.012658, 0.64557, -0.012658, 0.670886, -0.012658, 0.696203, -0.012658, 0.721519, -0.012658, 0.746835, -0.012658, 0.772152, -0.012658, 0.797468, -0.012658, 
0.822785, -0.012658, 0.848101, -0.012658, 0.873418, -0.012658, 0.898734, -0.012658, 0.924051, -0.012658, 0.949367, -0.012658, 0.974684, -0.012658, 1.0, -0.012658, 
-1.0, 0.012658, -0.974684, 0.012658, -0.949367, 0.012658, -0.924051, 0.012658, -0.898734, 0.012658, -0.873418, 0.012658, -0.848101, 0.012658, -0.822785, 0.012658, 
-0.797468, 0.012658, -0.772152, 0.012658, -0.746835, 0.012658, -0.721519, 0.012658, -0.696203, 0.012658, -0.670886, 0.012658, -0.64557, 0.012658, -0.620253, 0.012658, 
-0.594937, 0.012658, -0.56962, 0.012658, -0.544304, 0.012658, -0.518987, 0.012658, -0.493671, 0.012658, -0.468354, 0.012658, -0.443038, 0.012658, -0.417722, 0.012658, 
-0.392405, 0.012658, -0.367089, 0.012658, -0.341772, 0.012658, -0.316456, 0.012658, -0.291139, 0.012658, -0.265823, 0.012658, -0.240506, 0.012658, -0.21519, 0.012658, 
-0.189873, 0.012658, -0.164557, 0.012658, -0.13924, 0.012658, -0.113924, 0.012658, -0.088608, 0.012658, -0.063291, 0.012658, -0.037975, 0.012658, -0.012658, 0.012658, 
0.012658, 0.012658, 0.037975, 0.012658, 0.063291, 0.012658, 0.088608, 0.012658, 0.113924, 0.012658, 0.13924, 0.012658, 0.164557, 0.012658, 0.189873, 0.012658, 
0.21519, 0.012658, 0.240506, 0.012658, 0.265823, 0.012658, 0.291139, 0.012658, 0.316456, 0.012658, 0.341772, 0.012658, 0.367089, 0.012658, 0.392405, 0.012658, 
0.417722, 0.012658, 0.443038, 0.012658, 0.468354, 0.012658, 0.493671, 0.012658, 0.518987, 0.012658, 0.544304, 0.012658, 0.56962, 0.012658, 0.594937, 0.012658, 
0.620253, 0.012658, 0.64557, 0.012658, 0.670886, 0.012658, 0.696203, 0.012658, 0.721519, 0.012658, 0.746835, 0.012658, 0.772152, 0.012658, 0.797468, 0.012658, 
0.822785, 0.012658, 0.848101, 0.012658, 0.873418, 0.012658, 0.898734, 0.012658, 0.924051, 0.012658, 0.949367, 0.012658, 0.974684, 0.012658, 1.0, 0.012658, 
-1.0, 0.037975, -0.974684, 0.037975, -0.949367, 0.037975, -0.924051, 0.037975, -0.898734, 0.037975, -0.873418, 0.037975, -0.848101, 0.037975, -0.822785, 0.037975, 
-0.797468, 0.037975, -0.772152, 0.037975, -0.746835, 0.037975, -0.721519, 0.037975, -0.696203, 0.037975, -0.670886, 0.037975, -0.64557, 0.037975, -0.620253, 0.037975, 
-0.594937, 0.037975, -0.56962, 0.037975, -0.544304, 0.037975, -0.518987, 0.037975, -0.493671, 0.037975, -0.468354, 0.037975, -0.443038, 0.037975, -0.417722, 0.037975, 
-0.392405, 0.037975, -0.367089, 0.037975, -0.341772, 0.037975, -0.316456, 0.037975, -0.291139, 0.037975, -0.265823, 0.037975, -0.240506, 0.037975, -0.21519, 0.037975, 
-0.189873, 0.037975, -0.164557, 0.037975, -0.13924, 0.037975, -0.113924, 0.037975, -0.088608, 0.037975, -0.063291, 0.037975, -0.037975, 0.037975, -0.012658, 0.037975, 
0.012658, 0.037975, 0.037975, 0.037975, 0.063291, 0.037975, 0.088608, 0.037975, 0.113924, 0.037975, 0.13924, 0.037975, 0.164557, 0.037975, 0.189873, 0.037975, 
0.21519, 0.037975, 0.240506, 0.037975, 0.265823, 0.037975, 0.291139, 0.037975, 0.316456, 0.037975, 0.341772, 0.037975, 0.367089, 0.037975, 0.392405, 0.037975, 
0.417722, 0.037975, 0.443038, 0.037975, 0.468354, 0.037975, 0.493671, 0.037975, 0.518987, 0.037975, 0.544304, 0.037975, 0.56962, 0.037975, 0.594937, 0.037975, 
0.620253, 0.037975, 0.64557, 0.037975, 0.670886, 0.037975, 0.696203, 0.037975, 0.721519, 0.037975, 0.746835, 0.037975, 0.772152, 0.037975, 0.797468, 0.037975, 
0.822785, 0.037975, 0.848101, 0.037975, 0.873418, 0.037975, 0.898734, 0.037975, 0.924051, 0.037975, 0.949367, 0.037975, 0.974684, 0.037975, 1.0, 0.037975, 
-1.0, 0.063291, -0.974684, 0.063291, -0.949367, 0.063291, -0.924051, 0.063291, -0.898734, 0.063291, -0.873418, 0.063291, -0.848101, 0.063291, -0.822785, 0.063291, 
-0.797468, 0.063291, -0.772152, 0.063291, -0.746835, 0.063291, -0.721519, 0.063291, -0.696203, 0.063291, -0.670886, 0.063291, -0.64557, 0.063291, -0.620253, 0.063291, 
-0.594937, 0.063291, -0.56962, 0.063291, -0.544304, 0.063291, -0.518987, 0.063291, -0.493671, 0.063291, -0.468354, 0.063291, -0.443038, 0.063291, -0.417722, 0.063291, 
-0.392405, 0.063291, -0.367089, 0.063291, -0.341772, 0.063291, -0.316456, 0.063291, -0.291139, 0.063291, -0.265823, 0.063291, -0.240506, 0.063291, -0.21519, 0.063291, 
-0.189873, 0.063291, -0.164557, 0.063291, -0.13924, 0.063291, -0.113924, 0.063291, -0.088608, 0.063291, -0.063291, 0.063291, -0.037975, 0.063291, -0.012658, 0.063291, 
0.012658, 0.063291, 0.037975, 0.063291, 0.063291, 0.063291, 0.088608, 0.063291, 0.113924, 0.063291, 0.13924, 0.063291, 0.164557, 0.063291, 0.189873, 0.063291, 
0.21519, 0.063291, 0.240506, 0.063291, 0.265823, 0.063291, 0.291139, 0.063291, 0.316456, 0.063291, 0.341772, 0.063291, 0.367089, 0.063291, 0.392405, 0.063291, 
0.417722, 0.063291, 0.443038, 0.063291, 0.468354, 0.063291, 0.493671, 0.063291, 0.518987, 0.063291, 0.544304, 0.063291, 0.56962, 0.063291, 0.594937, 0.063291, 
0.620253, 0.063291, 0.64557, 0.063291, 0.670886, 0.063291, 0.696203, 0.063291, 0.721519, 0.063291, 0.746835, 0.063291, 0.772152, 0.063291, 0.797468, 0.063291, 
0.822785, 0.063291, 0.848101, 0.063291, 0.873418, 0.063291, 0.898734, 0.063291, 0.924051, 0.063291, 0.949367, 0.063291, 0.974684, 0.063291, 1.0, 0.063291, 
-1.0, 0.088608, -0.974684, 0.088608, -0.949367, 0.088608, -0.924051, 0.088608, -0.898734, 0.088608, -0.873418, 0.088608, -0.848101, 0.088608, -0.822785, 0.088608, 
-0.797468, 0.088608, -0.772152, 0.088608, -0.746835, 0.088608, -0.721519, 0.088608, -0.696203, 0.088608, -0.670886, 0.088608, -0.64557, 0.088608, -0.620253, 0.088608, 
-0.594937, 0.088608, -0.56962, 0.088608, -0.544304, 0.088608, -0.518987, 0.088608, -0.493671, 0.088608, -0.468354, 0.088608, -0.443038, 0.088608, -0.417722, 0.088608, 
-0.392405, 0.088608, -0.367089, 0.088608, -0.341772, 0.088608, -0.316456, 0.088608, -0.291139, 0.088608, -0.265823, 0.088608, -0.240506, 0.088608, -0.21519, 0.088608, 
-0.189873, 0.088608, -0.164557, 0.088608, -0.13924, 0.088608, -0.113924, 0.088608, -0.088608, 0.088608, -0.063291, 0.088608, -0.037975, 0.088608, -0.012658, 0.088608, 
0.012658, 0.088608, 0.037975, 0.088608, 0.063291, 0.088608, 0.088608, 0.088608, 0.113924, 0.088608, 0.13924, 0.088608, 0.164557, 0.088608, 0.189873, 0.088608, 
0.21519, 0.088608, 0.240506, 0.088608, 0.265823, 0.088608, 0.291139, 0.088608, 0.316456, 0.088608, 0.341772, 0.088608, 0.367089, 0.088608, 0.392405, 0.088608, 
0.417722, 0.088608, 0.443038, 0.088608, 0.468354, 0.088608, 0.493671, 0.088608, 0.518987, 0.088608, 0.544304, 0.088608, 0.56962, 0.088608, 0.594937, 0.088608, 
0.620253, 0.088608, 0.64557, 0.088608, 0.670886, 0.088608, 0.696203, 0.088608, 0.721519, 0.088608, 0.746835, 0.088608, 0.772152, 0.088608, 0.797468, 0.088608, 
0.822785, 0.088608, 0.848101, 0.088608, 0.873418, 0.088608, 0.898734, 0.088608, 0.924051, 0.088608, 0.949367, 0.088608, 0.974684, 0.088608, 1.0, 0.088608, 
-1.0, 0.113924, -0.974684, 0.113924, -0.949367, 0.113924, -0.924051, 0.113924, -0.898734, 0.113924, -0.873418, 0.113924, -0.848101, 0.113924, -0.822785, 0.113924, 
-0.797468, 0.113924, -0.772152, 0.113924, -0.746835, 0.113924, -0.721519, 0.113924, -0.696203, 0.113924, -0.670886, 0.113924, -0.64557, 0.113924, -0.620253, 0.113924, 
-0.594937, 0.113924, -0.56962, 0.113924, -0.544304, 0.113924, -0.518987, 0.113924, -0.493671, 0.113924, -0.468354, 0.113924, -0.443038, 0.113924, -0.417722, 0.113924, 
-0.392405, 0.113924, -0.367089, 0.113924, -0.341772, 0.113924, -0.316456, 0.113924, -0.291139, 0.113924, -0.265823, 0.113924, -0.240506, 0.113924, -0.21519, 0.113924, 
-0.189873, 0.113924, -0.164557, 0.113924, -0.13924, 0.113924, -0.113924, 0.113924, -0.088608, 0.113924, -0.063291, 0.113924, -0.037975, 0.113924, -0.012658, 0.113924, 
0.012658, 0.113924, 0.037975, 0.113924, 0.063291, 0.113924, 0.088608, 0.113924, 0.113924, 0.113924, 0.13924, 0.113924, 0.164557, 0.113924, 0.189873, 0.113924, 
0.21519, 0.113924, 0.240506, 0.113924, 0.265823, 0.113924, 0.291139, 0.113924, 0.316456, 0.113924, 0.341772, 0.113924, 0.367089, 0.113924, 0.392405, 0.113924, 
0.417722, 0.113924, 0.443038, 0.113924, 0.468354, 0.113924, 0.493671, 0.113924, 0.518987, 0.113924, 0.544304, 0.113924, 0.56962, 0.113924, 0.594937, 0.113924, 
0.620253, 0.113924, 0.64557, 0.113924, 0.670886, 0.113924, 0.696203, 0.113924, 0.721519, 0.113924, 0.746835, 0.113924, 0.772152, 0.113924, 0.797468, 0.113924, 
0.822785, 0.113924, 0.848101, 0.113924, 0.873418, 0.113924, 0.898734, 0.113924, 0.924051, 0.113924, 0.949367, 0.113924, 0.974684, 0.113924, 1.0, 0.113924, 
-1.0, 0.13924, -0.974684, 0.13924, -0.949367, 0.13924, -0.924051, 0.13924, -0.898734, 0.13924, -0.873418, 0.13924, -0.848101, 0.13924, -0.822785, 0.13924, 
-0.797468, 0.13924, -0.772152, 0.13924, -0.746835, 0.13924, -0.721519, 0.13924, -0.696203, 0.13924, -0.670886, 0.13924, -0.64557, 0.13924, -0.620253, 0.13924, 
-0.594937, 0.13924, -0.56962, 0.13924, -0.544304, 0.13924, -0.518987, 0.13924, -0.493671, 0.13924, -0.468354, 0.13924, -0.443038, 0.13924, -0.417722, 0.13924, 
-0.392405, 0.13924, -0.367089, 0.13924, -0.341772, 0.13924, -0.316456, 0.13924, -0.291139, 0.13924, -0.265823, 0.13924, -0.240506, 0.13924, -0.21519, 0.13924, 
-0.189873, 0.13924, -0.164557, 0.13924, -0.13924, 0.13924, -0.113924, 0.13924, -0.088608, 0.13924, -0.063291, 0.13924, -0.037975, 0.13924, -0.012658, 0.13924, 
0.012658, 0.13924, 0.037975, 0.13924, 0.063291, 0.13924, 0.088608, 0.13924, 0.113924, 0.13924, 0.13924, 0.13924, 0.164557, 0.13924, 0.189873, 0.13924, 
0.21519, 0.13924, 0.240506, 0.13924, 0.265823, 0.13924, 0.291139, 0.13924, 0.316456, 0.13924, 0.341772, 0.13924, 0.367089, 0.13924, 0.392405, 0.13924, 
0.417722, 0.13924, 0.443038, 0.13924, 0.468354, 0.13924, 0.493671, 0.13924, 0.518987, 0.13924, 0.544304, 0.13924, 0.56962, 0.13924, 0.594937, 0.13924, 
0.620253, 0.13924, 0.64557, 0.13924, 0.670886, 0.13924, 0.696203, 0.13924, 0.721519, 0.13924, 0.746835, 0.13924, 0.772152, 0.13924, 0.797468, 0.13924, 
0.822785, 0.13924, 0.848101, 0.13924, 0.873418, 0.13924, 0.898734, 0.13924, 0.924051, 0.13924, 0.949367, 0.13924, 0.974684, 0.13924, 1.0, 0.13924, 
-1.0, 0.164557, -0.974684, 0.164557, -0.949367, 0.164557, -0.924051, 0.164557, -0.898734, 0.164557, -0.873418, 0.164557, -0.848101, 0.164557, -0.822785, 0.164557, 
-0.797468, 0.164557, -0.772152, 0.164557, -0.746835, 0.164557, -0.721519, 0.164557, -0.696203, 0.164557, -0.670886, 0.164557, -0.64557, 0.164557, -0.620253, 0.164557, 
-0.594937, 0.164557, -0.56962, 0.164557, -0.544304, 0.164557, -0.518987, 0.164557, -0.493671, 0.164557, -0.468354, 0.164557, -0.443038, 0.164557, -0.417722, 0.164557, 
-0.392405, 0.164557, -0.367089, 0.164557, -0.341772, 0.164557, -0.316456, 0.164557, -0.291139, 0.164557, -0.265823, 0.164557, -0.240506, 0.164557, -0.21519, 0.164557, 
-0.189873, 0.164557, -0.164557, 0.164557, -0.13924, 0.164557, -0.113924, 0.164557, -0.088608, 0.164557, -0.063291, 0.164557, -0.037975, 0.164557, -0.012658, 0.164557, 
0.012658, 0.164557, 0.037975, 0.164557, 0.063291, 0.164557, 0.088608, 0.164557, 0.113924, 0.164557, 0.13924, 0.164557, 0.164557, 0.164557, 0.189873, 0.164557, 
0.21519, 0.164557, 0.240506, 0.164557, 0.265823, 0.164557, 0.291139, 0.164557, 0.316456, 0.164557, 0.341772, 0.164557, 0.367089, 0.164557, 0.392405, 0.164557, 
0.417722, 0.164557, 0.443038, 0.164557, 0.468354, 0.164557, 0.493671, 0.164557, 0.518987, 0.164557, 0.544304, 0.164557, 0.56962, 0.164557, 0.594937, 0.164557, 
0.620253, 0.164557, 0.64557, 0.164557, 0.670886, 0.164557, 0.696203, 0.164557, 0.721519, 0.164557, 0.746835, 0.164557, 0.772152, 0.164557, 0.797468, 0.164557, 
0.822785, 0.164557, 0.848101, 0.164557, 0.873418, 0.164557, 0.898734, 0.164557, 0.924051, 0.164557, 0.949367, 0.164557, 0.974684, 0.164557, 1.0, 0.164557, 
-1.0, 0.189873, -0.974684, 0.189873, -0.949367, 0.189873, -0.924051, 0.189873, -0.898734, 0.189873, -0.873418, 0.189873, -0.848101, 0.189873, -0.822785, 0.189873, 
-0.797468, 0.189873, -0.772152, 0.189873, -0.746835, 0.189873, -0.721519, 0.189873, -0.696203, 0.189873, -0.670886, 0.189873, -0.64557, 0.189873, -0.620253, 0.189873, 
-0.594937, 0.189873, -0.56962, 0.189873, -0.544304, 0.189873, -0.518987, 0.189873, -0.493671, 0.189873, -0.468354, 0.189873, -0.443038, 0.189873, -0.417722, 0.189873, 
-0.392405, 0.189873, -0.367089, 0.189873, -0.341772, 0.189873, -0.316456, 0.189873, -0.291139, 0.189873, -0.265823, 0.189873, -0.240506, 0.189873, -0.21519, 0.189873, 
-0.189873, 0.189873, -0.164557, 0.189873, -0.13924, 0.189873, -0.113924, 0.189873, -0.088608, 0.189873, -0.063291, 0.189873, -0.037975, 0.189873, -0.012658, 0.189873, 
0.012658, 0.189873, 0.037975, 0.189873, 0.063291, 0.189873, 0.088608, 0.189873, 0.113924, 0.189873, 0.13924, 0.189873, 0.164557, 0.189873, 0.189873, 0.189873, 
0.21519, 0.189873, 0.240506, 0.189873, 0.265823, 0.189873, 0.291139, 0.189873, 0.316456, 0.189873, 0.341772, 0.189873, 0.367089, 0.189873, 0.392405, 0.189873, 
0.417722, 0.189873, 0.443038, 0.189873, 0.468354, 0.189873, 0.493671, 0.189873, 0.518987, 0.189873, 0.544304, 0.189873, 0.56962, 0.189873, 0.594937, 0.189873, 
0.620253, 0.189873, 0.64557, 0.189873, 0.670886, 0.189873, 0.696203, 0.189873, 0.721519, 0.189873, 0.746835, 0.189873, 0.772152, 0.189873, 0.797468, 0.189873, 
0.822785, 0.189873, 0.848101, 0.189873, 0.873418, 0.189873, 0.898734, 0.189873, 0.924051, 0.189873, 0.949367, 0.189873, 0.974684, 0.189873, 1.0, 0.189873, 
-1.0, 0.21519, -0.974684, 0.21519, -0.949367, 0.21519, -0.924051, 0.21519, -0.898734, 0.21519, -0.873418, 0.21519, -0.848101, 0.21519, -0.822785, 0.21519, 
-0.797468, 0.21519, -0.772152, 0.21519, -0.746835, 0.21519, -0.721519, 0.21519, -0.696203, 0.21519, -0.670886, 0.21519, -0.64557, 0.21519, -0.620253, 0.21519, 
-0.594937, 0.21519, -0.56962, 0.21519, -0.544304, 0.21519, -0.518987, 0.21519, -0.493671, 0.21519, -0.468354, 0.21519, -0.443038, 0.21519, -0.417722, 0.21519, 
-0.392405, 0.21519, -0.367089, 0.21519, -0.341772, 0.21519, -0.316456, 0.21519, -0.291139, 0.21519, -0.265823, 0.21519, -0.240506, 0.21519, -0.21519, 0.21519, 
-0.189873, 0.21519, -0.164557, 0.21519, -0.13924, 0.21519, -0.113924, 0.21519, -0.088608, 0.21519, -0.063291, 0.21519, -0.037975, 0.21519, -0.012658, 0.21519, 
0.012658, 0.21519, 0.037975, 0.21519, 0.063291, 0.21519, 0.088608, 0.21519, 0.113924, 0.21519, 0.13924, 0.21519, 0.164557, 0.21519, 0.189873, 0.21519, 
0.21519, 0.21519, 0.240506, 0.21519, 0.265823, 0.21519, 0.291139, 0.21519, 0.316456, 0.21519, 0.341772, 0.21519, 0.367089, 0.21519, 0.392405, 0.21519, 
0.417722, 0.21519, 0.443038, 0.21519, 0.468354, 0.21519, 0.493671, 0.21519, 0.518987, 0.21519, 0.544304, 0.21519, 0.56962, 0.21519, 0.594937, 0.21519, 
0.620253, 0.21519, 0.64557, 0.21519, 0.670886, 0.21519, 0.696203, 0.21519, 0.721519, 0.21519, 0.746835, 0.21519, 0.772152, 0.21519, 0.797468, 0.21519, 
0.822785, 0.21519, 0.848101, 0.21519, 0.873418, 0.21519, 0.898734, 0.21519, 0.924051, 0.21519, 0.949367, 0.21519, 0.974684, 0.21519, 1.0, 0.21519, 
-1.0, 0.240506, -0.974684, 0.240506, -0.949367, 0.240506, -0.924051, 0.240506, -0.898734, 0.240506, -0.873418, 0.240506, -0.848101, 0.240506, -0.822785, 0.240506, 
-0.797468, 0.240506, -0.772152, 0.240506, -0.746835, 0.240506, -0.721519, 0.240506, -0.696203, 0.240506, -0.670886, 0.240506, -0.64557, 0.240506, -0.620253, 0.240506, 
-0.594937, 0.240506, -0.56962, 0.240506, -0.544304, 0.240506, -0.518987, 0.240506, -0.493671, 0.240506, -0.468354, 0.240506, -0.443038, 0.240506, -0.417722, 0.240506, 
-0.392405, 0.240506, -0.367089, 0.240506, -0.341772, 0.240506, -0.316456, 0.240506, -0.291139, 0.240506, -0.265823, 0.240506, -0.240506, 0.240506, -0.21519, 0.240506, 
-0.189873, 0.240506, -0.164557, 0.240506, -0.13924, 0.240506, -0.113924, 0.240506, -0.088608, 0.240506, -0.063291, 0.240506, -0.037975, 0.240506, -0.012658, 0.240506, 
0.012658, 0.240506, 0.037975, 0.240506, 0.063291, 0.240506, 0.088608, 0.240506, 0.113924, 0.240506, 0.13924, 0.240506, 0.164557, 0.240506, 0.189873, 0.240506, 
0.21519, 0.240506, 0.240506, 0.240506, 0.265823, 0.240506, 0.291139, 0.240506, 0.316456, 0.240506, 0.341772, 0.240506, 0.367089, 0.240506, 0.392405, 0.240506, 
0.417722, 0.240506, 0.443038, 0.240506, 0.468354, 0.240506, 0.493671, 0.240506, 0.518987, 0.240506, 0.544304, 0.240506, 0.56962, 0.240506, 0.594937, 0.240506, 
0.620253, 0.240506, 0.64557, 0.240506, 0.670886, 0.240506, 0.696203, 0.240506, 0.721519, 0.240506, 0.746835, 0.240506, 0.772152, 0.240506, 0.797468, 0.240506, 
0.822785, 0.240506, 0.848101, 0.240506, 0.873418, 0.240506, 0.898734, 0.240506, 0.924051, 0.240506, 0.949367, 0.240506, 0.974684, 0.240506, 1.0, 0.240506, 
-1.0, 0.265823, -0.974684, 0.265823, -0.949367, 0.265823, -0.924051, 0.265823, -0.898734, 0.265823, -0.873418, 0.265823, -0.848101, 0.265823, -0.822785, 0.265823, 
-0.797468, 0.265823, -0.772152, 0.265823, -0.746835, 0.265823, -0.721519, 0.265823, -0.696203, 0.265823, -0.670886, 0.265823, -0.64557, 0.265823, -0.620253, 0.265823, 
-0.594937, 0.265823, -0.56962, 0.265823, -0.544304, 0.265823, -0.518987, 0.265823, -0.493671, 0.265823, -0.468354, 0.265823, -0.443038, 0.265823, -0.417722, 0.265823, 
-0.392405, 0.265823, -0.367089, 0.265823, -0.341772, 0.265823, -0.316456, 0.265823, -0.291139, 0.265823, -0.265823, 0.265823, -0.240506, 0.265823, -0.21519, 0.265823, 
-0.189873, 0.265823, -0.164557, 0.265823, -0.13924, 0.265823, -0.113924, 0.265823, -0.088608, 0.265823, -0.063291, 0.265823, -0.037975, 0.265823, -0.012658, 0.265823, 
0.012658, 0.265823, 0.037975, 0.265823, 0.063291, 0.265823, 0.088608, 0.265823, 0.113924, 0.265823, 0.13924, 0.265823, 0.164557, 0.265823, 0.189873, 0.265823, 
0.21519, 0.265823, 0.240506, 0.265823, 0.265823, 0.265823, 0.291139, 0.265823, 0.316456, 0.265823, 0.341772, 0.265823, 0.367089, 0.265823, 0.392405, 0.265823, 
0.417722, 0.265823, 0.443038, 0.265823, 0.468354, 0.265823, 0.493671, 0.265823, 0.518987, 0.265823, 0.544304, 0.265823, 0.56962, 0.265823, 0.594937, 0.265823, 
0.620253, 0.265823, 0.64557, 0.265823, 0.670886, 0.265823, 0.696203, 0.265823, 0.721519, 0.265823, 0.746835, 0.265823, 0.772152, 0.265823, 0.797468, 0.265823, 
0.822785, 0.265823, 0.848101, 0.265823, 0.873418, 0.265823, 0.898734, 0.265823, 0.924051, 0.265823, 0.949367, 0.265823, 0.974684, 0.265823, 1.0, 0.265823, 
-1.0, 0.291139, -0.974684, 0.291139, -0.949367, 0.291139, -0.924051, 0.291139, -0.898734, 0.291139, -0.873418, 0.291139, -0.848101, 0.291139, -0.822785, 0.291139, 
-0.797468, 0.291139, -0.772152, 0.291139, -0.746835, 0.291139, -0.721519, 0.291139, -0.696203, 0.291139, -0.670886, 0.291139, -0.64557, 0.291139, -0.620253, 0.291139, 
-0.594937, 0.291139, -0.56962, 0.291139, -0.544304, 0.291139, -0.518987, 0.291139, -0.493671, 0.291139, -0.468354, 0.291139, -0.443038, 0.291139, -0.417722, 0.291139, 
-0.392405, 0.291139, -0.367089, 0.291139, -0.341772, 0.291139, -0.316456, 0.291139, -0.291139, 0.291139, -0.265823, 0.291139, -0.240506, 0.291139, -0.21519, 0.291139, 
-0.189873, 0.291139, -0.164557, 0.291139, -0.13924, 0.291139, -0.113924, 0.291139, -0.088608, 0.291139, -0.063291, 0.291139, -0.037975, 0.291139, -0.012658, 0.291139, 
0.012658, 0.291139, 0.037975, 0.291139, 0.063291, 0.291139, 0.088608, 0.291139, 0.113924, 0.291139, 0.13924, 0.291139, 0.164557, 0.291139, 0.189873, 0.291139, 
0.21519, 0.291139, 0.240506, 0.291139, 0.265823, 0.291139, 0.291139, 0.291139, 0.316456, 0.291139, 0.341772, 0.291139, 0.367089, 0.291139, 0.392405, 0.291139, 
0.417722, 0.291139, 0.443038, 0.291139, 0.468354, 0.291139, 0.493671, 0.291139, 0.518987, 0.291139, 0.544304, 0.291139, 0.56962, 0.291139, 0.594937, 0.291139, 
0.620253, 0.291139, 0.64557, 0.291139, 0.670886, 0.291139, 0.696203, 0.291139, 0.721519, 0.291139, 0.746835, 0.291139, 0.772152, 0.291139, 0.797468, 0.291139, 
0.822785, 0.291139, 0.848101, 0.291139, 0.873418, 0.291139, 0.898734, 0.291139, 0.924051, 0.291139, 0.949367, 0.291139, 0.974684, 0.291139, 1.0, 0.291139, 
-1.0, 0.316456, -0.974684, 0.316456, -0.949367, 0.316456, -0.924051, 0.316456, -0.898734, 0.316456, -0.873418, 0.316456, -0.848101, 0.316456, -0.822785, 0.316456, 
-0.797468, 0.316456, -0.772152, 0.316456, -0.746835, 0.316456, -0.721519, 0.316456, -0.696203, 0.316456, -0.670886, 0.316456, -0.64557, 0.316456, -0.620253, 0.316456, 
-0.594937, 0.316456, -0.56962, 0.316456, -0.544304, 0.316456, -0.518987, 0.316456, -0.493671, 0.316456, -0.468354, 0.316456, -0.443038, 0.316456, -0.417722, 0.316456, 
-0.392405, 0.316456, -0.367089, 0.316456, -0.341772, 0.316456, -0.316456, 0.316456, -0.291139, 0.316456, -0.265823, 0.316456, -0.240506, 0.316456, -0.21519, 0.316456, 
-0.189873, 0.316456, -0.164557, 0.316456, -0.13924, 0.316456, -0.113924, 0.316456, -0.088608, 0.316456, -0.063291, 0.316456, -0.037975, 0.316456, -0.012658, 0.316456, 
0.012658, 0.316456, 0.037975, 0.316456, 0.063291, 0.316456, 0.088608, 0.316456, 0.113924, 0.316456, 0.13924, 0.316456, 0.164557, 0.316456, 0.189873, 0.316456, 
0.21519, 0.316456, 0.240506, 0.316456, 0.265823, 0.316456, 0.291139, 0.316456, 0.316456, 0.316456, 0.341772, 0.316456, 0.367089, 0.316456, 0.392405, 0.316456, 
0.417722, 0.316456, 0.443038, 0.316456, 0.468354, 0.316456, 0.493671, 0.316456, 0.518987, 0.316456, 0.544304, 0.316456, 0.56962, 0.316456, 0.594937, 0.316456, 
0.620253, 0.316456, 0.64557, 0.316456, 0.670886, 0.316456, 0.696203, 0.316456, 0.721519, 0.316456, 0.746835, 0.316456, 0.772152, 0.316456, 0.797468, 0.316456, 
0.822785, 0.316456, 0.848101, 0.316456, 0.873418, 0.316456, 0.898734, 0.316456, 0.924051, 0.316456, 0.949367, 0.316456, 0.974684, 0.316456, 1.0, 0.316456, 
-1.0, 0.341772, -0.974684, 0.341772, -0.949367, 0.341772, -0.924051, 0.341772, -0.898734, 0.341772, -0.873418, 0.341772, -0.848101, 0.341772, -0.822785, 0.341772, 
-0.797468, 0.341772, -0.772152, 0.341772, -0.746835, 0.341772, -0.721519, 0.341772, -0.696203, 0.341772, -0.670886, 0.341772, -0.64557, 0.341772, -0.620253, 0.341772, 
-0.594937, 0.341772, -0.56962, 0.341772, -0.544304, 0.341772, -0.518987, 0.341772, -0.493671, 0.341772, -0.468354, 0.341772, -0.443038, 0.341772, -0.417722, 0.341772, 
-0.392405, 0.341772, -0.367089, 0.341772, -0.341772, 0.341772, -0.316456, 0.341772, -0.291139, 0.341772, -0.265823, 0.341772, -0.240506, 0.341772, -0.21519, 0.341772, 
-0.189873, 0.341772, -0.164557, 0.341772, -0.13924, 0.341772, -0.113924, 0.341772, -0.088608, 0.341772, -0.063291, 0.341772, -0.037975, 0.341772, -0.012658, 0.341772, 
0.012658, 0.341772, 0.037975, 0.341772, 0.063291, 0.341772, 0.088608, 0.341772, 0.113924, 0.341772, 0.13924, 0.341772, 0.164557, 0.341772, 0.189873, 0.341772, 
0.21519, 0.341772, 0.240506, 0.341772, 0.265823, 0.341772, 0.291139, 0.341772, 0.316456, 0.341772, 0.341772, 0.341772, 0.367089, 0.341772, 0.392405, 0.341772, 
0.417722, 0.341772, 0.443038, 0.341772, 0.468354, 0.341772, 0.493671, 0.341772, 0.518987, 0.341772, 0.544304, 0.341772, 0.56962, 0.341772, 0.594937, 0.341772, 
0.620253, 0.341772, 0.64557, 0.341772, 0.670886, 0.341772, 0.696203, 0.341772, 0.721519, 0.341772, 0.746835, 0.341772, 0.772152, 0.341772, 0.797468, 0.341772, 
0.822785, 0.341772, 0.848101, 0.341772, 0.873418, 0.341772, 0.898734, 0.341772, 0.924051, 0.341772, 0.949367, 0.341772, 0.974684, 0.341772, 1.0, 0.341772, 
-1.0, 0.367089, -0.974684, 0.367089, -0.949367, 0.367089, -0.924051, 0.367089, -0.898734, 0.367089, -0.873418, 0.367089, -0.848101, 0.367089, -0.822785, 0.367089, 
-0.797468, 0.367089, -0.772152, 0.367089, -0.746835, 0.367089, -0.721519, 0.367089, -0.696203, 0.367089, -0.670886, 0.367089, -0.64557, 0.367089, -0.620253, 0.367089, 
-0.594937, 0.367089, -0.56962, 0.367089, -0.544304, 0.367089, -0.518987, 0.367089, -0.493671, 0.367089, -0.468354, 0.367089, -0.443038, 0.367089, -0.417722, 0.367089, 
-0.392405, 0.367089, -0.367089, 0.367089, -0.341772, 0.367089, -0.316456, 0.367089, -0.291139, 0.367089, -0.265823, 0.367089, -0.240506, 0.367089, -0.21519, 0.367089, 
-0.189873, 0.367089, -0.164557, 0.367089, -0.13924, 0.367089, -0.113924, 0.367089, -0.088608, 0.367089, -0.063291, 0.367089, -0.037975, 0.367089, -0.012658, 0.367089, 
0.012658, 0.367089, 0.037975, 0.367089, 0.063291, 0.367089, 0.088608, 0.367089, 0.113924, 0.367089, 0.13924, 0.367089, 0.164557, 0.367089, 0.189873, 0.367089, 
0.21519, 0.367089, 0.240506, 0.367089, 0.265823, 0.367089, 0.291139, 0.367089, 0.316456, 0.367089, 0.341772, 0.367089, 0.367089, 0.367089, 0.392405, 0.367089, 
0.417722, 0.367089, 0.443038, 0.367089, 0.468354, 0.367089, 0.493671, 0.367089, 0.518987, 0.367089, 0.544304, 0.367089, 0.56962, 0.367089, 0.594937, 0.367089, 
0.620253, 0.367089, 0.64557, 0.367089, 0.670886, 0.367089, 0.696203, 0.367089, 0.721519, 0.367089, 0.746835, 0.367089, 0.772152, 0.367089, 0.797468, 0.367089, 
0.822785, 0.367089, 0.848101, 0.367089, 0.873418, 0.367089, 0.898734, 0.367089, 0.924051, 0.367089, 0.949367, 0.367089, 0.974684, 0.367089, 1.0, 0.367089, 
-1.0, 0.392405, -0.974684, 0.392405, -0.949367, 0.392405, -0.924051, 0.392405, -0.898734, 0.392405, -0.873418, 0.392405, -0.848101, 0.392405, -0.822785, 0.392405, 
-0.797468, 0.392405, -0.772152, 0.392405, -0.746835, 0.392405, -0.721519, 0.392405, -0.696203, 0.392405, -0.670886, 0.392405, -0.64557, 0.392405, -0.620253, 0.392405, 
-0.594937, 0.392405, -0.56962, 0.392405, -0.544304, 0.392405, -0.518987, 0.392405, -0.493671, 0.392405, -0.468354, 0.392405, -0.443038, 0.392405, -0.417722, 0.392405, 
-0.392405, 0.392405, -0.367089, 0.392405, -0.341772, 0.392405, -0.316456, 0.392405, -0.291139, 0.392405, -0.265823, 0.392405, -0.240506, 0.392405, -0.21519, 0.392405, 
-0.189873, 0.392405, -0.164557, 0.392405, -0.13924, 0.392405, -0.113924, 0.392405, -0.088608, 0.392405, -0.063291, 0.392405, -0.037975, 0.392405, -0.012658, 0.392405, 
0.012658, 0.392405, 0.037975, 0.392405, 0.063291, 0.392405, 0.088608, 0.392405, 0.113924, 0.392405, 0.13924, 0.392405, 0.164557, 0.392405, 0.189873, 0.392405, 
0.21519, 0.392405, 0.240506, 0.392405, 0.265823, 0.392405, 0.291139, 0.392405, 0.316456, 0.392405, 0.341772, 0.392405, 0.367089, 0.392405, 0.392405, 0.392405, 
0.417722, 0.392405, 0.443038, 0.392405, 0.468354, 0.392405, 0.493671, 0.392405, 0.518987, 0.392405, 0.544304, 0.392405, 0.56962, 0.392405, 0.594937, 0.392405, 
0.620253, 0.392405, 0.64557, 0.392405, 0.670886, 0.392405, 0.696203, 0.392405, 0.721519, 0.392405, 0.746835, 0.392405, 0.772152, 0.392405, 0.797468, 0.392405, 
0.822785, 0.392405, 0.848101, 0.392405, 0.873418, 0.392405, 0.898734, 0.392405, 0.924051, 0.392405, 0.949367, 0.392405, 0.974684, 0.392405, 1.0, 0.392405, 
-1.0, 0.417722, -0.974684, 0.417722, -0.949367, 0.417722, -0.924051, 0.417722, -0.898734, 0.417722, -0.873418, 0.417722, -0.848101, 0.417722, -0.822785, 0.417722, 
-0.797468, 0.417722, -0.772152, 0.417722, -0.746835, 0.417722, -0.721519, 0.417722, -0.696203, 0.417722, -0.670886, 0.417722, -0.64557, 0.417722, -0.620253, 0.417722, 
-0.594937, 0.417722, -0.56962, 0.417722, -0.544304, 0.417722, -0.518987, 0.417722, -0.493671, 0.417722, -0.468354, 0.417722, -0.443038, 0.417722, -0.417722, 0.417722, 
-0.392405, 0.417722, -0.367089, 0.417722, -0.341772, 0.417722, -0.316456, 0.417722, -0.291139, 0.417722, -0.265823, 0.417722, -0.240506, 0.417722, -0.21519, 0.417722, 
-0.189873, 0.417722, -0.164557, 0.417722, -0.13924, 0.417722, -0.113924, 0.417722, -0.088608, 0.417722, -0.063291, 0.417722, -0.037975, 0.417722, -0.012658, 0.417722, 
0.012658, 0.417722, 0.037975, 0.417722, 0.063291, 0.417722, 0.088608, 0.417722, 0.113924, 0.417722, 0.13924, 0.417722, 0.164557, 0.417722, 0.189873, 0.417722, 
0.21519, 0.417722, 0.240506, 0.417722, 0.265823, 0.417722, 0.291139, 0.417722, 0.316456, 0.417722, 0.341772, 0.417722, 0.367089, 0.417722, 0.392405, 0.417722, 
0.417722, 0.417722, 0.443038, 0.417722, 0.468354, 0.417722, 0.493671, 0.417722, 0.518987, 0.417722, 0.544304, 0.417722, 0.56962, 0.417722, 0.594937, 0.417722, 
0.620253, 0.417722, 0.64557, 0.417722, 0.670886, 0.417722, 0.696203, 0.417722, 0.721519, 0.417722, 0.746835, 0.417722, 0.772152, 0.417722, 0.797468, 0.417722, 
0.822785, 0.417722, 0.848101, 0.417722, 0.873418, 0.417722, 0.898734, 0.417722, 0.924051, 0.417722, 0.949367, 0.417722, 0.974684, 0.417722, 1.0, 0.417722, 
-1.0, 0.443038, -0.974684, 0.443038, -0.949367, 0.443038, -0.924051, 0.443038, -0.898734, 0.443038, -0.873418, 0.443038, -0.848101, 0.443038, -0.822785, 0.443038, 
-0.797468, 0.443038, -0.772152, 0.443038, -0.746835, 0.443038, -0.721519, 0.443038, -0.696203, 0.443038, -0.670886, 0.443038, -0.64557, 0.443038, -0.620253, 0.443038, 
-0.594937, 0.443038, -0.56962, 0.443038, -0.544304, 0.443038, -0.518987, 0.443038, -0.493671, 0.443038, -0.468354, 0.443038, -0.443038, 0.443038, -0.417722, 0.443038, 
-0.392405, 0.443038, -0.367089, 0.443038, -0.341772, 0.443038, -0.316456, 0.443038, -0.291139, 0.443038, -0.265823, 0.443038, -0.240506, 0.443038, -0.21519, 0.443038, 
-0.189873, 0.443038, -0.164557, 0.443038, -0.13924, 0.443038, -0.113924, 0.443038, -0.088608, 0.443038, -0.063291, 0.443038, -0.037975, 0.443038, -0.012658, 0.443038, 
0.012658, 0.443038, 0.037975, 0.443038, 0.063291, 0.443038, 0.088608, 0.443038, 0.113924, 0.443038, 0.13924, 0.443038, 0.164557, 0.443038, 0.189873, 0.443038, 
0.21519, 0.443038, 0.240506, 0.443038, 0.265823, 0.443038, 0.291139, 0.443038, 0.316456, 0.443038, 0.341772, 0.443038, 0.367089, 0.443038, 0.392405, 0.443038, 
0.417722, 0.443038, 0.443038, 0.443038, 0.468354, 0.443038, 0.493671, 0.443038, 0.518987, 0.443038, 0.544304, 0.443038, 0.56962, 0.443038, 0.594937, 0.443038, 
0.620253, 0.443038, 0.64557, 0.443038, 0.670886, 0.443038, 0.696203, 0.443038, 0.721519, 0.443038, 0.746835, 0.443038, 0.772152, 0.443038, 0.797468, 0.443038, 
0.822785, 0.443038, 0.848101, 0.443038, 0.873418, 0.443038, 0.898734, 0.443038, 0.924051, 0.443038, 0.949367, 0.443038, 0.974684, 0.443038, 1.0, 0.443038, 
-1.0, 0.468354, -0.974684, 0.468354, -0.949367, 0.468354, -0.924051, 0.468354, -0.898734, 0.468354, -0.873418, 0.468354, -0.848101, 0.468354, -0.822785, 0.468354, 
-0.797468, 0.468354, -0.772152, 0.468354, -0.746835, 0.468354, -0.721519, 0.468354, -0.696203, 0.468354, -0.670886, 0.468354, -0.64557, 0.468354, -0.620253, 0.468354, 
-0.594937, 0.468354, -0.56962, 0.468354, -0.544304, 0.468354, -0.518987, 0.468354, -0.493671, 0.468354, -0.468354, 0.468354, -0.443038, 0.468354, -0.417722, 0.468354, 
-0.392405, 0.468354, -0.367089, 0.468354, -0.341772, 0.468354, -0.316456, 0.468354, -0.291139, 0.468354, -0.265823, 0.468354, -0.240506, 0.468354, -0.21519, 0.468354, 
-0.189873, 0.468354, -0.164557, 0.468354, -0.13924, 0.468354, -0.113924, 0.468354, -0.088608, 0.468354, -0.063291, 0.468354, -0.037975, 0.468354, -0.012658, 0.468354, 
0.012658, 0.468354, 0.037975, 0.468354, 0.063291, 0.468354, 0.088608, 0.468354, 0.113924, 0.468354, 0.13924, 0.468354, 0.164557, 0.468354, 0.189873, 0.468354, 
0.21519, 0.468354, 0.240506, 0.468354, 0.265823, 0.468354, 0.291139, 0.468354, 0.316456, 0.468354, 0.341772, 0.468354, 0.367089, 0.468354, 0.392405, 0.468354, 
0.417722, 0.468354, 0.443038, 0.468354, 0.468354, 0.468354, 0.493671, 0.468354, 0.518987, 0.468354, 0.544304, 0.468354, 0.56962, 0.468354, 0.594937, 0.468354, 
0.620253, 0.468354, 0.64557, 0.468354, 0.670886, 0.468354, 0.696203, 0.468354, 0.721519, 0.468354, 0.746835, 0.468354, 0.772152, 0.468354, 0.797468, 0.468354, 
0.822785, 0.468354, 0.848101, 0.468354, 0.873418, 0.468354, 0.898734, 0.468354, 0.924051, 0.468354, 0.949367, 0.468354, 0.974684, 0.468354, 1.0, 0.468354, 
-1.0, 0.493671, -0.974684, 0.493671, -0.949367, 0.493671, -0.924051, 0.493671, -0.898734, 0.493671, -0.873418, 0.493671, -0.848101, 0.493671, -0.822785, 0.493671, 
-0.797468, 0.493671, -0.772152, 0.493671, -0.746835, 0.493671, -0.721519, 0.493671, -0.696203, 0.493671, -0.670886, 0.493671, -0.64557, 0.493671, -0.620253, 0.493671, 
-0.594937, 0.493671, -0.56962, 0.493671, -0.544304, 0.493671, -0.518987, 0.493671, -0.493671, 0.493671, -0.468354, 0.493671, -0.443038, 0.493671, -0.417722, 0.493671, 
-0.392405, 0.493671, -0.367089, 0.493671, -0.341772, 0.493671, -0.316456, 0.493671, -0.291139, 0.493671, -0.265823, 0.493671, -0.240506, 0.493671, -0.21519, 0.493671, 
-0.189873, 0.493671, -0.164557, 0.493671, -0.13924, 0.493671, -0.113924, 0.493671, -0.088608, 0.493671, -0.063291, 0.493671, -0.037975, 0.493671, -0.012658, 0.493671, 
0.012658, 0.493671, 0.037975, 0.493671, 0.063291, 0.493671, 0.088608, 0.493671, 0.113924, 0.493671, 0.13924, 0.493671, 0.164557, 0.493671, 0.189873, 0.493671, 
0.21519, 0.493671, 0.240506, 0.493671, 0.265823, 0.493671, 0.291139, 0.493671, 0.316456, 0.493671, 0.341772, 0.493671, 0.367089, 0.493671, 0.392405, 0.493671, 
0.417722, 0.493671, 0.443038, 0.493671, 0.468354, 0.493671, 0.493671, 0.493671, 0.518987, 0.493671, 0.544304, 0.493671, 0.56962, 0.493671, 0.594937, 0.493671, 
0.620253, 0.493671, 0.64557, 0.493671, 0.670886, 0.493671, 0.696203, 0.493671, 0.721519, 0.493671, 0.746835, 0.493671, 0.772152, 0.493671, 0.797468, 0.493671, 
0.822785, 0.493671, 0.848101, 0.493671, 0.873418, 0.493671, 0.898734, 0.493671, 0.924051, 0.493671, 0.949367, 0.493671, 0.974684, 0.493671, 1.0, 0.493671, 
-1.0, 0.518987, -0.974684, 0.518987, -0.949367, 0.518987, -0.924051, 0.518987, -0.898734, 0.518987, -0.873418, 0.518987, -0.848101, 0.518987, -0.822785, 0.518987, 
-0.797468, 0.518987, -0.772152, 0.518987, -0.746835, 0.518987, -0.721519, 0.518987, -0.696203, 0.518987, -0.670886, 0.518987, -0.64557, 0.518987, -0.620253, 0.518987, 
-0.594937, 0.518987, -0.56962, 0.518987, -0.544304, 0.518987, -0.518987, 0.518987, -0.493671, 0.518987, -0.468354, 0.518987, -0.443038, 0.518987, -0.417722, 0.518987, 
-0.392405, 0.518987, -0.367089, 0.518987, -0.341772, 0.518987, -0.316456, 0.518987, -0.291139, 0.518987, -0.265823, 0.518987, -0.240506, 0.518987, -0.21519, 0.518987, 
-0.189873, 0.518987, -0.164557, 0.518987, -0.13924, 0.518987, -0.113924, 0.518987, -0.088608, 0.518987, -0.063291, 0.518987, -0.037975, 0.518987, -0.012658, 0.518987, 
0.012658, 0.518987, 0.037975, 0.518987, 0.063291, 0.518987, 0.088608, 0.518987, 0.113924, 0.518987, 0.13924, 0.518987, 0.164557, 0.518987, 0.189873, 0.518987, 
0.21519, 0.518987, 0.240506, 0.518987, 0.265823, 0.518987, 0.291139, 0.518987, 0.316456, 0.518987, 0.341772, 0.518987, 0.367089, 0.518987, 0.392405, 0.518987, 
0.417722, 0.518987, 0.443038, 0.518987, 0.468354, 0.518987, 0.493671, 0.518987, 0.518987, 0.518987, 0.544304, 0.518987, 0.56962, 0.518987, 0.594937, 0.518987, 
0.620253, 0.518987, 0.64557, 0.518987, 0.670886, 0.518987, 0.696203, 0.518987, 0.721519, 0.518987, 0.746835, 0.518987, 0.772152, 0.518987, 0.797468, 0.518987, 
0.822785, 0.518987, 0.848101, 0.518987, 0.873418, 0.518987, 0.898734, 0.518987, 0.924051, 0.518987, 0.949367, 0.518987, 0.974684, 0.518987, 1.0, 0.518987, 
-1.0, 0.544304, -0.974684, 0.544304, -0.949367, 0.544304, -0.924051, 0.544304, -0.898734, 0.544304, -0.873418, 0.544304, -0.848101, 0.544304, -0.822785, 0.544304, 
-0.797468, 0.544304, -0.772152, 0.544304, -0.746835, 0.544304, -0.721519, 0.544304, -0.696203, 0.544304, -0.670886, 0.544304, -0.64557, 0.544304, -0.620253, 0.544304, 
-0.594937, 0.544304, -0.56962, 0.544304, -0.544304, 0.544304, -0.518987, 0.544304, -0.493671, 0.544304, -0.468354, 0.544304, -0.443038, 0.544304, -0.417722, 0.544304, 
-0.392405, 0.544304, -0.367089, 0.544304, -0.341772, 0.544304, -0.316456, 0.544304, -0.291139, 0.544304, -0.265823, 0.544304, -0.240506, 0.544304, -0.21519, 0.544304, 
-0.189873, 0.544304, -0.164557, 0.544304, -0.13924, 0.544304, -0.113924, 0.544304, -0.088608, 0.544304, -0.063291, 0.544304, -0.037975, 0.544304, -0.012658, 0.544304, 
0.012658, 0.544304, 0.037975, 0.544304, 0.063291, 0.544304, 0.088608, 0.544304, 0.113924, 0.544304, 0.13924, 0.544304, 0.164557, 0.544304, 0.189873, 0.544304, 
0.21519, 0.544304, 0.240506, 0.544304, 0.265823, 0.544304, 0.291139, 0.544304, 0.316456, 0.544304, 0.341772, 0.544304, 0.367089, 0.544304, 0.392405, 0.544304, 
0.417722, 0.544304, 0.443038, 0.544304, 0.468354, 0.544304, 0.493671, 0.544304, 0.518987, 0.544304, 0.544304, 0.544304, 0.56962, 0.544304, 0.594937, 0.544304, 
0.620253, 0.544304, 0.64557, 0.544304, 0.670886, 0.544304, 0.696203, 0.544304, 0.721519, 0.544304, 0.746835, 0.544304, 0.772152, 0.544304, 0.797468, 0.544304, 
0.822785, 0.544304, 0.848101, 0.544304, 0.873418, 0.544304, 0.898734, 0.544304, 0.924051, 0.544304, 0.949367, 0.544304, 0.974684, 0.544304, 1.0, 0.544304, 
-1.0, 0.56962, -0.974684, 0.56962, -0.949367, 0.56962, -0.924051, 0.56962, -0.898734, 0.56962, -0.873418, 0.56962, -0.848101, 0.56962, -0.822785, 0.56962, 
-0.797468, 0.56962, -0.772152, 0.56962, -0.746835, 0.56962, -0.721519, 0.56962, -0.696203, 0.56962, -0.670886, 0.56962, -0.64557, 0.56962, -0.620253, 0.56962, 
-0.594937, 0.56962, -0.56962, 0.56962, -0.544304, 0.56962, -0.518987, 0.56962, -0.493671, 0.56962, -0.468354, 0.56962, -0.443038, 0.56962, -0.417722, 0.56962, 
-0.392405, 0.56962, -0.367089, 0.56962, -0.341772, 0.56962, -0.316456, 0.56962, -0.291139, 0.56962, -0.265823, 0.56962, -0.240506, 0.56962, -0.21519, 0.56962, 
-0.189873, 0.56962, -0.164557, 0.56962, -0.13924, 0.56962, -0.113924, 0.56962, -0.088608, 0.56962, -0.063291, 0.56962, -0.037975, 0.56962, -0.012658, 0.56962, 
0.012658, 0.56962, 0.037975, 0.56962, 0.063291, 0.56962, 0.088608, 0.56962, 0.113924, 0.56962, 0.13924, 0.56962, 0.164557, 0.56962, 0.189873, 0.56962, 
0.21519, 0.56962, 0.240506, 0.56962, 0.265823, 0.56962, 0.291139, 0.56962, 0.316456, 0.56962, 0.341772, 0.56962, 0.367089, 0.56962, 0.392405, 0.56962, 
0.417722, 0.56962, 0.443038, 0.56962, 0.468354, 0.56962, 0.493671, 0.56962, 0.518987, 0.56962, 0.544304, 0.56962, 0.56962, 0.56962, 0.594937, 0.56962, 
0.620253, 0.56962, 0.64557, 0.56962, 0.670886, 0.56962, 0.696203, 0.56962, 0.721519, 0.56962, 0.746835, 0.56962, 0.772152, 0.56962, 0.797468, 0.56962, 
0.822785, 0.56962, 0.848101, 0.56962, 0.873418, 0.56962, 0.898734, 0.56962, 0.924051, 0.56962, 0.949367, 0.56962, 0.974684, 0.56962, 1.0, 0.56962, 
-1.0, 0.594937, -0.974684, 0.594937, -0.949367, 0.594937, -0.924051, 0.594937, -0.898734, 0.594937, -0.873418, 0.594937, -0.848101, 0.594937, -0.822785, 0.594937, 
-0.797468, 0.594937, -0.772152, 0.594937, -0.746835, 0.594937, -0.721519, 0.594937, -0.696203, 0.594937, -0.670886, 0.594937, -0.64557, 0.594937, -0.620253, 0.594937, 
-0.594937, 0.594937, -0.56962, 0.594937, -0.544304, 0.594937, -0.518987, 0.594937, -0.493671, 0.594937, -0.468354, 0.594937, -0.443038, 0.594937, -0.417722, 0.594937, 
-0.392405, 0.594937, -0.367089, 0.594937, -0.341772, 0.594937, -0.316456, 0.594937, -0.291139, 0.594937, -0.265823, 0.594937, -0.240506, 0.594937, -0.21519, 0.594937, 
-0.189873, 0.594937, -0.164557, 0.594937, -0.13924, 0.594937, -0.113924, 0.594937, -0.088608, 0.594937, -0.063291, 0.594937, -0.037975, 0.594937, -0.012658, 0.594937, 
0.012658, 0.594937, 0.037975, 0.594937, 0.063291, 0.594937, 0.088608, 0.594937, 0.113924, 0.594937, 0.13924, 0.594937, 0.164557, 0.594937, 0.189873, 0.594937, 
0.21519, 0.594937, 0.240506, 0.594937, 0.265823, 0.594937, 0.291139, 0.594937, 0.316456, 0.594937, 0.341772, 0.594937, 0.367089, 0.594937, 0.392405, 0.594937, 
0.417722, 0.594937, 0.443038, 0.594937, 0.468354, 0.594937, 0.493671, 0.594937, 0.518987, 0.594937, 0.544304, 0.594937, 0.56962, 0.594937, 0.594937, 0.594937, 
0.620253, 0.594937, 0.64557, 0.594937, 0.670886, 0.594937, 0.696203, 0.594937, 0.721519, 0.594937, 0.746835, 0.594937, 0.772152, 0.594937, 0.797468, 0.594937, 
0.822785, 0.594937, 0.848101, 0.594937, 0.873418, 0.594937, 0.898734, 0.594937, 0.924051, 0.594937, 0.949367, 0.594937, 0.974684, 0.594937, 1.0, 0.594937, 
-1.0, 0.620253, -0.974684, 0.620253, -0.949367, 0.620253, -0.924051, 0.620253, -0.898734, 0.620253, -0.873418, 0.620253, -0.848101, 0.620253, -0.822785, 0.620253, 
-0.797468, 0.620253, -0.772152, 0.620253, -0.746835, 0.620253, -0.721519, 0.620253, -0.696203, 0.620253, -0.670886, 0.620253, -0.64557, 0.620253, -0.620253, 0.620253, 
-0.594937, 0.620253, -0.56962, 0.620253, -0.544304, 0.620253, -0.518987, 0.620253, -0.493671, 0.620253, -0.468354, 0.620253, -0.443038, 0.620253, -0.417722, 0.620253, 
-0.392405, 0.620253, -0.367089, 0.620253, -0.341772, 0.620253, -0.316456, 0.620253, -0.291139, 0.620253, -0.265823, 0.620253, -0.240506, 0.620253, -0.21519, 0.620253, 
-0.189873, 0.620253, -0.164557, 0.620253, -0.13924, 0.620253, -0.113924, 0.620253, -0.088608, 0.620253, -0.063291, 0.620253, -0.037975, 0.620253, -0.012658, 0.620253, 
0.012658, 0.620253, 0.037975, 0.620253, 0.063291, 0.620253, 0.088608, 0.620253, 0.113924, 0.620253, 0.13924, 0.620253, 0.164557, 0.620253, 0.189873, 0.620253, 
0.21519, 0.620253, 0.240506, 0.620253, 0.265823, 0.620253, 0.291139, 0.620253, 0.316456, 0.620253, 0.341772, 0.620253, 0.367089, 0.620253, 0.392405, 0.620253, 
0.417722, 0.620253, 0.443038, 0.620253, 0.468354, 0.620253, 0.493671, 0.620253, 0.518987, 0.620253, 0.544304, 0.620253, 0.56962, 0.620253, 0.594937, 0.620253, 
0.620253, 0.620253, 0.64557, 0.620253, 0.670886, 0.620253, 0.696203, 0.620253, 0.721519, 0.620253, 0.746835, 0.620253, 0.772152, 0.620253, 0.797468, 0.620253, 
0.822785, 0.620253, 0.848101, 0.620253, 0.873418, 0.620253, 0.898734, 0.620253, 0.924051, 0.620253, 0.949367, 0.620253, 0.974684, 0.620253, 1.0, 0.620253, 
-1.0, 0.64557, -0.974684, 0.64557, -0.949367, 0.64557, -0.924051, 0.64557, -0.898734, 0.64557, -0.873418, 0.64557, -0.848101, 0.64557, -0.822785, 0.64557, 
-0.797468, 0.64557, -0.772152, 0.64557, -0.746835, 0.64557, -0.721519, 0.64557, -0.696203, 0.64557, -0.670886, 0.64557, -0.64557, 0.64557, -0.620253, 0.64557, 
-0.594937, 0.64557, -0.56962, 0.64557, -0.544304, 0.64557, -0.518987, 0.64557, -0.493671, 0.64557, -0.468354, 0.64557, -0.443038, 0.64557, -0.417722, 0.64557, 
-0.392405, 0.64557, -0.367089, 0.64557, -0.341772, 0.64557, -0.316456, 0.64557, -0.291139, 0.64557, -0.265823, 0.64557, -0.240506, 0.64557, -0.21519, 0.64557, 
-0.189873, 0.64557, -0.164557, 0.64557, -0.13924, 0.64557, -0.113924, 0.64557, -0.088608, 0.64557, -0.063291, 0.64557, -0.037975, 0.64557, -0.012658, 0.64557, 
0.012658, 0.64557, 0.037975, 0.64557, 0.063291, 0.64557, 0.088608, 0.64557, 0.113924, 0.64557, 0.13924, 0.64557, 0.164557, 0.64557, 0.189873, 0.64557, 
0.21519, 0.64557, 0.240506, 0.64557, 0.265823, 0.64557, 0.291139, 0.64557, 0.316456, 0.64557, 0.341772, 0.64557, 0.367089, 0.64557, 0.392405, 0.64557, 
0.417722, 0.64557, 0.443038, 0.64557, 0.468354, 0.64557, 0.493671, 0.64557, 0.518987, 0.64557, 0.544304, 0.64557, 0.56962, 0.64557, 0.594937, 0.64557, 
0.620253, 0.64557, 0.64557, 0.64557, 0.670886, 0.64557, 0.696203, 0.64557, 0.721519, 0.64557, 0.746835, 0.64557, 0.772152, 0.64557, 0.797468, 0.64557, 
0.822785, 0.64557, 0.848101, 0.64557, 0.873418, 0.64557, 0.898734, 0.64557, 0.924051, 0.64557, 0.949367, 0.64557, 0.974684, 0.64557, 1.0, 0.64557, 
-1.0, 0.670886, -0.974684, 0.670886, -0.949367, 0.670886, -0.924051, 0.670886, -0.898734, 0.670886, -0.873418, 0.670886, -0.848101, 0.670886, -0.822785, 0.670886, 
-0.797468, 0.670886, -0.772152, 0.670886, -0.746835, 0.670886, -0.721519, 0.670886, -0.696203, 0.670886, -0.670886, 0.670886, -0.64557, 0.670886, -0.620253, 0.670886, 
-0.594937, 0.670886, -0.56962, 0.670886, -0.544304, 0.670886, -0.518987, 0.670886, -0.493671, 0.670886, -0.468354, 0.670886, -0.443038, 0.670886, -0.417722, 0.670886, 
-0.392405, 0.670886, -0.367089, 0.670886, -0.341772, 0.670886, -0.316456, 0.670886, -0.291139, 0.670886, -0.265823, 0.670886, -0.240506, 0.670886, -0.21519, 0.670886, 
-0.189873, 0.670886, -0.164557, 0.670886, -0.13924, 0.670886, -0.113924, 0.670886, -0.088608, 0.670886, -0.063291, 0.670886, -0.037975, 0.670886, -0.012658, 0.670886, 
0.012658, 0.670886, 0.037975, 0.670886, 0.063291, 0.670886, 0.088608, 0.670886, 0.113924, 0.670886, 0.13924, 0.670886, 0.164557, 0.670886, 0.189873, 0.670886, 
0.21519, 0.670886, 0.240506, 0.670886, 0.265823, 0.670886, 0.291139, 0.670886, 0.316456, 0.670886, 0.341772, 0.670886, 0.367089, 0.670886, 0.392405, 0.670886, 
0.417722, 0.670886, 0.443038, 0.670886, 0.468354, 0.670886, 0.493671, 0.670886, 0.518987, 0.670886, 0.544304, 0.670886, 0.56962, 0.670886, 0.594937, 0.670886, 
0.620253, 0.670886, 0.64557, 0.670886, 0.670886, 0.670886, 0.696203, 0.670886, 0.721519, 0.670886, 0.746835, 0.670886, 0.772152, 0.670886, 0.797468, 0.670886, 
0.822785, 0.670886, 0.848101, 0.670886, 0.873418, 0.670886, 0.898734, 0.670886, 0.924051, 0.670886, 0.949367, 0.670886, 0.974684, 0.670886, 1.0, 0.670886, 
-1.0, 0.696203, -0.974684, 0.696203, -0.949367, 0.696203, -0.924051, 0.696203, -0.898734, 0.696203, -0.873418, 0.696203, -0.848101, 0.696203, -0.822785, 0.696203, 
-0.797468, 0.696203, -0.772152, 0.696203, -0.746835, 0.696203, -0.721519, 0.696203, -0.696203, 0.696203, -0.670886, 0.696203, -0.64557, 0.696203, -0.620253, 0.696203, 
-0.594937, 0.696203, -0.56962, 0.696203, -0.544304, 0.696203, -0.518987, 0.696203, -0.493671, 0.696203, -0.468354, 0.696203, -0.443038, 0.696203, -0.417722, 0.696203, 
-0.392405, 0.696203, -0.367089, 0.696203, -0.341772, 0.696203, -0.316456, 0.696203, -0.291139, 0.696203, -0.265823, 0.696203, -0.240506, 0.696203, -0.21519, 0.696203, 
-0.189873, 0.696203, -0.164557, 0.696203, -0.13924, 0.696203, -0.113924, 0.696203, -0.088608, 0.696203, -0.063291, 0.696203, -0.037975, 0.696203, -0.012658, 0.696203, 
0.012658, 0.696203, 0.037975, 0.696203, 0.063291, 0.696203, 0.088608, 0.696203, 0.113924, 0.696203, 0.13924, 0.696203, 0.164557, 0.696203, 0.189873, 0.696203, 
0.21519, 0.696203, 0.240506, 0.696203, 0.265823, 0.696203, 0.291139, 0.696203, 0.316456, 0.696203, 0.341772, 0.696203, 0.367089, 0.696203, 0.392405, 0.696203, 
0.417722, 0.696203, 0.443038, 0.696203, 0.468354, 0.696203, 0.493671, 0.696203, 0.518987, 0.696203, 0.544304, 0.696203, 0.56962, 0.696203, 0.594937, 0.696203, 
0.620253, 0.696203, 0.64557, 0.696203, 0.670886, 0.696203, 0.696203, 0.696203, 0.721519, 0.696203, 0.746835, 0.696203, 0.772152, 0.696203, 0.797468, 0.696203, 
0.822785, 0.696203, 0.848101, 0.696203, 0.873418, 0.696203, 0.898734, 0.696203, 0.924051, 0.696203, 0.949367, 0.696203, 0.974684, 0.696203, 1.0, 0.696203, 
-1.0, 0.721519, -0.974684, 0.721519, -0.949367, 0.721519, -0.924051, 0.721519, -0.898734, 0.721519, -0.873418, 0.721519, -0.848101, 0.721519, -0.822785, 0.721519, 
-0.797468, 0.721519, -0.772152, 0.721519, -0.746835, 0.721519, -0.721519, 0.721519, -0.696203, 0.721519, -0.670886, 0.721519, -0.64557, 0.721519, -0.620253, 0.721519, 
-0.594937, 0.721519, -0.56962, 0.721519, -0.544304, 0.721519, -0.518987, 0.721519, -0.493671, 0.721519, -0.468354, 0.721519, -0.443038, 0.721519, -0.417722, 0.721519, 
-0.392405, 0.721519, -0.367089, 0.721519, -0.341772, 0.721519, -0.316456, 0.721519, -0.291139, 0.721519, -0.265823, 0.721519, -0.240506, 0.721519, -0.21519, 0.721519, 
-0.189873, 0.721519, -0.164557, 0.721519, -0.13924, 0.721519, -0.113924, 0.721519, -0.088608, 0.721519, -0.063291, 0.721519, -0.037975, 0.721519, -0.012658, 0.721519, 
0.012658, 0.721519, 0.037975, 0.721519, 0.063291, 0.721519, 0.088608, 0.721519, 0.113924, 0.721519, 0.13924, 0.721519, 0.164557, 0.721519, 0.189873, 0.721519, 
0.21519, 0.721519, 0.240506, 0.721519, 0.265823, 0.721519, 0.291139, 0.721519, 0.316456, 0.721519, 0.341772, 0.721519, 0.367089, 0.721519, 0.392405, 0.721519, 
0.417722, 0.721519, 0.443038, 0.721519, 0.468354, 0.721519, 0.493671, 0.721519, 0.518987, 0.721519, 0.544304, 0.721519, 0.56962, 0.721519, 0.594937, 0.721519, 
0.620253, 0.721519, 0.64557, 0.721519, 0.670886, 0.721519, 0.696203, 0.721519, 0.721519, 0.721519, 0.746835, 0.721519, 0.772152, 0.721519, 0.797468, 0.721519, 
0.822785, 0.721519, 0.848101, 0.721519, 0.873418, 0.721519, 0.898734, 0.721519, 0.924051, 0.721519, 0.949367, 0.721519, 0.974684, 0.721519, 1.0, 0.721519, 
-1.0, 0.746835, -0.974684, 0.746835, -0.949367, 0.746835, -0.924051, 0.746835, -0.898734, 0.746835, -0.873418, 0.746835, -0.848101, 0.746835, -0.822785, 0.746835, 
-0.797468, 0.746835, -0.772152, 0.746835, -0.746835, 0.746835, -0.721519, 0.746835, -0.696203, 0.746835, -0.670886, 0.746835, -0.64557, 0.746835, -0.620253, 0.746835, 
-0.594937, 0.746835, -0.56962, 0.746835, -0.544304, 0.746835, -0.518987, 0.746835, -0.493671, 0.746835, -0.468354, 0.746835, -0.443038, 0.746835, -0.417722, 0.746835, 
-0.392405, 0.746835, -0.367089, 0.746835, -0.341772, 0.746835, -0.316456, 0.746835, -0.291139, 0.746835, -0.265823, 0.746835, -0.240506, 0.746835, -0.21519, 0.746835, 
-0.189873, 0.746835, -0.164557, 0.746835, -0.13924, 0.746835, -0.113924, 0.746835, -0.088608, 0.746835, -0.063291, 0.746835, -0.037975, 0.746835, -0.012658, 0.746835, 
0.012658, 0.746835, 0.037975, 0.746835, 0.063291, 0.746835, 0.088608, 0.746835, 0.113924, 0.746835, 0.13924, 0.746835, 0.164557, 0.746835, 0.189873, 0.746835, 
0.21519, 0.746835, 0.240506, 0.746835, 0.265823, 0.746835, 0.291139, 0.746835, 0.316456, 0.746835, 0.341772, 0.746835, 0.367089, 0.746835, 0.392405, 0.746835, 
0.417722, 0.746835, 0.443038, 0.746835, 0.468354, 0.746835, 0.493671, 0.746835, 0.518987, 0.746835, 0.544304, 0.746835, 0.56962, 0.746835, 0.594937, 0.746835, 
0.620253, 0.746835, 0.64557, 0.746835, 0.670886, 0.746835, 0.696203, 0.746835, 0.721519, 0.746835, 0.746835, 0.746835, 0.772152, 0.746835, 0.797468, 0.746835, 
0.822785, 0.746835, 0.848101, 0.746835, 0.873418, 0.746835, 0.898734, 0.746835, 0.924051, 0.746835, 0.949367, 0.746835, 0.974684, 0.746835, 1.0, 0.746835, 
-1.0, 0.772152, -0.974684, 0.772152, -0.949367, 0.772152, -0.924051, 0.772152, -0.898734, 0.772152, -0.873418, 0.772152, -0.848101, 0.772152, -0.822785, 0.772152, 
-0.797468, 0.772152, -0.772152, 0.772152, -0.746835, 0.772152, -0.721519, 0.772152, -0.696203, 0.772152, -0.670886, 0.772152, -0.64557, 0.772152, -0.620253, 0.772152, 
-0.594937, 0.772152, -0.56962, 0.772152, -0.544304, 0.772152, -0.518987, 0.772152, -0.493671, 0.772152, -0.468354, 0.772152, -0.443038, 0.772152, -0.417722, 0.772152, 
-0.392405, 0.772152, -0.367089, 0.772152, -0.341772, 0.772152, -0.316456, 0.772152, -0.291139, 0.772152, -0.265823, 0.772152, -0.240506, 0.772152, -0.21519, 0.772152, 
-0.189873, 0.772152, -0.164557, 0.772152, -0.13924, 0.772152, -0.113924, 0.772152, -0.088608, 0.772152, -0.063291, 0.772152, -0.037975, 0.772152, -0.012658, 0.772152, 
0.012658, 0.772152, 0.037975, 0.772152, 0.063291, 0.772152, 0.088608, 0.772152, 0.113924, 0.772152, 0.13924, 0.772152, 0.164557, 0.772152, 0.189873, 0.772152, 
0.21519, 0.772152, 0.240506, 0.772152, 0.265823, 0.772152, 0.291139, 0.772152, 0.316456, 0.772152, 0.341772, 0.772152, 0.367089, 0.772152, 0.392405, 0.772152, 
0.417722, 0.772152, 0.443038, 0.772152, 0.468354, 0.772152, 0.493671, 0.772152, 0.518987, 0.772152, 0.544304, 0.772152, 0.56962, 0.772152, 0.594937, 0.772152, 
0.620253, 0.772152, 0.64557, 0.772152, 0.670886, 0.772152, 0.696203, 0.772152, 0.721519, 0.772152, 0.746835, 0.772152, 0.772152, 0.772152, 0.797468, 0.772152, 
0.822785, 0.772152, 0.848101, 0.772152, 0.873418, 0.772152, 0.898734, 0.772152, 0.924051, 0.772152, 0.949367, 0.772152, 0.974684, 0.772152, 1.0, 0.772152, 
-1.0, 0.797468, -0.974684, 0.797468, -0.949367, 0.797468, -0.924051, 0.797468, -0.898734, 0.797468, -0.873418, 0.797468, -0.848101, 0.797468, -0.822785, 0.797468, 
-0.797468, 0.797468, -0.772152, 0.797468, -0.746835, 0.797468, -0.721519, 0.797468, -0.696203, 0.797468, -0.670886, 0.797468, -0.64557, 0.797468, -0.620253, 0.797468, 
-0.594937, 0.797468, -0.56962, 0.797468, -0.544304, 0.797468, -0.518987, 0.797468, -0.493671, 0.797468, -0.468354, 0.797468, -0.443038, 0.797468, -0.417722, 0.797468, 
-0.392405, 0.797468, -0.367089, 0.797468, -0.341772, 0.797468, -0.316456, 0.797468, -0.291139, 0.797468, -0.265823, 0.797468, -0.240506, 0.797468, -0.21519, 0.797468, 
-0.189873, 0.797468, -0.164557, 0.797468, -0.13924, 0.797468, -0.113924, 0.797468, -0.088608, 0.797468, -0.063291, 0.797468, -0.037975, 0.797468, -0.012658, 0.797468, 
0.012658, 0.797468, 0.037975, 0.797468, 0.063291, 0.797468, 0.088608, 0.797468, 0.113924, 0.797468, 0.13924, 0.797468, 0.164557, 0.797468, 0.189873, 0.797468, 
0.21519, 0.797468, 0.240506, 0.797468, 0.265823, 0.797468, 0.291139, 0.797468, 0.316456, 0.797468, 0.341772, 0.797468, 0.367089, 0.797468, 0.392405, 0.797468, 
0.417722, 0.797468, 0.443038, 0.797468, 0.468354, 0.797468, 0.493671, 0.797468, 0.518987, 0.797468, 0.544304, 0.797468, 0.56962, 0.797468, 0.594937, 0.797468, 
0.620253, 0.797468, 0.64557, 0.797468, 0.670886, 0.797468, 0.696203, 0.797468, 0.721519, 0.797468, 0.746835, 0.797468, 0.772152, 0.797468, 0.797468, 0.797468, 
0.822785, 0.797468, 0.848101, 0.797468, 0.873418, 0.797468, 0.898734, 0.797468, 0.924051, 0.797468, 0.949367, 0.797468, 0.974684, 0.797468, 1.0, 0.797468, 
-1.0, 0.822785, -0.974684, 0.822785, -0.949367, 0.822785, -0.924051, 0.822785, -0.898734, 0.822785, -0.873418, 0.822785, -0.848101, 0.822785, -0.822785, 0.822785, 
-0.797468, 0.822785, -0.772152, 0.822785, -0.746835, 0.822785, -0.721519, 0.822785, -0.696203, 0.822785, -0.670886, 0.822785, -0.64557, 0.822785, -0.620253, 0.822785, 
-0.594937, 0.822785, -0.56962, 0.822785, -0.544304, 0.822785, -0.518987, 0.822785, -0.493671, 0.822785, -0.468354, 0.822785, -0.443038, 0.822785, -0.417722, 0.822785, 
-0.392405, 0.822785, -0.367089, 0.822785, -0.341772, 0.822785, -0.316456, 0.822785, -0.291139, 0.822785, -0.265823, 0.822785, -0.240506, 0.822785, -0.21519, 0.822785, 
-0.189873, 0.822785, -0.164557, 0.822785, -0.13924, 0.822785, -0.113924, 0.822785, -0.088608, 0.822785, -0.063291, 0.822785, -0.037975, 0.822785, -0.012658, 0.822785, 
0.012658, 0.822785, 0.037975, 0.822785, 0.063291, 0.822785, 0.088608, 0.822785, 0.113924, 0.822785, 0.13924, 0.822785, 0.164557, 0.822785, 0.189873, 0.822785, 
0.21519, 0.822785, 0.240506, 0.822785, 0.265823, 0.822785, 0.291139, 0.822785, 0.316456, 0.822785, 0.341772, 0.822785, 0.367089, 0.822785, 0.392405, 0.822785, 
0.417722, 0.822785, 0.443038, 0.822785, 0.468354, 0.822785, 0.493671, 0.822785, 0.518987, 0.822785, 0.544304, 0.822785, 0.56962, 0.822785, 0.594937, 0.822785, 
0.620253, 0.822785, 0.64557, 0.822785, 0.670886, 0.822785, 0.696203, 0.822785, 0.721519, 0.822785, 0.746835, 0.822785, 0.772152, 0.822785, 0.797468, 0.822785, 
0.822785, 0.822785, 0.848101, 0.822785, 0.873418, 0.822785, 0.898734, 0.822785, 0.924051, 0.822785, 0.949367, 0.822785, 0.974684, 0.822785, 1.0, 0.822785, 
-1.0, 0.848101, -0.974684, 0.848101, -0.949367, 0.848101, -0.924051, 0.848101, -0.898734, 0.848101, -0.873418, 0.848101, -0.848101, 0.848101, -0.822785, 0.848101, 
-0.797468, 0.848101, -0.772152, 0.848101, -0.746835, 0.848101, -0.721519, 0.848101, -0.696203, 0.848101, -0.670886, 0.848101, -0.64557, 0.848101, -0.620253, 0.848101, 
-0.594937, 0.848101, -0.56962, 0.848101, -0.544304, 0.848101, -0.518987, 0.848101, -0.493671, 0.848101, -0.468354, 0.848101, -0.443038, 0.848101, -0.417722, 0.848101, 
-0.392405, 0.848101, -0.367089, 0.848101, -0.341772, 0.848101, -0.316456, 0.848101, -0.291139, 0.848101, -0.265823, 0.848101, -0.240506, 0.848101, -0.21519, 0.848101, 
-0.189873, 0.848101, -0.164557, 0.848101, -0.13924, 0.848101, -0.113924, 0.848101, -0.088608, 0.848101, -0.063291, 0.848101, -0.037975, 0.848101, -0.012658, 0.848101, 
0.012658, 0.848101, 0.037975, 0.848101, 0.063291, 0.848101, 0.088608, 0.848101, 0.113924, 0.848101, 0.13924, 0.848101, 0.164557, 0.848101, 0.189873, 0.848101, 
0.21519, 0.848101, 0.240506, 0.848101, 0.265823, 0.848101, 0.291139, 0.848101, 0.316456, 0.848101, 0.341772, 0.848101, 0.367089, 0.848101, 0.392405, 0.848101, 
0.417722, 0.848101, 0.443038, 0.848101, 0.468354, 0.848101, 0.493671, 0.848101, 0.518987, 0.848101, 0.544304, 0.848101, 0.56962, 0.848101, 0.594937, 0.848101, 
0.620253, 0.848101, 0.64557, 0.848101, 0.670886, 0.848101, 0.696203, 0.848101, 0.721519, 0.848101, 0.746835, 0.848101, 0.772152, 0.848101, 0.797468, 0.848101, 
0.822785, 0.848101, 0.848101, 0.848101, 0.873418, 0.848101, 0.898734, 0.848101, 0.924051, 0.848101, 0.949367, 0.848101, 0.974684, 0.848101, 1.0, 0.848101, 
-1.0, 0.873418, -0.974684, 0.873418, -0.949367, 0.873418, -0.924051, 0.873418, -0.898734, 0.873418, -0.873418, 0.873418, -0.848101, 0.873418, -0.822785, 0.873418, 
-0.797468, 0.873418, -0.772152, 0.873418, -0.746835, 0.873418, -0.721519, 0.873418, -0.696203, 0.873418, -0.670886, 0.873418, -0.64557, 0.873418, -0.620253, 0.873418, 
-0.594937, 0.873418, -0.56962, 0.873418, -0.544304, 0.873418, -0.518987, 0.873418, -0.493671, 0.873418, -0.468354, 0.873418, -0.443038, 0.873418, -0.417722, 0.873418, 
-0.392405, 0.873418, -0.367089, 0.873418, -0.341772, 0.873418, -0.316456, 0.873418, -0.291139, 0.873418, -0.265823, 0.873418, -0.240506, 0.873418, -0.21519, 0.873418, 
-0.189873, 0.873418, -0.164557, 0.873418, -0.13924, 0.873418, -0.113924, 0.873418, -0.088608, 0.873418, -0.063291, 0.873418, -0.037975, 0.873418, -0.012658, 0.873418, 
0.012658, 0.873418, 0.037975, 0.873418, 0.063291, 0.873418, 0.088608, 0.873418, 0.113924, 0.873418, 0.13924, 0.873418, 0.164557, 0.873418, 0.189873, 0.873418, 
0.21519, 0.873418, 0.240506, 0.873418, 0.265823, 0.873418, 0.291139, 0.873418, 0.316456, 0.873418, 0.341772, 0.873418, 0.367089, 0.873418, 0.392405, 0.873418, 
0.417722, 0.873418, 0.443038, 0.873418, 0.468354, 0.873418, 0.493671, 0.873418, 0.518987, 0.873418, 0.544304, 0.873418, 0.56962, 0.873418, 0.594937, 0.873418, 
0.620253, 0.873418, 0.64557, 0.873418, 0.670886, 0.873418, 0.696203, 0.873418, 0.721519, 0.873418, 0.746835, 0.873418, 0.772152, 0.873418, 0.797468, 0.873418, 
0.822785, 0.873418, 0.848101, 0.873418, 0.873418, 0.873418, 0.898734, 0.873418, 0.924051, 0.873418, 0.949367, 0.873418, 0.974684, 0.873418, 1.0, 0.873418, 
-1.0, 0.898734, -0.974684, 0.898734, -0.949367, 0.898734, -0.924051, 0.898734, -0.898734, 0.898734, -0.873418, 0.898734, -0.848101, 0.898734, -0.822785, 0.898734, 
-0.797468, 0.898734, -0.772152, 0.898734, -0.746835, 0.898734, -0.721519, 0.898734, -0.696203, 0.898734, -0.670886, 0.898734, -0.64557, 0.898734, -0.620253, 0.898734, 
-0.594937, 0.898734, -0.56962, 0.898734, -0.544304, 0.898734, -0.518987, 0.898734, -0.493671, 0.898734, -0.468354, 0.898734, -0.443038, 0.898734, -0.417722, 0.898734, 
-0.392405, 0.898734, -0.367089, 0.898734, -0.341772, 0.898734, -0.316456, 0.898734, -0.291139, 0.898734, -0.265823, 0.898734, -0.240506, 0.898734, -0.21519, 0.898734, 
-0.189873, 0.898734, -0.164557, 0.898734, -0.13924, 0.898734, -0.113924, 0.898734, -0.088608, 0.898734, -0.063291, 0.898734, -0.037975, 0.898734, -0.012658, 0.898734, 
0.012658, 0.898734, 0.037975, 0.898734, 0.063291, 0.898734, 0.088608, 0.898734, 0.113924, 0.898734, 0.13924, 0.898734, 0.164557, 0.898734, 0.189873, 0.898734, 
0.21519, 0.898734, 0.240506, 0.898734, 0.265823, 0.898734, 0.291139, 0.898734, 0.316456, 0.898734, 0.341772, 0.898734, 0.367089, 0.898734, 0.392405, 0.898734, 
0.417722, 0.898734, 0.443038, 0.898734, 0.468354, 0.898734, 0.493671, 0.898734, 0.518987, 0.898734, 0.544304, 0.898734, 0.56962, 0.898734, 0.594937, 0.898734, 
0.620253, 0.898734, 0.64557, 0.898734, 0.670886, 0.898734, 0.696203, 0.898734, 0.721519, 0.898734, 0.746835, 0.898734, 0.772152, 0.898734, 0.797468, 0.898734, 
0.822785, 0.898734, 0.848101, 0.898734, 0.873418, 0.898734, 0.898734, 0.898734, 0.924051, 0.898734, 0.949367, 0.898734, 0.974684, 0.898734, 1.0, 0.898734, 
-1.0, 0.924051, -0.974684, 0.924051, -0.949367, 0.924051, -0.924051, 0.924051, -0.898734, 0.924051, -0.873418, 0.924051, -0.848101, 0.924051, -0.822785, 0.924051, 
-0.797468, 0.924051, -0.772152, 0.924051, -0.746835, 0.924051, -0.721519, 0.924051, -0.696203, 0.924051, -0.670886, 0.924051, -0.64557, 0.924051, -0.620253, 0.924051, 
-0.594937, 0.924051, -0.56962, 0.924051, -0.544304, 0.924051, -0.518987, 0.924051, -0.493671, 0.924051, -0.468354, 0.924051, -0.443038, 0.924051, -0.417722, 0.924051, 
-0.392405, 0.924051, -0.367089, 0.924051, -0.341772, 0.924051, -0.316456, 0.924051, -0.291139, 0.924051, -0.265823, 0.924051, -0.240506, 0.924051, -0.21519, 0.924051, 
-0.189873, 0.924051, -0.164557, 0.924051, -0.13924, 0.924051, -0.113924, 0.924051, -0.088608, 0.924051, -0.063291, 0.924051, -0.037975, 0.924051, -0.012658, 0.924051, 
0.012658, 0.924051, 0.037975, 0.924051, 0.063291, 0.924051, 0.088608, 0.924051, 0.113924, 0.924051, 0.13924, 0.924051, 0.164557, 0.924051, 0.189873, 0.924051, 
0.21519, 0.924051, 0.240506, 0.924051, 0.265823, 0.924051, 0.291139, 0.924051, 0.316456, 0.924051, 0.341772, 0.924051, 0.367089, 0.924051, 0.392405, 0.924051, 
0.417722, 0.924051, 0.443038, 0.924051, 0.468354, 0.924051, 0.493671, 0.924051, 0.518987, 0.924051, 0.544304, 0.924051, 0.56962, 0.924051, 0.594937, 0.924051, 
0.620253, 0.924051, 0.64557, 0.924051, 0.670886, 0.924051, 0.696203, 0.924051, 0.721519, 0.924051, 0.746835, 0.924051, 0.772152, 0.924051, 0.797468, 0.924051, 
0.822785, 0.924051, 0.848101, 0.924051, 0.873418, 0.924051, 0.898734, 0.924051, 0.924051, 0.924051, 0.949367, 0.924051, 0.974684, 0.924051, 1.0, 0.924051, 
-1.0, 0.949367, -0.974684, 0.949367, -0.949367, 0.949367, -0.924051, 0.949367, -0.898734, 0.949367, -0.873418, 0.949367, -0.848101, 0.949367, -0.822785, 0.949367, 
-0.797468, 0.949367, -0.772152, 0.949367, -0.746835, 0.949367, -0.721519, 0.949367, -0.696203, 0.949367, -0.670886, 0.949367, -0.64557, 0.949367, -0.620253, 0.949367, 
-0.594937, 0.949367, -0.56962, 0.949367, -0.544304, 0.949367, -0.518987, 0.949367, -0.493671, 0.949367, -0.468354, 0.949367, -0.443038, 0.949367, -0.417722, 0.949367, 
-0.392405, 0.949367, -0.367089, 0.949367, -0.341772, 0.949367, -0.316456, 0.949367, -0.291139, 0.949367, -0.265823, 0.949367, -0.240506, 0.949367, -0.21519, 0.949367, 
-0.189873, 0.949367, -0.164557, 0.949367, -0.13924, 0.949367, -0.113924, 0.949367, -0.088608, 0.949367, -0.063291, 0.949367, -0.037975, 0.949367, -0.012658, 0.949367, 
0.012658, 0.949367, 0.037975, 0.949367, 0.063291, 0.949367, 0.088608, 0.949367, 0.113924, 0.949367, 0.13924, 0.949367, 0.164557, 0.949367, 0.189873, 0.949367, 
0.21519, 0.949367, 0.240506, 0.949367, 0.265823, 0.949367, 0.291139, 0.949367, 0.316456, 0.949367, 0.341772, 0.949367, 0.367089, 0.949367, 0.392405, 0.949367, 
0.417722, 0.949367, 0.443038, 0.949367, 0.468354, 0.949367, 0.493671, 0.949367, 0.518987, 0.949367, 0.544304, 0.949367, 0.56962, 0.949367, 0.594937, 0.949367, 
0.620253, 0.949367, 0.64557, 0.949367, 0.670886, 0.949367, 0.696203, 0.949367, 0.721519, 0.949367, 0.746835, 0.949367, 0.772152, 0.949367, 0.797468, 0.949367, 
0.822785, 0.949367, 0.848101, 0.949367, 0.873418, 0.949367, 0.898734, 0.949367, 0.924051, 0.949367, 0.949367, 0.949367, 0.974684, 0.949367, 1.0, 0.949367, 
-1.0, 0.974684, -0.974684, 0.974684, -0.949367, 0.974684, -0.924051, 0.974684, -0.898734, 0.974684, -0.873418, 0.974684, -0.848101, 0.974684, -0.822785, 0.974684, 
-0.797468, 0.974684, -0.772152, 0.974684, -0.746835, 0.974684, -0.721519, 0.974684, -0.696203, 0.974684, -0.670886, 0.974684, -0.64557, 0.974684, -0.620253, 0.974684, 
-0.594937, 0.974684, -0.56962, 0.974684, -0.544304, 0.974684, -0.518987, 0.974684, -0.493671, 0.974684, -0.468354, 0.974684, -0.443038, 0.974684, -0.417722, 0.974684, 
-0.392405, 0.974684, -0.367089, 0.974684, -0.341772, 0.974684, -0.316456, 0.974684, -0.291139, 0.974684, -0.265823, 0.974684, -0.240506, 0.974684, -0.21519, 0.974684, 
-0.189873, 0.974684, -0.164557, 0.974684, -0.13924, 0.974684, -0.113924, 0.974684, -0.088608, 0.974684, -0.063291, 0.974684, -0.037975, 0.974684, -0.012658, 0.974684, 
0.012658, 0.974684, 0.037975, 0.974684, 0.063291, 0.974684, 0.088608, 0.974684, 0.113924, 0.974684, 0.13924, 0.974684, 0.164557, 0.974684, 0.189873, 0.974684, 
0.21519, 0.974684, 0.240506, 0.974684, 0.265823, 0.974684, 0.291139, 0.974684, 0.316456, 0.974684, 0.341772, 0.974684, 0.367089, 0.974684, 0.392405, 0.974684, 
0.417722, 0.974684, 0.443038, 0.974684, 0.468354, 0.974684, 0.493671, 0.974684, 0.518987, 0.974684, 0.544304, 0.974684, 0.56962, 0.974684, 0.594937, 0.974684, 
0.620253, 0.974684, 0.64557, 0.974684, 0.670886, 0.974684, 0.696203, 0.974684, 0.721519, 0.974684, 0.746835, 0.974684, 0.772152, 0.974684, 0.797468, 0.974684, 
0.822785, 0.974684, 0.848101, 0.974684, 0.873418, 0.974684, 0.898734, 0.974684, 0.924051, 0.974684, 0.949367, 0.974684, 0.974684, 0.974684, 1.0, 0.974684, 
-1.0, 1.0, -0.974684, 1.0, -0.949367, 1.0, -0.924051, 1.0, -0.898734, 1.0, -0.873418, 1.0, -0.848101, 1.0, -0.822785, 1.0, 
-0.797468, 1.0, -0.772152, 1.0, -0.746835, 1.0, -0.721519, 1.0, -0.696203, 1.0, -0.670886, 1.0, -0.64557, 1.0, -0.620253, 1.0, 
-0.594937, 1.0, -0.56962, 1.0, -0.544304, 1.0, -0.518987, 1.0, -0.493671, 1.0, -0.468354, 1.0, -0.443038, 1.0, -0.417722, 1.0, 
-0.392405, 1.0, -0.367089, 1.0, -0.341772, 1.0, -0.316456, 1.0, -0.291139, 1.0, -0.265823, 1.0, -0.240506, 1.0, -0.21519, 1.0, 
-0.189873, 1.0, -0.164557, 1.0, -0.13924, 1.0, -0.113924, 1.0, -0.088608, 1.0, -0.063291, 1.0, -0.037975, 1.0, -0.012658, 1.0, 
0.012658, 1.0, 0.037975, 1.0, 0.063291, 1.0, 0.088608, 1.0, 0.113924, 1.0, 0.13924, 1.0, 0.164557, 1.0, 0.189873, 1.0, 
0.21519, 1.0, 0.240506, 1.0, 0.265823, 1.0, 0.291139, 1.0, 0.316456, 1.0, 0.341772, 1.0, 0.367089, 1.0, 0.392405, 1.0, 
0.417722, 1.0, 0.443038, 1.0, 0.468354, 1.0, 0.493671, 1.0, 0.518987, 1.0, 0.544304, 1.0, 0.56962, 1.0, 0.594937, 1.0, 
0.620253, 1.0, 0.64557, 1.0, 0.670886, 1.0, 0.696203, 1.0, 0.721519, 1.0, 0.746835, 1.0, 0.772152, 1.0, 0.797468, 1.0, 
0.822785, 1.0, 0.848101, 1.0, 0.873418, 1.0, 0.898734, 1.0, 0.924051, 1.0, 0.949367, 1.0, 0.974684, 1.0, 1.0, 1.0
};

static inline std::vector<float> input2 ={-1.0, -1.0, -0.948718, -1.0, -0.897436, -1.0, -0.846154, -1.0, -0.794872, -1.0, -0.74359, -1.0, -0.692308, -1.0, -0.641026, -1.0, 
-0.589744, -1.0, -0.538462, -1.0, -0.48718, -1.0, -0.435897, -1.0, -0.384615, -1.0, -0.333333, -1.0, -0.282051, -1.0, -0.230769, -1.0, 
-0.179487, -1.0, -0.128205, -1.0, -0.076923, -1.0, -0.025641, -1.0, 0.025641, -1.0, 0.076923, -1.0, 0.128205, -1.0, 0.179487, -1.0, 
0.230769, -1.0, 0.282051, -1.0, 0.333333, -1.0, 0.384615, -1.0, 0.435897, -1.0, 0.487179, -1.0, 0.538462, -1.0, 0.589744, -1.0, 
0.641026, -1.0, 0.692308, -1.0, 0.74359, -1.0, 0.794872, -1.0, 0.846154, -1.0, 0.897436, -1.0, 0.948718, -1.0, 1.0, -1.0, 
-1.0, -0.948718, -0.948718, -0.948718, -0.897436, -0.948718, -0.846154, -0.948718, -0.794872, -0.948718, -0.74359, -0.948718, -0.692308, -0.948718, -0.641026, -0.948718, 
-0.589744, -0.948718, -0.538462, -0.948718, -0.48718, -0.948718, -0.435897, -0.948718, -0.384615, -0.948718, -0.333333, -0.948718, -0.282051, -0.948718, -0.230769, -0.948718, 
-0.179487, -0.948718, -0.128205, -0.948718, -0.076923, -0.948718, -0.025641, -0.948718, 0.025641, -0.948718, 0.076923, -0.948718, 0.128205, -0.948718, 0.179487, -0.948718, 
0.230769, -0.948718, 0.282051, -0.948718, 0.333333, -0.948718, 0.384615, -0.948718, 0.435897, -0.948718, 0.487179, -0.948718, 0.538462, -0.948718, 0.589744, -0.948718, 
0.641026, -0.948718, 0.692308, -0.948718, 0.74359, -0.948718, 0.794872, -0.948718, 0.846154, -0.948718, 0.897436, -0.948718, 0.948718, -0.948718, 1.0, -0.948718, 
-1.0, -0.897436, -0.948718, -0.897436, -0.897436, -0.897436, -0.846154, -0.897436, -0.794872, -0.897436, -0.74359, -0.897436, -0.692308, -0.897436, -0.641026, -0.897436, 
-0.589744, -0.897436, -0.538462, -0.897436, -0.48718, -0.897436, -0.435897, -0.897436, -0.384615, -0.897436, -0.333333, -0.897436, -0.282051, -0.897436, -0.230769, -0.897436, 
-0.179487, -0.897436, -0.128205, -0.897436, -0.076923, -0.897436, -0.025641, -0.897436, 0.025641, -0.897436, 0.076923, -0.897436, 0.128205, -0.897436, 0.179487, -0.897436, 
0.230769, -0.897436, 0.282051, -0.897436, 0.333333, -0.897436, 0.384615, -0.897436, 0.435897, -0.897436, 0.487179, -0.897436, 0.538462, -0.897436, 0.589744, -0.897436, 
0.641026, -0.897436, 0.692308, -0.897436, 0.74359, -0.897436, 0.794872, -0.897436, 0.846154, -0.897436, 0.897436, -0.897436, 0.948718, -0.897436, 1.0, -0.897436, 
-1.0, -0.846154, -0.948718, -0.846154, -0.897436, -0.846154, -0.846154, -0.846154, -0.794872, -0.846154, -0.74359, -0.846154, -0.692308, -0.846154, -0.641026, -0.846154, 
-0.589744, -0.846154, -0.538462, -0.846154, -0.48718, -0.846154, -0.435897, -0.846154, -0.384615, -0.846154, -0.333333, -0.846154, -0.282051, -0.846154, -0.230769, -0.846154, 
-0.179487, -0.846154, -0.128205, -0.846154, -0.076923, -0.846154, -0.025641, -0.846154, 0.025641, -0.846154, 0.076923, -0.846154, 0.128205, -0.846154, 0.179487, -0.846154, 
0.230769, -0.846154, 0.282051, -0.846154, 0.333333, -0.846154, 0.384615, -0.846154, 0.435897, -0.846154, 0.487179, -0.846154, 0.538462, -0.846154, 0.589744, -0.846154, 
0.641026, -0.846154, 0.692308, -0.846154, 0.74359, -0.846154, 0.794872, -0.846154, 0.846154, -0.846154, 0.897436, -0.846154, 0.948718, -0.846154, 1.0, -0.846154, 
-1.0, -0.794872, -0.948718, -0.794872, -0.897436, -0.794872, -0.846154, -0.794872, -0.794872, -0.794872, -0.74359, -0.794872, -0.692308, -0.794872, -0.641026, -0.794872, 
-0.589744, -0.794872, -0.538462, -0.794872, -0.48718, -0.794872, -0.435897, -0.794872, -0.384615, -0.794872, -0.333333, -0.794872, -0.282051, -0.794872, -0.230769, -0.794872, 
-0.179487, -0.794872, -0.128205, -0.794872, -0.076923, -0.794872, -0.025641, -0.794872, 0.025641, -0.794872, 0.076923, -0.794872, 0.128205, -0.794872, 0.179487, -0.794872, 
0.230769, -0.794872, 0.282051, -0.794872, 0.333333, -0.794872, 0.384615, -0.794872, 0.435897, -0.794872, 0.487179, -0.794872, 0.538462, -0.794872, 0.589744, -0.794872, 
0.641026, -0.794872, 0.692308, -0.794872, 0.74359, -0.794872, 0.794872, -0.794872, 0.846154, -0.794872, 0.897436, -0.794872, 0.948718, -0.794872, 1.0, -0.794872, 
-1.0, -0.74359, -0.948718, -0.74359, -0.897436, -0.74359, -0.846154, -0.74359, -0.794872, -0.74359, -0.74359, -0.74359, -0.692308, -0.74359, -0.641026, -0.74359, 
-0.589744, -0.74359, -0.538462, -0.74359, -0.48718, -0.74359, -0.435897, -0.74359, -0.384615, -0.74359, -0.333333, -0.74359, -0.282051, -0.74359, -0.230769, -0.74359, 
-0.179487, -0.74359, -0.128205, -0.74359, -0.076923, -0.74359, -0.025641, -0.74359, 0.025641, -0.74359, 0.076923, -0.74359, 0.128205, -0.74359, 0.179487, -0.74359, 
0.230769, -0.74359, 0.282051, -0.74359, 0.333333, -0.74359, 0.384615, -0.74359, 0.435897, -0.74359, 0.487179, -0.74359, 0.538462, -0.74359, 0.589744, -0.74359, 
0.641026, -0.74359, 0.692308, -0.74359, 0.74359, -0.74359, 0.794872, -0.74359, 0.846154, -0.74359, 0.897436, -0.74359, 0.948718, -0.74359, 1.0, -0.74359, 
-1.0, -0.692308, -0.948718, -0.692308, -0.897436, -0.692308, -0.846154, -0.692308, -0.794872, -0.692308, -0.74359, -0.692308, -0.692308, -0.692308, -0.641026, -0.692308, 
-0.589744, -0.692308, -0.538462, -0.692308, -0.48718, -0.692308, -0.435897, -0.692308, -0.384615, -0.692308, -0.333333, -0.692308, -0.282051, -0.692308, -0.230769, -0.692308, 
-0.179487, -0.692308, -0.128205, -0.692308, -0.076923, -0.692308, -0.025641, -0.692308, 0.025641, -0.692308, 0.076923, -0.692308, 0.128205, -0.692308, 0.179487, -0.692308, 
0.230769, -0.692308, 0.282051, -0.692308, 0.333333, -0.692308, 0.384615, -0.692308, 0.435897, -0.692308, 0.487179, -0.692308, 0.538462, -0.692308, 0.589744, -0.692308, 
0.641026, -0.692308, 0.692308, -0.692308, 0.74359, -0.692308, 0.794872, -0.692308, 0.846154, -0.692308, 0.897436, -0.692308, 0.948718, -0.692308, 1.0, -0.692308, 
-1.0, -0.641026, -0.948718, -0.641026, -0.897436, -0.641026, -0.846154, -0.641026, -0.794872, -0.641026, -0.74359, -0.641026, -0.692308, -0.641026, -0.641026, -0.641026, 
-0.589744, -0.641026, -0.538462, -0.641026, -0.48718, -0.641026, -0.435897, -0.641026, -0.384615, -0.641026, -0.333333, -0.641026, -0.282051, -0.641026, -0.230769, -0.641026, 
-0.179487, -0.641026, -0.128205, -0.641026, -0.076923, -0.641026, -0.025641, -0.641026, 0.025641, -0.641026, 0.076923, -0.641026, 0.128205, -0.641026, 0.179487, -0.641026, 
0.230769, -0.641026, 0.282051, -0.641026, 0.333333, -0.641026, 0.384615, -0.641026, 0.435897, -0.641026, 0.487179, -0.641026, 0.538462, -0.641026, 0.589744, -0.641026, 
0.641026, -0.641026, 0.692308, -0.641026, 0.74359, -0.641026, 0.794872, -0.641026, 0.846154, -0.641026, 0.897436, -0.641026, 0.948718, -0.641026, 1.0, -0.641026, 
-1.0, -0.589744, -0.948718, -0.589744, -0.897436, -0.589744, -0.846154, -0.589744, -0.794872, -0.589744, -0.74359, -0.589744, -0.692308, -0.589744, -0.641026, -0.589744, 
-0.589744, -0.589744, -0.538462, -0.589744, -0.48718, -0.589744, -0.435897, -0.589744, -0.384615, -0.589744, -0.333333, -0.589744, -0.282051, -0.589744, -0.230769, -0.589744, 
-0.179487, -0.589744, -0.128205, -0.589744, -0.076923, -0.589744, -0.025641, -0.589744, 0.025641, -0.589744, 0.076923, -0.589744, 0.128205, -0.589744, 0.179487, -0.589744, 
0.230769, -0.589744, 0.282051, -0.589744, 0.333333, -0.589744, 0.384615, -0.589744, 0.435897, -0.589744, 0.487179, -0.589744, 0.538462, -0.589744, 0.589744, -0.589744, 
0.641026, -0.589744, 0.692308, -0.589744, 0.74359, -0.589744, 0.794872, -0.589744, 0.846154, -0.589744, 0.897436, -0.589744, 0.948718, -0.589744, 1.0, -0.589744, 
-1.0, -0.538462, -0.948718, -0.538462, -0.897436, -0.538462, -0.846154, -0.538462, -0.794872, -0.538462, -0.74359, -0.538462, -0.692308, -0.538462, -0.641026, -0.538462, 
-0.589744, -0.538462, -0.538462, -0.538462, -0.48718, -0.538462, -0.435897, -0.538462, -0.384615, -0.538462, -0.333333, -0.538462, -0.282051, -0.538462, -0.230769, -0.538462, 
-0.179487, -0.538462, -0.128205, -0.538462, -0.076923, -0.538462, -0.025641, -0.538462, 0.025641, -0.538462, 0.076923, -0.538462, 0.128205, -0.538462, 0.179487, -0.538462, 
0.230769, -0.538462, 0.282051, -0.538462, 0.333333, -0.538462, 0.384615, -0.538462, 0.435897, -0.538462, 0.487179, -0.538462, 0.538462, -0.538462, 0.589744, -0.538462, 
0.641026, -0.538462, 0.692308, -0.538462, 0.74359, -0.538462, 0.794872, -0.538462, 0.846154, -0.538462, 0.897436, -0.538462, 0.948718, -0.538462, 1.0, -0.538462, 
-1.0, -0.48718, -0.948718, -0.48718, -0.897436, -0.48718, -0.846154, -0.48718, -0.794872, -0.48718, -0.74359, -0.48718, -0.692308, -0.48718, -0.641026, -0.48718, 
-0.589744, -0.48718, -0.538462, -0.48718, -0.48718, -0.48718, -0.435897, -0.48718, -0.384615, -0.48718, -0.333333, -0.48718, -0.282051, -0.48718, -0.230769, -0.48718, 
-0.179487, -0.48718, -0.128205, -0.48718, -0.076923, -0.48718, -0.025641, -0.48718, 0.025641, -0.48718, 0.076923, -0.48718, 0.128205, -0.48718, 0.179487, -0.48718, 
0.230769, -0.48718, 0.282051, -0.48718, 0.333333, -0.48718, 0.384615, -0.48718, 0.435897, -0.48718, 0.487179, -0.48718, 0.538462, -0.48718, 0.589744, -0.48718, 
0.641026, -0.48718, 0.692308, -0.48718, 0.74359, -0.48718, 0.794872, -0.48718, 0.846154, -0.48718, 0.897436, -0.48718, 0.948718, -0.48718, 1.0, -0.48718, 
-1.0, -0.435897, -0.948718, -0.435897, -0.897436, -0.435897, -0.846154, -0.435897, -0.794872, -0.435897, -0.74359, -0.435897, -0.692308, -0.435897, -0.641026, -0.435897, 
-0.589744, -0.435897, -0.538462, -0.435897, -0.48718, -0.435897, -0.435897, -0.435897, -0.384615, -0.435897, -0.333333, -0.435897, -0.282051, -0.435897, -0.230769, -0.435897, 
-0.179487, -0.435897, -0.128205, -0.435897, -0.076923, -0.435897, -0.025641, -0.435897, 0.025641, -0.435897, 0.076923, -0.435897, 0.128205, -0.435897, 0.179487, -0.435897, 
0.230769, -0.435897, 0.282051, -0.435897, 0.333333, -0.435897, 0.384615, -0.435897, 0.435897, -0.435897, 0.487179, -0.435897, 0.538462, -0.435897, 0.589744, -0.435897, 
0.641026, -0.435897, 0.692308, -0.435897, 0.74359, -0.435897, 0.794872, -0.435897, 0.846154, -0.435897, 0.897436, -0.435897, 0.948718, -0.435897, 1.0, -0.435897, 
-1.0, -0.384615, -0.948718, -0.384615, -0.897436, -0.384615, -0.846154, -0.384615, -0.794872, -0.384615, -0.74359, -0.384615, -0.692308, -0.384615, -0.641026, -0.384615, 
-0.589744, -0.384615, -0.538462, -0.384615, -0.48718, -0.384615, -0.435897, -0.384615, -0.384615, -0.384615, -0.333333, -0.384615, -0.282051, -0.384615, -0.230769, -0.384615, 
-0.179487, -0.384615, -0.128205, -0.384615, -0.076923, -0.384615, -0.025641, -0.384615, 0.025641, -0.384615, 0.076923, -0.384615, 0.128205, -0.384615, 0.179487, -0.384615, 
0.230769, -0.384615, 0.282051, -0.384615, 0.333333, -0.384615, 0.384615, -0.384615, 0.435897, -0.384615, 0.487179, -0.384615, 0.538462, -0.384615, 0.589744, -0.384615, 
0.641026, -0.384615, 0.692308, -0.384615, 0.74359, -0.384615, 0.794872, -0.384615, 0.846154, -0.384615, 0.897436, -0.384615, 0.948718, -0.384615, 1.0, -0.384615, 
-1.0, -0.333333, -0.948718, -0.333333, -0.897436, -0.333333, -0.846154, -0.333333, -0.794872, -0.333333, -0.74359, -0.333333, -0.692308, -0.333333, -0.641026, -0.333333, 
-0.589744, -0.333333, -0.538462, -0.333333, -0.48718, -0.333333, -0.435897, -0.333333, -0.384615, -0.333333, -0.333333, -0.333333, -0.282051, -0.333333, -0.230769, -0.333333, 
-0.179487, -0.333333, -0.128205, -0.333333, -0.076923, -0.333333, -0.025641, -0.333333, 0.025641, -0.333333, 0.076923, -0.333333, 0.128205, -0.333333, 0.179487, -0.333333, 
0.230769, -0.333333, 0.282051, -0.333333, 0.333333, -0.333333, 0.384615, -0.333333, 0.435897, -0.333333, 0.487179, -0.333333, 0.538462, -0.333333, 0.589744, -0.333333, 
0.641026, -0.333333, 0.692308, -0.333333, 0.74359, -0.333333, 0.794872, -0.333333, 0.846154, -0.333333, 0.897436, -0.333333, 0.948718, -0.333333, 1.0, -0.333333, 
-1.0, -0.282051, -0.948718, -0.282051, -0.897436, -0.282051, -0.846154, -0.282051, -0.794872, -0.282051, -0.74359, -0.282051, -0.692308, -0.282051, -0.641026, -0.282051, 
-0.589744, -0.282051, -0.538462, -0.282051, -0.48718, -0.282051, -0.435897, -0.282051, -0.384615, -0.282051, -0.333333, -0.282051, -0.282051, -0.282051, -0.230769, -0.282051, 
-0.179487, -0.282051, -0.128205, -0.282051, -0.076923, -0.282051, -0.025641, -0.282051, 0.025641, -0.282051, 0.076923, -0.282051, 0.128205, -0.282051, 0.179487, -0.282051, 
0.230769, -0.282051, 0.282051, -0.282051, 0.333333, -0.282051, 0.384615, -0.282051, 0.435897, -0.282051, 0.487179, -0.282051, 0.538462, -0.282051, 0.589744, -0.282051, 
0.641026, -0.282051, 0.692308, -0.282051, 0.74359, -0.282051, 0.794872, -0.282051, 0.846154, -0.282051, 0.897436, -0.282051, 0.948718, -0.282051, 1.0, -0.282051, 
-1.0, -0.230769, -0.948718, -0.230769, -0.897436, -0.230769, -0.846154, -0.230769, -0.794872, -0.230769, -0.74359, -0.230769, -0.692308, -0.230769, -0.641026, -0.230769, 
-0.589744, -0.230769, -0.538462, -0.230769, -0.48718, -0.230769, -0.435897, -0.230769, -0.384615, -0.230769, -0.333333, -0.230769, -0.282051, -0.230769, -0.230769, -0.230769, 
-0.179487, -0.230769, -0.128205, -0.230769, -0.076923, -0.230769, -0.025641, -0.230769, 0.025641, -0.230769, 0.076923, -0.230769, 0.128205, -0.230769, 0.179487, -0.230769, 
0.230769, -0.230769, 0.282051, -0.230769, 0.333333, -0.230769, 0.384615, -0.230769, 0.435897, -0.230769, 0.487179, -0.230769, 0.538462, -0.230769, 0.589744, -0.230769, 
0.641026, -0.230769, 0.692308, -0.230769, 0.74359, -0.230769, 0.794872, -0.230769, 0.846154, -0.230769, 0.897436, -0.230769, 0.948718, -0.230769, 1.0, -0.230769, 
-1.0, -0.179487, -0.948718, -0.179487, -0.897436, -0.179487, -0.846154, -0.179487, -0.794872, -0.179487, -0.74359, -0.179487, -0.692308, -0.179487, -0.641026, -0.179487, 
-0.589744, -0.179487, -0.538462, -0.179487, -0.48718, -0.179487, -0.435897, -0.179487, -0.384615, -0.179487, -0.333333, -0.179487, -0.282051, -0.179487, -0.230769, -0.179487, 
-0.179487, -0.179487, -0.128205, -0.179487, -0.076923, -0.179487, -0.025641, -0.179487, 0.025641, -0.179487, 0.076923, -0.179487, 0.128205, -0.179487, 0.179487, -0.179487, 
0.230769, -0.179487, 0.282051, -0.179487, 0.333333, -0.179487, 0.384615, -0.179487, 0.435897, -0.179487, 0.487179, -0.179487, 0.538462, -0.179487, 0.589744, -0.179487, 
0.641026, -0.179487, 0.692308, -0.179487, 0.74359, -0.179487, 0.794872, -0.179487, 0.846154, -0.179487, 0.897436, -0.179487, 0.948718, -0.179487, 1.0, -0.179487, 
-1.0, -0.128205, -0.948718, -0.128205, -0.897436, -0.128205, -0.846154, -0.128205, -0.794872, -0.128205, -0.74359, -0.128205, -0.692308, -0.128205, -0.641026, -0.128205, 
-0.589744, -0.128205, -0.538462, -0.128205, -0.48718, -0.128205, -0.435897, -0.128205, -0.384615, -0.128205, -0.333333, -0.128205, -0.282051, -0.128205, -0.230769, -0.128205, 
-0.179487, -0.128205, -0.128205, -0.128205, -0.076923, -0.128205, -0.025641, -0.128205, 0.025641, -0.128205, 0.076923, -0.128205, 0.128205, -0.128205, 0.179487, -0.128205, 
0.230769, -0.128205, 0.282051, -0.128205, 0.333333, -0.128205, 0.384615, -0.128205, 0.435897, -0.128205, 0.487179, -0.128205, 0.538462, -0.128205, 0.589744, -0.128205, 
0.641026, -0.128205, 0.692308, -0.128205, 0.74359, -0.128205, 0.794872, -0.128205, 0.846154, -0.128205, 0.897436, -0.128205, 0.948718, -0.128205, 1.0, -0.128205, 
-1.0, -0.076923, -0.948718, -0.076923, -0.897436, -0.076923, -0.846154, -0.076923, -0.794872, -0.076923, -0.74359, -0.076923, -0.692308, -0.076923, -0.641026, -0.076923, 
-0.589744, -0.076923, -0.538462, -0.076923, -0.48718, -0.076923, -0.435897, -0.076923, -0.384615, -0.076923, -0.333333, -0.076923, -0.282051, -0.076923, -0.230769, -0.076923, 
-0.179487, -0.076923, -0.128205, -0.076923, -0.076923, -0.076923, -0.025641, -0.076923, 0.025641, -0.076923, 0.076923, -0.076923, 0.128205, -0.076923, 0.179487, -0.076923, 
0.230769, -0.076923, 0.282051, -0.076923, 0.333333, -0.076923, 0.384615, -0.076923, 0.435897, -0.076923, 0.487179, -0.076923, 0.538462, -0.076923, 0.589744, -0.076923, 
0.641026, -0.076923, 0.692308, -0.076923, 0.74359, -0.076923, 0.794872, -0.076923, 0.846154, -0.076923, 0.897436, -0.076923, 0.948718, -0.076923, 1.0, -0.076923, 
-1.0, -0.025641, -0.948718, -0.025641, -0.897436, -0.025641, -0.846154, -0.025641, -0.794872, -0.025641, -0.74359, -0.025641, -0.692308, -0.025641, -0.641026, -0.025641, 
-0.589744, -0.025641, -0.538462, -0.025641, -0.48718, -0.025641, -0.435897, -0.025641, -0.384615, -0.025641, -0.333333, -0.025641, -0.282051, -0.025641, -0.230769, -0.025641, 
-0.179487, -0.025641, -0.128205, -0.025641, -0.076923, -0.025641, -0.025641, -0.025641, 0.025641, -0.025641, 0.076923, -0.025641, 0.128205, -0.025641, 0.179487, -0.025641, 
0.230769, -0.025641, 0.282051, -0.025641, 0.333333, -0.025641, 0.384615, -0.025641, 0.435897, -0.025641, 0.487179, -0.025641, 0.538462, -0.025641, 0.589744, -0.025641, 
0.641026, -0.025641, 0.692308, -0.025641, 0.74359, -0.025641, 0.794872, -0.025641, 0.846154, -0.025641, 0.897436, -0.025641, 0.948718, -0.025641, 1.0, -0.025641, 
-1.0, 0.025641, -0.948718, 0.025641, -0.897436, 0.025641, -0.846154, 0.025641, -0.794872, 0.025641, -0.74359, 0.025641, -0.692308, 0.025641, -0.641026, 0.025641, 
-0.589744, 0.025641, -0.538462, 0.025641, -0.48718, 0.025641, -0.435897, 0.025641, -0.384615, 0.025641, -0.333333, 0.025641, -0.282051, 0.025641, -0.230769, 0.025641, 
-0.179487, 0.025641, -0.128205, 0.025641, -0.076923, 0.025641, -0.025641, 0.025641, 0.025641, 0.025641, 0.076923, 0.025641, 0.128205, 0.025641, 0.179487, 0.025641, 
0.230769, 0.025641, 0.282051, 0.025641, 0.333333, 0.025641, 0.384615, 0.025641, 0.435897, 0.025641, 0.487179, 0.025641, 0.538462, 0.025641, 0.589744, 0.025641, 
0.641026, 0.025641, 0.692308, 0.025641, 0.74359, 0.025641, 0.794872, 0.025641, 0.846154, 0.025641, 0.897436, 0.025641, 0.948718, 0.025641, 1.0, 0.025641, 
-1.0, 0.076923, -0.948718, 0.076923, -0.897436, 0.076923, -0.846154, 0.076923, -0.794872, 0.076923, -0.74359, 0.076923, -0.692308, 0.076923, -0.641026, 0.076923, 
-0.589744, 0.076923, -0.538462, 0.076923, -0.48718, 0.076923, -0.435897, 0.076923, -0.384615, 0.076923, -0.333333, 0.076923, -0.282051, 0.076923, -0.230769, 0.076923, 
-0.179487, 0.076923, -0.128205, 0.076923, -0.076923, 0.076923, -0.025641, 0.076923, 0.025641, 0.076923, 0.076923, 0.076923, 0.128205, 0.076923, 0.179487, 0.076923, 
0.230769, 0.076923, 0.282051, 0.076923, 0.333333, 0.076923, 0.384615, 0.076923, 0.435897, 0.076923, 0.487179, 0.076923, 0.538462, 0.076923, 0.589744, 0.076923, 
0.641026, 0.076923, 0.692308, 0.076923, 0.74359, 0.076923, 0.794872, 0.076923, 0.846154, 0.076923, 0.897436, 0.076923, 0.948718, 0.076923, 1.0, 0.076923, 
-1.0, 0.128205, -0.948718, 0.128205, -0.897436, 0.128205, -0.846154, 0.128205, -0.794872, 0.128205, -0.74359, 0.128205, -0.692308, 0.128205, -0.641026, 0.128205, 
-0.589744, 0.128205, -0.538462, 0.128205, -0.48718, 0.128205, -0.435897, 0.128205, -0.384615, 0.128205, -0.333333, 0.128205, -0.282051, 0.128205, -0.230769, 0.128205, 
-0.179487, 0.128205, -0.128205, 0.128205, -0.076923, 0.128205, -0.025641, 0.128205, 0.025641, 0.128205, 0.076923, 0.128205, 0.128205, 0.128205, 0.179487, 0.128205, 
0.230769, 0.128205, 0.282051, 0.128205, 0.333333, 0.128205, 0.384615, 0.128205, 0.435897, 0.128205, 0.487179, 0.128205, 0.538462, 0.128205, 0.589744, 0.128205, 
0.641026, 0.128205, 0.692308, 0.128205, 0.74359, 0.128205, 0.794872, 0.128205, 0.846154, 0.128205, 0.897436, 0.128205, 0.948718, 0.128205, 1.0, 0.128205, 
-1.0, 0.179487, -0.948718, 0.179487, -0.897436, 0.179487, -0.846154, 0.179487, -0.794872, 0.179487, -0.74359, 0.179487, -0.692308, 0.179487, -0.641026, 0.179487, 
-0.589744, 0.179487, -0.538462, 0.179487, -0.48718, 0.179487, -0.435897, 0.179487, -0.384615, 0.179487, -0.333333, 0.179487, -0.282051, 0.179487, -0.230769, 0.179487, 
-0.179487, 0.179487, -0.128205, 0.179487, -0.076923, 0.179487, -0.025641, 0.179487, 0.025641, 0.179487, 0.076923, 0.179487, 0.128205, 0.179487, 0.179487, 0.179487, 
0.230769, 0.179487, 0.282051, 0.179487, 0.333333, 0.179487, 0.384615, 0.179487, 0.435897, 0.179487, 0.487179, 0.179487, 0.538462, 0.179487, 0.589744, 0.179487, 
0.641026, 0.179487, 0.692308, 0.179487, 0.74359, 0.179487, 0.794872, 0.179487, 0.846154, 0.179487, 0.897436, 0.179487, 0.948718, 0.179487, 1.0, 0.179487, 
-1.0, 0.230769, -0.948718, 0.230769, -0.897436, 0.230769, -0.846154, 0.230769, -0.794872, 0.230769, -0.74359, 0.230769, -0.692308, 0.230769, -0.641026, 0.230769, 
-0.589744, 0.230769, -0.538462, 0.230769, -0.48718, 0.230769, -0.435897, 0.230769, -0.384615, 0.230769, -0.333333, 0.230769, -0.282051, 0.230769, -0.230769, 0.230769, 
-0.179487, 0.230769, -0.128205, 0.230769, -0.076923, 0.230769, -0.025641, 0.230769, 0.025641, 0.230769, 0.076923, 0.230769, 0.128205, 0.230769, 0.179487, 0.230769, 
0.230769, 0.230769, 0.282051, 0.230769, 0.333333, 0.230769, 0.384615, 0.230769, 0.435897, 0.230769, 0.487179, 0.230769, 0.538462, 0.230769, 0.589744, 0.230769, 
0.641026, 0.230769, 0.692308, 0.230769, 0.74359, 0.230769, 0.794872, 0.230769, 0.846154, 0.230769, 0.897436, 0.230769, 0.948718, 0.230769, 1.0, 0.230769, 
-1.0, 0.282051, -0.948718, 0.282051, -0.897436, 0.282051, -0.846154, 0.282051, -0.794872, 0.282051, -0.74359, 0.282051, -0.692308, 0.282051, -0.641026, 0.282051, 
-0.589744, 0.282051, -0.538462, 0.282051, -0.48718, 0.282051, -0.435897, 0.282051, -0.384615, 0.282051, -0.333333, 0.282051, -0.282051, 0.282051, -0.230769, 0.282051, 
-0.179487, 0.282051, -0.128205, 0.282051, -0.076923, 0.282051, -0.025641, 0.282051, 0.025641, 0.282051, 0.076923, 0.282051, 0.128205, 0.282051, 0.179487, 0.282051, 
0.230769, 0.282051, 0.282051, 0.282051, 0.333333, 0.282051, 0.384615, 0.282051, 0.435897, 0.282051, 0.487179, 0.282051, 0.538462, 0.282051, 0.589744, 0.282051, 
0.641026, 0.282051, 0.692308, 0.282051, 0.74359, 0.282051, 0.794872, 0.282051, 0.846154, 0.282051, 0.897436, 0.282051, 0.948718, 0.282051, 1.0, 0.282051, 
-1.0, 0.333333, -0.948718, 0.333333, -0.897436, 0.333333, -0.846154, 0.333333, -0.794872, 0.333333, -0.74359, 0.333333, -0.692308, 0.333333, -0.641026, 0.333333, 
-0.589744, 0.333333, -0.538462, 0.333333, -0.48718, 0.333333, -0.435897, 0.333333, -0.384615, 0.333333, -0.333333, 0.333333, -0.282051, 0.333333, -0.230769, 0.333333, 
-0.179487, 0.333333, -0.128205, 0.333333, -0.076923, 0.333333, -0.025641, 0.333333, 0.025641, 0.333333, 0.076923, 0.333333, 0.128205, 0.333333, 0.179487, 0.333333, 
0.230769, 0.333333, 0.282051, 0.333333, 0.333333, 0.333333, 0.384615, 0.333333, 0.435897, 0.333333, 0.487179, 0.333333, 0.538462, 0.333333, 0.589744, 0.333333, 
0.641026, 0.333333, 0.692308, 0.333333, 0.74359, 0.333333, 0.794872, 0.333333, 0.846154, 0.333333, 0.897436, 0.333333, 0.948718, 0.333333, 1.0, 0.333333, 
-1.0, 0.384615, -0.948718, 0.384615, -0.897436, 0.384615, -0.846154, 0.384615, -0.794872, 0.384615, -0.74359, 0.384615, -0.692308, 0.384615, -0.641026, 0.384615, 
-0.589744, 0.384615, -0.538462, 0.384615, -0.48718, 0.384615, -0.435897, 0.384615, -0.384615, 0.384615, -0.333333, 0.384615, -0.282051, 0.384615, -0.230769, 0.384615, 
-0.179487, 0.384615, -0.128205, 0.384615, -0.076923, 0.384615, -0.025641, 0.384615, 0.025641, 0.384615, 0.076923, 0.384615, 0.128205, 0.384615, 0.179487, 0.384615, 
0.230769, 0.384615, 0.282051, 0.384615, 0.333333, 0.384615, 0.384615, 0.384615, 0.435897, 0.384615, 0.487179, 0.384615, 0.538462, 0.384615, 0.589744, 0.384615, 
0.641026, 0.384615, 0.692308, 0.384615, 0.74359, 0.384615, 0.794872, 0.384615, 0.846154, 0.384615, 0.897436, 0.384615, 0.948718, 0.384615, 1.0, 0.384615, 
-1.0, 0.435897, -0.948718, 0.435897, -0.897436, 0.435897, -0.846154, 0.435897, -0.794872, 0.435897, -0.74359, 0.435897, -0.692308, 0.435897, -0.641026, 0.435897, 
-0.589744, 0.435897, -0.538462, 0.435897, -0.48718, 0.435897, -0.435897, 0.435897, -0.384615, 0.435897, -0.333333, 0.435897, -0.282051, 0.435897, -0.230769, 0.435897, 
-0.179487, 0.435897, -0.128205, 0.435897, -0.076923, 0.435897, -0.025641, 0.435897, 0.025641, 0.435897, 0.076923, 0.435897, 0.128205, 0.435897, 0.179487, 0.435897, 
0.230769, 0.435897, 0.282051, 0.435897, 0.333333, 0.435897, 0.384615, 0.435897, 0.435897, 0.435897, 0.487179, 0.435897, 0.538462, 0.435897, 0.589744, 0.435897, 
0.641026, 0.435897, 0.692308, 0.435897, 0.74359, 0.435897, 0.794872, 0.435897, 0.846154, 0.435897, 0.897436, 0.435897, 0.948718, 0.435897, 1.0, 0.435897, 
-1.0, 0.487179, -0.948718, 0.487179, -0.897436, 0.487179, -0.846154, 0.487179, -0.794872, 0.487179, -0.74359, 0.487179, -0.692308, 0.487179, -0.641026, 0.487179, 
-0.589744, 0.487179, -0.538462, 0.487179, -0.48718, 0.487179, -0.435897, 0.487179, -0.384615, 0.487179, -0.333333, 0.487179, -0.282051, 0.487179, -0.230769, 0.487179, 
-0.179487, 0.487179, -0.128205, 0.487179, -0.076923, 0.487179, -0.025641, 0.487179, 0.025641, 0.487179, 0.076923, 0.487179, 0.128205, 0.487179, 0.179487, 0.487179, 
0.230769, 0.487179, 0.282051, 0.487179, 0.333333, 0.487179, 0.384615, 0.487179, 0.435897, 0.487179, 0.487179, 0.487179, 0.538462, 0.487179, 0.589744, 0.487179, 
0.641026, 0.487179, 0.692308, 0.487179, 0.74359, 0.487179, 0.794872, 0.487179, 0.846154, 0.487179, 0.897436, 0.487179, 0.948718, 0.487179, 1.0, 0.487179, 
-1.0, 0.538462, -0.948718, 0.538462, -0.897436, 0.538462, -0.846154, 0.538462, -0.794872, 0.538462, -0.74359, 0.538462, -0.692308, 0.538462, -0.641026, 0.538462, 
-0.589744, 0.538462, -0.538462, 0.538462, -0.48718, 0.538462, -0.435897, 0.538462, -0.384615, 0.538462, -0.333333, 0.538462, -0.282051, 0.538462, -0.230769, 0.538462, 
-0.179487, 0.538462, -0.128205, 0.538462, -0.076923, 0.538462, -0.025641, 0.538462, 0.025641, 0.538462, 0.076923, 0.538462, 0.128205, 0.538462, 0.179487, 0.538462, 
0.230769, 0.538462, 0.282051, 0.538462, 0.333333, 0.538462, 0.384615, 0.538462, 0.435897, 0.538462, 0.487179, 0.538462, 0.538462, 0.538462, 0.589744, 0.538462, 
0.641026, 0.538462, 0.692308, 0.538462, 0.74359, 0.538462, 0.794872, 0.538462, 0.846154, 0.538462, 0.897436, 0.538462, 0.948718, 0.538462, 1.0, 0.538462, 
-1.0, 0.589744, -0.948718, 0.589744, -0.897436, 0.589744, -0.846154, 0.589744, -0.794872, 0.589744, -0.74359, 0.589744, -0.692308, 0.589744, -0.641026, 0.589744, 
-0.589744, 0.589744, -0.538462, 0.589744, -0.48718, 0.589744, -0.435897, 0.589744, -0.384615, 0.589744, -0.333333, 0.589744, -0.282051, 0.589744, -0.230769, 0.589744, 
-0.179487, 0.589744, -0.128205, 0.589744, -0.076923, 0.589744, -0.025641, 0.589744, 0.025641, 0.589744, 0.076923, 0.589744, 0.128205, 0.589744, 0.179487, 0.589744, 
0.230769, 0.589744, 0.282051, 0.589744, 0.333333, 0.589744, 0.384615, 0.589744, 0.435897, 0.589744, 0.487179, 0.589744, 0.538462, 0.589744, 0.589744, 0.589744, 
0.641026, 0.589744, 0.692308, 0.589744, 0.74359, 0.589744, 0.794872, 0.589744, 0.846154, 0.589744, 0.897436, 0.589744, 0.948718, 0.589744, 1.0, 0.589744, 
-1.0, 0.641026, -0.948718, 0.641026, -0.897436, 0.641026, -0.846154, 0.641026, -0.794872, 0.641026, -0.74359, 0.641026, -0.692308, 0.641026, -0.641026, 0.641026, 
-0.589744, 0.641026, -0.538462, 0.641026, -0.48718, 0.641026, -0.435897, 0.641026, -0.384615, 0.641026, -0.333333, 0.641026, -0.282051, 0.641026, -0.230769, 0.641026, 
-0.179487, 0.641026, -0.128205, 0.641026, -0.076923, 0.641026, -0.025641, 0.641026, 0.025641, 0.641026, 0.076923, 0.641026, 0.128205, 0.641026, 0.179487, 0.641026, 
0.230769, 0.641026, 0.282051, 0.641026, 0.333333, 0.641026, 0.384615, 0.641026, 0.435897, 0.641026, 0.487179, 0.641026, 0.538462, 0.641026, 0.589744, 0.641026, 
0.641026, 0.641026, 0.692308, 0.641026, 0.74359, 0.641026, 0.794872, 0.641026, 0.846154, 0.641026, 0.897436, 0.641026, 0.948718, 0.641026, 1.0, 0.641026, 
-1.0, 0.692308, -0.948718, 0.692308, -0.897436, 0.692308, -0.846154, 0.692308, -0.794872, 0.692308, -0.74359, 0.692308, -0.692308, 0.692308, -0.641026, 0.692308, 
-0.589744, 0.692308, -0.538462, 0.692308, -0.48718, 0.692308, -0.435897, 0.692308, -0.384615, 0.692308, -0.333333, 0.692308, -0.282051, 0.692308, -0.230769, 0.692308, 
-0.179487, 0.692308, -0.128205, 0.692308, -0.076923, 0.692308, -0.025641, 0.692308, 0.025641, 0.692308, 0.076923, 0.692308, 0.128205, 0.692308, 0.179487, 0.692308, 
0.230769, 0.692308, 0.282051, 0.692308, 0.333333, 0.692308, 0.384615, 0.692308, 0.435897, 0.692308, 0.487179, 0.692308, 0.538462, 0.692308, 0.589744, 0.692308, 
0.641026, 0.692308, 0.692308, 0.692308, 0.74359, 0.692308, 0.794872, 0.692308, 0.846154, 0.692308, 0.897436, 0.692308, 0.948718, 0.692308, 1.0, 0.692308, 
-1.0, 0.74359, -0.948718, 0.74359, -0.897436, 0.74359, -0.846154, 0.74359, -0.794872, 0.74359, -0.74359, 0.74359, -0.692308, 0.74359, -0.641026, 0.74359, 
-0.589744, 0.74359, -0.538462, 0.74359, -0.48718, 0.74359, -0.435897, 0.74359, -0.384615, 0.74359, -0.333333, 0.74359, -0.282051, 0.74359, -0.230769, 0.74359, 
-0.179487, 0.74359, -0.128205, 0.74359, -0.076923, 0.74359, -0.025641, 0.74359, 0.025641, 0.74359, 0.076923, 0.74359, 0.128205, 0.74359, 0.179487, 0.74359, 
0.230769, 0.74359, 0.282051, 0.74359, 0.333333, 0.74359, 0.384615, 0.74359, 0.435897, 0.74359, 0.487179, 0.74359, 0.538462, 0.74359, 0.589744, 0.74359, 
0.641026, 0.74359, 0.692308, 0.74359, 0.74359, 0.74359, 0.794872, 0.74359, 0.846154, 0.74359, 0.897436, 0.74359, 0.948718, 0.74359, 1.0, 0.74359, 
-1.0, 0.794872, -0.948718, 0.794872, -0.897436, 0.794872, -0.846154, 0.794872, -0.794872, 0.794872, -0.74359, 0.794872, -0.692308, 0.794872, -0.641026, 0.794872, 
-0.589744, 0.794872, -0.538462, 0.794872, -0.48718, 0.794872, -0.435897, 0.794872, -0.384615, 0.794872, -0.333333, 0.794872, -0.282051, 0.794872, -0.230769, 0.794872, 
-0.179487, 0.794872, -0.128205, 0.794872, -0.076923, 0.794872, -0.025641, 0.794872, 0.025641, 0.794872, 0.076923, 0.794872, 0.128205, 0.794872, 0.179487, 0.794872, 
0.230769, 0.794872, 0.282051, 0.794872, 0.333333, 0.794872, 0.384615, 0.794872, 0.435897, 0.794872, 0.487179, 0.794872, 0.538462, 0.794872, 0.589744, 0.794872, 
0.641026, 0.794872, 0.692308, 0.794872, 0.74359, 0.794872, 0.794872, 0.794872, 0.846154, 0.794872, 0.897436, 0.794872, 0.948718, 0.794872, 1.0, 0.794872, 
-1.0, 0.846154, -0.948718, 0.846154, -0.897436, 0.846154, -0.846154, 0.846154, -0.794872, 0.846154, -0.74359, 0.846154, -0.692308, 0.846154, -0.641026, 0.846154, 
-0.589744, 0.846154, -0.538462, 0.846154, -0.48718, 0.846154, -0.435897, 0.846154, -0.384615, 0.846154, -0.333333, 0.846154, -0.282051, 0.846154, -0.230769, 0.846154, 
-0.179487, 0.846154, -0.128205, 0.846154, -0.076923, 0.846154, -0.025641, 0.846154, 0.025641, 0.846154, 0.076923, 0.846154, 0.128205, 0.846154, 0.179487, 0.846154, 
0.230769, 0.846154, 0.282051, 0.846154, 0.333333, 0.846154, 0.384615, 0.846154, 0.435897, 0.846154, 0.487179, 0.846154, 0.538462, 0.846154, 0.589744, 0.846154, 
0.641026, 0.846154, 0.692308, 0.846154, 0.74359, 0.846154, 0.794872, 0.846154, 0.846154, 0.846154, 0.897436, 0.846154, 0.948718, 0.846154, 1.0, 0.846154, 
-1.0, 0.897436, -0.948718, 0.897436, -0.897436, 0.897436, -0.846154, 0.897436, -0.794872, 0.897436, -0.74359, 0.897436, -0.692308, 0.897436, -0.641026, 0.897436, 
-0.589744, 0.897436, -0.538462, 0.897436, -0.48718, 0.897436, -0.435897, 0.897436, -0.384615, 0.897436, -0.333333, 0.897436, -0.282051, 0.897436, -0.230769, 0.897436, 
-0.179487, 0.897436, -0.128205, 0.897436, -0.076923, 0.897436, -0.025641, 0.897436, 0.025641, 0.897436, 0.076923, 0.897436, 0.128205, 0.897436, 0.179487, 0.897436, 
0.230769, 0.897436, 0.282051, 0.897436, 0.333333, 0.897436, 0.384615, 0.897436, 0.435897, 0.897436, 0.487179, 0.897436, 0.538462, 0.897436, 0.589744, 0.897436, 
0.641026, 0.897436, 0.692308, 0.897436, 0.74359, 0.897436, 0.794872, 0.897436, 0.846154, 0.897436, 0.897436, 0.897436, 0.948718, 0.897436, 1.0, 0.897436, 
-1.0, 0.948718, -0.948718, 0.948718, -0.897436, 0.948718, -0.846154, 0.948718, -0.794872, 0.948718, -0.74359, 0.948718, -0.692308, 0.948718, -0.641026, 0.948718, 
-0.589744, 0.948718, -0.538462, 0.948718, -0.48718, 0.948718, -0.435897, 0.948718, -0.384615, 0.948718, -0.333333, 0.948718, -0.282051, 0.948718, -0.230769, 0.948718, 
-0.179487, 0.948718, -0.128205, 0.948718, -0.076923, 0.948718, -0.025641, 0.948718, 0.025641, 0.948718, 0.076923, 0.948718, 0.128205, 0.948718, 0.179487, 0.948718, 
0.230769, 0.948718, 0.282051, 0.948718, 0.333333, 0.948718, 0.384615, 0.948718, 0.435897, 0.948718, 0.487179, 0.948718, 0.538462, 0.948718, 0.589744, 0.948718, 
0.641026, 0.948718, 0.692308, 0.948718, 0.74359, 0.948718, 0.794872, 0.948718, 0.846154, 0.948718, 0.897436, 0.948718, 0.948718, 0.948718, 1.0, 0.948718, 
-1.0, 1.0, -0.948718, 1.0, -0.897436, 1.0, -0.846154, 1.0, -0.794872, 1.0, -0.74359, 1.0, -0.692308, 1.0, -0.641026, 1.0, 
-0.589744, 1.0, -0.538462, 1.0, -0.48718, 1.0, -0.435897, 1.0, -0.384615, 1.0, -0.333333, 1.0, -0.282051, 1.0, -0.230769, 1.0, 
-0.179487, 1.0, -0.128205, 1.0, -0.076923, 1.0, -0.025641, 1.0, 0.025641, 1.0, 0.076923, 1.0, 0.128205, 1.0, 0.179487, 1.0, 
0.230769, 1.0, 0.282051, 1.0, 0.333333, 1.0, 0.384615, 1.0, 0.435897, 1.0, 0.487179, 1.0, 0.538462, 1.0, 0.589744, 1.0, 
0.641026, 1.0, 0.692308, 1.0, 0.74359, 1.0, 0.794872, 1.0, 0.846154, 1.0, 0.897436, 1.0, 0.948718, 1.0, 1.0, 1.0
};

static inline std::vector<float> input3 ={-1.0, -1.0, -0.894737, -1.0, -0.789474, -1.0, -0.684211, -1.0, -0.578947, -1.0, -0.473684, -1.0, -0.368421, -1.0, -0.263158, -1.0, 
-0.157895, -1.0, -0.052632, -1.0, 0.052632, -1.0, 0.157895, -1.0, 0.263158, -1.0, 0.368421, -1.0, 0.473684, -1.0, 0.578947, -1.0, 
0.684211, -1.0, 0.789474, -1.0, 0.894737, -1.0, 1.0, -1.0, -1.0, -0.894737, -0.894737, -0.894737, -0.789474, -0.894737, -0.684211, -0.894737, 
-0.578947, -0.894737, -0.473684, -0.894737, -0.368421, -0.894737, -0.263158, -0.894737, -0.157895, -0.894737, -0.052632, -0.894737, 0.052632, -0.894737, 0.157895, -0.894737, 
0.263158, -0.894737, 0.368421, -0.894737, 0.473684, -0.894737, 0.578947, -0.894737, 0.684211, -0.894737, 0.789474, -0.894737, 0.894737, -0.894737, 1.0, -0.894737, 
-1.0, -0.789474, -0.894737, -0.789474, -0.789474, -0.789474, -0.684211, -0.789474, -0.578947, -0.789474, -0.473684, -0.789474, -0.368421, -0.789474, -0.263158, -0.789474, 
-0.157895, -0.789474, -0.052632, -0.789474, 0.052632, -0.789474, 0.157895, -0.789474, 0.263158, -0.789474, 0.368421, -0.789474, 0.473684, -0.789474, 0.578947, -0.789474, 
0.684211, -0.789474, 0.789474, -0.789474, 0.894737, -0.789474, 1.0, -0.789474, -1.0, -0.684211, -0.894737, -0.684211, -0.789474, -0.684211, -0.684211, -0.684211, 
-0.578947, -0.684211, -0.473684, -0.684211, -0.368421, -0.684211, -0.263158, -0.684211, -0.157895, -0.684211, -0.052632, -0.684211, 0.052632, -0.684211, 0.157895, -0.684211, 
0.263158, -0.684211, 0.368421, -0.684211, 0.473684, -0.684211, 0.578947, -0.684211, 0.684211, -0.684211, 0.789474, -0.684211, 0.894737, -0.684211, 1.0, -0.684211, 
-1.0, -0.578947, -0.894737, -0.578947, -0.789474, -0.578947, -0.684211, -0.578947, -0.578947, -0.578947, -0.473684, -0.578947, -0.368421, -0.578947, -0.263158, -0.578947, 
-0.157895, -0.578947, -0.052632, -0.578947, 0.052632, -0.578947, 0.157895, -0.578947, 0.263158, -0.578947, 0.368421, -0.578947, 0.473684, -0.578947, 0.578947, -0.578947, 
0.684211, -0.578947, 0.789474, -0.578947, 0.894737, -0.578947, 1.0, -0.578947, -1.0, -0.473684, -0.894737, -0.473684, -0.789474, -0.473684, -0.684211, -0.473684, 
-0.578947, -0.473684, -0.473684, -0.473684, -0.368421, -0.473684, -0.263158, -0.473684, -0.157895, -0.473684, -0.052632, -0.473684, 0.052632, -0.473684, 0.157895, -0.473684, 
0.263158, -0.473684, 0.368421, -0.473684, 0.473684, -0.473684, 0.578947, -0.473684, 0.684211, -0.473684, 0.789474, -0.473684, 0.894737, -0.473684, 1.0, -0.473684, 
-1.0, -0.368421, -0.894737, -0.368421, -0.789474, -0.368421, -0.684211, -0.368421, -0.578947, -0.368421, -0.473684, -0.368421, -0.368421, -0.368421, -0.263158, -0.368421, 
-0.157895, -0.368421, -0.052632, -0.368421, 0.052632, -0.368421, 0.157895, -0.368421, 0.263158, -0.368421, 0.368421, -0.368421, 0.473684, -0.368421, 0.578947, -0.368421, 
0.684211, -0.368421, 0.789474, -0.368421, 0.894737, -0.368421, 1.0, -0.368421, -1.0, -0.263158, -0.894737, -0.263158, -0.789474, -0.263158, -0.684211, -0.263158, 
-0.578947, -0.263158, -0.473684, -0.263158, -0.368421, -0.263158, -0.263158, -0.263158, -0.157895, -0.263158, -0.052632, -0.263158, 0.052632, -0.263158, 0.157895, -0.263158, 
0.263158, -0.263158, 0.368421, -0.263158, 0.473684, -0.263158, 0.578947, -0.263158, 0.684211, -0.263158, 0.789474, -0.263158, 0.894737, -0.263158, 1.0, -0.263158, 
-1.0, -0.157895, -0.894737, -0.157895, -0.789474, -0.157895, -0.684211, -0.157895, -0.578947, -0.157895, -0.473684, -0.157895, -0.368421, -0.157895, -0.263158, -0.157895, 
-0.157895, -0.157895, -0.052632, -0.157895, 0.052632, -0.157895, 0.157895, -0.157895, 0.263158, -0.157895, 0.368421, -0.157895, 0.473684, -0.157895, 0.578947, -0.157895, 
0.684211, -0.157895, 0.789474, -0.157895, 0.894737, -0.157895, 1.0, -0.157895, -1.0, -0.052632, -0.894737, -0.052632, -0.789474, -0.052632, -0.684211, -0.052632, 
-0.578947, -0.052632, -0.473684, -0.052632, -0.368421, -0.052632, -0.263158, -0.052632, -0.157895, -0.052632, -0.052632, -0.052632, 0.052632, -0.052632, 0.157895, -0.052632, 
0.263158, -0.052632, 0.368421, -0.052632, 0.473684, -0.052632, 0.578947, -0.052632, 0.684211, -0.052632, 0.789474, -0.052632, 0.894737, -0.052632, 1.0, -0.052632, 
-1.0, 0.052632, -0.894737, 0.052632, -0.789474, 0.052632, -0.684211, 0.052632, -0.578947, 0.052632, -0.473684, 0.052632, -0.368421, 0.052632, -0.263158, 0.052632, 
-0.157895, 0.052632, -0.052632, 0.052632, 0.052632, 0.052632, 0.157895, 0.052632, 0.263158, 0.052632, 0.368421, 0.052632, 0.473684, 0.052632, 0.578947, 0.052632, 
0.684211, 0.052632, 0.789474, 0.052632, 0.894737, 0.052632, 1.0, 0.052632, -1.0, 0.157895, -0.894737, 0.157895, -0.789474, 0.157895, -0.684211, 0.157895, 
-0.578947, 0.157895, -0.473684, 0.157895, -0.368421, 0.157895, -0.263158, 0.157895, -0.157895, 0.157895, -0.052632, 0.157895, 0.052632, 0.157895, 0.157895, 0.157895, 
0.263158, 0.157895, 0.368421, 0.157895, 0.473684, 0.157895, 0.578947, 0.157895, 0.684211, 0.157895, 0.789474, 0.157895, 0.894737, 0.157895, 1.0, 0.157895, 
-1.0, 0.263158, -0.894737, 0.263158, -0.789474, 0.263158, -0.684211, 0.263158, -0.578947, 0.263158, -0.473684, 0.263158, -0.368421, 0.263158, -0.263158, 0.263158, 
-0.157895, 0.263158, -0.052632, 0.263158, 0.052632, 0.263158, 0.157895, 0.263158, 0.263158, 0.263158, 0.368421, 0.263158, 0.473684, 0.263158, 0.578947, 0.263158, 
0.684211, 0.263158, 0.789474, 0.263158, 0.894737, 0.263158, 1.0, 0.263158, -1.0, 0.368421, -0.894737, 0.368421, -0.789474, 0.368421, -0.684211, 0.368421, 
-0.578947, 0.368421, -0.473684, 0.368421, -0.368421, 0.368421, -0.263158, 0.368421, -0.157895, 0.368421, -0.052632, 0.368421, 0.052632, 0.368421, 0.157895, 0.368421, 
0.263158, 0.368421, 0.368421, 0.368421, 0.473684, 0.368421, 0.578947, 0.368421, 0.684211, 0.368421, 0.789474, 0.368421, 0.894737, 0.368421, 1.0, 0.368421, 
-1.0, 0.473684, -0.894737, 0.473684, -0.789474, 0.473684, -0.684211, 0.473684, -0.578947, 0.473684, -0.473684, 0.473684, -0.368421, 0.473684, -0.263158, 0.473684, 
-0.157895, 0.473684, -0.052632, 0.473684, 0.052632, 0.473684, 0.157895, 0.473684, 0.263158, 0.473684, 0.368421, 0.473684, 0.473684, 0.473684, 0.578947, 0.473684, 
0.684211, 0.473684, 0.789474, 0.473684, 0.894737, 0.473684, 1.0, 0.473684, -1.0, 0.578947, -0.894737, 0.578947, -0.789474, 0.578947, -0.684211, 0.578947, 
-0.578947, 0.578947, -0.473684, 0.578947, -0.368421, 0.578947, -0.263158, 0.578947, -0.157895, 0.578947, -0.052632, 0.578947, 0.052632, 0.578947, 0.157895, 0.578947, 
0.263158, 0.578947, 0.368421, 0.578947, 0.473684, 0.578947, 0.578947, 0.578947, 0.684211, 0.578947, 0.789474, 0.578947, 0.894737, 0.578947, 1.0, 0.578947, 
-1.0, 0.684211, -0.894737, 0.684211, -0.789474, 0.684211, -0.684211, 0.684211, -0.578947, 0.684211, -0.473684, 0.684211, -0.368421, 0.684211, -0.263158, 0.684211, 
-0.157895, 0.684211, -0.052632, 0.684211, 0.052632, 0.684211, 0.157895, 0.684211, 0.263158, 0.684211, 0.368421, 0.684211, 0.473684, 0.684211, 0.578947, 0.684211, 
0.684211, 0.684211, 0.789474, 0.684211, 0.894737, 0.684211, 1.0, 0.684211, -1.0, 0.789474, -0.894737, 0.789474, -0.789474, 0.789474, -0.684211, 0.789474, 
-0.578947, 0.789474, -0.473684, 0.789474, -0.368421, 0.789474, -0.263158, 0.789474, -0.157895, 0.789474, -0.052632, 0.789474, 0.052632, 0.789474, 0.157895, 0.789474, 
0.263158, 0.789474, 0.368421, 0.789474, 0.473684, 0.789474, 0.578947, 0.789474, 0.684211, 0.789474, 0.789474, 0.789474, 0.894737, 0.789474, 1.0, 0.789474, 
-1.0, 0.894737, -0.894737, 0.894737, -0.789474, 0.894737, -0.684211, 0.894737, -0.578947, 0.894737, -0.473684, 0.894737, -0.368421, 0.894737, -0.263158, 0.894737, 
-0.157895, 0.894737, -0.052632, 0.894737, 0.052632, 0.894737, 0.157895, 0.894737, 0.263158, 0.894737, 0.368421, 0.894737, 0.473684, 0.894737, 0.578947, 0.894737, 
0.684211, 0.894737, 0.789474, 0.894737, 0.894737, 0.894737, 1.0, 0.894737, -1.0, 1.0, -0.894737, 1.0, -0.789474, 1.0, -0.684211, 1.0, 
-0.578947, 1.0, -0.473684, 1.0, -0.368421, 1.0, -0.263158, 1.0, -0.157895, 1.0, -0.052632, 1.0, 0.052632, 1.0, 0.157895, 1.0, 
0.263158, 1.0, 0.368421, 1.0, 0.473684, 1.0, 0.578947, 1.0, 0.684211, 1.0, 0.789474, 1.0, 0.894737, 1.0, 1.0, 1.0
};

static inline std::vector<float> input4 ={-1.0, -1.0, -0.894737, -1.0, -0.789474, -1.0, -0.684211, -1.0, -0.578947, -1.0, -0.473684, -1.0, -0.368421, -1.0, -0.263158, -1.0, 
-0.157895, -1.0, -0.052632, -1.0, 0.052632, -1.0, 0.157895, -1.0, 0.263158, -1.0, 0.368421, -1.0, 0.473684, -1.0, 0.578947, -1.0, 
0.684211, -1.0, 0.789474, -1.0, 0.894737, -1.0, 1.0, -1.0, -1.0, -0.894737, -0.894737, -0.894737, -0.789474, -0.894737, -0.684211, -0.894737, 
-0.578947, -0.894737, -0.473684, -0.894737, -0.368421, -0.894737, -0.263158, -0.894737, -0.157895, -0.894737, -0.052632, -0.894737, 0.052632, -0.894737, 0.157895, -0.894737, 
0.263158, -0.894737, 0.368421, -0.894737, 0.473684, -0.894737, 0.578947, -0.894737, 0.684211, -0.894737, 0.789474, -0.894737, 0.894737, -0.894737, 1.0, -0.894737, 
-1.0, -0.789474, -0.894737, -0.789474, -0.789474, -0.789474, -0.684211, -0.789474, -0.578947, -0.789474, -0.473684, -0.789474, -0.368421, -0.789474, -0.263158, -0.789474, 
-0.157895, -0.789474, -0.052632, -0.789474, 0.052632, -0.789474, 0.157895, -0.789474, 0.263158, -0.789474, 0.368421, -0.789474, 0.473684, -0.789474, 0.578947, -0.789474, 
0.684211, -0.789474, 0.789474, -0.789474, 0.894737, -0.789474, 1.0, -0.789474, -1.0, -0.684211, -0.894737, -0.684211, -0.789474, -0.684211, -0.684211, -0.684211, 
-0.578947, -0.684211, -0.473684, -0.684211, -0.368421, -0.684211, -0.263158, -0.684211, -0.157895, -0.684211, -0.052632, -0.684211, 0.052632, -0.684211, 0.157895, -0.684211, 
0.263158, -0.684211, 0.368421, -0.684211, 0.473684, -0.684211, 0.578947, -0.684211, 0.684211, -0.684211, 0.789474, -0.684211, 0.894737, -0.684211, 1.0, -0.684211, 
-1.0, -0.578947, -0.894737, -0.578947, -0.789474, -0.578947, -0.684211, -0.578947, -0.578947, -0.578947, -0.473684, -0.578947, -0.368421, -0.578947, -0.263158, -0.578947, 
-0.157895, -0.578947, -0.052632, -0.578947, 0.052632, -0.578947, 0.157895, -0.578947, 0.263158, -0.578947, 0.368421, -0.578947, 0.473684, -0.578947, 0.578947, -0.578947, 
0.684211, -0.578947, 0.789474, -0.578947, 0.894737, -0.578947, 1.0, -0.578947, -1.0, -0.473684, -0.894737, -0.473684, -0.789474, -0.473684, -0.684211, -0.473684, 
-0.578947, -0.473684, -0.473684, -0.473684, -0.368421, -0.473684, -0.263158, -0.473684, -0.157895, -0.473684, -0.052632, -0.473684, 0.052632, -0.473684, 0.157895, -0.473684, 
0.263158, -0.473684, 0.368421, -0.473684, 0.473684, -0.473684, 0.578947, -0.473684, 0.684211, -0.473684, 0.789474, -0.473684, 0.894737, -0.473684, 1.0, -0.473684, 
-1.0, -0.368421, -0.894737, -0.368421, -0.789474, -0.368421, -0.684211, -0.368421, -0.578947, -0.368421, -0.473684, -0.368421, -0.368421, -0.368421, -0.263158, -0.368421, 
-0.157895, -0.368421, -0.052632, -0.368421, 0.052632, -0.368421, 0.157895, -0.368421, 0.263158, -0.368421, 0.368421, -0.368421, 0.473684, -0.368421, 0.578947, -0.368421, 
0.684211, -0.368421, 0.789474, -0.368421, 0.894737, -0.368421, 1.0, -0.368421, -1.0, -0.263158, -0.894737, -0.263158, -0.789474, -0.263158, -0.684211, -0.263158, 
-0.578947, -0.263158, -0.473684, -0.263158, -0.368421, -0.263158, -0.263158, -0.263158, -0.157895, -0.263158, -0.052632, -0.263158, 0.052632, -0.263158, 0.157895, -0.263158, 
0.263158, -0.263158, 0.368421, -0.263158, 0.473684, -0.263158, 0.578947, -0.263158, 0.684211, -0.263158, 0.789474, -0.263158, 0.894737, -0.263158, 1.0, -0.263158, 
-1.0, -0.157895, -0.894737, -0.157895, -0.789474, -0.157895, -0.684211, -0.157895, -0.578947, -0.157895, -0.473684, -0.157895, -0.368421, -0.157895, -0.263158, -0.157895, 
-0.157895, -0.157895, -0.052632, -0.157895, 0.052632, -0.157895, 0.157895, -0.157895, 0.263158, -0.157895, 0.368421, -0.157895, 0.473684, -0.157895, 0.578947, -0.157895, 
0.684211, -0.157895, 0.789474, -0.157895, 0.894737, -0.157895, 1.0, -0.157895, -1.0, -0.052632, -0.894737, -0.052632, -0.789474, -0.052632, -0.684211, -0.052632, 
-0.578947, -0.052632, -0.473684, -0.052632, -0.368421, -0.052632, -0.263158, -0.052632, -0.157895, -0.052632, -0.052632, -0.052632, 0.052632, -0.052632, 0.157895, -0.052632, 
0.263158, -0.052632, 0.368421, -0.052632, 0.473684, -0.052632, 0.578947, -0.052632, 0.684211, -0.052632, 0.789474, -0.052632, 0.894737, -0.052632, 1.0, -0.052632, 
-1.0, 0.052632, -0.894737, 0.052632, -0.789474, 0.052632, -0.684211, 0.052632, -0.578947, 0.052632, -0.473684, 0.052632, -0.368421, 0.052632, -0.263158, 0.052632, 
-0.157895, 0.052632, -0.052632, 0.052632, 0.052632, 0.052632, 0.157895, 0.052632, 0.263158, 0.052632, 0.368421, 0.052632, 0.473684, 0.052632, 0.578947, 0.052632, 
0.684211, 0.052632, 0.789474, 0.052632, 0.894737, 0.052632, 1.0, 0.052632, -1.0, 0.157895, -0.894737, 0.157895, -0.789474, 0.157895, -0.684211, 0.157895, 
-0.578947, 0.157895, -0.473684, 0.157895, -0.368421, 0.157895, -0.263158, 0.157895, -0.157895, 0.157895, -0.052632, 0.157895, 0.052632, 0.157895, 0.157895, 0.157895, 
0.263158, 0.157895, 0.368421, 0.157895, 0.473684, 0.157895, 0.578947, 0.157895, 0.684211, 0.157895, 0.789474, 0.157895, 0.894737, 0.157895, 1.0, 0.157895, 
-1.0, 0.263158, -0.894737, 0.263158, -0.789474, 0.263158, -0.684211, 0.263158, -0.578947, 0.263158, -0.473684, 0.263158, -0.368421, 0.263158, -0.263158, 0.263158, 
-0.157895, 0.263158, -0.052632, 0.263158, 0.052632, 0.263158, 0.157895, 0.263158, 0.263158, 0.263158, 0.368421, 0.263158, 0.473684, 0.263158, 0.578947, 0.263158, 
0.684211, 0.263158, 0.789474, 0.263158, 0.894737, 0.263158, 1.0, 0.263158, -1.0, 0.368421, -0.894737, 0.368421, -0.789474, 0.368421, -0.684211, 0.368421, 
-0.578947, 0.368421, -0.473684, 0.368421, -0.368421, 0.368421, -0.263158, 0.368421, -0.157895, 0.368421, -0.052632, 0.368421, 0.052632, 0.368421, 0.157895, 0.368421, 
0.263158, 0.368421, 0.368421, 0.368421, 0.473684, 0.368421, 0.578947, 0.368421, 0.684211, 0.368421, 0.789474, 0.368421, 0.894737, 0.368421, 1.0, 0.368421, 
-1.0, 0.473684, -0.894737, 0.473684, -0.789474, 0.473684, -0.684211, 0.473684, -0.578947, 0.473684, -0.473684, 0.473684, -0.368421, 0.473684, -0.263158, 0.473684, 
-0.157895, 0.473684, -0.052632, 0.473684, 0.052632, 0.473684, 0.157895, 0.473684, 0.263158, 0.473684, 0.368421, 0.473684, 0.473684, 0.473684, 0.578947, 0.473684, 
0.684211, 0.473684, 0.789474, 0.473684, 0.894737, 0.473684, 1.0, 0.473684, -1.0, 0.578947, -0.894737, 0.578947, -0.789474, 0.578947, -0.684211, 0.578947, 
-0.578947, 0.578947, -0.473684, 0.578947, -0.368421, 0.578947, -0.263158, 0.578947, -0.157895, 0.578947, -0.052632, 0.578947, 0.052632, 0.578947, 0.157895, 0.578947, 
0.263158, 0.578947, 0.368421, 0.578947, 0.473684, 0.578947, 0.578947, 0.578947, 0.684211, 0.578947, 0.789474, 0.578947, 0.894737, 0.578947, 1.0, 0.578947, 
-1.0, 0.684211, -0.894737, 0.684211, -0.789474, 0.684211, -0.684211, 0.684211, -0.578947, 0.684211, -0.473684, 0.684211, -0.368421, 0.684211, -0.263158, 0.684211, 
-0.157895, 0.684211, -0.052632, 0.684211, 0.052632, 0.684211, 0.157895, 0.684211, 0.263158, 0.684211, 0.368421, 0.684211, 0.473684, 0.684211, 0.578947, 0.684211, 
0.684211, 0.684211, 0.789474, 0.684211, 0.894737, 0.684211, 1.0, 0.684211, -1.0, 0.789474, -0.894737, 0.789474, -0.789474, 0.789474, -0.684211, 0.789474, 
-0.578947, 0.789474, -0.473684, 0.789474, -0.368421, 0.789474, -0.263158, 0.789474, -0.157895, 0.789474, -0.052632, 0.789474, 0.052632, 0.789474, 0.157895, 0.789474, 
0.263158, 0.789474, 0.368421, 0.789474, 0.473684, 0.789474, 0.578947, 0.789474, 0.684211, 0.789474, 0.789474, 0.789474, 0.894737, 0.789474, 1.0, 0.789474, 
-1.0, 0.894737, -0.894737, 0.894737, -0.789474, 0.894737, -0.684211, 0.894737, -0.578947, 0.894737, -0.473684, 0.894737, -0.368421, 0.894737, -0.263158, 0.894737, 
-0.157895, 0.894737, -0.052632, 0.894737, 0.052632, 0.894737, 0.157895, 0.894737, 0.263158, 0.894737, 0.368421, 0.894737, 0.473684, 0.894737, 0.578947, 0.894737, 
0.684211, 0.894737, 0.789474, 0.894737, 0.894737, 0.894737, 1.0, 0.894737, -1.0, 1.0, -0.894737, 1.0, -0.789474, 1.0, -0.684211, 1.0, 
-0.578947, 1.0, -0.473684, 1.0, -0.368421, 1.0, -0.263158, 1.0, -0.157895, 1.0, -0.052632, 1.0, 0.052632, 1.0, 0.157895, 1.0, 
0.263158, 1.0, 0.368421, 1.0, 0.473684, 1.0, 0.578947, 1.0, 0.684211, 1.0, 0.789474, 1.0, 0.894737, 1.0, 1.0, 1.0
};
