/* CRC-32 and CRC-32C slicing-by-8 constants, for use on big-endian systems. */
static const unsigned int __attribute__((aligned(128))) crc32table_le[8][256] = {
	{
	0x00000000, 0x96300777, 0x2c610eee, 0xba510999,
	0x19c46d07, 0x8ff46a70, 0x35a563e9, 0xa395649e,
	0x3288db0e, 0xa4b8dc79, 0x1ee9d5e0, 0x88d9d297,
	0x2b4cb609, 0xbd7cb17e, 0x072db8e7, 0x911dbf90,
	0x6410b71d, 0xf220b06a, 0x4871b9f3, 0xde41be84,
	0x7dd4da1a, 0xebe4dd6d, 0x51b5d4f4, 0xc785d383,
	0x56986c13, 0xc0a86b64, 0x7af962fd, 0xecc9658a,
	0x4f5c0114, 0xd96c0663, 0x633d0ffa, 0xf50d088d,
	0xc8206e3b, 0x5e10694c, 0xe44160d5, 0x727167a2,
	0xd1e4033c, 0x47d4044b, 0xfd850dd2, 0x6bb50aa5,
	0xfaa8b535, 0x6c98b242, 0xd6c9bbdb, 0x40f9bcac,
	0xe36cd832, 0x755cdf45, 0xcf0dd6dc, 0x593dd1ab,
	0xac30d926, 0x3a00de51, 0x8051d7c8, 0x1661d0bf,
	0xb5f4b421, 0x23c4b356, 0x9995bacf, 0x0fa5bdb8,
	0x9eb80228, 0x0888055f, 0xb2d90cc6, 0x24e90bb1,
	0x877c6f2f, 0x114c6858, 0xab1d61c1, 0x3d2d66b6,
	0x9041dc76, 0x0671db01, 0xbc20d298, 0x2a10d5ef,
	0x8985b171, 0x1fb5b606, 0xa5e4bf9f, 0x33d4b8e8,
	0xa2c90778, 0x34f9000f, 0x8ea80996, 0x18980ee1,
	0xbb0d6a7f, 0x2d3d6d08, 0x976c6491, 0x015c63e6,
	0xf4516b6b, 0x62616c1c, 0xd8306585, 0x4e0062f2,
	0xed95066c, 0x7ba5011b, 0xc1f40882, 0x57c40ff5,
	0xc6d9b065, 0x50e9b712, 0xeab8be8b, 0x7c88b9fc,
	0xdf1ddd62, 0x492dda15, 0xf37cd38c, 0x654cd4fb,
	0x5861b24d, 0xce51b53a, 0x7400bca3, 0xe230bbd4,
	0x41a5df4a, 0xd795d83d, 0x6dc4d1a4, 0xfbf4d6d3,
	0x6ae96943, 0xfcd96e34, 0x468867ad, 0xd0b860da,
	0x732d0444, 0xe51d0333, 0x5f4c0aaa, 0xc97c0ddd,
	0x3c710550, 0xaa410227, 0x10100bbe, 0x86200cc9,
	0x25b56857, 0xb3856f20, 0x09d466b9, 0x9fe461ce,
	0x0ef9de5e, 0x98c9d929, 0x2298d0b0, 0xb4a8d7c7,
	0x173db359, 0x810db42e, 0x3b5cbdb7, 0xad6cbac0,
	0x2083b8ed, 0xb6b3bf9a, 0x0ce2b603, 0x9ad2b174,
	0x3947d5ea, 0xaf77d29d, 0x1526db04, 0x8316dc73,
	0x120b63e3, 0x843b6494, 0x3e6a6d0d, 0xa85a6a7a,
	0x0bcf0ee4, 0x9dff0993, 0x27ae000a, 0xb19e077d,
	0x44930ff0, 0xd2a30887, 0x68f2011e, 0xfec20669,
	0x5d5762f7, 0xcb676580, 0x71366c19, 0xe7066b6e,
	0x761bd4fe, 0xe02bd389, 0x5a7ada10, 0xcc4add67,
	0x6fdfb9f9, 0xf9efbe8e, 0x43beb717, 0xd58eb060,
	0xe8a3d6d6, 0x7e93d1a1, 0xc4c2d838, 0x52f2df4f,
	0xf167bbd1, 0x6757bca6, 0xdd06b53f, 0x4b36b248,
	0xda2b0dd8, 0x4c1b0aaf, 0xf64a0336, 0x607a0441,
	0xc3ef60df, 0x55df67a8, 0xef8e6e31, 0x79be6946,
	0x8cb361cb, 0x1a8366bc, 0xa0d26f25, 0x36e26852,
	0x95770ccc, 0x03470bbb, 0xb9160222, 0x2f260555,
	0xbe3bbac5, 0x280bbdb2, 0x925ab42b, 0x046ab35c,
	0xa7ffd7c2, 0x31cfd0b5, 0x8b9ed92c, 0x1daede5b,
	0xb0c2649b, 0x26f263ec, 0x9ca36a75, 0x0a936d02,
	0xa906099c, 0x3f360eeb, 0x85670772, 0x13570005,
	0x824abf95, 0x147ab8e2, 0xae2bb17b, 0x381bb60c,
	0x9b8ed292, 0x0dbed5e5, 0xb7efdc7c, 0x21dfdb0b,
	0xd4d2d386, 0x42e2d4f1, 0xf8b3dd68, 0x6e83da1f,
	0xcd16be81, 0x5b26b9f6, 0xe177b06f, 0x7747b718,
	0xe65a0888, 0x706a0fff, 0xca3b0666, 0x5c0b0111,
	0xff9e658f, 0x69ae62f8, 0xd3ff6b61, 0x45cf6c16,
	0x78e20aa0, 0xeed20dd7, 0x5483044e, 0xc2b30339,
	0x612667a7, 0xf71660d0, 0x4d476949, 0xdb776e3e,
	0x4a6ad1ae, 0xdc5ad6d9, 0x660bdf40, 0xf03bd837,
	0x53aebca9, 0xc59ebbde, 0x7fcfb247, 0xe9ffb530,
	0x1cf2bdbd, 0x8ac2baca, 0x3093b353, 0xa6a3b424,
	0x0536d0ba, 0x9306d7cd, 0x2957de54, 0xbf67d923,
	0x2e7a66b3, 0xb84a61c4, 0x021b685d, 0x942b6f2a,
	0x37be0bb4, 0xa18e0cc3, 0x1bdf055a, 0x8def022d
	},{
	0x00000000, 0x41311b19, 0x82623632, 0xc3532d2b,
	0x04c56c64, 0x45f4777d, 0x86a75a56, 0xc796414f,
	0x088ad9c8, 0x49bbc2d1, 0x8ae8effa, 0xcbd9f4e3,
	0x0c4fb5ac, 0x4d7eaeb5, 0x8e2d839e, 0xcf1c9887,
	0x5112c24a, 0x1023d953, 0xd370f478, 0x9241ef61,
	0x55d7ae2e, 0x14e6b537, 0xd7b5981c, 0x96848305,
	0x59981b82, 0x18a9009b, 0xdbfa2db0, 0x9acb36a9,
	0x5d5d77e6, 0x1c6c6cff, 0xdf3f41d4, 0x9e0e5acd,
	0xa2248495, 0xe3159f8c, 0x2046b2a7, 0x6177a9be,
	0xa6e1e8f1, 0xe7d0f3e8, 0x2483dec3, 0x65b2c5da,
	0xaaae5d5d, 0xeb9f4644, 0x28cc6b6f, 0x69fd7076,
	0xae6b3139, 0xef5a2a20, 0x2c09070b, 0x6d381c12,
	0xf33646df, 0xb2075dc6, 0x715470ed, 0x30656bf4,
	0xf7f32abb, 0xb6c231a2, 0x75911c89, 0x34a00790,
	0xfbbc9f17, 0xba8d840e, 0x79dea925, 0x38efb23c,
	0xff79f373, 0xbe48e86a, 0x7d1bc541, 0x3c2ade58,
	0x054f79f0, 0x447e62e9, 0x872d4fc2, 0xc61c54db,
	0x018a1594, 0x40bb0e8d, 0x83e823a6, 0xc2d938bf,
	0x0dc5a038, 0x4cf4bb21, 0x8fa7960a, 0xce968d13,
	0x0900cc5c, 0x4831d745, 0x8b62fa6e, 0xca53e177,
	0x545dbbba, 0x156ca0a3, 0xd63f8d88, 0x970e9691,
	0x5098d7de, 0x11a9ccc7, 0xd2fae1ec, 0x93cbfaf5,
	0x5cd76272, 0x1de6796b, 0xdeb55440, 0x9f844f59,
	0x58120e16, 0x1923150f, 0xda703824, 0x9b41233d,
	0xa76bfd65, 0xe65ae67c, 0x2509cb57, 0x6438d04e,
	0xa3ae9101, 0xe29f8a18, 0x21cca733, 0x60fdbc2a,
	0xafe124ad, 0xeed03fb4, 0x2d83129f, 0x6cb20986,
	0xab2448c9, 0xea1553d0, 0x29467efb, 0x687765e2,
	0xf6793f2f, 0xb7482436, 0x741b091d, 0x352a1204,
	0xf2bc534b, 0xb38d4852, 0x70de6579, 0x31ef7e60,
	0xfef3e6e7, 0xbfc2fdfe, 0x7c91d0d5, 0x3da0cbcc,
	0xfa368a83, 0xbb07919a, 0x7854bcb1, 0x3965a7a8,
	0x4b98833b, 0x0aa99822, 0xc9fab509, 0x88cbae10,
	0x4f5def5f, 0x0e6cf446, 0xcd3fd96d, 0x8c0ec274,
	0x43125af3, 0x022341ea, 0xc1706cc1, 0x804177d8,
	0x47d73697, 0x06e62d8e, 0xc5b500a5, 0x84841bbc,
	0x1a8a4171, 0x5bbb5a68, 0x98e87743, 0xd9d96c5a,
	0x1e4f2d15, 0x5f7e360c, 0x9c2d1b27, 0xdd1c003e,
	0x120098b9, 0x533183a0, 0x9062ae8b, 0xd153b592,
	0x16c5f4dd, 0x57f4efc4, 0x94a7c2ef, 0xd596d9f6,
	0xe9bc07ae, 0xa88d1cb7, 0x6bde319c, 0x2aef2a85,
	0xed796bca, 0xac4870d3, 0x6f1b5df8, 0x2e2a46e1,
	0xe136de66, 0xa007c57f, 0x6354e854, 0x2265f34d,
	0xe5f3b202, 0xa4c2a91b, 0x67918430, 0x26a09f29,
	0xb8aec5e4, 0xf99fdefd, 0x3accf3d6, 0x7bfde8cf,
	0xbc6ba980, 0xfd5ab299, 0x3e099fb2, 0x7f3884ab,
	0xb0241c2c, 0xf1150735, 0x32462a1e, 0x73773107,
	0xb4e17048, 0xf5d06b51, 0x3683467a, 0x77b25d63,
	0x4ed7facb, 0x0fe6e1d2, 0xccb5ccf9, 0x8d84d7e0,
	0x4a1296af, 0x0b238db6, 0xc870a09d, 0x8941bb84,
	0x465d2303, 0x076c381a, 0xc43f1531, 0x850e0e28,
	0x42984f67, 0x03a9547e, 0xc0fa7955, 0x81cb624c,
	0x1fc53881, 0x5ef42398, 0x9da70eb3, 0xdc9615aa,
	0x1b0054e5, 0x5a314ffc, 0x996262d7, 0xd85379ce,
	0x174fe149, 0x567efa50, 0x952dd77b, 0xd41ccc62,
	0x138a8d2d, 0x52bb9634, 0x91e8bb1f, 0xd0d9a006,
	0xecf37e5e, 0xadc26547, 0x6e91486c, 0x2fa05375,
	0xe836123a, 0xa9070923, 0x6a542408, 0x2b653f11,
	0xe479a796, 0xa548bc8f, 0x661b91a4, 0x272a8abd,
	0xe0bccbf2, 0xa18dd0eb, 0x62defdc0, 0x23efe6d9,
	0xbde1bc14, 0xfcd0a70d, 0x3f838a26, 0x7eb2913f,
	0xb924d070, 0xf815cb69, 0x3b46e642, 0x7a77fd5b,
	0xb56b65dc, 0xf45a7ec5, 0x370953ee, 0x763848f7,
	0xb1ae09b8, 0xf09f12a1, 0x33cc3f8a, 0x72fd2493
	},{
	0x00000000, 0x376ac201, 0x6ed48403, 0x59be4602,
	0xdca80907, 0xebc2cb06, 0xb27c8d04, 0x85164f05,
	0xb851130e, 0x8f3bd10f, 0xd685970d, 0xe1ef550c,
	0x64f91a09, 0x5393d808, 0x0a2d9e0a, 0x3d475c0b,
	0x70a3261c, 0x47c9e41d, 0x1e77a21f, 0x291d601e,
	0xac0b2f1b, 0x9b61ed1a, 0xc2dfab18, 0xf5b56919,
	0xc8f23512, 0xff98f713, 0xa626b111, 0x914c7310,
	0x145a3c15, 0x2330fe14, 0x7a8eb816, 0x4de47a17,
	0xe0464d38, 0xd72c8f39, 0x8e92c93b, 0xb9f80b3a,
	0x3cee443f, 0x0b84863e, 0x523ac03c, 0x6550023d,
	0x58175e36, 0x6f7d9c37, 0x36c3da35, 0x01a91834,
	0x84bf5731, 0xb3d59530, 0xea6bd332, 0xdd011133,
	0x90e56b24, 0xa78fa925, 0xfe31ef27, 0xc95b2d26,
	0x4c4d6223, 0x7b27a022, 0x2299e620, 0x15f32421,
	0x28b4782a, 0x1fdeba2b, 0x4660fc29, 0x710a3e28,
	0xf41c712d, 0xc376b32c, 0x9ac8f52e, 0xada2372f,
	0xc08d9a70, 0xf7e75871, 0xae591e73, 0x9933dc72,
	0x1c259377, 0x2b4f5176, 0x72f11774, 0x459bd575,
	0x78dc897e, 0x4fb64b7f, 0x16080d7d, 0x2162cf7c,
	0xa4748079, 0x931e4278, 0xcaa0047a, 0xfdcac67b,
	0xb02ebc6c, 0x87447e6d, 0xdefa386f, 0xe990fa6e,
	0x6c86b56b, 0x5bec776a, 0x02523168, 0x3538f369,
	0x087faf62, 0x3f156d63, 0x66ab2b61, 0x51c1e960,
	0xd4d7a665, 0xe3bd6464, 0xba032266, 0x8d69e067,
	0x20cbd748, 0x17a11549, 0x4e1f534b, 0x7975914a,
	0xfc63de4f, 0xcb091c4e, 0x92b75a4c, 0xa5dd984d,
	0x989ac446, 0xaff00647, 0xf64e4045, 0xc1248244,
	0x4432cd41, 0x73580f40, 0x2ae64942, 0x1d8c8b43,
	0x5068f154, 0x67023355, 0x3ebc7557, 0x09d6b756,
	0x8cc0f853, 0xbbaa3a52, 0xe2147c50, 0xd57ebe51,
	0xe839e25a, 0xdf53205b, 0x86ed6659, 0xb187a458,
	0x3491eb5d, 0x03fb295c, 0x5a456f5e, 0x6d2fad5f,
	0x801b35e1, 0xb771f7e0, 0xeecfb1e2, 0xd9a573e3,
	0x5cb33ce6, 0x6bd9fee7, 0x3267b8e5, 0x050d7ae4,
	0x384a26ef, 0x0f20e4ee, 0x569ea2ec, 0x61f460ed,
	0xe4e22fe8, 0xd388ede9, 0x8a36abeb, 0xbd5c69ea,
	0xf0b813fd, 0xc7d2d1fc, 0x9e6c97fe, 0xa90655ff,
	0x2c101afa, 0x1b7ad8fb, 0x42c49ef9, 0x75ae5cf8,
	0x48e900f3, 0x7f83c2f2, 0x263d84f0, 0x115746f1,
	0x944109f4, 0xa32bcbf5, 0xfa958df7, 0xcdff4ff6,
	0x605d78d9, 0x5737bad8, 0x0e89fcda, 0x39e33edb,
	0xbcf571de, 0x8b9fb3df, 0xd221f5dd, 0xe54b37dc,
	0xd80c6bd7, 0xef66a9d6, 0xb6d8efd4, 0x81b22dd5,
	0x04a462d0, 0x33cea0d1, 0x6a70e6d3, 0x5d1a24d2,
	0x10fe5ec5, 0x27949cc4, 0x7e2adac6, 0x494018c7,
	0xcc5657c2, 0xfb3c95c3, 0xa282d3c1, 0x95e811c0,
	0xa8af4dcb, 0x9fc58fca, 0xc67bc9c8, 0xf1110bc9,
	0x740744cc, 0x436d86cd, 0x1ad3c0cf, 0x2db902ce,
	0x4096af91, 0x77fc6d90, 0x2e422b92, 0x1928e993,
	0x9c3ea696, 0xab546497, 0xf2ea2295, 0xc580e094,
	0xf8c7bc9f, 0xcfad7e9e, 0x9613389c, 0xa179fa9d,
	0x246fb598, 0x13057799, 0x4abb319b, 0x7dd1f39a,
	0x3035898d, 0x075f4b8c, 0x5ee10d8e, 0x698bcf8f,
	0xec9d808a, 0xdbf7428b, 0x82490489, 0xb523c688,
	0x88649a83, 0xbf0e5882, 0xe6b01e80, 0xd1dadc81,
	0x54cc9384, 0x63a65185, 0x3a181787, 0x0d72d586,
	0xa0d0e2a9, 0x97ba20a8, 0xce0466aa, 0xf96ea4ab,
	0x7c78ebae, 0x4b1229af, 0x12ac6fad, 0x25c6adac,
	0x1881f1a7, 0x2feb33a6, 0x765575a4, 0x413fb7a5,
	0xc429f8a0, 0xf3433aa1, 0xaafd7ca3, 0x9d97bea2,
	0xd073c4b5, 0xe71906b4, 0xbea740b6, 0x89cd82b7,
	0x0cdbcdb2, 0x3bb10fb3, 0x620f49b1, 0x55658bb0,
	0x6822d7bb, 0x5f4815ba, 0x06f653b8, 0x319c91b9,
	0xb48adebc, 0x83e01cbd, 0xda5e5abf, 0xed3498be
	},{
	0x00000000, 0x6567bcb8, 0x8bc809aa, 0xeeafb512,
	0x5797628f, 0x32f0de37, 0xdc5f6b25, 0xb938d79d,
	0xef28b4c5, 0x8a4f087d, 0x64e0bd6f, 0x018701d7,
	0xb8bfd64a, 0xddd86af2, 0x3377dfe0, 0x56106358,
	0x9f571950, 0xfa30a5e8, 0x149f10fa, 0x71f8ac42,
	0xc8c07bdf, 0xada7c767, 0x43087275, 0x266fcecd,
	0x707fad95, 0x1518112d, 0xfbb7a43f, 0x9ed01887,
	0x27e8cf1a, 0x428f73a2, 0xac20c6b0, 0xc9477a08,
	0x3eaf32a0, 0x5bc88e18, 0xb5673b0a, 0xd00087b2,
	0x6938502f, 0x0c5fec97, 0xe2f05985, 0x8797e53d,
	0xd1878665, 0xb4e03add, 0x5a4f8fcf, 0x3f283377,
	0x8610e4ea, 0xe3775852, 0x0dd8ed40, 0x68bf51f8,
	0xa1f82bf0, 0xc49f9748, 0x2a30225a, 0x4f579ee2,
	0xf66f497f, 0x9308f5c7, 0x7da740d5, 0x18c0fc6d,
	0x4ed09f35, 0x2bb7238d, 0xc518969f, 0xa07f2a27,
	0x1947fdba, 0x7c204102, 0x928ff410, 0xf7e848a8,
	0x3d58149b, 0x583fa823, 0xb6901d31, 0xd3f7a189,
	0x6acf7614, 0x0fa8caac, 0xe1077fbe, 0x8460c306,
	0xd270a05e, 0xb7171ce6, 0x59b8a9f4, 0x3cdf154c,
	0x85e7c2d1, 0xe0807e69, 0x0e2fcb7b, 0x6b4877c3,
	0xa20f0dcb, 0xc768b173, 0x29c70461, 0x4ca0b8d9,
	0xf5986f44, 0x90ffd3fc, 0x7e5066ee, 0x1b37da56,
	0x4d27b90e, 0x284005b6, 0xc6efb0a4, 0xa3880c1c,
	0x1ab0db81, 0x7fd76739, 0x9178d22b, 0xf41f6e93,
	0x03f7263b, 0x66909a83, 0x883f2f91, 0xed589329,
	0x546044b4, 0x3107f80c, 0xdfa84d1e, 0xbacff1a6,
	0xecdf92fe, 0x89b82e46, 0x67179b54, 0x027027ec,
	0xbb48f071, 0xde2f4cc9, 0x3080f9db, 0x55e74563,
	0x9ca03f6b, 0xf9c783d3, 0x176836c1, 0x720f8a79,
	0xcb375de4, 0xae50e15c, 0x40ff544e, 0x2598e8f6,
	0x73888bae, 0x16ef3716, 0xf8408204, 0x9d273ebc,
	0x241fe921, 0x41785599, 0xafd7e08b, 0xcab05c33,
	0x3bb659ed, 0x5ed1e555, 0xb07e5047, 0xd519ecff,
	0x6c213b62, 0x094687da, 0xe7e932c8, 0x828e8e70,
	0xd49eed28, 0xb1f95190, 0x5f56e482, 0x3a31583a,
	0x83098fa7, 0xe66e331f, 0x08c1860d, 0x6da63ab5,
	0xa4e140bd, 0xc186fc05, 0x2f294917, 0x4a4ef5af,
	0xf3762232, 0x96119e8a, 0x78be2b98, 0x1dd99720,
	0x4bc9f478, 0x2eae48c0, 0xc001fdd2, 0xa566416a,
	0x1c5e96f7, 0x79392a4f, 0x97969f5d, 0xf2f123e5,
	0x05196b4d, 0x607ed7f5, 0x8ed162e7, 0xebb6de5f,
	0x528e09c2, 0x37e9b57a, 0xd9460068, 0xbc21bcd0,
	0xea31df88, 0x8f566330, 0x61f9d622, 0x049e6a9a,
	0xbda6bd07, 0xd8c101bf, 0x366eb4ad, 0x53090815,
	0x9a4e721d, 0xff29cea5, 0x11867bb7, 0x74e1c70f,
	0xcdd91092, 0xa8beac2a, 0x46111938, 0x2376a580,
	0x7566c6d8, 0x10017a60, 0xfeaecf72, 0x9bc973ca,
	0x22f1a457, 0x479618ef, 0xa939adfd, 0xcc5e1145,
	0x06ee4d76, 0x6389f1ce, 0x8d2644dc, 0xe841f864,
	0x51792ff9, 0x341e9341, 0xdab12653, 0xbfd69aeb,
	0xe9c6f9b3, 0x8ca1450b, 0x620ef019, 0x07694ca1,
	0xbe519b3c, 0xdb362784, 0x35999296, 0x50fe2e2e,
	0x99b95426, 0xfcdee89e, 0x12715d8c, 0x7716e134,
	0xce2e36a9, 0xab498a11, 0x45e63f03, 0x208183bb,
	0x7691e0e3, 0x13f65c5b, 0xfd59e949, 0x983e55f1,
	0x2106826c, 0x44613ed4, 0xaace8bc6, 0xcfa9377e,
	0x38417fd6, 0x5d26c36e, 0xb389767c, 0xd6eecac4,
	0x6fd61d59, 0x0ab1a1e1, 0xe41e14f3, 0x8179a84b,
	0xd769cb13, 0xb20e77ab, 0x5ca1c2b9, 0x39c67e01,
	0x80fea99c, 0xe5991524, 0x0b36a036, 0x6e511c8e,
	0xa7166686, 0xc271da3e, 0x2cde6f2c, 0x49b9d394,
	0xf0810409, 0x95e6b8b1, 0x7b490da3, 0x1e2eb11b,
	0x483ed243, 0x2d596efb, 0xc3f6dbe9, 0xa6916751,
	0x1fa9b0cc, 0x7ace0c74, 0x9461b966, 0xf10605de
	},{
	0x00000000, 0xb029603d, 0x6053c07a, 0xd07aa047,
	0xc0a680f5, 0x708fe0c8, 0xa0f5408f, 0x10dc20b2,
	0xc14b7030, 0x7162100d, 0xa118b04a, 0x1131d077,
	0x01edf0c5, 0xb1c490f8, 0x61be30bf, 0xd1975082,
	0x8297e060, 0x32be805d, 0xe2c4201a, 0x52ed4027,
	0x42316095, 0xf21800a8, 0x2262a0ef, 0x924bc0d2,
	0x43dc9050, 0xf3f5f06d, 0x238f502a, 0x93a63017,
	0x837a10a5, 0x33537098, 0xe329d0df, 0x5300b0e2,
	0x042fc1c1, 0xb406a1fc, 0x647c01bb, 0xd4556186,
	0xc4894134, 0x74a02109, 0xa4da814e, 0x14f3e173,
	0xc564b1f1, 0x754dd1cc, 0xa537718b, 0x151e11b6,
	0x05c23104, 0xb5eb5139, 0x6591f17e, 0xd5b89143,
	0x86b821a1, 0x3691419c, 0xe6ebe1db, 0x56c281e6,
	0x461ea154, 0xf637c169, 0x264d612e, 0x96640113,
	0x47f35191, 0xf7da31ac, 0x27a091eb, 0x9789f1d6,
	0x8755d164, 0x377cb159, 0xe706111e, 0x572f7123,
	0x4958f358, 0xf9719365, 0x290b3322, 0x9922531f,
	0x89fe73ad, 0x39d71390, 0xe9adb3d7, 0x5984d3ea,
	0x88138368, 0x383ae355, 0xe8404312, 0x5869232f,
	0x48b5039d, 0xf89c63a0, 0x28e6c3e7, 0x98cfa3da,
	0xcbcf1338, 0x7be67305, 0xab9cd342, 0x1bb5b37f,
	0x0b6993cd, 0xbb40f3f0, 0x6b3a53b7, 0xdb13338a,
	0x0a846308, 0xbaad0335, 0x6ad7a372, 0xdafec34f,
	0xca22e3fd, 0x7a0b83c0, 0xaa712387, 0x1a5843ba,
	0x4d773299, 0xfd5e52a4, 0x2d24f2e3, 0x9d0d92de,
	0x8dd1b26c, 0x3df8d251, 0xed827216, 0x5dab122b,
	0x8c3c42a9, 0x3c152294, 0xec6f82d3, 0x5c46e2ee,
	0x4c9ac25c, 0xfcb3a261, 0x2cc90226, 0x9ce0621b,
	0xcfe0d2f9, 0x7fc9b2c4, 0xafb31283, 0x1f9a72be,
	0x0f46520c, 0xbf6f3231, 0x6f159276, 0xdf3cf24b,
	0x0eaba2c9, 0xbe82c2f4, 0x6ef862b3, 0xded1028e,
	0xce0d223c, 0x7e244201, 0xae5ee246, 0x1e77827b,
	0x92b0e6b1, 0x2299868c, 0xf2e326cb, 0x42ca46f6,
	0x52166644, 0xe23f0679, 0x3245a63e, 0x826cc603,
	0x53fb9681, 0xe3d2f6bc, 0x33a856fb, 0x838136c6,
	0x935d1674, 0x23747649, 0xf30ed60e, 0x4327b633,
	0x102706d1, 0xa00e66ec, 0x7074c6ab, 0xc05da696,
	0xd0818624, 0x60a8e619, 0xb0d2465e, 0x00fb2663,
	0xd16c76e1, 0x614516dc, 0xb13fb69b, 0x0116d6a6,
	0x11caf614, 0xa1e39629, 0x7199366e, 0xc1b05653,
	0x969f2770, 0x26b6474d, 0xf6cce70a, 0x46e58737,
	0x5639a785, 0xe610c7b8, 0x366a67ff, 0x864307c2,
	0x57d45740, 0xe7fd377d, 0x3787973a, 0x87aef707,
	0x9772d7b5, 0x275bb788, 0xf72117cf, 0x470877f2,
	0x1408c710, 0xa421a72d, 0x745b076a, 0xc4726757,
	0xd4ae47e5, 0x648727d8, 0xb4fd879f, 0x04d4e7a2,
	0xd543b720, 0x656ad71d, 0xb510775a, 0x05391767,
	0x15e537d5, 0xa5cc57e8, 0x75b6f7af, 0xc59f9792,
	0xdbe815e9, 0x6bc175d4, 0xbbbbd593, 0x0b92b5ae,
	0x1b4e951c, 0xab67f521, 0x7b1d5566, 0xcb34355b,
	0x1aa365d9, 0xaa8a05e4, 0x7af0a5a3, 0xcad9c59e,
	0xda05e52c, 0x6a2c8511, 0xba562556, 0x0a7f456b,
	0x597ff589, 0xe95695b4, 0x392c35f3, 0x890555ce,
	0x99d9757c, 0x29f01541, 0xf98ab506, 0x49a3d53b,
	0x983485b9, 0x281de584, 0xf86745c3, 0x484e25fe,
	0x5892054c, 0xe8bb6571, 0x38c1c536, 0x88e8a50b,
	0xdfc7d428, 0x6feeb415, 0xbf941452, 0x0fbd746f,
	0x1f6154dd, 0xaf4834e0, 0x7f3294a7, 0xcf1bf49a,
	0x1e8ca418, 0xaea5c425, 0x7edf6462, 0xcef6045f,
	0xde2a24ed, 0x6e0344d0, 0xbe79e497, 0x0e5084aa,
	0x5d503448, 0xed795475, 0x3d03f432, 0x8d2a940f,
	0x9df6b4bd, 0x2ddfd480, 0xfda574c7, 0x4d8c14fa,
	0x9c1b4478, 0x2c322445, 0xfc488402, 0x4c61e43f,
	0x5cbdc48d, 0xec94a4b0, 0x3cee04f7, 0x8cc764ca
	},{
	0x00000000, 0xa5d35ccb, 0x0ba1c84d, 0xae729486,
	0x1642919b, 0xb391cd50, 0x1de359d6, 0xb830051d,
	0x6d8253ec, 0xc8510f27, 0x66239ba1, 0xc3f0c76a,
	0x7bc0c277, 0xde139ebc, 0x70610a3a, 0xd5b256f1,
	0x9b02d603, 0x3ed18ac8, 0x90a31e4e, 0x35704285,
	0x8d404798, 0x28931b53, 0x86e18fd5, 0x2332d31e,
	0xf68085ef, 0x5353d924, 0xfd214da2, 0x58f21169,
	0xe0c21474, 0x451148bf, 0xeb63dc39, 0x4eb080f2,
	0x3605ac07, 0x93d6f0cc, 0x3da4644a, 0x98773881,
	0x20473d9c, 0x85946157, 0x2be6f5d1, 0x8e35a91a,
	0x5b87ffeb, 0xfe54a320, 0x502637a6, 0xf5f56b6d,
	0x4dc56e70, 0xe81632bb, 0x4664a63d, 0xe3b7faf6,
	0xad077a04, 0x08d426cf, 0xa6a6b249, 0x0375ee82,
	0xbb45eb9f, 0x1e96b754, 0xb0e423d2, 0x15377f19,
	0xc08529e8, 0x65567523, 0xcb24e1a5, 0x6ef7bd6e,
	0xd6c7b873, 0x7314e4b8, 0xdd66703e, 0x78b52cf5,
	0x6c0a580f, 0xc9d904c4, 0x67ab9042, 0xc278cc89,
	0x7a48c994, 0xdf9b955f, 0x71e901d9, 0xd43a5d12,
	0x01880be3, 0xa45b5728, 0x0a29c3ae, 0xaffa9f65,
	0x17ca9a78, 0xb219c6b3, 0x1c6b5235, 0xb9b80efe,
	0xf7088e0c, 0x52dbd2c7, 0xfca94641, 0x597a1a8a,
	0xe14a1f97, 0x4499435c, 0xeaebd7da, 0x4f388b11,
	0x9a8adde0, 0x3f59812b, 0x912b15ad, 0x34f84966,
	0x8cc84c7b, 0x291b10b0, 0x87698436, 0x22bad8fd,
	0x5a0ff408, 0xffdca8c3, 0x51ae3c45, 0xf47d608e,
	0x4c4d6593, 0xe99e3958, 0x47ecadde, 0xe23ff115,
	0x378da7e4, 0x925efb2f, 0x3c2c6fa9, 0x99ff3362,
	0x21cf367f, 0x841c6ab4, 0x2a6efe32, 0x8fbda2f9,
	0xc10d220b, 0x64de7ec0, 0xcaacea46, 0x6f7fb68d,
	0xd74fb390, 0x729cef5b, 0xdcee7bdd, 0x793d2716,
	0xac8f71e7, 0x095c2d2c, 0xa72eb9aa, 0x02fde561,
	0xbacde07c, 0x1f1ebcb7, 0xb16c2831, 0x14bf74fa,
	0xd814b01e, 0x7dc7ecd5, 0xd3b57853, 0x76662498,
	0xce562185, 0x6b857d4e, 0xc5f7e9c8, 0x6024b503,
	0xb596e3f2, 0x1045bf39, 0xbe372bbf, 0x1be47774,
	0xa3d47269, 0x06072ea2, 0xa875ba24, 0x0da6e6ef,
	0x4316661d, 0xe6c53ad6, 0x48b7ae50, 0xed64f29b,
	0x5554f786, 0xf087ab4d, 0x5ef53fcb, 0xfb266300,
	0x2e9435f1, 0x8b47693a, 0x2535fdbc, 0x80e6a177,
	0x38d6a46a, 0x9d05f8a1, 0x33776c27, 0x96a430ec,
	0xee111c19, 0x4bc240d2, 0xe5b0d454, 0x4063889f,
	0xf8538d82, 0x5d80d149, 0xf3f245cf, 0x56211904,
	0x83934ff5, 0x2640133e, 0x883287b8, 0x2de1db73,
	0x95d1de6e, 0x300282a5, 0x9e701623, 0x3ba34ae8,
	0x7513ca1a, 0xd0c096d1, 0x7eb20257, 0xdb615e9c,
	0x63515b81, 0xc682074a, 0x68f093cc, 0xcd23cf07,
	0x189199f6, 0xbd42c53d, 0x133051bb, 0xb6e30d70,
	0x0ed3086d, 0xab0054a6, 0x0572c020, 0xa0a19ceb,
	0xb41ee811, 0x11cdb4da, 0xbfbf205c, 0x1a6c7c97,
	0xa25c798a, 0x078f2541, 0xa9fdb1c7, 0x0c2eed0c,
	0xd99cbbfd, 0x7c4fe736, 0xd23d73b0, 0x77ee2f7b,
	0xcfde2a66, 0x6a0d76ad, 0xc47fe22b, 0x61acbee0,
	0x2f1c3e12, 0x8acf62d9, 0x24bdf65f, 0x816eaa94,
	0x395eaf89, 0x9c8df342, 0x32ff67c4, 0x972c3b0f,
	0x429e6dfe, 0xe74d3135, 0x493fa5b3, 0xececf978,
	0x54dcfc65, 0xf10fa0ae, 0x5f7d3428, 0xfaae68e3,
	0x821b4416, 0x27c818dd, 0x89ba8c5b, 0x2c69d090,
	0x9459d58d, 0x318a8946, 0x9ff81dc0, 0x3a2b410b,
	0xef9917fa, 0x4a4a4b31, 0xe438dfb7, 0x41eb837c,
	0xf9db8661, 0x5c08daaa, 0xf27a4e2c, 0x57a912e7,
	0x19199215, 0xbccacede, 0x12b85a58, 0xb76b0693,
	0x0f5b038e, 0xaa885f45, 0x04facbc3, 0xa1299708,
	0x749bc1f9, 0xd1489d32, 0x7f3a09b4, 0xdae9557f,
	0x62d95062, 0xc70a0ca9, 0x6978982f, 0xccabc4e4
	},{
	0x00000000, 0xb40b77a6, 0x29119f97, 0x9d1ae831,
	0x13244ff4, 0xa72f3852, 0x3a35d063, 0x8e3ea7c5,
	0x674eef33, 0xd3459895, 0x4e5f70a4, 0xfa540702,
	0x746aa0c7, 0xc061d761, 0x5d7b3f50, 0xe97048f6,
	0xce9cde67, 0x7a97a9c1, 0xe78d41f0, 0x53863656,
	0xddb89193, 0x69b3e635, 0xf4a90e04, 0x40a279a2,
	0xa9d23154, 0x1dd946f2, 0x80c3aec3, 0x34c8d965,
	0xbaf67ea0, 0x0efd0906, 0x93e7e137, 0x27ec9691,
	0x9c39bdcf, 0x2832ca69, 0xb5282258, 0x012355fe,
	0x8f1df23b, 0x3b16859d, 0xa60c6dac, 0x12071a0a,
	0xfb7752fc, 0x4f7c255a, 0xd266cd6b, 0x666dbacd,
	0xe8531d08, 0x5c586aae, 0xc142829f, 0x7549f539,
	0x52a563a8, 0xe6ae140e, 0x7bb4fc3f, 0xcfbf8b99,
	0x41812c5c, 0xf58a5bfa, 0x6890b3cb, 0xdc9bc46d,
	0x35eb8c9b, 0x81e0fb3d, 0x1cfa130c, 0xa8f164aa,
	0x26cfc36f, 0x92c4b4c9, 0x0fde5cf8, 0xbbd52b5e,
	0x79750b44, 0xcd7e7ce2, 0x506494d3, 0xe46fe375,
	0x6a5144b0, 0xde5a3316, 0x4340db27, 0xf74bac81,
	0x1e3be477, 0xaa3093d1, 0x372a7be0, 0x83210c46,
	0x0d1fab83, 0xb914dc25, 0x240e3414, 0x900543b2,
	0xb7e9d523, 0x03e2a285, 0x9ef84ab4, 0x2af33d12,
	0xa4cd9ad7, 0x10c6ed71, 0x8ddc0540, 0x39d772e6,
	0xd0a73a10, 0x64ac4db6, 0xf9b6a587, 0x4dbdd221,
	0xc38375e4, 0x77880242, 0xea92ea73, 0x5e999dd5,
	0xe54cb68b, 0x5147c12d, 0xcc5d291c, 0x78565eba,
	0xf668f97f, 0x42638ed9, 0xdf7966e8, 0x6b72114e,
	0x820259b8, 0x36092e1e, 0xab13c62f, 0x1f18b189,
	0x9126164c, 0x252d61ea, 0xb83789db, 0x0c3cfe7d,
	0x2bd068ec, 0x9fdb1f4a, 0x02c1f77b, 0xb6ca80dd,
	0x38f42718, 0x8cff50be, 0x11e5b88f, 0xa5eecf29,
	0x4c9e87df, 0xf895f079, 0x658f1848, 0xd1846fee,
	0x5fbac82b, 0xebb1bf8d, 0x76ab57bc, 0xc2a0201a,
	0xf2ea1688, 0x46e1612e, 0xdbfb891f, 0x6ff0feb9,
	0xe1ce597c, 0x55c52eda, 0xc8dfc6eb, 0x7cd4b14d,
	0x95a4f9bb, 0x21af8e1d, 0xbcb5662c, 0x08be118a,
	0x8680b64f, 0x328bc1e9, 0xaf9129d8, 0x1b9a5e7e,
	0x3c76c8ef, 0x887dbf49, 0x15675778, 0xa16c20de,
	0x2f52871b, 0x9b59f0bd, 0x0643188c, 0xb2486f2a,
	0x5b3827dc, 0xef33507a, 0x7229b84b, 0xc622cfed,
	0x481c6828, 0xfc171f8e, 0x610df7bf, 0xd5068019,
	0x6ed3ab47, 0xdad8dce1, 0x47c234d0, 0xf3c94376,
	0x7df7e4b3, 0xc9fc9315, 0x54e67b24, 0xe0ed0c82,
	0x099d4474, 0xbd9633d2, 0x208cdbe3, 0x9487ac45,
	0x1ab90b80, 0xaeb27c26, 0x33a89417, 0x87a3e3b1,
	0xa04f7520, 0x14440286, 0x895eeab7, 0x3d559d11,
	0xb36b3ad4, 0x07604d72, 0x9a7aa543, 0x2e71d2e5,
	0xc7019a13, 0x730aedb5, 0xee100584, 0x5a1b7222,
	0xd425d5e7, 0x602ea241, 0xfd344a70, 0x493f3dd6,
	0x8b9f1dcc, 0x3f946a6a, 0xa28e825b, 0x1685f5fd,
	0x98bb5238, 0x2cb0259e, 0xb1aacdaf, 0x05a1ba09,
	0xecd1f2ff, 0x58da8559, 0xc5c06d68, 0x71cb1ace,
	0xfff5bd0b, 0x4bfecaad, 0xd6e4229c, 0x62ef553a,
	0x4503c3ab, 0xf108b40d, 0x6c125c3c, 0xd8192b9a,
	0x56278c5f, 0xe22cfbf9, 0x7f3613c8, 0xcb3d646e,
	0x224d2c98, 0x96465b3e, 0x0b5cb30f, 0xbf57c4a9,
	0x3169636c, 0x856214ca, 0x1878fcfb, 0xac738b5d,
	0x17a6a003, 0xa3add7a5, 0x3eb73f94, 0x8abc4832,
	0x0482eff7, 0xb0899851, 0x2d937060, 0x999807c6,
	0x70e84f30, 0xc4e33896, 0x59f9d0a7, 0xedf2a701,
	0x63cc00c4, 0xd7c77762, 0x4add9f53, 0xfed6e8f5,
	0xd93a7e64, 0x6d3109c2, 0xf02be1f3, 0x44209655,
	0xca1e3190, 0x7e154636, 0xe30fae07, 0x5704d9a1,
	0xbe749157, 0x0a7fe6f1, 0x97650ec0, 0x236e7966,
	0xad50dea3, 0x195ba905, 0x84414134, 0x304a3692
	},{
	0x00000000, 0x9e00aacc, 0x7d072542, 0xe3078f8e,
	0xfa0e4a84, 0x640ee048, 0x87096fc6, 0x1909c50a,
	0xb51be5d3, 0x2b1b4f1f, 0xc81cc091, 0x561c6a5d,
	0x4f15af57, 0xd115059b, 0x32128a15, 0xac1220d9,
	0x2b31bb7c, 0xb53111b0, 0x56369e3e, 0xc83634f2,
	0xd13ff1f8, 0x4f3f5b34, 0xac38d4ba, 0x32387e76,
	0x9e2a5eaf, 0x002af463, 0xe32d7bed, 0x7d2dd121,
	0x6424142b, 0xfa24bee7, 0x19233169, 0x87239ba5,
	0x566276f9, 0xc862dc35, 0x2b6553bb, 0xb565f977,
	0xac6c3c7d, 0x326c96b1, 0xd16b193f, 0x4f6bb3f3,
	0xe379932a, 0x7d7939e6, 0x9e7eb668, 0x007e1ca4,
	0x1977d9ae, 0x87777362, 0x6470fcec, 0xfa705620,
	0x7d53cd85, 0xe3536749, 0x0054e8c7, 0x9e54420b,
	0x875d8701, 0x195d2dcd, 0xfa5aa243, 0x645a088f,
	0xc8482856, 0x5648829a, 0xb54f0d14, 0x2b4fa7d8,
	0x324662d2, 0xac46c81e, 0x4f414790, 0xd141ed5c,
	0xedc29d29, 0x73c237e5, 0x90c5b86b, 0x0ec512a7,
	0x17ccd7ad, 0x89cc7d61, 0x6acbf2ef, 0xf4cb5823,
	0x58d978fa, 0xc6d9d236, 0x25de5db8, 0xbbdef774,
	0xa2d7327e, 0x3cd798b2, 0xdfd0173c, 0x41d0bdf0,
	0xc6f32655, 0x58f38c99, 0xbbf40317, 0x25f4a9db,
	0x3cfd6cd1, 0xa2fdc61d, 0x41fa4993, 0xdffae35f,
	0x73e8c386, 0xede8694a, 0x0eefe6c4, 0x90ef4c08,
	0x89e68902, 0x17e623ce, 0xf4e1ac40, 0x6ae1068c,
	0xbba0ebd0, 0x25a0411c, 0xc6a7ce92, 0x58a7645e,
	0x41aea154, 0xdfae0b98, 0x3ca98416, 0xa2a92eda,
	0x0ebb0e03, 0x90bba4cf, 0x73bc2b41, 0xedbc818d,
	0xf4b54487, 0x6ab5ee4b, 0x89b261c5, 0x17b2cb09,
	0x909150ac, 0x0e91fa60, 0xed9675ee, 0x7396df22,
	0x6a9f1a28, 0xf49fb0e4, 0x17983f6a, 0x899895a6,
	0x258ab57f, 0xbb8a1fb3, 0x588d903d, 0xc68d3af1,
	0xdf84fffb, 0x41845537, 0xa283dab9, 0x3c837075,
	0xda853b53, 0x4485919f, 0xa7821e11, 0x3982b4dd,
	0x208b71d7, 0xbe8bdb1b, 0x5d8c5495, 0xc38cfe59,
	0x6f9ede80, 0xf19e744c, 0x1299fbc2, 0x8c99510e,
	0x95909404, 0x0b903ec8, 0xe897b146, 0x76971b8a,
	0xf1b4802f, 0x6fb42ae3, 0x8cb3a56d, 0x12b30fa1,
	0x0bbacaab, 0x95ba6067, 0x76bdefe9, 0xe8bd4525,
	0x44af65fc, 0xdaafcf30, 0x39a840be, 0xa7a8ea72,
	0xbea12f78, 0x20a185b4, 0xc3a60a3a, 0x5da6a0f6,
	0x8ce74daa, 0x12e7e766, 0xf1e068e8, 0x6fe0c224,
	0x76e9072e, 0xe8e9ade2, 0x0bee226c, 0x95ee88a0,
	0x39fca879, 0xa7fc02b5, 0x44fb8d3b, 0xdafb27f7,
	0xc3f2e2fd, 0x5df24831, 0xbef5c7bf, 0x20f56d73,
	0xa7d6f6d6, 0x39d65c1a, 0xdad1d394, 0x44d17958,
	0x5dd8bc52, 0xc3d8169e, 0x20df9910, 0xbedf33dc,
	0x12cd1305, 0x8ccdb9c9, 0x6fca3647, 0xf1ca9c8b,
	0xe8c35981, 0x76c3f34d, 0x95c47cc3, 0x0bc4d60f,
	0x3747a67a, 0xa9470cb6, 0x4a408338, 0xd44029f4,
	0xcd49ecfe, 0x53494632, 0xb04ec9bc, 0x2e4e6370,
	0x825c43a9, 0x1c5ce965, 0xff5b66eb, 0x615bcc27,
	0x7852092d, 0xe652a3e1, 0x05552c6f, 0x9b5586a3,
	0x1c761d06, 0x8276b7ca, 0x61713844, 0xff719288,
	0xe6785782, 0x7878fd4e, 0x9b7f72c0, 0x057fd80c,
	0xa96df8d5, 0x376d5219, 0xd46add97, 0x4a6a775b,
	0x5363b251, 0xcd63189d, 0x2e649713, 0xb0643ddf,
	0x6125d083, 0xff257a4f, 0x1c22f5c1, 0x82225f0d,
	0x9b2b9a07, 0x052b30cb, 0xe62cbf45, 0x782c1589,
	0xd43e3550, 0x4a3e9f9c, 0xa9391012, 0x3739bade,
	0x2e307fd4, 0xb030d518, 0x53375a96, 0xcd37f05a,
	0x4a146bff, 0xd414c133, 0x37134ebd, 0xa913e471,
	0xb01a217b, 0x2e1a8bb7, 0xcd1d0439, 0x531daef5,
	0xff0f8e2c, 0x610f24e0, 0x8208ab6e, 0x1c0801a2,
	0x0501c4a8, 0x9b016e64, 0x7806e1ea, 0xe6064b26
	}
};

static const unsigned int __attribute__((aligned(128))) crc32table_be[8][256] = {
	{
	0x00000000, 0x04c11db7, 0x09823b6e, 0x0d4326d9,
	0x130476dc, 0x17c56b6b, 0x1a864db2, 0x1e475005,
	0x2608edb8, 0x22c9f00f, 0x2f8ad6d6, 0x2b4bcb61,
	0x350c9b64, 0x31cd86d3, 0x3c8ea00a, 0x384fbdbd,
	0x4c11db70, 0x48d0c6c7, 0x4593e01e, 0x4152fda9,
	0x5f15adac, 0x5bd4b01b, 0x569796c2, 0x52568b75,
	0x6a1936c8, 0x6ed82b7f, 0x639b0da6, 0x675a1011,
	0x791d4014, 0x7ddc5da3, 0x709f7b7a, 0x745e66cd,
	0x9823b6e0, 0x9ce2ab57, 0x91a18d8e, 0x95609039,
	0x8b27c03c, 0x8fe6dd8b, 0x82a5fb52, 0x8664e6e5,
	0xbe2b5b58, 0xbaea46ef, 0xb7a96036, 0xb3687d81,
	0xad2f2d84, 0xa9ee3033, 0xa4ad16ea, 0xa06c0b5d,
	0xd4326d90, 0xd0f37027, 0xddb056fe, 0xd9714b49,
	0xc7361b4c, 0xc3f706fb, 0xceb42022, 0xca753d95,
	0xf23a8028, 0xf6fb9d9f, 0xfbb8bb46, 0xff79a6f1,
	0xe13ef6f4, 0xe5ffeb43, 0xe8bccd9a, 0xec7dd02d,
	0x34867077, 0x30476dc0, 0x3d044b19, 0x39c556ae,
	0x278206ab, 0x23431b1c, 0x2e003dc5, 0x2ac12072,
	0x128e9dcf, 0x164f8078, 0x1b0ca6a1, 0x1fcdbb16,
	0x018aeb13, 0x054bf6a4, 0x0808d07d, 0x0cc9cdca,
	0x7897ab07, 0x7c56b6b0, 0x71159069, 0x75d48dde,
	0x6b93dddb, 0x6f52c06c, 0x6211e6b5, 0x66d0fb02,
	0x5e9f46bf, 0x5a5e5b08, 0x571d7dd1, 0x53dc6066,
	0x4d9b3063, 0x495a2dd4, 0x44190b0d, 0x40d816ba,
	0xaca5c697, 0xa864db20, 0xa527fdf9, 0xa1e6e04e,
	0xbfa1b04b, 0xbb60adfc, 0xb6238b25, 0xb2e29692,
	0x8aad2b2f, 0x8e6c3698, 0x832f1041, 0x87ee0df6,
	0x99a95df3, 0x9d684044, 0x902b669d, 0x94ea7b2a,
	0xe0b41de7, 0xe4750050, 0xe9362689, 0xedf73b3e,
	0xf3b06b3b, 0xf771768c, 0xfa325055, 0xfef34de2,
	0xc6bcf05f, 0xc27dede8, 0xcf3ecb31, 0xcbffd686,
	0xd5b88683, 0xd1799b34, 0xdc3abded, 0xd8fba05a,
	0x690ce0ee, 0x6dcdfd59, 0x608edb80, 0x644fc637,
	0x7a089632, 0x7ec98b85, 0x738aad5c, 0x774bb0eb,
	0x4f040d56, 0x4bc510e1, 0x46863638, 0x42472b8f,
	0x5c007b8a, 0x58c1663d, 0x558240e4, 0x51435d53,
	0x251d3b9e, 0x21dc2629, 0x2c9f00f0, 0x285e1d47,
	0x36194d42, 0x32d850f5, 0x3f9b762c, 0x3b5a6b9b,
	0x0315d626, 0x07d4cb91, 0x0a97ed48, 0x0e56f0ff,
	0x1011a0fa, 0x14d0bd4d, 0x19939b94, 0x1d528623,
	0xf12f560e, 0xf5ee4bb9, 0xf8ad6d60, 0xfc6c70d7,
	0xe22b20d2, 0xe6ea3d65, 0xeba91bbc, 0xef68060b,
	0xd727bbb6, 0xd3e6a601, 0xdea580d8, 0xda649d6f,
	0xc423cd6a, 0xc0e2d0dd, 0xcda1f604, 0xc960ebb3,
	0xbd3e8d7e, 0xb9ff90c9, 0xb4bcb610, 0xb07daba7,
	0xae3afba2, 0xaafbe615, 0xa7b8c0cc, 0xa379dd7b,
	0x9b3660c6, 0x9ff77d71, 0x92b45ba8, 0x9675461f,
	0x8832161a, 0x8cf30bad, 0x81b02d74, 0x857130c3,
	0x5d8a9099, 0x594b8d2e, 0x5408abf7, 0x50c9b640,
	0x4e8ee645, 0x4a4ffbf2, 0x470cdd2b, 0x43cdc09c,
	0x7b827d21, 0x7f436096, 0x7200464f, 0x76c15bf8,
	0x68860bfd, 0x6c47164a, 0x61043093, 0x65c52d24,
	0x119b4be9, 0x155a565e, 0x18197087, 0x1cd86d30,
	0x029f3d35, 0x065e2082, 0x0b1d065b, 0x0fdc1bec,
	0x3793a651, 0x3352bbe6, 0x3e119d3f, 0x3ad08088,
	0x2497d08d, 0x2056cd3a, 0x2d15ebe3, 0x29d4f654,
	0xc5a92679, 0xc1683bce, 0xcc2b1d17, 0xc8ea00a0,
	0xd6ad50a5, 0xd26c4d12, 0xdf2f6bcb, 0xdbee767c,
	0xe3a1cbc1, 0xe760d676, 0xea23f0af, 0xeee2ed18,
	0xf0a5bd1d, 0xf464a0aa, 0xf9278673, 0xfde69bc4,
	0x89b8fd09, 0x8d79e0be, 0x803ac667, 0x84fbdbd0,
	0x9abc8bd5, 0x9e7d9662, 0x933eb0bb, 0x97ffad0c,
	0xafb010b1, 0xab710d06, 0xa6322bdf, 0xa2f33668,
	0xbcb4666d, 0xb8757bda, 0xb5365d03, 0xb1f740b4
	},{
	0x00000000, 0xd219c1dc, 0xa0f29e0f, 0x72eb5fd3,
	0x452421a9, 0x973de075, 0xe5d6bfa6, 0x37cf7e7a,
	0x8a484352, 0x5851828e, 0x2abadd5d, 0xf8a31c81,
	0xcf6c62fb, 0x1d75a327, 0x6f9efcf4, 0xbd873d28,
	0x10519b13, 0xc2485acf, 0xb0a3051c, 0x62bac4c0,
	0x5575baba, 0x876c7b66, 0xf58724b5, 0x279ee569,
	0x9a19d841, 0x4800199d, 0x3aeb464e, 0xe8f28792,
	0xdf3df9e8, 0x0d243834, 0x7fcf67e7, 0xadd6a63b,
	0x20a33626, 0xf2baf7fa, 0x8051a829, 0x524869f5,
	0x6587178f, 0xb79ed653, 0xc5758980, 0x176c485c,
	0xaaeb7574, 0x78f2b4a8, 0x0a19eb7b, 0xd8002aa7,
	0xefcf54dd, 0x3dd69501, 0x4f3dcad2, 0x9d240b0e,
	0x30f2ad35, 0xe2eb6ce9, 0x9000333a, 0x4219f2e6,
	0x75d68c9c, 0xa7cf4d40, 0xd5241293, 0x073dd34f,
	0xbabaee67, 0x68a32fbb, 0x1a487068, 0xc851b1b4,
	0xff9ecfce, 0x2d870e12, 0x5f6c51c1, 0x8d75901d,
	0x41466c4c, 0x935fad90, 0xe1b4f243, 0x33ad339f,
	0x04624de5, 0xd67b8c39, 0xa490d3ea, 0x76891236,
	0xcb0e2f1e, 0x1917eec2, 0x6bfcb111, 0xb9e570cd,
	0x8e2a0eb7, 0x5c33cf6b, 0x2ed890b8, 0xfcc15164,
	0x5117f75f, 0x830e3683, 0xf1e56950, 0x23fca88c,
	0x1433d6f6, 0xc62a172a, 0xb4c148f9, 0x66d88925,
	0xdb5fb40d, 0x094675d1, 0x7bad2a02, 0xa9b4ebde,
	0x9e7b95a4, 0x4c625478, 0x3e890bab, 0xec90ca77,
	0x61e55a6a, 0xb3fc9bb6, 0xc117c465, 0x130e05b9,
	0x24c17bc3, 0xf6d8ba1f, 0x8433e5cc, 0x562a2410,
	0xebad1938, 0x39b4d8e4, 0x4b5f8737, 0x994646eb,
	0xae893891, 0x7c90f94d, 0x0e7ba69e, 0xdc626742,
	0x71b4c179, 0xa3ad00a5, 0xd1465f76, 0x035f9eaa,
	0x3490e0d0, 0xe689210c, 0x94627edf, 0x467bbf03,
	0xfbfc822b, 0x29e543f7, 0x5b0e1c24, 0x8917ddf8,
	0xbed8a382, 0x6cc1625e, 0x1e2a3d8d, 0xcc33fc51,
	0x828cd898, 0x50951944, 0x227e4697, 0xf067874b,
	0xc7a8f931, 0x15b138ed, 0x675a673e, 0xb543a6e2,
	0x08c49bca, 0xdadd5a16, 0xa83605c5, 0x7a2fc419,
	0x4de0ba63, 0x9ff97bbf, 0xed12246c, 0x3f0be5b0,
	0x92dd438b, 0x40c48257, 0x322fdd84, 0xe0361c58,
	0xd7f96222, 0x05e0a3fe, 0x770bfc2d, 0xa5123df1,
	0x189500d9, 0xca8cc105, 0xb8679ed6, 0x6a7e5f0a,
	0x5db12170, 0x8fa8e0ac, 0xfd43bf7f, 0x2f5a7ea3,
	0xa22feebe, 0x70362f62, 0x02dd70b1, 0xd0c4b16d,
	0xe70bcf17, 0x35120ecb, 0x47f95118, 0x95e090c4,
	0x2867adec, 0xfa7e6c30, 0x889533e3, 0x5a8cf23f,
	0x6d438c45, 0xbf5a4d99, 0xcdb1124a, 0x1fa8d396,
	0xb27e75ad, 0x6067b471, 0x128ceba2, 0xc0952a7e,
	0xf75a5404, 0x254395d8, 0x57a8ca0b, 0x85b10bd7,
	0x383636ff, 0xea2ff723, 0x98c4a8f0, 0x4add692c,
	0x7d121756, 0xaf0bd68a, 0xdde08959, 0x0ff94885,
	0xc3cab4d4, 0x11d37508, 0x63382adb, 0xb121eb07,
	0x86ee957d, 0x54f754a1, 0x261c0b72, 0xf405caae,
	0x4982f786, 0x9b9b365a, 0xe9706989, 0x3b69a855,
	0x0ca6d62f, 0xdebf17f3, 0xac544820, 0x7e4d89fc,
	0xd39b2fc7, 0x0182ee1b, 0x7369b1c8, 0xa1707014,
	0x96bf0e6e, 0x44a6cfb2, 0x364d9061, 0xe45451bd,
	0x59d36c95, 0x8bcaad49, 0xf921f29a, 0x2b383346,
	0x1cf74d3c, 0xceee8ce0, 0xbc05d333, 0x6e1c12ef,
	0xe36982f2, 0x3170432e, 0x439b1cfd, 0x9182dd21,
	0xa64da35b, 0x74546287, 0x06bf3d54, 0xd4a6fc88,
	0x6921c1a0, 0xbb38007c, 0xc9d35faf, 0x1bca9e73,
	0x2c05e009, 0xfe1c21d5, 0x8cf77e06, 0x5eeebfda,
	0xf33819e1, 0x2121d83d, 0x53ca87ee, 0x81d34632,
	0xb61c3848, 0x6405f994, 0x16eea647, 0xc4f7679b,
	0x79705ab3, 0xab699b6f, 0xd982c4bc, 0x0b9b0560,
	0x3c547b1a, 0xee4dbac6, 0x9ca6e515, 0x4ebf24c9
	},{
	0x00000000, 0x01d8ac87, 0x03b1590e, 0x0269f589,
	0x0762b21c, 0x06ba1e9b, 0x04d3eb12, 0x050b4795,
	0x0ec56438, 0x0f1dc8bf, 0x0d743d36, 0x0cac91b1,
	0x09a7d624, 0x087f7aa3, 0x0a168f2a, 0x0bce23ad,
	0x1d8ac870, 0x1c5264f7, 0x1e3b917e, 0x1fe33df9,
	0x1ae87a6c, 0x1b30d6eb, 0x19592362, 0x18818fe5,
	0x134fac48, 0x129700cf, 0x10fef546, 0x112659c1,
	0x142d1e54, 0x15f5b2d3, 0x179c475a, 0x1644ebdd,
	0x3b1590e0, 0x3acd3c67, 0x38a4c9ee, 0x397c6569,
	0x3c7722fc, 0x3daf8e7b, 0x3fc67bf2, 0x3e1ed775,
	0x35d0f4d8, 0x3408585f, 0x3661add6, 0x37b90151,
	0x32b246c4, 0x336aea43, 0x31031fca, 0x30dbb34d,
	0x269f5890, 0x2747f417, 0x252e019e, 0x24f6ad19,
	0x21fdea8c, 0x2025460b, 0x224cb382, 0x23941f05,
	0x285a3ca8, 0x2982902f, 0x2beb65a6, 0x2a33c921,
	0x2f388eb4, 0x2ee02233, 0x2c89d7ba, 0x2d517b3d,
	0x762b21c0, 0x77f38d47, 0x759a78ce, 0x7442d449,
	0x714993dc, 0x70913f5b, 0x72f8cad2, 0x73206655,
	0x78ee45f8, 0x7936e97f, 0x7b5f1cf6, 0x7a87b071,
	0x7f8cf7e4, 0x7e545b63, 0x7c3daeea, 0x7de5026d,
	0x6ba1e9b0, 0x6a794537, 0x6810b0be, 0x69c81c39,
	0x6cc35bac, 0x6d1bf72b, 0x6f7202a2, 0x6eaaae25,
	0x65648d88, 0x64bc210f, 0x66d5d486, 0x670d7801,
	0x62063f94, 0x63de9313, 0x61b7669a, 0x606fca1d,
	0x4d3eb120, 0x4ce61da7, 0x4e8fe82e, 0x4f5744a9,
	0x4a5c033c, 0x4b84afbb, 0x49ed5a32, 0x4835f6b5,
	0x43fbd518, 0x4223799f, 0x404a8c16, 0x41922091,
	0x44996704, 0x4541cb83, 0x47283e0a, 0x46f0928d,
	0x50b47950, 0x516cd5d7, 0x5305205e, 0x52dd8cd9,
	0x57d6cb4c, 0x560e67cb, 0x54679242, 0x55bf3ec5,
	0x5e711d68, 0x5fa9b1ef, 0x5dc04466, 0x5c18e8e1,
	0x5913af74, 0x58cb03f3, 0x5aa2f67a, 0x5b7a5afd,
	0xec564380, 0xed8eef07, 0xefe71a8e, 0xee3fb609,
	0xeb34f19c, 0xeaec5d1b, 0xe885a892, 0xe95d0415,
	0xe29327b8, 0xe34b8b3f, 0xe1227eb6, 0xe0fad231,
	0xe5f195a4, 0xe4293923, 0xe640ccaa, 0xe798602d,
	0xf1dc8bf0, 0xf0042777, 0xf26dd2fe, 0xf3b57e79,
	0xf6be39ec, 0xf766956b, 0xf50f60e2, 0xf4d7cc65,
	0xff19efc8, 0xfec1434f, 0xfca8b6c6, 0xfd701a41,
	0xf87b5dd4, 0xf9a3f153, 0xfbca04da, 0xfa12a85d,
	0xd743d360, 0xd69b7fe7, 0xd4f28a6e, 0xd52a26e9,
	0xd021617c, 0xd1f9cdfb, 0xd3903872, 0xd24894f5,
	0xd986b758, 0xd85e1bdf, 0xda37ee56, 0xdbef42d1,
	0xdee40544, 0xdf3ca9c3, 0xdd555c4a, 0xdc8df0cd,
	0xcac91b10, 0xcb11b797, 0xc978421e, 0xc8a0ee99,
	0xcdaba90c, 0xcc73058b, 0xce1af002, 0xcfc25c85,
	0xc40c7f28, 0xc5d4d3af, 0xc7bd2626, 0xc6658aa1,
	0xc36ecd34, 0xc2b661b3, 0xc0df943a, 0xc10738bd,
	0x9a7d6240, 0x9ba5cec7, 0x99cc3b4e, 0x981497c9,
	0x9d1fd05c, 0x9cc77cdb, 0x9eae8952, 0x9f7625d5,
	0x94b80678, 0x9560aaff, 0x97095f76, 0x96d1f3f1,
	0x93dab464, 0x920218e3, 0x906bed6a, 0x91b341ed,
	0x87f7aa30, 0x862f06b7, 0x8446f33e, 0x859e5fb9,
	0x8095182c, 0x814db4ab, 0x83244122, 0x82fceda5,
	0x8932ce08, 0x88ea628f, 0x8a839706, 0x8b5b3b81,
	0x8e507c14, 0x8f88d093, 0x8de1251a, 0x8c39899d,
	0xa168f2a0, 0xa0b05e27, 0xa2d9abae, 0xa3010729,
	0xa60a40bc, 0xa7d2ec3b, 0xa5bb19b2, 0xa463b535,
	0xafad9698, 0xae753a1f, 0xac1ccf96, 0xadc46311,
	0xa8cf2484, 0xa9178803, 0xab7e7d8a, 0xaaa6d10d,
	0xbce23ad0, 0xbd3a9657, 0xbf5363de, 0xbe8bcf59,
	0xbb8088cc, 0xba58244b, 0xb831d1c2, 0xb9e97d45,
	0xb2275ee8, 0xb3fff26f, 0xb19607e6, 0xb04eab61,
	0xb545ecf4, 0xb49d4073, 0xb6f4b5fa, 0xb72c197d
	},{
	0x00000000, 0xdc6d9ab7, 0xbc1a28d9, 0x6077b26e,
	0x7cf54c05, 0xa098d6b2, 0xc0ef64dc, 0x1c82fe6b,
	0xf9ea980a, 0x258702bd, 0x45f0b0d3, 0x999d2a64,
	0x851fd40f, 0x59724eb8, 0x3905fcd6, 0xe5686661,
	0xf7142da3, 0x2b79b714, 0x4b0e057a, 0x97639fcd,
	0x8be161a6, 0x578cfb11, 0x37fb497f, 0xeb96d3c8,
	0x0efeb5a9, 0xd2932f1e, 0xb2e49d70, 0x6e8907c7,
	0x720bf9ac, 0xae66631b, 0xce11d175, 0x127c4bc2,
	0xeae946f1, 0x3684dc46, 0x56f36e28, 0x8a9ef49f,
	0x961c0af4, 0x4a719043, 0x2a06222d, 0xf66bb89a,
	0x1303defb, 0xcf6e444c, 0xaf19f622, 0x73746c95,
	0x6ff692fe, 0xb39b0849, 0xd3ecba27, 0x0f812090,
	0x1dfd6b52, 0xc190f1e5, 0xa1e7438b, 0x7d8ad93c,
	0x61082757, 0xbd65bde0, 0xdd120f8e, 0x017f9539,
	0xe417f358, 0x387a69ef, 0x580ddb81, 0x84604136,
	0x98e2bf5d, 0x448f25ea, 0x24f89784, 0xf8950d33,
	0xd1139055, 0x0d7e0ae2, 0x6d09b88c, 0xb164223b,
	0xade6dc50, 0x718b46e7, 0x11fcf489, 0xcd916e3e,
	0x28f9085f, 0xf49492e8, 0x94e32086, 0x488eba31,
	0x540c445a, 0x8861deed, 0xe8166c83, 0x347bf634,
	0x2607bdf6, 0xfa6a2741, 0x9a1d952f, 0x46700f98,
	0x5af2f1f3, 0x869f6b44, 0xe6e8d92a, 0x3a85439d,
	0xdfed25fc, 0x0380bf4b, 0x63f70d25, 0xbf9a9792,
	0xa31869f9, 0x7f75f34e, 0x1f024120, 0xc36fdb97,
	0x3bfad6a4, 0xe7974c13, 0x87e0fe7d, 0x5b8d64ca,
	0x470f9aa1, 0x9b620016, 0xfb15b278, 0x277828cf,
	0xc2104eae, 0x1e7dd419, 0x7e0a6677, 0xa267fcc0,
	0xbee502ab, 0x6288981c, 0x02ff2a72, 0xde92b0c5,
	0xcceefb07, 0x108361b0, 0x70f4d3de, 0xac994969,
	0xb01bb702, 0x6c762db5, 0x0c019fdb, 0xd06c056c,
	0x3504630d, 0xe969f9ba, 0x891e4bd4, 0x5573d163,
	0x49f12f08, 0x959cb5bf, 0xf5eb07d1, 0x29869d66,
	0xa6e63d1d, 0x7a8ba7aa, 0x1afc15c4, 0xc6918f73,
	0xda137118, 0x067eebaf, 0x660959c1, 0xba64c376,
	0x5f0ca517, 0x83613fa0, 0xe3168dce, 0x3f7b1779,
	0x23f9e912, 0xff9473a5, 0x9fe3c1cb, 0x438e5b7c,
	0x51f210be, 0x8d9f8a09, 0xede83867, 0x3185a2d0,
	0x2d075cbb, 0xf16ac60c, 0x911d7462, 0x4d70eed5,
	0xa81888b4, 0x74751203, 0x1402a06d, 0xc86f3ada,
	0xd4edc4b1, 0x08805e06, 0x68f7ec68, 0xb49a76df,
	0x4c0f7bec, 0x9062e15b, 0xf0155335, 0x2c78c982,
	0x30fa37e9, 0xec97ad5e, 0x8ce01f30, 0x508d8587,
	0xb5e5e3e6, 0x69887951, 0x09ffcb3f, 0xd5925188,
	0xc910afe3, 0x157d3554, 0x750a873a, 0xa9671d8d,
	0xbb1b564f, 0x6776ccf8, 0x07017e96, 0xdb6ce421,
	0xc7ee1a4a, 0x1b8380fd, 0x7bf43293, 0xa799a824,
	0x42f1ce45, 0x9e9c54f2, 0xfeebe69c, 0x22867c2b,
	0x3e048240, 0xe26918f7, 0x821eaa99, 0x5e73302e,
	0x77f5ad48, 0xab9837ff, 0xcbef8591, 0x17821f26,
	0x0b00e14d, 0xd76d7bfa, 0xb71ac994, 0x6b775323,
	0x8e1f3542, 0x5272aff5, 0x32051d9b, 0xee68872c,
	0xf2ea7947, 0x2e87e3f0, 0x4ef0519e, 0x929dcb29,
	0x80e180eb, 0x5c8c1a5c, 0x3cfba832, 0xe0963285,
	0xfc14ccee, 0x20795659, 0x400ee437, 0x9c637e80,
	0x790b18e1, 0xa5668256, 0xc5113038, 0x197caa8f,
	0x05fe54e4, 0xd993ce53, 0xb9e47c3d, 0x6589e68a,
	0x9d1cebb9, 0x4171710e, 0x2106c360, 0xfd6b59d7,
	0xe1e9a7bc, 0x3d843d0b, 0x5df38f65, 0x819e15d2,
	0x64f673b3, 0xb89be904, 0xd8ec5b6a, 0x0481c1dd,
	0x18033fb6, 0xc46ea501, 0xa419176f, 0x78748dd8,
	0x6a08c61a, 0xb6655cad, 0xd612eec3, 0x0a7f7474,
	0x16fd8a1f, 0xca9010a8, 0xaae7a2c6, 0x768a3871,
	0x93e25e10, 0x4f8fc4a7, 0x2ff876c9, 0xf395ec7e,
	0xef171215, 0x337a88a2, 0x530d3acc, 0x8f60a07b
	},{
	0x00000000, 0x490d678d, 0x921acf1a, 0xdb17a897,
	0x20f48383, 0x69f9e40e, 0xb2ee4c99, 0xfbe32b14,
	0x41e90706, 0x08e4608b, 0xd3f3c81c, 0x9afeaf91,
	0x611d8485, 0x2810e308, 0xf3074b9f, 0xba0a2c12,
	0x83d20e0c, 0xcadf6981, 0x11c8c116, 0x58c5a69b,
	0xa3268d8f, 0xea2bea02, 0x313c4295, 0x78312518,
	0xc23b090a, 0x8b366e87, 0x5021c610, 0x192ca19d,
	0xe2cf8a89, 0xabc2ed04, 0x70d54593, 0x39d8221e,
	0x036501af, 0x4a686622, 0x917fceb5, 0xd872a938,
	0x2391822c, 0x6a9ce5a1, 0xb18b4d36, 0xf8862abb,
	0x428c06a9, 0x0b816124, 0xd096c9b3, 0x999bae3e,
	0x6278852a, 0x2b75e2a7, 0xf0624a30, 0xb96f2dbd,
	0x80b70fa3, 0xc9ba682e, 0x12adc0b9, 0x5ba0a734,
	0xa0438c20, 0xe94eebad, 0x3259433a, 0x7b5424b7,
	0xc15e08a5, 0x88536f28, 0x5344c7bf, 0x1a49a032,
	0xe1aa8b26, 0xa8a7ecab, 0x73b0443c, 0x3abd23b1,
	0x06ca035e, 0x4fc764d3, 0x94d0cc44, 0xddddabc9,
	0x263e80dd, 0x6f33e750, 0xb4244fc7, 0xfd29284a,
	0x47230458, 0x0e2e63d5, 0xd539cb42, 0x9c34accf,
	0x67d787db, 0x2edae056, 0xf5cd48c1, 0xbcc02f4c,
	0x85180d52, 0xcc156adf, 0x1702c248, 0x5e0fa5c5,
	0xa5ec8ed1, 0xece1e95c, 0x37f641cb, 0x7efb2646,
	0xc4f10a54, 0x8dfc6dd9, 0x56ebc54e, 0x1fe6a2c3,
	0xe40589d7, 0xad08ee5a, 0x761f46cd, 0x3f122140,
	0x05af02f1, 0x4ca2657c, 0x97b5cdeb, 0xdeb8aa66,
	0x255b8172, 0x6c56e6ff, 0xb7414e68, 0xfe4c29e5,
	0x444605f7, 0x0d4b627a, 0xd65ccaed, 0x9f51ad60,
	0x64b28674, 0x2dbfe1f9, 0xf6a8496e, 0xbfa52ee3,
	0x867d0cfd, 0xcf706b70, 0x1467c3e7, 0x5d6aa46a,
	0xa6898f7e, 0xef84e8f3, 0x34934064, 0x7d9e27e9,
	0xc7940bfb, 0x8e996c76, 0x558ec4e1, 0x1c83a36c,
	0xe7608878, 0xae6deff5, 0x757a4762, 0x3c7720ef,
	0x0d9406bc, 0x44996131, 0x9f8ec9a6, 0xd683ae2b,
	0x2d60853f, 0x646de2b2, 0xbf7a4a25, 0xf6772da8,
	0x4c7d01ba, 0x05706637, 0xde67cea0, 0x976aa92d,
	0x6c898239, 0x2584e5b4, 0xfe934d23, 0xb79e2aae,
	0x8e4608b0, 0xc74b6f3d, 0x1c5cc7aa, 0x5551a027,
	0xaeb28b33, 0xe7bfecbe, 0x3ca84429, 0x75a523a4,
	0xcfaf0fb6, 0x86a2683b, 0x5db5c0ac, 0x14b8a721,
	0xef5b8c35, 0xa656ebb8, 0x7d41432f, 0x344c24a2,
	0x0ef10713, 0x47fc609e, 0x9cebc809, 0xd5e6af84,
	0x2e058490, 0x6708e31d, 0xbc1f4b8a, 0xf5122c07,
	0x4f180015, 0x06156798, 0xdd02cf0f, 0x940fa882,
	0x6fec8396, 0x26e1e41b, 0xfdf64c8c, 0xb4fb2b01,
	0x8d23091f, 0xc42e6e92, 0x1f39c605, 0x5634a188,
	0xadd78a9c, 0xe4daed11, 0x3fcd4586, 0x76c0220b,
	0xccca0e19, 0x85c76994, 0x5ed0c103, 0x17dda68e,
	0xec3e8d9a, 0xa533ea17, 0x7e244280, 0x3729250d,
	0x0b5e05e2, 0x4253626f, 0x9944caf8, 0xd049ad75,
	0x2baa8661, 0x62a7e1ec, 0xb9b0497b, 0xf0bd2ef6,
	0x4ab702e4, 0x03ba6569, 0xd8adcdfe, 0x91a0aa73,
	0x6a438167, 0x234ee6ea, 0xf8594e7d, 0xb15429f0,
	0x888c0bee, 0xc1816c63, 0x1a96c4f4, 0x539ba379,
	0xa878886d, 0xe175efe0, 0x3a624777, 0x736f20fa,
	0xc9650ce8, 0x80686b65, 0x5b7fc3f2, 0x1272a47f,
	0xe9918f6b, 0xa09ce8e6, 0x7b8b4071, 0x328627fc,
	0x083b044d, 0x413663c0, 0x9a21cb57, 0xd32cacda,
	0x28cf87ce, 0x61c2e043, 0xbad548d4, 0xf3d82f59,
	0x49d2034b, 0x00df64c6, 0xdbc8cc51, 0x92c5abdc,
	0x692680c8, 0x202be745, 0xfb3c4fd2, 0xb231285f,
	0x8be90a41, 0xc2e46dcc, 0x19f3c55b, 0x50fea2d6,
	0xab1d89c2, 0xe210ee4f, 0x390746d8, 0x700a2155,
	0xca000d47, 0x830d6aca, 0x581ac25d, 0x1117a5d0,
	0xeaf48ec4, 0xa3f9e949, 0x78ee41de, 0x31e32653
	},{
	0x00000000, 0x1b280d78, 0x36501af0, 0x2d781788,
	0x6ca035e0, 0x77883898, 0x5af02f10, 0x41d82268,
	0xd9406bc0, 0xc26866b8, 0xef107130, 0xf4387c48,
	0xb5e05e20, 0xaec85358, 0x83b044d0, 0x989849a8,
	0xb641ca37, 0xad69c74f, 0x8011d0c7, 0x9b39ddbf,
	0xdae1ffd7, 0xc1c9f2af, 0xecb1e527, 0xf799e85f,
	0x6f01a1f7, 0x7429ac8f, 0x5951bb07, 0x4279b67f,
	0x03a19417, 0x1889996f, 0x35f18ee7, 0x2ed9839f,
	0x684289d9, 0x736a84a1, 0x5e129329, 0x453a9e51,
	0x04e2bc39, 0x1fcab141, 0x32b2a6c9, 0x299aabb1,
	0xb102e219, 0xaa2aef61, 0x8752f8e9, 0x9c7af591,
	0xdda2d7f9, 0xc68ada81, 0xebf2cd09, 0xf0dac071,
	0xde0343ee, 0xc52b4e96, 0xe853591e, 0xf37b5466,
	0xb2a3760e, 0xa98b7b76, 0x84f36cfe, 0x9fdb6186,
	0x0743282e, 0x1c6b2556, 0x311332de, 0x2a3b3fa6,
	0x6be31dce, 0x70cb10b6, 0x5db3073e, 0x469b0a46,
	0xd08513b2, 0xcbad1eca, 0xe6d50942, 0xfdfd043a,
	0xbc252652, 0xa70d2b2a, 0x8a753ca2, 0x915d31da,
	0x09c57872, 0x12ed750a, 0x3f956282, 0x24bd6ffa,
	0x65654d92, 0x7e4d40ea, 0x53355762, 0x481d5a1a,
	0x66c4d985, 0x7decd4fd, 0x5094c375, 0x4bbcce0d,
	0x0a64ec65, 0x114ce11d, 0x3c34f695, 0x271cfbed,
	0xbf84b245, 0xa4acbf3d, 0x89d4a8b5, 0x92fca5cd,
	0xd32487a5, 0xc80c8add, 0xe5749d55, 0xfe5c902d,
	0xb8c79a6b, 0xa3ef9713, 0x8e97809b, 0x95bf8de3,
	0xd467af8b, 0xcf4fa2f3, 0xe237b57b, 0xf91fb803,
	0x6187f1ab, 0x7aaffcd3, 0x57d7eb5b, 0x4cffe623,
	0x0d27c44b, 0x160fc933, 0x3b77debb, 0x205fd3c3,
	0x0e86505c, 0x15ae5d24, 0x38d64aac, 0x23fe47d4,
	0x622665bc, 0x790e68c4, 0x54767f4c, 0x4f5e7234,
	0xd7c63b9c, 0xccee36e4, 0xe196216c, 0xfabe2c14,
	0xbb660e7c, 0xa04e0304, 0x8d36148c, 0x961e19f4,
	0xa5cb3ad3, 0xbee337ab, 0x939b2023, 0x88b32d5b,
	0xc96b0f33, 0xd243024b, 0xff3b15c3, 0xe41318bb,
	0x7c8b5113, 0x67a35c6b, 0x4adb4be3, 0x51f3469b,
	0x102b64f3, 0x0b03698b, 0x267b7e03, 0x3d53737b,
	0x138af0e4, 0x08a2fd9c, 0x25daea14, 0x3ef2e76c,
	0x7f2ac504, 0x6402c87c, 0x497adff4, 0x5252d28c,
	0xcaca9b24, 0xd1e2965c, 0xfc9a81d4, 0xe7b28cac,
	0xa66aaec4, 0xbd42a3bc, 0x903ab434, 0x8b12b94c,
	0xcd89b30a, 0xd6a1be72, 0xfbd9a9fa, 0xe0f1a482,
	0xa12986ea, 0xba018b92, 0x97799c1a, 0x8c519162,
	0x14c9d8ca, 0x0fe1d5b2, 0x2299c23a, 0x39b1cf42,
	0x7869ed2a, 0x6341e052, 0x4e39f7da, 0x5511faa2,
	0x7bc8793d, 0x60e07445, 0x4d9863cd, 0x56b06eb5,
	0x17684cdd, 0x0c4041a5, 0x2138562d, 0x3a105b55,
	0xa28812fd, 0xb9a01f85, 0x94d8080d, 0x8ff00575,
	0xce28271d, 0xd5002a65, 0xf8783ded, 0xe3503095,
	0x754e2961, 0x6e662419, 0x431e3391, 0x58363ee9,
	0x19ee1c81, 0x02c611f9, 0x2fbe0671, 0x34960b09,
	0xac0e42a1, 0xb7264fd9, 0x9a5e5851, 0x81765529,
	0xc0ae7741, 0xdb867a39, 0xf6fe6db1, 0xedd660c9,
	0xc30fe356, 0xd827ee2e, 0xf55ff9a6, 0xee77f4de,
	0xafafd6b6, 0xb487dbce, 0x99ffcc46, 0x82d7c13e,
	0x1a4f8896, 0x016785ee, 0x2c1f9266, 0x37379f1e,
	0x76efbd76, 0x6dc7b00e, 0x40bfa786, 0x5b97aafe,
	0x1d0ca0b8, 0x0624adc0, 0x2b5cba48, 0x3074b730,
	0x71ac9558, 0x6a849820, 0x47fc8fa8, 0x5cd482d0,
	0xc44ccb78, 0xdf64c600, 0xf21cd188, 0xe934dcf0,
	0xa8ecfe98, 0xb3c4f3e0, 0x9ebce468, 0x8594e910,
	0xab4d6a8f, 0xb06567f7, 0x9d1d707f, 0x86357d07,
	0xc7ed5f6f, 0xdcc55217, 0xf1bd459f, 0xea9548e7,
	0x720d014f, 0x69250c37, 0x445d1bbf, 0x5f7516c7,
	0x1ead34af, 0x058539d7, 0x28fd2e5f, 0x33d52327
	},{
	0x00000000, 0x4f576811, 0x9eaed022, 0xd1f9b833,
	0x399cbdf3, 0x76cbd5e2, 0xa7326dd1, 0xe86505c0,
	0x73397be6, 0x3c6e13f7, 0xed97abc4, 0xa2c0c3d5,
	0x4aa5c615, 0x05f2ae04, 0xd40b1637, 0x9b5c7e26,
	0xe672f7cc, 0xa9259fdd, 0x78dc27ee, 0x378b4fff,
	0xdfee4a3f, 0x90b9222e, 0x41409a1d, 0x0e17f20c,
	0x954b8c2a, 0xda1ce43b, 0x0be55c08, 0x44b23419,
	0xacd731d9, 0xe38059c8, 0x3279e1fb, 0x7d2e89ea,
	0xc824f22f, 0x87739a3e, 0x568a220d, 0x19dd4a1c,
	0xf1b84fdc, 0xbeef27cd, 0x6f169ffe, 0x2041f7ef,
	0xbb1d89c9, 0xf44ae1d8, 0x25b359eb, 0x6ae431fa,
	0x8281343a, 0xcdd65c2b, 0x1c2fe418, 0x53788c09,
	0x2e5605e3, 0x61016df2, 0xb0f8d5c1, 0xffafbdd0,
	0x17cab810, 0x589dd001, 0x89646832, 0xc6330023,
	0x5d6f7e05, 0x12381614, 0xc3c1ae27, 0x8c96c636,
	0x64f3c3f6, 0x2ba4abe7, 0xfa5d13d4, 0xb50a7bc5,
	0x9488f9e9, 0xdbdf91f8, 0x0a2629cb, 0x457141da,
	0xad14441a, 0xe2432c0b, 0x33ba9438, 0x7cedfc29,
	0xe7b1820f, 0xa8e6ea1e, 0x791f522d, 0x36483a3c,
	0xde2d3ffc, 0x917a57ed, 0x4083efde, 0x0fd487cf,
	0x72fa0e25, 0x3dad6634, 0xec54de07, 0xa303b616,
	0x4b66b3d6, 0x0431dbc7, 0xd5c863f4, 0x9a9f0be5,
	0x01c375c3, 0x4e941dd2, 0x9f6da5e1, 0xd03acdf0,
	0x385fc830, 0x7708a021, 0xa6f11812, 0xe9a67003,
	0x5cac0bc6, 0x13fb63d7, 0xc202dbe4, 0x8d55b3f5,
	0x6530b635, 0x2a67de24, 0xfb9e6617, 0xb4c90e06,
	0x2f957020, 0x60c21831, 0xb13ba002, 0xfe6cc813,
	0x1609cdd3, 0x595ea5c2, 0x88a71df1, 0xc7f075e0,
	0xbadefc0a, 0xf589941b, 0x24702c28, 0x6b274439,
	0x834241f9, 0xcc1529e8, 0x1dec91db, 0x52bbf9ca,
	0xc9e787ec, 0x86b0effd, 0x574957ce, 0x181e3fdf,
	0xf07b3a1f, 0xbf2c520e, 0x6ed5ea3d, 0x2182822c,
	0x2dd0ee65, 0x62878674, 0xb37e3e47, 0xfc295656,
	0x144c5396, 0x5b1b3b87, 0x8ae283b4, 0xc5b5eba5,
	0x5ee99583, 0x11befd92, 0xc04745a1, 0x8f102db0,
	0x67752870, 0x28224061, 0xf9dbf852, 0xb68c9043,
	0xcba219a9, 0x84f571b8, 0x550cc98b, 0x1a5ba19a,
	0xf23ea45a, 0xbd69cc4b, 0x6c907478, 0x23c71c69,
	0xb89b624f, 0xf7cc0a5e, 0x2635b26d, 0x6962da7c,
	0x8107dfbc, 0xce50b7ad, 0x1fa90f9e, 0x50fe678f,
	0xe5f41c4a, 0xaaa3745b, 0x7b5acc68, 0x340da479,
	0xdc68a1b9, 0x933fc9a8, 0x42c6719b, 0x0d91198a,
	0x96cd67ac, 0xd99a0fbd, 0x0863b78e, 0x4734df9f,
	0xaf51da5f, 0xe006b24e, 0x31ff0a7d, 0x7ea8626c,
	0x0386eb86, 0x4cd18397, 0x9d283ba4, 0xd27f53b5,
	0x3a1a5675, 0x754d3e64, 0xa4b48657, 0xebe3ee46,
	0x70bf9060, 0x3fe8f871, 0xee114042, 0xa1462853,
	0x49232d93, 0x06744582, 0xd78dfdb1, 0x98da95a0,
	0xb958178c, 0xf60f7f9d, 0x27f6c7ae, 0x68a1afbf,
	0x80c4aa7f, 0xcf93c26e, 0x1e6a7a5d, 0x513d124c,
	0xca616c6a, 0x8536047b, 0x54cfbc48, 0x1b98d459,
	0xf3fdd199, 0xbcaab988, 0x6d5301bb, 0x220469aa,
	0x5f2ae040, 0x107d8851, 0xc1843062, 0x8ed35873,
	0x66b65db3, 0x29e135a2, 0xf8188d91, 0xb74fe580,
	0x2c139ba6, 0x6344f3b7, 0xb2bd4b84, 0xfdea2395,
	0x158f2655, 0x5ad84e44, 0x8b21f677, 0xc4769e66,
	0x717ce5a3, 0x3e2b8db2, 0xefd23581, 0xa0855d90,
	0x48e05850, 0x07b73041, 0xd64e8872, 0x9919e063,
	0x02459e45, 0x4d12f654, 0x9ceb4e67, 0xd3bc2676,
	0x3bd923b6, 0x748e4ba7, 0xa577f394, 0xea209b85,
	0x970e126f, 0xd8597a7e, 0x09a0c24d, 0x46f7aa5c,
	0xae92af9c, 0xe1c5c78d, 0x303c7fbe, 0x7f6b17af,
	0xe4376989, 0xab600198, 0x7a99b9ab, 0x35ced1ba,
	0xddabd47a, 0x92fcbc6b, 0x43050458, 0x0c526c49
	},{
	0x00000000, 0x5ba1dcca, 0xb743b994, 0xece2655e,
	0x6a466e9f, 0x31e7b255, 0xdd05d70b, 0x86a40bc1,
	0xd48cdd3e, 0x8f2d01f4, 0x63cf64aa, 0x386eb860,
	0xbecab3a1, 0xe56b6f6b, 0x09890a35, 0x5228d6ff,
	0xadd8a7cb, 0xf6797b01, 0x1a9b1e5f, 0x413ac295,
	0xc79ec954, 0x9c3f159e, 0x70dd70c0, 0x2b7cac0a,
	0x79547af5, 0x22f5a63f, 0xce17c361, 0x95b61fab,
	0x1312146a, 0x48b3c8a0, 0xa451adfe, 0xfff07134,
	0x5f705221, 0x04d18eeb, 0xe833ebb5, 0xb392377f,
	0x35363cbe, 0x6e97e074, 0x8275852a, 0xd9d459e0,
	0x8bfc8f1f, 0xd05d53d5, 0x3cbf368b, 0x671eea41,
	0xe1bae180, 0xba1b3d4a, 0x56f95814, 0x0d5884de,
	0xf2a8f5ea, 0xa9092920, 0x45eb4c7e, 0x1e4a90b4,
	0x98ee9b75, 0xc34f47bf, 0x2fad22e1, 0x740cfe2b,
	0x262428d4, 0x7d85f41e, 0x91679140, 0xcac64d8a,
	0x4c62464b, 0x17c39a81, 0xfb21ffdf, 0xa0802315,
	0xbee0a442, 0xe5417888, 0x09a31dd6, 0x5202c11c,
	0xd4a6cadd, 0x8f071617, 0x63e57349, 0x3844af83,
	0x6a6c797c, 0x31cda5b6, 0xdd2fc0e8, 0x868e1c22,
	0x002a17e3, 0x5b8bcb29, 0xb769ae77, 0xecc872bd,
	0x13380389, 0x4899df43, 0xa47bba1d, 0xffda66d7,
	0x797e6d16, 0x22dfb1dc, 0xce3dd482, 0x959c0848,
	0xc7b4deb7, 0x9c15027d, 0x70f76723, 0x2b56bbe9,
	0xadf2b028, 0xf6536ce2, 0x1ab109bc, 0x4110d576,
	0xe190f663, 0xba312aa9, 0x56d34ff7, 0x0d72933d,
	0x8bd698fc, 0xd0774436, 0x3c952168, 0x6734fda2,
	0x351c2b5d, 0x6ebdf797, 0x825f92c9, 0xd9fe4e03,
	0x5f5a45c2, 0x04fb9908, 0xe819fc56, 0xb3b8209c,
	0x4c4851a8, 0x17e98d62, 0xfb0be83c, 0xa0aa34f6,
	0x260e3f37, 0x7dafe3fd, 0x914d86a3, 0xcaec5a69,
	0x98c48c96, 0xc365505c, 0x2f873502, 0x7426e9c8,
	0xf282e209, 0xa9233ec3, 0x45c15b9d, 0x1e608757,
	0x79005533, 0x22a189f9, 0xce43eca7, 0x95e2306d,
	0x13463bac, 0x48e7e766, 0xa4058238, 0xffa45ef2,
	0xad8c880d, 0xf62d54c7, 0x1acf3199, 0x416eed53,
	0xc7cae692, 0x9c6b3a58, 0x70895f06, 0x2b2883cc,
	0xd4d8f2f8, 0x8f792e32, 0x639b4b6c, 0x383a97a6,
	0xbe9e9c67, 0xe53f40ad, 0x09dd25f3, 0x527cf939,
	0x00542fc6, 0x5bf5f30c, 0xb7179652, 0xecb64a98,
	0x6a124159, 0x31b39d93, 0xdd51f8cd, 0x86f02407,
	0x26700712, 0x7dd1dbd8, 0x9133be86, 0xca92624c,
	0x4c36698d, 0x1797b547, 0xfb75d019, 0xa0d40cd3,
	0xf2fcda2c, 0xa95d06e6, 0x45bf63b8, 0x1e1ebf72,
	0x98bab4b3, 0xc31b6879, 0x2ff90d27, 0x7458d1ed,
	0x8ba8a0d9, 0xd0097c13, 0x3ceb194d, 0x674ac587,
	0xe1eece46, 0xba4f128c, 0x56ad77d2, 0x0d0cab18,
	0x5f247de7, 0x0485a12d, 0xe867c473, 0xb3c618b9,
	0x35621378, 0x6ec3cfb2, 0x8221aaec, 0xd9807626,
	0xc7e0f171, 0x9c412dbb, 0x70a348e5, 0x2b02942f,
	0xada69fee, 0xf6074324, 0x1ae5267a, 0x4144fab0,
	0x136c2c4f, 0x48cdf085, 0xa42f95db, 0xff8e4911,
	0x792a42d0, 0x228b9e1a, 0xce69fb44, 0x95c8278e,
	0x6a3856ba, 0x31998a70, 0xdd7bef2e, 0x86da33e4,
	0x007e3825, 0x5bdfe4ef, 0xb73d81b1, 0xec9c5d7b,
	0xbeb48b84, 0xe515574e, 0x09f73210, 0x5256eeda,
	0xd4f2e51b, 0x8f5339d1, 0x63b15c8f, 0x38108045,
	0x9890a350, 0xc3317f9a, 0x2fd31ac4, 0x7472c60e,
	0xf2d6cdcf, 0xa9771105, 0x4595745b, 0x1e34a891,
	0x4c1c7e6e, 0x17bda2a4, 0xfb5fc7fa, 0xa0fe1b30,
	0x265a10f1, 0x7dfbcc3b, 0x9119a965, 0xcab875af,
	0x3548049b, 0x6ee9d851, 0x820bbd0f, 0xd9aa61c5,
	0x5f0e6a04, 0x04afb6ce, 0xe84dd390, 0xb3ec0f5a,
	0xe1c4d9a5, 0xba65056f, 0x56876031, 0x0d26bcfb,
	0x8b82b73a, 0xd0236bf0, 0x3cc10eae, 0x6760d264
	}
};

static const unsigned int __attribute__((aligned(128))) crc32ctable_le[8][256] = {
	{
	0x00000000, 0x03836bf2, 0xf7703be1, 0xf4f35013,
	0x1f979ac7, 0x1c14f135, 0xe8e7a126, 0xeb64cad4,
	0xcf58d98a, 0xccdbb278, 0x3828e26b, 0x3bab8999,
	0xd0cf434d, 0xd34c28bf, 0x27bf78ac, 0x243c135e,
	0x6fc75e10, 0x6c4435e2, 0x98b765f1, 0x9b340e03,
	0x7050c4d7, 0x73d3af25, 0x8720ff36, 0x84a394c4,
	0xa09f879a, 0xa31cec68, 0x57efbc7b, 0x546cd789,
	0xbf081d5d, 0xbc8b76af, 0x487826bc, 0x4bfb4d4e,
	0xde8ebd20, 0xdd0dd6d2, 0x29fe86c1, 0x2a7ded33,
	0xc11927e7, 0xc29a4c15, 0x36691c06, 0x35ea77f4,
	0x11d664aa, 0x12550f58, 0xe6a65f4b, 0xe52534b9,
	0x0e41fe6d, 0x0dc2959f, 0xf931c58c, 0xfab2ae7e,
	0xb149e330, 0xb2ca88c2, 0x4639d8d1, 0x45bab323,
	0xaede79f7, 0xad5d1205, 0x59ae4216, 0x5a2d29e4,
	0x7e113aba, 0x7d925148, 0x8961015b, 0x8ae26aa9,
	0x6186a07d, 0x6205cb8f, 0x96f69b9c, 0x9575f06e,
	0xbc1d7b41, 0xbf9e10b3, 0x4b6d40a0, 0x48ee2b52,
	0xa38ae186, 0xa0098a74, 0x54fada67, 0x5779b195,
	0x7345a2cb, 0x70c6c939, 0x8435992a, 0x87b6f2d8,
	0x6cd2380c, 0x6f5153fe, 0x9ba203ed, 0x9821681f,
	0xd3da2551, 0xd0594ea3, 0x24aa1eb0, 0x27297542,
	0xcc4dbf96, 0xcfced464, 0x3b3d8477, 0x38beef85,
	0x1c82fcdb, 0x1f019729, 0xebf2c73a, 0xe871acc8,
	0x0315661c, 0x00960dee, 0xf4655dfd, 0xf7e6360f,
	0x6293c661, 0x6110ad93, 0x95e3fd80, 0x96609672,
	0x7d045ca6, 0x7e873754, 0x8a746747, 0x89f70cb5,
	0xadcb1feb, 0xae487419, 0x5abb240a, 0x59384ff8,
	0xb25c852c, 0xb1dfeede, 0x452cbecd, 0x46afd53f,
	0x0d549871, 0x0ed7f383, 0xfa24a390, 0xf9a7c862,
	0x12c302b6, 0x11406944, 0xe5b33957, 0xe63052a5,
	0xc20c41fb, 0xc18f2a09, 0x357c7a1a, 0x36ff11e8,
	0xdd9bdb3c, 0xde18b0ce, 0x2aebe0dd, 0x29688b2f,
	0x783bf682, 0x7bb89d70, 0x8f4bcd63, 0x8cc8a691,
	0x67ac6c45, 0x642f07b7, 0x90dc57a4, 0x935f3c56,
	0xb7632f08, 0xb4e044fa, 0x401314e9, 0x43907f1b,
	0xa8f4b5cf, 0xab77de3d, 0x5f848e2e, 0x5c07e5dc,
	0x17fca892, 0x147fc360, 0xe08c9373, 0xe30ff881,
	0x086b3255, 0x0be859a7, 0xff1b09b4, 0xfc986246,
	0xd8a47118, 0xdb271aea, 0x2fd44af9, 0x2c57210b,
	0xc733ebdf, 0xc4b0802d, 0x3043d03e, 0x33c0bbcc,
	0xa6b54ba2, 0xa5362050, 0x51c57043, 0x52461bb1,
	0xb922d165, 0xbaa1ba97, 0x4e52ea84, 0x4dd18176,
	0x69ed9228, 0x6a6ef9da, 0x9e9da9c9, 0x9d1ec23b,
	0x767a08ef, 0x75f9631d, 0x810a330e, 0x828958fc,
	0xc97215b2, 0xcaf17e40, 0x3e022e53, 0x3d8145a1,
	0xd6e58f75, 0xd566e487, 0x2195b494, 0x2216df66,
	0x062acc38, 0x05a9a7ca, 0xf15af7d9, 0xf2d99c2b,
	0x19bd56ff, 0x1a3e3d0d, 0xeecd6d1e, 0xed4e06ec,
	0xc4268dc3, 0xc7a5e631, 0x3356b622, 0x30d5ddd0,
	0xdbb11704, 0xd8327cf6, 0x2cc12ce5, 0x2f424717,
	0x0b7e5449, 0x08fd3fbb, 0xfc0e6fa8, 0xff8d045a,
	0x14e9ce8e, 0x176aa57c, 0xe399f56f, 0xe01a9e9d,
	0xabe1d3d3, 0xa862b821, 0x5c91e832, 0x5f1283c0,
	0xb4764914, 0xb7f522e6, 0x430672f5, 0x40851907,
	0x64b90a59, 0x673a61ab, 0x93c931b8, 0x904a5a4a,
	0x7b2e909e, 0x78adfb6c, 0x8c5eab7f, 0x8fddc08d,
	0x1aa830e3, 0x192b5b11, 0xedd80b02, 0xee5b60f0,
	0x053faa24, 0x06bcc1d6, 0xf24f91c5, 0xf1ccfa37,
	0xd5f0e969, 0xd673829b, 0x2280d288, 0x2103b97a,
	0xca6773ae, 0xc9e4185c, 0x3d17484f, 0x3e9423bd,
	0x756f6ef3, 0x76ec0501, 0x821f5512, 0x819c3ee0,
	0x6af8f434, 0x697b9fc6, 0x9d88cfd5, 0x9e0ba427,
	0xba37b779, 0xb9b4dc8b, 0x4d478c98, 0x4ec4e76a,
	0xa5a02dbe, 0xa623464c, 0x52d0165f, 0x51537dad
	},{
	0x00000000, 0x7798a213, 0xee304527, 0x99a8e734,
	0xdc618a4e, 0xabf9285d, 0x3251cf69, 0x45c96d7a,
	0xb8c3149d, 0xcf5bb68e, 0x56f351ba, 0x216bf3a9,
	0x64a29ed3, 0x133a3cc0, 0x8a92dbf4, 0xfd0a79e7,
	0x81f1c53f, 0xf669672c, 0x6fc18018, 0x1859220b,
	0x5d904f71, 0x2a08ed62, 0xb3a00a56, 0xc438a845,
	0x3932d1a2, 0x4eaa73b1, 0xd7029485, 0xa09a3696,
	0xe5535bec, 0x92cbf9ff, 0x0b631ecb, 0x7cfbbcd8,
	0x02e38b7f, 0x757b296c, 0xecd3ce58, 0x9b4b6c4b,
	0xde820131, 0xa91aa322, 0x30b24416, 0x472ae605,
	0xba209fe2, 0xcdb83df1, 0x5410dac5, 0x238878d6,
	0x664115ac, 0x11d9b7bf, 0x8871508b, 0xffe9f298,
	0x83124e40, 0xf48aec53, 0x6d220b67, 0x1abaa974,
	0x5f73c40e, 0x28eb661d, 0xb1438129, 0xc6db233a,
	0x3bd15add, 0x4c49f8ce, 0xd5e11ffa, 0xa279bde9,
	0xe7b0d093, 0x90287280, 0x098095b4, 0x7e1837a7,
	0x04c617ff, 0x735eb5ec, 0xeaf652d8, 0x9d6ef0cb,
	0xd8a79db1, 0xaf3f3fa2, 0x3697d896, 0x410f7a85,
	0xbc050362, 0xcb9da171, 0x52354645, 0x25ade456,
	0x6064892c, 0x17fc2b3f, 0x8e54cc0b, 0xf9cc6e18,
	0x8537d2c0, 0xf2af70d3, 0x6b0797e7, 0x1c9f35f4,
	0x5956588e, 0x2ecefa9d, 0xb7661da9, 0xc0febfba,
	0x3df4c65d, 0x4a6c644e, 0xd3c4837a, 0xa45c2169,
	0xe1954c13, 0x960dee00, 0x0fa50934, 0x783dab27,
	0x06259c80, 0x71bd3e93, 0xe815d9a7, 0x9f8d7bb4,
	0xda4416ce, 0xaddcb4dd, 0x347453e9, 0x43ecf1fa,
	0xbee6881d, 0xc97e2a0e, 0x50d6cd3a, 0x274e6f29,
	0x62870253, 0x151fa040, 0x8cb74774, 0xfb2fe567,
	0x87d459bf, 0xf04cfbac, 0x69e41c98, 0x1e7cbe8b,
	0x5bb5d3f1, 0x2c2d71e2, 0xb58596d6, 0xc21d34c5,
	0x3f174d22, 0x488fef31, 0xd1270805, 0xa6bfaa16,
	0xe376c76c, 0x94ee657f, 0x0d46824b, 0x7ade2058,
	0xf9fac3fb, 0x8e6261e8, 0x17ca86dc, 0x605224cf,
	0x259b49b5, 0x5203eba6, 0xcbab0c92, 0xbc33ae81,
	0x4139d766, 0x36a17575, 0xaf099241, 0xd8913052,
	0x9d585d28, 0xeac0ff3b, 0x7368180f, 0x04f0ba1c,
	0x780b06c4, 0x0f93a4d7, 0x963b43e3, 0xe1a3e1f0,
	0xa46a8c8a, 0xd3f22e99, 0x4a5ac9ad, 0x3dc26bbe,
	0xc0c81259, 0xb750b04a, 0x2ef8577e, 0x5960f56d,
	0x1ca99817, 0x6b313a04, 0xf299dd30, 0x85017f23,
	0xfb194884, 0x8c81ea97, 0x15290da3, 0x62b1afb0,
	0x2778c2ca, 0x50e060d9, 0xc94887ed, 0xbed025fe,
	0x43da5c19, 0x3442fe0a, 0xadea193e, 0xda72bb2d,
	0x9fbbd657, 0xe8237444, 0x718b9370, 0x06133163,
	0x7ae88dbb, 0x0d702fa8, 0x94d8c89c, 0xe3406a8f,
	0xa68907f5, 0xd111a5e6, 0x48b942d2, 0x3f21e0c1,
	0xc22b9926, 0xb5b33b35, 0x2c1bdc01, 0x5b837e12,
	0x1e4a1368, 0x69d2b17b, 0xf07a564f, 0x87e2f45c,
	0xfd3cd404, 0x8aa47617, 0x130c9123, 0x64943330,
	0x215d5e4a, 0x56c5fc59, 0xcf6d1b6d, 0xb8f5b97e,
	0x45ffc099, 0x3267628a, 0xabcf85be, 0xdc5727ad,
	0x999e4ad7, 0xee06e8c4, 0x77ae0ff0, 0x0036ade3,
	0x7ccd113b, 0x0b55b328, 0x92fd541c, 0xe565f60f,
	0xa0ac9b75, 0xd7343966, 0x4e9cde52, 0x39047c41,
	0xc40e05a6, 0xb396a7b5, 0x2a3e4081, 0x5da6e292,
	0x186f8fe8, 0x6ff72dfb, 0xf65fcacf, 0x81c768dc,
	0xffdf5f7b, 0x8847fd68, 0x11ef1a5c, 0x6677b84f,
	0x23bed535, 0x54267726, 0xcd8e9012, 0xba163201,
	0x471c4be6, 0x3084e9f5, 0xa92c0ec1, 0xdeb4acd2,
	0x9b7dc1a8, 0xece563bb, 0x754d848f, 0x02d5269c,
	0x7e2e9a44, 0x09b63857, 0x901edf63, 0xe7867d70,
	0xa24f100a, 0xd5d7b219, 0x4c7f552d, 0x3be7f73e,
	0xc6ed8ed9, 0xb1752cca, 0x28ddcbfe, 0x5f4569ed,
	0x1a8c0497, 0x6d14a684, 0xf4bc41b0, 0x8324e3a3
	},{
	0x00000000, 0x7e9241a5, 0x0d526f4f, 0x73c02eea,
	0x1aa4de9e, 0x64369f3b, 0x17f6b1d1, 0x6964f074,
	0xc53e5138, 0xbbac109d, 0xc86c3e77, 0xb6fe7fd2,
	0xdf9a8fa6, 0xa108ce03, 0xd2c8e0e9, 0xac5aa14c,
	0x8a7da270, 0xf4efe3d5, 0x872fcd3f, 0xf9bd8c9a,
	0x90d97cee, 0xee4b3d4b, 0x9d8b13a1, 0xe3195204,
	0x4f43f348, 0x31d1b2ed, 0x42119c07, 0x3c83dda2,
	0x55e72dd6, 0x2b756c73, 0x58b54299, 0x2627033c,
	0x14fb44e1, 0x6a690544, 0x19a92bae, 0x673b6a0b,
	0x0e5f9a7f, 0x70cddbda, 0x030df530, 0x7d9fb495,
	0xd1c515d9, 0xaf57547c, 0xdc977a96, 0xa2053b33,
	0xcb61cb47, 0xb5f38ae2, 0xc633a408, 0xb8a1e5ad,
	0x9e86e691, 0xe014a734, 0x93d489de, 0xed46c87b,
	0x8422380f, 0xfab079aa, 0x89705740, 0xf7e216e5,
	0x5bb8b7a9, 0x252af60c, 0x56ead8e6, 0x28789943,
	0x411c6937, 0x3f8e2892, 0x4c4e0678, 0x32dc47dd,
	0xd98065c7, 0xa7122462, 0xd4d20a88, 0xaa404b2d,
	0xc324bb59, 0xbdb6fafc, 0xce76d416, 0xb0e495b3,
	0x1cbe34ff, 0x622c755a, 0x11ec5bb0, 0x6f7e1a15,
	0x061aea61, 0x7888abc4, 0x0b48852e, 0x75dac48b,
	0x53fdc7b7, 0x2d6f8612, 0x5eafa8f8, 0x203de95d,
	0x49591929, 0x37cb588c, 0x440b7666, 0x3a9937c3,
	0x96c3968f, 0xe851d72a, 0x9b91f9c0, 0xe503b865,
	0x8c674811, 0xf2f509b4, 0x8135275e, 0xffa766fb,
	0xcd7b2126, 0xb3e96083, 0xc0294e69, 0xbebb0fcc,
	0xd7dfffb8, 0xa94dbe1d, 0xda8d90f7, 0xa41fd152,
	0x0845701e, 0x76d731bb, 0x05171f51, 0x7b855ef4,
	0x12e1ae80, 0x6c73ef25, 0x1fb3c1cf, 0x6121806a,
	0x47068356, 0x3994c2f3, 0x4a54ec19, 0x34c6adbc,
	0x5da25dc8, 0x23301c6d, 0x50f03287, 0x2e627322,
	0x8238d26e, 0xfcaa93cb, 0x8f6abd21, 0xf1f8fc84,
	0x989c0cf0, 0xe60e4d55, 0x95ce63bf, 0xeb5c221a,
	0x4377278b, 0x3de5662e, 0x4e2548c4, 0x30b70961,
	0x59d3f915, 0x2741b8b0, 0x5481965a, 0x2a13d7ff,
	0x864976b3, 0xf8db3716, 0x8b1b19fc, 0xf5895859,
	0x9ceda82d, 0xe27fe988, 0x91bfc762, 0xef2d86c7,
	0xc90a85fb, 0xb798c45e, 0xc458eab4, 0xbacaab11,
	0xd3ae5b65, 0xad3c1ac0, 0xdefc342a, 0xa06e758f,
	0x0c34d4c3, 0x72a69566, 0x0166bb8c, 0x7ff4fa29,
	0x16900a5d, 0x68024bf8, 0x1bc26512, 0x655024b7,
	0x578c636a, 0x291e22cf, 0x5ade0c25, 0x244c4d80,
	0x4d28bdf4, 0x33bafc51, 0x407ad2bb, 0x3ee8931e,
	0x92b23252, 0xec2073f7, 0x9fe05d1d, 0xe1721cb8,
	0x8816eccc, 0xf684ad69, 0x85448383, 0xfbd6c226,
	0xddf1c11a, 0xa36380bf, 0xd0a3ae55, 0xae31eff0,
	0xc7551f84, 0xb9c75e21, 0xca0770cb, 0xb495316e,
	0x18cf9022, 0x665dd187, 0x159dff6d, 0x6b0fbec8,
	0x026b4ebc, 0x7cf90f19, 0x0f3921f3, 0x71ab6056,
	0x9af7424c, 0xe46503e9, 0x97a52d03, 0xe9376ca6,
	0x80539cd2, 0xfec1dd77, 0x8d01f39d, 0xf393b238,
	0x5fc91374, 0x215b52d1, 0x529b7c3b, 0x2c093d9e,
	0x456dcdea, 0x3bff8c4f, 0x483fa2a5, 0x36ade300,
	0x108ae03c, 0x6e18a199, 0x1dd88f73, 0x634aced6,
	0x0a2e3ea2, 0x74bc7f07, 0x077c51ed, 0x79ee1048,
	0xd5b4b104, 0xab26f0a1, 0xd8e6de4b, 0xa6749fee,
	0xcf106f9a, 0xb1822e3f, 0xc24200d5, 0xbcd04170,
	0x8e0c06ad, 0xf09e4708, 0x835e69e2, 0xfdcc2847,
	0x94a8d833, 0xea3a9996, 0x99fab77c, 0xe768f6d9,
	0x4b325795, 0x35a01630, 0x466038da, 0x38f2797f,
	0x5196890b, 0x2f04c8ae, 0x5cc4e644, 0x2256a7e1,
	0x0471a4dd, 0x7ae3e578, 0x0923cb92, 0x77b18a37,
	0x1ed57a43, 0x60473be6, 0x1387150c, 0x6d1554a9,
	0xc14ff5e5, 0xbfddb440, 0xcc1d9aaa, 0xb28fdb0f,
	0xdbeb2b7b, 0xa5796ade, 0xd6b94434, 0xa82b0591
	},{
	0x00000000, 0xb8aa45dd, 0x812367bf, 0x39892262,
	0xf331227b, 0x4b9b67a6, 0x721245c4, 0xcab80019,
	0xe66344f6, 0x5ec9012b, 0x67402349, 0xdfea6694,
	0x1552668d, 0xadf82350, 0x94710132, 0x2cdb44ef,
	0x3db164e9, 0x851b2134, 0xbc920356, 0x0438468b,
	0xce804692, 0x762a034f, 0x4fa3212d, 0xf70964f0,
	0xdbd2201f, 0x637865c2, 0x5af147a0, 0xe25b027d,
	0x28e30264, 0x904947b9, 0xa9c065db, 0x116a2006,
	0x8b1425d7, 0x33be600a, 0x0a374268, 0xb29d07b5,
	0x782507ac, 0xc08f4271, 0xf9066013, 0x41ac25ce,
	0x6d776121, 0xd5dd24fc, 0xec54069e, 0x54fe4343,
	0x9e46435a, 0x26ec0687, 0x1f6524e5, 0xa7cf6138,
	0xb6a5413e, 0x0e0f04e3, 0x37862681, 0x8f2c635c,
	0x45946345, 0xfd3e2698, 0xc4b704fa, 0x7c1d4127,
	0x50c605c8, 0xe86c4015, 0xd1e56277, 0x694f27aa,
	0xa3f727b3, 0x1b5d626e, 0x22d4400c, 0x9a7e05d1,
	0xe75fa6ab, 0x5ff5e376, 0x667cc114, 0xded684c9,
	0x146e84d0, 0xacc4c10d, 0x954de36f, 0x2de7a6b2,
	0x013ce25d, 0xb996a780, 0x801f85e2, 0x38b5c03f,
	0xf20dc026, 0x4aa785fb, 0x732ea799, 0xcb84e244,
	0xdaeec242, 0x6244879f, 0x5bcda5fd, 0xe367e020,
	0x29dfe039, 0x9175a5e4, 0xa8fc8786, 0x1056c25b,
	0x3c8d86b4, 0x8427c369, 0xbdaee10b, 0x0504a4d6,
	0xcfbca4cf, 0x7716e112, 0x4e9fc370, 0xf63586ad,
	0x6c4b837c, 0xd4e1c6a1, 0xed68e4c3, 0x55c2a11e,
	0x9f7aa107, 0x27d0e4da, 0x1e59c6b8, 0xa6f38365,
	0x8a28c78a, 0x32828257, 0x0b0ba035, 0xb3a1e5e8,
	0x7919e5f1, 0xc1b3a02c, 0xf83a824e, 0x4090c793,
	0x51fae795, 0xe950a248, 0xd0d9802a, 0x6873c5f7,
	0xa2cbc5ee, 0x1a618033, 0x23e8a251, 0x9b42e78c,
	0xb799a363, 0x0f33e6be, 0x36bac4dc, 0x8e108101,
	0x44a88118, 0xfc02c4c5, 0xc58be6a7, 0x7d21a37a,
	0x3fc9a052, 0x8763e58f, 0xbeeac7ed, 0x06408230,
	0xccf88229, 0x7452c7f4, 0x4ddbe596, 0xf571a04b,
	0xd9aae4a4, 0x6100a179, 0x5889831b, 0xe023c6c6,
	0x2a9bc6df, 0x92318302, 0xabb8a160, 0x1312e4bd,
	0x0278c4bb, 0xbad28166, 0x835ba304, 0x3bf1e6d9,
	0xf149e6c0, 0x49e3a31d, 0x706a817f, 0xc8c0c4a2,
	0xe41b804d, 0x5cb1c590, 0x6538e7f2, 0xdd92a22f,
	0x172aa236, 0xaf80e7eb, 0x9609c589, 0x2ea38054,
	0xb4dd8585, 0x0c77c058, 0x35fee23a, 0x8d54a7e7,
	0x47eca7fe, 0xff46e223, 0xc6cfc041, 0x7e65859c,
	0x52bec173, 0xea1484ae, 0xd39da6cc, 0x6b37e311,
	0xa18fe308, 0x1925a6d5, 0x20ac84b7, 0x9806c16a,
	0x896ce16c, 0x31c6a4b1, 0x084f86d3, 0xb0e5c30e,
	0x7a5dc317, 0xc2f786ca, 0xfb7ea4a8, 0x43d4e175,
	0x6f0fa59a, 0xd7a5e047, 0xee2cc225, 0x568687f8,
	0x9c3e87e1, 0x2494c23c, 0x1d1de05e, 0xa5b7a583,
	0xd89606f9, 0x603c4324, 0x59b56146, 0xe11f249b,
	0x2ba72482, 0x930d615f, 0xaa84433d, 0x122e06e0,
	0x3ef5420f, 0x865f07d2, 0xbfd625b0, 0x077c606d,
	0xcdc46074, 0x756e25a9, 0x4ce707cb, 0xf44d4216,
	0xe5276210, 0x5d8d27cd, 0x640405af, 0xdcae4072,
	0x1616406b, 0xaebc05b6, 0x973527d4, 0x2f9f6209,
	0x034426e6, 0xbbee633b, 0x82674159, 0x3acd0484,
	0xf075049d, 0x48df4140, 0x71566322, 0xc9fc26ff,
	0x5382232e, 0xeb2866f3, 0xd2a14491, 0x6a0b014c,
	0xa0b30155, 0x18194488, 0x219066ea, 0x993a2337,
	0xb5e167d8, 0x0d4b2205, 0x34c20067, 0x8c6845ba,
	0x46d045a3, 0xfe7a007e, 0xc7f3221c, 0x7f5967c1,
	0x6e3347c7, 0xd699021a, 0xef102078, 0x57ba65a5,
	0x9d0265bc, 0x25a82061, 0x1c210203, 0xa48b47de,
	0x88500331, 0x30fa46ec, 0x0973648e, 0xb1d92153,
	0x7b61214a, 0xc3cb6497, 0xfa4246f5, 0x42e80328
	},{
	0x00000000, 0xac6f1138, 0x58df2270, 0xf4b03348,
	0xb0be45e0, 0x1cd154d8, 0xe8616790, 0x440e76a8,
	0x910b67c5, 0x3d6476fd, 0xc9d445b5, 0x65bb548d,
	0x21b52225, 0x8dda331d, 0x796a0055, 0xd505116d,
	0xd361228f, 0x7f0e33b7, 0x8bbe00ff, 0x27d111c7,
	0x63df676f, 0xcfb07657, 0x3b00451f, 0x976f5427,
	0x426a454a, 0xee055472, 0x1ab5673a, 0xb6da7602,
	0xf2d400aa, 0x5ebb1192, 0xaa0b22da, 0x066433e2,
	0x57b5a81b, 0xfbdab923, 0x0f6a8a6b, 0xa3059b53,
	0xe70bedfb, 0x4b64fcc3, 0xbfd4cf8b, 0x13bbdeb3,
	0xc6becfde, 0x6ad1dee6, 0x9e61edae, 0x320efc96,
	0x76008a3e, 0xda6f9b06, 0x2edfa84e, 0x82b0b976,
	0x84d48a94, 0x28bb9bac, 0xdc0ba8e4, 0x7064b9dc,
	0x346acf74, 0x9805de4c, 0x6cb5ed04, 0xc0dafc3c,
	0x15dfed51, 0xb9b0fc69, 0x4d00cf21, 0xe16fde19,
	0xa561a8b1, 0x090eb989, 0xfdbe8ac1, 0x51d19bf9,
	0xae6a5137, 0x0205400f, 0xf6b57347, 0x5ada627f,
	0x1ed414d7, 0xb2bb05ef, 0x460b36a7, 0xea64279f,
	0x3f6136f2, 0x930e27ca, 0x67be1482, 0xcbd105ba,
	0x8fdf7312, 0x23b0622a, 0xd7005162, 0x7b6f405a,
	0x7d0b73b8, 0xd1646280, 0x25d451c8, 0x89bb40f0,
	0xcdb53658, 0x61da2760, 0x956a1428, 0x39050510,
	0xec00147d, 0x406f0545, 0xb4df360d, 0x18b02735,
	0x5cbe519d, 0xf0d140a5, 0x046173ed, 0xa80e62d5,
	0xf9dff92c, 0x55b0e814, 0xa100db5c, 0x0d6fca64,
	0x4961bccc, 0xe50eadf4, 0x11be9ebc, 0xbdd18f84,
	0x68d49ee9, 0xc4bb8fd1, 0x300bbc99, 0x9c64ada1,
	0xd86adb09, 0x7405ca31, 0x80b5f979, 0x2cdae841,
	0x2abedba3, 0x86d1ca9b, 0x7261f9d3, 0xde0ee8eb,
	0x9a009e43, 0x366f8f7b, 0xc2dfbc33, 0x6eb0ad0b,
	0xbbb5bc66, 0x17daad5e, 0xe36a9e16, 0x4f058f2e,
	0x0b0bf986, 0xa764e8be, 0x53d4dbf6, 0xffbbcace,
	0x5cd5a26e, 0xf0bab356, 0x040a801e, 0xa8659126,
	0xec6be78e, 0x4004f6b6, 0xb4b4c5fe, 0x18dbd4c6,
	0xcddec5ab, 0x61b1d493, 0x9501e7db, 0x396ef6e3,
	0x7d60804b, 0xd10f9173, 0x25bfa23b, 0x89d0b303,
	0x8fb480e1, 0x23db91d9, 0xd76ba291, 0x7b04b3a9,
	0x3f0ac501, 0x9365d439, 0x67d5e771, 0xcbbaf649,
	0x1ebfe724, 0xb2d0f61c, 0x4660c554, 0xea0fd46c,
	0xae01a2c4, 0x026eb3fc, 0xf6de80b4, 0x5ab1918c,
	0x0b600a75, 0xa70f1b4d, 0x53bf2805, 0xffd0393d,
	0xbbde4f95, 0x17b15ead, 0xe3016de5, 0x4f6e7cdd,
	0x9a6b6db0, 0x36047c88, 0xc2b44fc0, 0x6edb5ef8,
	0x2ad52850, 0x86ba3968, 0x720a0a20, 0xde651b18,
	0xd80128fa, 0x746e39c2, 0x80de0a8a, 0x2cb11bb2,
	0x68bf6d1a, 0xc4d07c22, 0x30604f6a, 0x9c0f5e52,
	0x490a4f3f, 0xe5655e07, 0x11d56d4f, 0xbdba7c77,
	0xf9b40adf, 0x55db1be7, 0xa16b28af, 0x0d043997,
	0xf2bff359, 0x5ed0e261, 0xaa60d129, 0x060fc011,
	0x4201b6b9, 0xee6ea781, 0x1ade94c9, 0xb6b185f1,
	0x63b4949c, 0xcfdb85a4, 0x3b6bb6ec, 0x9704a7d4,
	0xd30ad17c, 0x7f65c044, 0x8bd5f30c, 0x27bae234,
	0x21ded1d6, 0x8db1c0ee, 0x7901f3a6, 0xd56ee29e,
	0x91609436, 0x3d0f850e, 0xc9bfb646, 0x65d0a77e,
	0xb0d5b613, 0x1cbaa72b, 0xe80a9463, 0x4465855b,
	0x006bf3f3, 0xac04e2cb, 0x58b4d183, 0xf4dbc0bb,
	0xa50a5b42, 0x09654a7a, 0xfdd57932, 0x51ba680a,
	0x15b41ea2, 0xb9db0f9a, 0x4d6b3cd2, 0xe1042dea,
	0x34013c87, 0x986e2dbf, 0x6cde1ef7, 0xc0b10fcf,
	0x84bf7967, 0x28d0685f, 0xdc605b17, 0x700f4a2f,
	0x766b79cd, 0xda0468f5, 0x2eb45bbd, 0x82db4a85,
	0xc6d53c2d, 0x6aba2d15, 0x9e0a1e5d, 0x32650f65,
	0xe7601e08, 0x4b0f0f30, 0xbfbf3c78, 0x13d02d40,
	0x57de5be8, 0xfbb14ad0, 0x0f017998, 0xa36e68a0
	},{
	0x00000000, 0x196b30ef, 0xc3a08cdb, 0xdacbbc34,
	0x7737f5b2, 0x6e5cc55d, 0xb4977969, 0xadfc4986,
	0x1f180660, 0x0673368f, 0xdcb88abb, 0xc5d3ba54,
	0x682ff3d2, 0x7144c33d, 0xab8f7f09, 0xb2e44fe6,
	0x3e300cc0, 0x275b3c2f, 0xfd90801b, 0xe4fbb0f4,
	0x4907f972, 0x506cc99d, 0x8aa775a9, 0x93cc4546,
	0x21280aa0, 0x38433a4f, 0xe288867b, 0xfbe3b694,
	0x561fff12, 0x4f74cffd, 0x95bf73c9, 0x8cd44326,
	0x8d16f485, 0x947dc46a, 0x4eb6785e, 0x57dd48b1,
	0xfa210137, 0xe34a31d8, 0x39818dec, 0x20eabd03,
	0x920ef2e5, 0x8b65c20a, 0x51ae7e3e, 0x48c54ed1,
	0xe5390757, 0xfc5237b8, 0x26998b8c, 0x3ff2bb63,
	0xb326f845, 0xaa4dc8aa, 0x7086749e, 0x69ed4471,
	0xc4110df7, 0xdd7a3d18, 0x07b1812c, 0x1edab1c3,
	0xac3efe25, 0xb555ceca, 0x6f9e72fe, 0x76f54211,
	0xdb090b97, 0xc2623b78, 0x18a9874c, 0x01c2b7a3,
	0xeb5b040e, 0xf23034e1, 0x28fb88d5, 0x3190b83a,
	0x9c6cf1bc, 0x8507c153, 0x5fcc7d67, 0x46a74d88,
	0xf443026e, 0xed283281, 0x37e38eb5, 0x2e88be5a,
	0x8374f7dc, 0x9a1fc733, 0x40d47b07, 0x59bf4be8,
	0xd56b08ce, 0xcc003821, 0x16cb8415, 0x0fa0b4fa,
	0xa25cfd7c, 0xbb37cd93, 0x61fc71a7, 0x78974148,
	0xca730eae, 0xd3183e41, 0x09d38275, 0x10b8b29a,
	0xbd44fb1c, 0xa42fcbf3, 0x7ee477c7, 0x678f4728,
	0x664df08b, 0x7f26c064, 0xa5ed7c50, 0xbc864cbf,
	0x117a0539, 0x081135d6, 0xd2da89e2, 0xcbb1b90d,
	0x7955f6eb, 0x603ec604, 0xbaf57a30, 0xa39e4adf,
	0x0e620359, 0x170933b6, 0xcdc28f82, 0xd4a9bf6d,
	0x587dfc4b, 0x4116cca4, 0x9bdd7090, 0x82b6407f,
	0x2f4a09f9, 0x36213916, 0xecea8522, 0xf581b5cd,
	0x4765fa2b, 0x5e0ecac4, 0x84c576f0, 0x9dae461f,
	0x30520f99, 0x29393f76, 0xf3f28342, 0xea99b3ad,
	0xd6b7081c, 0xcfdc38f3, 0x151784c7, 0x0c7cb428,
	0xa180fdae, 0xb8ebcd41, 0x62207175, 0x7b4b419a,
	0xc9af0e7c, 0xd0c43e93, 0x0a0f82a7, 0x1364b248,
	0xbe98fbce, 0xa7f3cb21, 0x7d387715, 0x645347fa,
	0xe88704dc, 0xf1ec3433, 0x2b278807, 0x324cb8e8,
	0x9fb0f16e, 0x86dbc181, 0x5c107db5, 0x457b4d5a,
	0xf79f02bc, 0xeef43253, 0x343f8e67, 0x2d54be88,
	0x80a8f70e, 0x99c3c7e1, 0x43087bd5, 0x5a634b3a,
	0x5ba1fc99, 0x42cacc76, 0x98017042, 0x816a40ad,
	0x2c96092b, 0x35fd39c4, 0xef3685f0, 0xf65db51f,
	0x44b9faf9, 0x5dd2ca16, 0x87197622, 0x9e7246cd,
	0x338e0f4b, 0x2ae53fa4, 0xf02e8390, 0xe945b37f,
	0x6591f059, 0x7cfac0b6, 0xa6317c82, 0xbf5a4c6d,
	0x12a605eb, 0x0bcd3504, 0xd1068930, 0xc86db9df,
	0x7a89f639, 0x63e2c6d6, 0xb9297ae2, 0xa0424a0d,
	0x0dbe038b, 0x14d53364, 0xce1e8f50, 0xd775bfbf,
	0x3dec0c12, 0x24873cfd, 0xfe4c80c9, 0xe727b026,
	0x4adbf9a0, 0x53b0c94f, 0x897b757b, 0x90104594,
	0x22f40a72, 0x3b9f3a9d, 0xe15486a9, 0xf83fb646,
	0x55c3ffc0, 0x4ca8cf2f, 0x9663731b, 0x8f0843f4,
	0x03dc00d2, 0x1ab7303d, 0xc07c8c09, 0xd917bce6,
	0x74ebf560, 0x6d80c58f, 0xb74b79bb, 0xae204954,
	0x1cc406b2, 0x05af365d, 0xdf648a69, 0xc60fba86,
	0x6bf3f300, 0x7298c3ef, 0xa8537fdb, 0xb1384f34,
	0xb0faf897, 0xa991c878, 0x735a744c, 0x6a3144a3,
	0xc7cd0d25, 0xdea63dca, 0x046d81fe, 0x1d06b111,
	0xafe2fef7, 0xb689ce18, 0x6c42722c, 0x752942c3,
	0xd8d50b45, 0xc1be3baa, 0x1b75879e, 0x021eb771,
	0x8ecaf457, 0x97a1c4b8, 0x4d6a788c, 0x54014863,
	0xf9fd01e5, 0xe096310a, 0x3a5d8d3e, 0x2336bdd1,
	0x91d2f237, 0x88b9c2d8, 0x52727eec, 0x4b194e03,
	0xe6e50785, 0xff8e376a, 0x25458b5e, 0x3c2ebbb1
	},{
	0x00000000, 0xc82c0368, 0x905906d0, 0x587505b8,
	0xd1c5e0a5, 0x19e9e3cd, 0x419ce675, 0x89b0e51d,
	0x53fd2d4e, 0x9bd12e26, 0xc3a42b9e, 0x0b8828f6,
	0x8238cdeb, 0x4a14ce83, 0x1261cb3b, 0xda4dc853,
	0xa6fa5b9c, 0x6ed658f4, 0x36a35d4c, 0xfe8f5e24,
	0x773fbb39, 0xbf13b851, 0xe766bde9, 0x2f4abe81,
	0xf50776d2, 0x3d2b75ba, 0x655e7002, 0xad72736a,
	0x24c29677, 0xecee951f, 0xb49b90a7, 0x7cb793cf,
	0xbd835b3d, 0x75af5855, 0x2dda5ded, 0xe5f65e85,
	0x6c46bb98, 0xa46ab8f0, 0xfc1fbd48, 0x3433be20,
	0xee7e7673, 0x2652751b, 0x7e2770a3, 0xb60b73cb,
	0x3fbb96d6, 0xf79795be, 0xafe29006, 0x67ce936e,
	0x1b7900a1, 0xd35503c9, 0x8b200671, 0x430c0519,
	0xcabce004, 0x0290e36c, 0x5ae5e6d4, 0x92c9e5bc,
	0x48842def, 0x80a82e87, 0xd8dd2b3f, 0x10f12857,
	0x9941cd4a, 0x516dce22, 0x0918cb9a, 0xc134c8f2,
	0x7a07b77a, 0xb22bb412, 0xea5eb1aa, 0x2272b2c2,
	0xabc257df, 0x63ee54b7, 0x3b9b510f, 0xf3b75267,
	0x29fa9a34, 0xe1d6995c, 0xb9a39ce4, 0x718f9f8c,
	0xf83f7a91, 0x301379f9, 0x68667c41, 0xa04a7f29,
	0xdcfdece6, 0x14d1ef8e, 0x4ca4ea36, 0x8488e95e,
	0x0d380c43, 0xc5140f2b, 0x9d610a93, 0x554d09fb,
	0x8f00c1a8, 0x472cc2c0, 0x1f59c778, 0xd775c410,
	0x5ec5210d, 0x96e92265, 0xce9c27dd, 0x06b024b5,
	0xc784ec47, 0x0fa8ef2f, 0x57ddea97, 0x9ff1e9ff,
	0x16410ce2, 0xde6d0f8a, 0x86180a32, 0x4e34095a,
	0x9479c109, 0x5c55c261, 0x0420c7d9, 0xcc0cc4b1,
	0x45bc21ac, 0x8d9022c4, 0xd5e5277c, 0x1dc92414,
	0x617eb7db, 0xa952b4b3, 0xf127b10b, 0x390bb263,
	0xb0bb577e, 0x78975416, 0x20e251ae, 0xe8ce52c6,
	0x32839a95, 0xfaaf99fd, 0xa2da9c45, 0x6af69f2d,
	0xe3467a30, 0x2b6a7958, 0x731f7ce0, 0xbb337f88,
	0xf40e6ef5, 0x3c226d9d, 0x64576825, 0xac7b6b4d,
	0x25cb8e50, 0xede78d38, 0xb5928880, 0x7dbe8be8,
	0xa7f343bb, 0x6fdf40d3, 0x37aa456b, 0xff864603,
	0x7636a31e, 0xbe1aa076, 0xe66fa5ce, 0x2e43a6a6,
	0x52f43569, 0x9ad83601, 0xc2ad33b9, 0x0a8130d1,
	0x8331d5cc, 0x4b1dd6a4, 0x1368d31c, 0xdb44d074,
	0x01091827, 0xc9251b4f, 0x91501ef7, 0x597c1d9f,
	0xd0ccf882, 0x18e0fbea, 0x4095fe52, 0x88b9fd3a,
	0x498d35c8, 0x81a136a0, 0xd9d43318, 0x11f83070,
	0x9848d56d, 0x5064d605, 0x0811d3bd, 0xc03dd0d5,
	0x1a701886, 0xd25c1bee, 0x8a291e56, 0x42051d3e,
	0xcbb5f823, 0x0399fb4b, 0x5becfef3, 0x93c0fd9b,
	0xef776e54, 0x275b6d3c, 0x7f2e6884, 0xb7026bec,
	0x3eb28ef1, 0xf69e8d99, 0xaeeb8821, 0x66c78b49,
	0xbc8a431a, 0x74a64072, 0x2cd345ca, 0xe4ff46a2,
	0x6d4fa3bf, 0xa563a0d7, 0xfd16a56f, 0x353aa607,
	0x8e09d98f, 0x4625dae7, 0x1e50df5f, 0xd67cdc37,
	0x5fcc392a, 0x97e03a42, 0xcf953ffa, 0x07b93c92,
	0xddf4f4c1, 0x15d8f7a9, 0x4dadf211, 0x8581f179,
	0x0c311464, 0xc41d170c, 0x9c6812b4, 0x544411dc,
	0x28f38213, 0xe0df817b, 0xb8aa84c3, 0x708687ab,
	0xf93662b6, 0x311a61de, 0x696f6466, 0xa143670e,
	0x7b0eaf5d, 0xb322ac35, 0xeb57a98d, 0x237baae5,
	0xaacb4ff8, 0x62e74c90, 0x3a924928, 0xf2be4a40,
	0x338a82b2, 0xfba681da, 0xa3d38462, 0x6bff870a,
	0xe24f6217, 0x2a63617f, 0x721664c7, 0xba3a67af,
	0x6077affc, 0xa85bac94, 0xf02ea92c, 0x3802aa44,
	0xb1b24f59, 0x799e4c31, 0x21eb4989, 0xe9c74ae1,
	0x9570d92e, 0x5d5cda46, 0x0529dffe, 0xcd05dc96,
	0x44b5398b, 0x8c993ae3, 0xd4ec3f5b, 0x1cc03c33,
	0xc68df460, 0x0ea1f708, 0x56d4f2b0, 0x9ef8f1d8,
	0x174814c5, 0xdf6417ad, 0x87111215, 0x4f3d117d
	},{
	0x00000000, 0x277d3c49, 0x4efa7892, 0x698744db,
	0x6d821d21, 0x4aff2168, 0x237865b3, 0x040559fa,
	0xda043b42, 0xfd79070b, 0x94fe43d0, 0xb3837f99,
	0xb7862663, 0x90fb1a2a, 0xf97c5ef1, 0xde0162b8,
	0xb4097684, 0x93744acd, 0xfaf30e16, 0xdd8e325f,
	0xd98b6ba5, 0xfef657ec, 0x97711337, 0xb00c2f7e,
	0x6e0d4dc6, 0x4970718f, 0x20f73554, 0x078a091d,
	0x038f50e7, 0x24f26cae, 0x4d752875, 0x6a08143c,
	0x9965000d, 0xbe183c44, 0xd79f789f, 0xf0e244d6,
	0xf4e71d2c, 0xd39a2165, 0xba1d65be, 0x9d6059f7,
	0x43613b4f, 0x641c0706, 0x0d9b43dd, 0x2ae67f94,
	0x2ee3266e, 0x099e1a27, 0x60195efc, 0x476462b5,
	0x2d6c7689, 0x0a114ac0, 0x63960e1b, 0x44eb3252,
	0x40ee6ba8, 0x679357e1, 0x0e14133a, 0x29692f73,
	0xf7684dcb, 0xd0157182, 0xb9923559, 0x9eef0910,
	0x9aea50ea, 0xbd976ca3, 0xd4102878, 0xf36d1431,
	0x32cb001a, 0x15b63c53, 0x7c317888, 0x5b4c44c1,
	0x5f491d3b, 0x78342172, 0x11b365a9, 0x36ce59e0,
	0xe8cf3b58, 0xcfb20711, 0xa63543ca, 0x81487f83,
	0x854d2679, 0xa2301a30, 0xcbb75eeb, 0xecca62a2,
	0x86c2769e, 0xa1bf4ad7, 0xc8380e0c, 0xef453245,
	0xeb406bbf, 0xcc3d57f6, 0xa5ba132d, 0x82c72f64,
	0x5cc64ddc, 0x7bbb7195, 0x123c354e, 0x35410907,
	0x314450fd, 0x16396cb4, 0x7fbe286f, 0x58c31426,
	0xabae0017, 0x8cd33c5e, 0xe5547885, 0xc22944cc,
	0xc62c1d36, 0xe151217f, 0x88d665a4, 0xafab59ed,
	0x71aa3b55, 0x56d7071c, 0x3f5043c7, 0x182d7f8e,
	0x1c282674, 0x3b551a3d, 0x52d25ee6, 0x75af62af,
	0x1fa77693, 0x38da4ada, 0x515d0e01, 0x76203248,
	0x72256bb2, 0x555857fb, 0x3cdf1320, 0x1ba22f69,
	0xc5a34dd1, 0xe2de7198, 0x8b593543, 0xac24090a,
	0xa82150f0, 0x8f5c6cb9, 0xe6db2862, 0xc1a6142b,
	0x64960134, 0x43eb3d7d, 0x2a6c79a6, 0x0d1145ef,
	0x09141c15, 0x2e69205c, 0x47ee6487, 0x609358ce,
	0xbe923a76, 0x99ef063f, 0xf06842e4, 0xd7157ead,
	0xd3102757, 0xf46d1b1e, 0x9dea5fc5, 0xba97638c,
	0xd09f77b0, 0xf7e24bf9, 0x9e650f22, 0xb918336b,
	0xbd1d6a91, 0x9a6056d8, 0xf3e71203, 0xd49a2e4a,
	0x0a9b4cf2, 0x2de670bb, 0x44613460, 0x631c0829,
	0x671951d3, 0x40646d9a, 0x29e32941, 0x0e9e1508,
	0xfdf30139, 0xda8e3d70, 0xb30979ab, 0x947445e2,
	0x90711c18, 0xb70c2051, 0xde8b648a, 0xf9f658c3,
	0x27f73a7b, 0x008a0632, 0x690d42e9, 0x4e707ea0,
	0x4a75275a, 0x6d081b13, 0x048f5fc8, 0x23f26381,
	0x49fa77bd, 0x6e874bf4, 0x07000f2f, 0x207d3366,
	0x24786a9c, 0x030556d5, 0x6a82120e, 0x4dff2e47,
	0x93fe4cff, 0xb48370b6, 0xdd04346d, 0xfa790824,
	0xfe7c51de, 0xd9016d97, 0xb086294c, 0x97fb1505,
	0x565d012e, 0x71203d67, 0x18a779bc, 0x3fda45f5,
	0x3bdf1c0f, 0x1ca22046, 0x7525649d, 0x525858d4,
	0x8c593a6c, 0xab240625, 0xc2a342fe, 0xe5de7eb7,
	0xe1db274d, 0xc6a61b04, 0xaf215fdf, 0x885c6396,
	0xe25477aa, 0xc5294be3, 0xacae0f38, 0x8bd33371,
	0x8fd66a8b, 0xa8ab56c2, 0xc12c1219, 0xe6512e50,
	0x38504ce8, 0x1f2d70a1, 0x76aa347a, 0x51d70833,
	0x55d251c9, 0x72af6d80, 0x1b28295b, 0x3c551512,
	0xcf380123, 0xe8453d6a, 0x81c279b1, 0xa6bf45f8,
	0xa2ba1c02, 0x85c7204b, 0xec406490, 0xcb3d58d9,
	0x153c3a61, 0x32410628, 0x5bc642f3, 0x7cbb7eba,
	0x78be2740, 0x5fc31b09, 0x36445fd2, 0x1139639b,
	0x7b3177a7, 0x5c4c4bee, 0x35cb0f35, 0x12b6337c,
	0x16b36a86, 0x31ce56cf, 0x58491214, 0x7f342e5d,
	0xa1354ce5, 0x864870ac, 0xefcf3477, 0xc8b2083e,
	0xccb751c4, 0xebca6d8d, 0x824d2956, 0xa530151f
	}
};

static const unsigned int __attribute__((aligned(128))) crc32ctable_be[8][256] = {
	{
	0x00000000, 0x1edc6f41, 0x3db8de82, 0x2364b1c3,
	0x7b71bd04, 0x65add245, 0x46c96386, 0x58150cc7,
	0xf6e37a08, 0xe83f1549, 0xcb5ba48a, 0xd587cbcb,
	0x8d92c70c, 0x934ea84d, 0xb02a198e, 0xaef676cf,
	0xf31a9b51, 0xedc6f410, 0xcea245d3, 0xd07e2a92,
	0x886b2655, 0x96b74914, 0xb5d3f8d7, 0xab0f9796,
	0x05f9e159, 0x1b258e18, 0x38413fdb, 0x269d509a,
	0x7e885c5d, 0x6054331c, 0x433082df, 0x5deced9e,
	0xf8e959e3, 0xe63536a2, 0xc5518761, 0xdb8de820,
	0x8398e4e7, 0x9d448ba6, 0xbe203a65, 0xa0fc5524,
	0x0e0a23eb, 0x10d64caa, 0x33b2fd69, 0x2d6e9228,
	0x757b9eef, 0x6ba7f1ae, 0x48c3406d, 0x561f2f2c,
	0x0bf3c2b2, 0x152fadf3, 0x364b1c30, 0x28977371,
	0x70827fb6, 0x6e5e10f7, 0x4d3aa134, 0x53e6ce75,
	0xfd10b8ba, 0xe3ccd7fb, 0xc0a86638, 0xde740979,
	0x866105be, 0x98bd6aff, 0xbbd9db3c, 0xa505b47d,
	0xef0edc87, 0xf1d2b3c6, 0xd2b60205, 0xcc6a6d44,
	0x947f6183, 0x8aa30ec2, 0xa9c7bf01, 0xb71bd040,
	0x19eda68f, 0x0731c9ce, 0x2455780d, 0x3a89174c,
	0x629c1b8b, 0x7c4074ca, 0x5f24c509, 0x41f8aa48,
	0x1c1447d6, 0x02c82897, 0x21ac9954, 0x3f70f615,
	0x6765fad2, 0x79b99593, 0x5add2450, 0x44014b11,
	0xeaf73dde, 0xf42b529f, 0xd74fe35c, 0xc9938c1d,
	0x918680da, 0x8f5aef9b, 0xac3e5e58, 0xb2e23119,
	0x17e78564, 0x093bea25, 0x2a5f5be6, 0x348334a7,
	0x6c963860, 0x724a5721, 0x512ee6e2, 0x4ff289a3,
	0xe104ff6c, 0xffd8902d, 0xdcbc21ee, 0xc2604eaf,
	0x9a754268, 0x84a92d29, 0xa7cd9cea, 0xb911f3ab,
	0xe4fd1e35, 0xfa217174, 0xd945c0b7, 0xc799aff6,
	0x9f8ca331, 0x8150cc70, 0xa2347db3, 0xbce812f2,
	0x121e643d, 0x0cc20b7c, 0x2fa6babf, 0x317ad5fe,
	0x696fd939, 0x77b3b678, 0x54d707bb, 0x4a0b68fa,
	0xc0c1d64f, 0xde1db90e, 0xfd7908cd, 0xe3a5678c,
	0xbbb06b4b, 0xa56c040a, 0x8608b5c9, 0x98d4da88,
	0x3622ac47, 0x28fec306, 0x0b9a72c5, 0x15461d84,
	0x4d531143, 0x538f7e02, 0x70ebcfc1, 0x6e37a080,
	0x33db4d1e, 0x2d07225f, 0x0e63939c, 0x10bffcdd,
	0x48aaf01a, 0x56769f5b, 0x75122e98, 0x6bce41d9,
	0xc5383716, 0xdbe45857, 0xf880e994, 0xe65c86d5,
	0xbe498a12, 0xa095e553, 0x83f15490, 0x9d2d3bd1,
	0x38288fac, 0x26f4e0ed, 0x0590512e, 0x1b4c3e6f,
	0x435932a8, 0x5d855de9, 0x7ee1ec2a, 0x603d836b,
	0xcecbf5a4, 0xd0179ae5, 0xf3732b26, 0xedaf4467,
	0xb5ba48a0, 0xab6627e1, 0x88029622, 0x96def963,
	0xcb3214fd, 0xd5ee7bbc, 0xf68aca7f, 0xe856a53e,
	0xb043a9f9, 0xae9fc6b8, 0x8dfb777b, 0x9327183a,
	0x3dd16ef5, 0x230d01b4, 0x0069b077, 0x1eb5df36,
	0x46a0d3f1, 0x587cbcb0, 0x7b180d73, 0x65c46232,
	0x2fcf0ac8, 0x31136589, 0x1277d44a, 0x0cabbb0b,
	0x54beb7cc, 0x4a62d88d, 0x6906694e, 0x77da060f,
	0xd92c70c0, 0xc7f01f81, 0xe494ae42, 0xfa48c103,
	0xa25dcdc4, 0xbc81a285, 0x9fe51346, 0x81397c07,
	0xdcd59199, 0xc209fed8, 0xe16d4f1b, 0xffb1205a,
	0xa7a42c9d, 0xb97843dc, 0x9a1cf21f, 0x84c09d5e,
	0x2a36eb91, 0x34ea84d0, 0x178e3513, 0x09525a52,
	0x51475695, 0x4f9b39d4, 0x6cff8817, 0x7223e756,
	0xd726532b, 0xc9fa3c6a, 0xea9e8da9, 0xf442e2e8,
	0xac57ee2f, 0xb28b816e, 0x91ef30ad, 0x8f335fec,
	0x21c52923, 0x3f194662, 0x1c7df7a1, 0x02a198e0,
	0x5ab49427, 0x4468fb66, 0x670c4aa5, 0x79d025e4,
	0x243cc87a, 0x3ae0a73b, 0x198416f8, 0x075879b9,
	0x5f4d757e, 0x41911a3f, 0x62f5abfc, 0x7c29c4bd,
	0xd2dfb272, 0xcc03dd33, 0xef676cf0, 0xf1bb03b1,
	0xa9ae0f76, 0xb7726037, 0x9416d1f4, 0x8acabeb5
	},{
	0x00000000, 0x9f5fc3df, 0x2063e8ff, 0xbf3c2b20,
	0x40c7d1fe, 0xdf981221, 0x60a43901, 0xfffbfade,
	0x818fa3fc, 0x1ed06023, 0xa1ec4b03, 0x3eb388dc,
	0xc1487202, 0x5e17b1dd, 0xe12b9afd, 0x7e745922,
	0x1dc328b9, 0x829ceb66, 0x3da0c046, 0xa2ff0399,
	0x5d04f947, 0xc25b3a98, 0x7d6711b8, 0xe238d267,
	0x9c4c8b45, 0x0313489a, 0xbc2f63ba, 0x2370a065,
	0xdc8b5abb, 0x43d49964, 0xfce8b244, 0x63b7719b,
	0x3b865172, 0xa4d992ad, 0x1be5b98d, 0x84ba7a52,
	0x7b41808c, 0xe41e4353, 0x5b226873, 0xc47dabac,
	0xba09f28e, 0x25563151, 0x9a6a1a71, 0x0535d9ae,
	0xface2370, 0x6591e0af, 0xdaadcb8f, 0x45f20850,
	0x264579cb, 0xb91aba14, 0x06269134, 0x997952eb,
	0x6682a835, 0xf9dd6bea, 0x46e140ca, 0xd9be8315,
	0xa7cada37, 0x389519e8, 0x87a932c8, 0x18f6f117,
	0xe70d0bc9, 0x7852c816, 0xc76ee336, 0x583120e9,
	0x770ca2e4, 0xe853613b, 0x576f4a1b, 0xc83089c4,
	0x37cb731a, 0xa894b0c5, 0x17a89be5, 0x88f7583a,
	0xf6830118, 0x69dcc2c7, 0xd6e0e9e7, 0x49bf2a38,
	0xb644d0e6, 0x291b1339, 0x96273819, 0x0978fbc6,
	0x6acf8a5d, 0xf5904982, 0x4aac62a2, 0xd5f3a17d,
	0x2a085ba3, 0xb557987c, 0x0a6bb35c, 0x95347083,
	0xeb4029a1, 0x741fea7e, 0xcb23c15e, 0x547c0281,
	0xab87f85f, 0x34d83b80, 0x8be410a0, 0x14bbd37f,
	0x4c8af396, 0xd3d53049, 0x6ce91b69, 0xf3b6d8b6,
	0x0c4d2268, 0x9312e1b7, 0x2c2eca97, 0xb3710948,
	0xcd05506a, 0x525a93b5, 0xed66b895, 0x72397b4a,
	0x8dc28194, 0x129d424b, 0xada1696b, 0x32feaab4,
	0x5149db2f, 0xce1618f0, 0x712a33d0, 0xee75f00f,
	0x118e0ad1, 0x8ed1c90e, 0x31ede22e, 0xaeb221f1,
	0xd0c678d3, 0x4f99bb0c, 0xf0a5902c, 0x6ffa53f3,
	0x9001a92d, 0x0f5e6af2, 0xb06241d2, 0x2f3d820d,
	0xee1945c8, 0x71468617, 0xce7aad37, 0x51256ee8,
	0xaede9436, 0x318157e9, 0x8ebd7cc9, 0x11e2bf16,
	0x6f96e634, 0xf0c925eb, 0x4ff50ecb, 0xd0aacd14,
	0x2f5137ca, 0xb00ef415, 0x0f32df35, 0x906d1cea,
	0xf3da6d71, 0x6c85aeae, 0xd3b9858e, 0x4ce64651,
	0xb31dbc8f, 0x2c427f50, 0x937e5470, 0x0c2197af,
	0x7255ce8d, 0xed0a0d52, 0x52362672, 0xcd69e5ad,
	0x32921f73, 0xadcddcac, 0x12f1f78c, 0x8dae3453,
	0xd59f14ba, 0x4ac0d765, 0xf5fcfc45, 0x6aa33f9a,
	0x9558c544, 0x0a07069b, 0xb53b2dbb, 0x2a64ee64,
	0x5410b746, 0xcb4f7499, 0x74735fb9, 0xeb2c9c66,
	0x14d766b8, 0x8b88a567, 0x34b48e47, 0xabeb4d98,
	0xc85c3c03, 0x5703ffdc, 0xe83fd4fc, 0x77601723,
	0x889bedfd, 0x17c42e22, 0xa8f80502, 0x37a7c6dd,
	0x49d39fff, 0xd68c5c20, 0x69b07700, 0xf6efb4df,
	0x09144e01, 0x964b8dde, 0x2977a6fe, 0xb6286521,
	0x9915e72c, 0x064a24f3, 0xb9760fd3, 0x2629cc0c,
	0xd9d236d2, 0x468df50d, 0xf9b1de2d, 0x66ee1df2,
	0x189a44d0, 0x87c5870f, 0x38f9ac2f, 0xa7a66ff0,
	0x585d952e, 0xc70256f1, 0x783e7dd1, 0xe761be0e,
	0x84d6cf95, 0x1b890c4a, 0xa4b5276a, 0x3beae4b5,
	0xc4111e6b, 0x5b4eddb4, 0xe472f694, 0x7b2d354b,
	0x05596c69, 0x9a06afb6, 0x253a8496, 0xba654749,
	0x459ebd97, 0xdac17e48, 0x65fd5568, 0xfaa296b7,
	0xa293b65e, 0x3dcc7581, 0x82f05ea1, 0x1daf9d7e,
	0xe25467a0, 0x7d0ba47f, 0xc2378f5f, 0x5d684c80,
	0x231c15a2, 0xbc43d67d, 0x037ffd5d, 0x9c203e82,
	0x63dbc45c, 0xfc840783, 0x43b82ca3, 0xdce7ef7c,
	0xbf509ee7, 0x200f5d38, 0x9f337618, 0x006cb5c7,
	0xff974f19, 0x60c88cc6, 0xdff4a7e6, 0x40ab6439,
	0x3edf3d1b, 0xa180fec4, 0x1ebcd5e4, 0x81e3163b,
	0x7e18ece5, 0xe1472f3a, 0x5e7b041a, 0xc124c7c5
	},{
	0x00000000, 0xc2eee4d1, 0x9b01a6e3, 0x59ef4232,
	0x28df2287, 0xea31c656, 0xb3de8464, 0x713060b5,
	0x51be450e, 0x9350a1df, 0xcabfe3ed, 0x0851073c,
	0x79616789, 0xbb8f8358, 0xe260c16a, 0x208e25bb,
	0xa37c8a1c, 0x61926ecd, 0x387d2cff, 0xfa93c82e,
	0x8ba3a89b, 0x494d4c4a, 0x10a20e78, 0xd24ceaa9,
	0xf2c2cf12, 0x302c2bc3, 0x69c369f1, 0xab2d8d20,
	0xda1ded95, 0x18f30944, 0x411c4b76, 0x83f2afa7,
	0x58257b79, 0x9acb9fa8, 0xc324dd9a, 0x01ca394b,
	0x70fa59fe, 0xb214bd2f, 0xebfbff1d, 0x29151bcc,
	0x099b3e77, 0xcb75daa6, 0x929a9894, 0x50747c45,
	0x21441cf0, 0xe3aaf821, 0xba45ba13, 0x78ab5ec2,
	0xfb59f165, 0x39b715b4, 0x60585786, 0xa2b6b357,
	0xd386d3e2, 0x11683733, 0x48877501, 0x8a6991d0,
	0xaae7b46b, 0x680950ba, 0x31e61288, 0xf308f659,
	0x823896ec, 0x40d6723d, 0x1939300f, 0xdbd7d4de,
	0xb04af6f2, 0x72a41223, 0x2b4b5011, 0xe9a5b4c0,
	0x9895d475, 0x5a7b30a4, 0x03947296, 0xc17a9647,
	0xe1f4b3fc, 0x231a572d, 0x7af5151f, 0xb81bf1ce,
	0xc92b917b, 0x0bc575aa, 0x522a3798, 0x90c4d349,
	0x13367cee, 0xd1d8983f, 0x8837da0d, 0x4ad93edc,
	0x3be95e69, 0xf907bab8, 0xa0e8f88a, 0x62061c5b,
	0x428839e0, 0x8066dd31, 0xd9899f03, 0x1b677bd2,
	0x6a571b67, 0xa8b9ffb6, 0xf156bd84, 0x33b85955,
	0xe86f8d8b, 0x2a81695a, 0x736e2b68, 0xb180cfb9,
	0xc0b0af0c, 0x025e4bdd, 0x5bb109ef, 0x995fed3e,
	0xb9d1c885, 0x7b3f2c54, 0x22d06e66, 0xe03e8ab7,
	0x910eea02, 0x53e00ed3, 0x0a0f4ce1, 0xc8e1a830,
	0x4b130797, 0x89fde346, 0xd012a174, 0x12fc45a5,
	0x63cc2510, 0xa122c1c1, 0xf8cd83f3, 0x3a236722,
	0x1aad4299, 0xd843a648, 0x81ace47a, 0x434200ab,
	0x3272601e, 0xf09c84cf, 0xa973c6fd, 0x6b9d222c,
	0x7e4982a5, 0xbca76674, 0xe5482446, 0x27a6c097,
	0x5696a022, 0x947844f3, 0xcd9706c1, 0x0f79e210,
	0x2ff7c7ab, 0xed19237a, 0xb4f66148, 0x76188599,
	0x0728e52c, 0xc5c601fd, 0x9c2943cf, 0x5ec7a71e,
	0xdd3508b9, 0x1fdbec68, 0x4634ae5a, 0x84da4a8b,
	0xf5ea2a3e, 0x3704ceef, 0x6eeb8cdd, 0xac05680c,
	0x8c8b4db7, 0x4e65a966, 0x178aeb54, 0xd5640f85,
	0xa4546f30, 0x66ba8be1, 0x3f55c9d3, 0xfdbb2d02,
	0x266cf9dc, 0xe4821d0d, 0xbd6d5f3f, 0x7f83bbee,
	0x0eb3db5b, 0xcc5d3f8a, 0x95b27db8, 0x575c9969,
	0x77d2bcd2, 0xb53c5803, 0xecd31a31, 0x2e3dfee0,
	0x5f0d9e55, 0x9de37a84, 0xc40c38b6, 0x06e2dc67,
	0x851073c0, 0x47fe9711, 0x1e11d523, 0xdcff31f2,
	0xadcf5147, 0x6f21b596, 0x36cef7a4, 0xf4201375,
	0xd4ae36ce, 0x1640d21f, 0x4faf902d, 0x8d4174fc,
	0xfc711449, 0x3e9ff098, 0x6770b2aa, 0xa59e567b,
	0xce037457, 0x0ced9086, 0x5502d2b4, 0x97ec3665,
	0xe6dc56d0, 0x2432b201, 0x7dddf033, 0xbf3314e2,
	0x9fbd3159, 0x5d53d588, 0x04bc97ba, 0xc652736b,
	0xb76213de, 0x758cf70f, 0x2c63b53d, 0xee8d51ec,
	0x6d7ffe4b, 0xaf911a9a, 0xf67e58a8, 0x3490bc79,
	0x45a0dccc, 0x874e381d, 0xdea17a2f, 0x1c4f9efe,
	0x3cc1bb45, 0xfe2f5f94, 0xa7c01da6, 0x652ef977,
	0x141e99c2, 0xd6f07d13, 0x8f1f3f21, 0x4df1dbf0,
	0x96260f2e, 0x54c8ebff, 0x0d27a9cd, 0xcfc94d1c,
	0xbef92da9, 0x7c17c978, 0x25f88b4a, 0xe7166f9b,
	0xc7984a20, 0x0576aef1, 0x5c99ecc3, 0x9e770812,
	0xef4768a7, 0x2da98c76, 0x7446ce44, 0xb6a82a95,
	0x355a8532, 0xf7b461e3, 0xae5b23d1, 0x6cb5c700,
	0x1d85a7b5, 0xdf6b4364, 0x86840156, 0x446ae587,
	0x64e4c03c, 0xa60a24ed, 0xffe566df, 0x3d0b820e,
	0x4c3be2bb, 0x8ed5066a, 0xd73a4458, 0x15d4a089
	},{
	0x00000000, 0xfc93054a, 0xe7fa65d5, 0x1b69609f,
	0xd128a4eb, 0x2dbba1a1, 0x36d2c13e, 0xca41c474,
	0xbc8d2697, 0x401e23dd, 0x5b774342, 0xa7e44608,
	0x6da5827c, 0x91368736, 0x8a5fe7a9, 0x76cce2e3,
	0x67c6226f, 0x9b552725, 0x803c47ba, 0x7caf42f0,
	0xb6ee8684, 0x4a7d83ce, 0x5114e351, 0xad87e61b,
	0xdb4b04f8, 0x27d801b2, 0x3cb1612d, 0xc0226467,
	0x0a63a013, 0xf6f0a559, 0xed99c5c6, 0x110ac08c,
	0xcf8c44de, 0x331f4194, 0x2876210b, 0xd4e52441,
	0x1ea4e035, 0xe237e57f, 0xf95e85e0, 0x05cd80aa,
	0x73016249, 0x8f926703, 0x94fb079c, 0x686802d6,
	0xa229c6a2, 0x5ebac3e8, 0x45d3a377, 0xb940a63d,
	0xa84a66b1, 0x54d963fb, 0x4fb00364, 0xb323062e,
	0x7962c25a, 0x85f1c710, 0x9e98a78f, 0x620ba2c5,
	0x14c74026, 0xe854456c, 0xf33d25f3, 0x0fae20b9,
	0xc5efe4cd, 0x397ce187, 0x22158118, 0xde868452,
	0x81c4e6fd, 0x7d57e3b7, 0x663e8328, 0x9aad8662,
	0x50ec4216, 0xac7f475c, 0xb71627c3, 0x4b852289,
	0x3d49c06a, 0xc1dac520, 0xdab3a5bf, 0x2620a0f5,
	0xec616481, 0x10f261cb, 0x0b9b0154, 0xf708041e,
	0xe602c492, 0x1a91c1d8, 0x01f8a147, 0xfd6ba40d,
	0x372a6079, 0xcbb96533, 0xd0d005ac, 0x2c4300e6,
	0x5a8fe205, 0xa61ce74f, 0xbd7587d0, 0x41e6829a,
	0x8ba746ee, 0x773443a4, 0x6c5d233b, 0x90ce2671,
	0x4e48a223, 0xb2dba769, 0xa9b2c7f6, 0x5521c2bc,
	0x9f6006c8, 0x63f30382, 0x789a631d, 0x84096657,
	0xf2c584b4, 0x0e5681fe, 0x153fe161, 0xe9ace42b,
	0x23ed205f, 0xdf7e2515, 0xc417458a, 0x388440c0,
	0x298e804c, 0xd51d8506, 0xce74e599, 0x32e7e0d3,
	0xf8a624a7, 0x043521ed, 0x1f5c4172, 0xe3cf4438,
	0x9503a6db, 0x6990a391, 0x72f9c30e, 0x8e6ac644,
	0x442b0230, 0xb8b8077a, 0xa3d167e5, 0x5f4262af,
	0x1d55a2bb, 0xe1c6a7f1, 0xfaafc76e, 0x063cc224,
	0xcc7d0650, 0x30ee031a, 0x2b876385, 0xd71466cf,
	0xa1d8842c, 0x5d4b8166, 0x4622e1f9, 0xbab1e4b3,
	0x70f020c7, 0x8c63258d, 0x970a4512, 0x6b994058,
	0x7a9380d4, 0x8600859e, 0x9d69e501, 0x61fae04b,
	0xabbb243f, 0x57282175, 0x4c4141ea, 0xb0d244a0,
	0xc61ea643, 0x3a8da309, 0x21e4c396, 0xdd77c6dc,
	0x173602a8, 0xeba507e2, 0xf0cc677d, 0x0c5f6237,
	0xd2d9e665, 0x2e4ae32f, 0x352383b0, 0xc9b086fa,
	0x03f1428e, 0xff6247c4, 0xe40b275b, 0x18982211,
	0x6e54c0f2, 0x92c7c5b8, 0x89aea527, 0x753da06d,
	0xbf7c6419, 0x43ef6153, 0x588601cc, 0xa4150486,
	0xb51fc40a, 0x498cc140, 0x52e5a1df, 0xae76a495,
	0x643760e1, 0x98a465ab, 0x83cd0534, 0x7f5e007e,
	0x0992e29d, 0xf501e7d7, 0xee688748, 0x12fb8202,
	0xd8ba4676, 0x2429433c, 0x3f4023a3, 0xc3d326e9,
	0x9c914446, 0x6002410c, 0x7b6b2193, 0x87f824d9,
	0x4db9e0ad, 0xb12ae5e7, 0xaa438578, 0x56d08032,
	0x201c62d1, 0xdc8f679b, 0xc7e60704, 0x3b75024e,
	0xf134c63a, 0x0da7c370, 0x16cea3ef, 0xea5da6a5,
	0xfb576629, 0x07c46363, 0x1cad03fc, 0xe03e06b6,
	0x2a7fc2c2, 0xd6ecc788, 0xcd85a717, 0x3116a25d,
	0x47da40be, 0xbb4945f4, 0xa020256b, 0x5cb32021,
	0x96f2e455, 0x6a61e11f, 0x71088180, 0x8d9b84ca,
	0x531d0098, 0xaf8e05d2, 0xb4e7654d, 0x48746007,
	0x8235a473, 0x7ea6a139, 0x65cfc1a6, 0x995cc4ec,
	0xef90260f, 0x13032345, 0x086a43da, 0xf4f94690,
	0x3eb882e4, 0xc22b87ae, 0xd942e731, 0x25d1e27b,
	0x34db22f7, 0xc84827bd, 0xd3214722, 0x2fb24268,
	0xe5f3861c, 0x19608356, 0x0209e3c9, 0xfe9ae683,
	0x88560460, 0x74c5012a, 0x6fac61b5, 0x933f64ff,
	0x597ea08b, 0xa5eda5c1, 0xbe84c55e, 0x4217c014
	},{
	0x00000000, 0x3aab4576, 0x75568aec, 0x4ffdcf9a,
	0xeaad15d8, 0xd00650ae, 0x9ffb9f34, 0xa550da42,
	0xcb8644f1, 0xf12d0187, 0xbed0ce1d, 0x847b8b6b,
	0x212b5129, 0x1b80145f, 0x547ddbc5, 0x6ed69eb3,
	0x89d0e6a3, 0xb37ba3d5, 0xfc866c4f, 0xc62d2939,
	0x637df37b, 0x59d6b60d, 0x162b7997, 0x2c803ce1,
	0x4256a252, 0x78fde724, 0x370028be, 0x0dab6dc8,
	0xa8fbb78a, 0x9250f2fc, 0xddad3d66, 0xe7067810,
	0x0d7da207, 0x37d6e771, 0x782b28eb, 0x42806d9d,
	0xe7d0b7df, 0xdd7bf2a9, 0x92863d33, 0xa82d7845,
	0xc6fbe6f6, 0xfc50a380, 0xb3ad6c1a, 0x8906296c,
	0x2c56f32e, 0x16fdb658, 0x590079c2, 0x63ab3cb4,
	0x84ad44a4, 0xbe0601d2, 0xf1fbce48, 0xcb508b3e,
	0x6e00517c, 0x54ab140a, 0x1b56db90, 0x21fd9ee6,
	0x4f2b0055, 0x75804523, 0x3a7d8ab9, 0x00d6cfcf,
	0xa586158d, 0x9f2d50fb, 0xd0d09f61, 0xea7bda17,
	0x1afb440e, 0x20500178, 0x6fadcee2, 0x55068b94,
	0xf05651d6, 0xcafd14a0, 0x8500db3a, 0xbfab9e4c,
	0xd17d00ff, 0xebd64589, 0xa42b8a13, 0x9e80cf65,
	0x3bd01527, 0x017b5051, 0x4e869fcb, 0x742ddabd,
	0x932ba2ad, 0xa980e7db, 0xe67d2841, 0xdcd66d37,
	0x7986b775, 0x432df203, 0x0cd03d99, 0x367b78ef,
	0x58ade65c, 0x6206a32a, 0x2dfb6cb0, 0x175029c6,
	0xb200f384, 0x88abb6f2, 0xc7567968, 0xfdfd3c1e,
	0x1786e609, 0x2d2da37f, 0x62d06ce5, 0x587b2993,
	0xfd2bf3d1, 0xc780b6a7, 0x887d793d, 0xb2d63c4b,
	0xdc00a2f8, 0xe6abe78e, 0xa9562814, 0x93fd6d62,
	0x36adb720, 0x0c06f256, 0x43fb3dcc, 0x795078ba,
	0x9e5600aa, 0xa4fd45dc, 0xeb008a46, 0xd1abcf30,
	0x74fb1572, 0x4e505004, 0x01ad9f9e, 0x3b06dae8,
	0x55d0445b, 0x6f7b012d, 0x2086ceb7, 0x1a2d8bc1,
	0xbf7d5183, 0x85d614f5, 0xca2bdb6f, 0xf0809e19,
	0x35f6881c, 0x0f5dcd6a, 0x40a002f0, 0x7a0b4786,
	0xdf5b9dc4, 0xe5f0d8b2, 0xaa0d1728, 0x90a6525e,
	0xfe70cced, 0xc4db899b, 0x8b264601, 0xb18d0377,
	0x14ddd935, 0x2e769c43, 0x618b53d9, 0x5b2016af,
	0xbc266ebf, 0x868d2bc9, 0xc970e453, 0xf3dba125,
	0x568b7b67, 0x6c203e11, 0x23ddf18b, 0x1976b4fd,
	0x77a02a4e, 0x4d0b6f38, 0x02f6a0a2, 0x385de5d4,
	0x9d0d3f96, 0xa7a67ae0, 0xe85bb57a, 0xd2f0f00c,
	0x388b2a1b, 0x02206f6d, 0x4ddda0f7, 0x7776e581,
	0xd2263fc3, 0xe88d7ab5, 0xa770b52f, 0x9ddbf059,
	0xf30d6eea, 0xc9a62b9c, 0x865be406, 0xbcf0a170,
	0x19a07b32, 0x230b3e44, 0x6cf6f1de, 0x565db4a8,
	0xb15bccb8, 0x8bf089ce, 0xc40d4654, 0xfea60322,
	0x5bf6d960, 0x615d9c16, 0x2ea0538c, 0x140b16fa,
	0x7add8849, 0x4076cd3f, 0x0f8b02a5, 0x352047d3,
	0x90709d91, 0xaadbd8e7, 0xe526177d, 0xdf8d520b,
	0x2f0dcc12, 0x15a68964, 0x5a5b46fe, 0x60f00388,
	0xc5a0d9ca, 0xff0b9cbc, 0xb0f65326, 0x8a5d1650,
	0xe48b88e3, 0xde20cd95, 0x91dd020f, 0xab764779,
	0x0e269d3b, 0x348dd84d, 0x7b7017d7, 0x41db52a1,
	0xa6dd2ab1, 0x9c766fc7, 0xd38ba05d, 0xe920e52b,
	0x4c703f69, 0x76db7a1f, 0x3926b585, 0x038df0f3,
	0x6d5b6e40, 0x57f02b36, 0x180de4ac, 0x22a6a1da,
	0x87f67b98, 0xbd5d3eee, 0xf2a0f174, 0xc80bb402,
	0x22706e15, 0x18db2b63, 0x5726e4f9, 0x6d8da18f,
	0xc8dd7bcd, 0xf2763ebb, 0xbd8bf121, 0x8720b457,
	0xe9f62ae4, 0xd35d6f92, 0x9ca0a008, 0xa60be57e,
	0x035b3f3c, 0x39f07a4a, 0x760db5d0, 0x4ca6f0a6,
	0xaba088b6, 0x910bcdc0, 0xdef6025a, 0xe45d472c,
	0x410d9d6e, 0x7ba6d818, 0x345b1782, 0x0ef052f4,
	0x6026cc47, 0x5a8d8931, 0x157046ab, 0x2fdb03dd,
	0x8a8bd99f, 0xb0209ce9, 0xffdd5373, 0xc5761605
	},{
	0x00000000, 0x6bed1038, 0xd7da2070, 0xbc373048,
	0xb1682fa1, 0xda853f99, 0x66b20fd1, 0x0d5f1fe9,
	0x7c0c3003, 0x17e1203b, 0xabd61073, 0xc03b004b,
	0xcd641fa2, 0xa6890f9a, 0x1abe3fd2, 0x71532fea,
	0xf8186006, 0x93f5703e, 0x2fc24076, 0x442f504e,
	0x49704fa7, 0x229d5f9f, 0x9eaa6fd7, 0xf5477fef,
	0x84145005, 0xeff9403d, 0x53ce7075, 0x3823604d,
	0x357c7fa4, 0x5e916f9c, 0xe2a65fd4, 0x894b4fec,
	0xeeecaf4d, 0x8501bf75, 0x39368f3d, 0x52db9f05,
	0x5f8480ec, 0x346990d4, 0x885ea09c, 0xe3b3b0a4,
	0x92e09f4e, 0xf90d8f76, 0x453abf3e, 0x2ed7af06,
	0x2388b0ef, 0x4865a0d7, 0xf452909f, 0x9fbf80a7,
	0x16f4cf4b, 0x7d19df73, 0xc12eef3b, 0xaac3ff03,
	0xa79ce0ea, 0xcc71f0d2, 0x7046c09a, 0x1babd0a2,
	0x6af8ff48, 0x0115ef70, 0xbd22df38, 0xd6cfcf00,
	0xdb90d0e9, 0xb07dc0d1, 0x0c4af099, 0x67a7e0a1,
	0xc30531db, 0xa8e821e3, 0x14df11ab, 0x7f320193,
	0x726d1e7a, 0x19800e42, 0xa5b73e0a, 0xce5a2e32,
	0xbf0901d8, 0xd4e411e0, 0x68d321a8, 0x033e3190,
	0x0e612e79, 0x658c3e41, 0xd9bb0e09, 0xb2561e31,
	0x3b1d51dd, 0x50f041e5, 0xecc771ad, 0x872a6195,
	0x8a757e7c, 0xe1986e44, 0x5daf5e0c, 0x36424e34,
	0x471161de, 0x2cfc71e6, 0x90cb41ae, 0xfb265196,
	0xf6794e7f, 0x9d945e47, 0x21a36e0f, 0x4a4e7e37,
	0x2de99e96, 0x46048eae, 0xfa33bee6, 0x91deaede,
	0x9c81b137, 0xf76ca10f, 0x4b5b9147, 0x20b6817f,
	0x51e5ae95, 0x3a08bead, 0x863f8ee5, 0xedd29edd,
	0xe08d8134, 0x8b60910c, 0x3757a144, 0x5cbab17c,
	0xd5f1fe90, 0xbe1ceea8, 0x022bdee0, 0x69c6ced8,
	0x6499d131, 0x0f74c109, 0xb343f141, 0xd8aee179,
	0xa9fdce93, 0xc210deab, 0x7e27eee3, 0x15cafedb,
	0x1895e132, 0x7378f10a, 0xcf4fc142, 0xa4a2d17a,
	0x98d60cf7, 0xf33b1ccf, 0x4f0c2c87, 0x24e13cbf,
	0x29be2356, 0x4253336e, 0xfe640326, 0x9589131e,
	0xe4da3cf4, 0x8f372ccc, 0x33001c84, 0x58ed0cbc,
	0x55b21355, 0x3e5f036d, 0x82683325, 0xe985231d,
	0x60ce6cf1, 0x0b237cc9, 0xb7144c81, 0xdcf95cb9,
	0xd1a64350, 0xba4b5368, 0x067c6320, 0x6d917318,
	0x1cc25cf2, 0x772f4cca, 0xcb187c82, 0xa0f56cba,
	0xadaa7353, 0xc647636b, 0x7a705323, 0x119d431b,
	0x763aa3ba, 0x1dd7b382, 0xa1e083ca, 0xca0d93f2,
	0xc7528c1b, 0xacbf9c23, 0x1088ac6b, 0x7b65bc53,
	0x0a3693b9, 0x61db8381, 0xddecb3c9, 0xb601a3f1,
	0xbb5ebc18, 0xd0b3ac20, 0x6c849c68, 0x07698c50,
	0x8e22c3bc, 0xe5cfd384, 0x59f8e3cc, 0x3215f3f4,
	0x3f4aec1d, 0x54a7fc25, 0xe890cc6d, 0x837ddc55,
	0xf22ef3bf, 0x99c3e387, 0x25f4d3cf, 0x4e19c3f7,
	0x4346dc1e, 0x28abcc26, 0x949cfc6e, 0xff71ec56,
	0x5bd33d2c, 0x303e2d14, 0x8c091d5c, 0xe7e40d64,
	0xeabb128d, 0x815602b5, 0x3d6132fd, 0x568c22c5,
	0x27df0d2f, 0x4c321d17, 0xf0052d5f, 0x9be83d67,
	0x96b7228e, 0xfd5a32b6, 0x416d02fe, 0x2a8012c6,
	0xa3cb5d2a, 0xc8264d12, 0x74117d5a, 0x1ffc6d62,
	0x12a3728b, 0x794e62b3, 0xc57952fb, 0xae9442c3,
	0xdfc76d29, 0xb42a7d11, 0x081d4d59, 0x63f05d61,
	0x6eaf4288, 0x054252b0, 0xb97562f8, 0xd29872c0,
	0xb53f9261, 0xded28259, 0x62e5b211, 0x0908a229,
	0x0457bdc0, 0x6fbaadf8, 0xd38d9db0, 0xb8608d88,
	0xc933a262, 0xa2deb25a, 0x1ee98212, 0x7504922a,
	0x785b8dc3, 0x13b69dfb, 0xaf81adb3, 0xc46cbd8b,
	0x4d27f267, 0x26cae25f, 0x9afdd217, 0xf110c22f,
	0xfc4fddc6, 0x97a2cdfe, 0x2b95fdb6, 0x4078ed8e,
	0x312bc264, 0x5ac6d25c, 0xe6f1e214, 0x8d1cf22c,
	0x8043edc5, 0xebaefdfd, 0x5799cdb5, 0x3c74dd8d
	},{
	0x00000000, 0x2f7076af, 0x5ee0ed5e, 0x71909bf1,
	0xbdc1dabc, 0x92b1ac13, 0xe32137e2, 0xcc51414d,
	0x655fda39, 0x4a2fac96, 0x3bbf3767, 0x14cf41c8,
	0xd89e0085, 0xf7ee762a, 0x867eeddb, 0xa90e9b74,
	0xcabfb472, 0xe5cfc2dd, 0x945f592c, 0xbb2f2f83,
	0x777e6ece, 0x580e1861, 0x299e8390, 0x06eef53f,
	0xafe06e4b, 0x809018e4, 0xf1008315, 0xde70f5ba,
	0x1221b4f7, 0x3d51c258, 0x4cc159a9, 0x63b12f06,
	0x8ba307a5, 0xa4d3710a, 0xd543eafb, 0xfa339c54,
	0x3662dd19, 0x1912abb6, 0x68823047, 0x47f246e8,
	0xeefcdd9c, 0xc18cab33, 0xb01c30c2, 0x9f6c466d,
	0x533d0720, 0x7c4d718f, 0x0dddea7e, 0x22ad9cd1,
	0x411cb3d7, 0x6e6cc578, 0x1ffc5e89, 0x308c2826,
	0xfcdd696b, 0xd3ad1fc4, 0xa23d8435, 0x8d4df29a,
	0x244369ee, 0x0b331f41, 0x7aa384b0, 0x55d3f21f,
	0x9982b352, 0xb6f2c5fd, 0xc7625e0c, 0xe81228a3,
	0x099a600b, 0x26ea16a4, 0x577a8d55, 0x780afbfa,
	0xb45bbab7, 0x9b2bcc18, 0xeabb57e9, 0xc5cb2146,
	0x6cc5ba32, 0x43b5cc9d, 0x3225576c, 0x1d5521c3,
	0xd104608e, 0xfe741621, 0x8fe48dd0, 0xa094fb7f,
	0xc325d479, 0xec55a2d6, 0x9dc53927, 0xb2b54f88,
	0x7ee40ec5, 0x5194786a, 0x2004e39b, 0x0f749534,
	0xa67a0e40, 0x890a78ef, 0xf89ae31e, 0xd7ea95b1,
	0x1bbbd4fc, 0x34cba253, 0x455b39a2, 0x6a2b4f0d,
	0x823967ae, 0xad491101, 0xdcd98af0, 0xf3a9fc5f,
	0x3ff8bd12, 0x1088cbbd, 0x6118504c, 0x4e6826e3,
	0xe766bd97, 0xc816cb38, 0xb98650c9, 0x96f62666,
	0x5aa7672b, 0x75d71184, 0x04478a75, 0x2b37fcda,
	0x4886d3dc, 0x67f6a573, 0x16663e82, 0x3916482d,
	0xf5470960, 0xda377fcf, 0xaba7e43e, 0x84d79291,
	0x2dd909e5, 0x02a97f4a, 0x7339e4bb, 0x5c499214,
	0x9018d359, 0xbf68a5f6, 0xcef83e07, 0xe18848a8,
	0x1334c016, 0x3c44b6b9, 0x4dd42d48, 0x62a45be7,
	0xaef51aaa, 0x81856c05, 0xf015f7f4, 0xdf65815b,
	0x766b1a2f, 0x591b6c80, 0x288bf771, 0x07fb81de,
	0xcbaac093, 0xe4dab63c, 0x954a2dcd, 0xba3a5b62,
	0xd98b7464, 0xf6fb02cb, 0x876b993a, 0xa81bef95,
	0x644aaed8, 0x4b3ad877, 0x3aaa4386, 0x15da3529,
	0xbcd4ae5d, 0x93a4d8f2, 0xe2344303, 0xcd4435ac,
	0x011574e1, 0x2e65024e, 0x5ff599bf, 0x7085ef10,
	0x9897c7b3, 0xb7e7b11c, 0xc6772aed, 0xe9075c42,
	0x25561d0f, 0x0a266ba0, 0x7bb6f051, 0x54c686fe,
	0xfdc81d8a, 0xd2b86b25, 0xa328f0d4, 0x8c58867b,
	0x4009c736, 0x6f79b199, 0x1ee92a68, 0x31995cc7,
	0x522873c1, 0x7d58056e, 0x0cc89e9f, 0x23b8e830,
	0xefe9a97d, 0xc099dfd2, 0xb1094423, 0x9e79328c,
	0x3777a9f8, 0x1807df57, 0x699744a6, 0x46e73209,
	0x8ab67344, 0xa5c605eb, 0xd4569e1a, 0xfb26e8b5,
	0x1aaea01d, 0x35ded6b2, 0x444e4d43, 0x6b3e3bec,
	0xa76f7aa1, 0x881f0c0e, 0xf98f97ff, 0xd6ffe150,
	0x7ff17a24, 0x50810c8b, 0x2111977a, 0x0e61e1d5,
	0xc230a098, 0xed40d637, 0x9cd04dc6, 0xb3a03b69,
	0xd011146f, 0xff6162c0, 0x8ef1f931, 0xa1818f9e,
	0x6dd0ced3, 0x42a0b87c, 0x3330238d, 0x1c405522,
	0xb54ece56, 0x9a3eb8f9, 0xebae2308, 0xc4de55a7,
	0x088f14ea, 0x27ff6245, 0x566ff9b4, 0x791f8f1b,
	0x910da7b8, 0xbe7dd117, 0xcfed4ae6, 0xe09d3c49,
	0x2ccc7d04, 0x03bc0bab, 0x722c905a, 0x5d5ce6f5,
	0xf4527d81, 0xdb220b2e, 0xaab290df, 0x85c2e670,
	0x4993a73d, 0x66e3d192, 0x17734a63, 0x38033ccc,
	0x5bb213ca, 0x74c26565, 0x0552fe94, 0x2a22883b,
	0xe673c976, 0xc903bfd9, 0xb8932428, 0x97e35287,
	0x3eedc9f3, 0x119dbf5c, 0x600d24ad, 0x4f7d5202,
	0x832c134f, 0xac5c65e0, 0xddccfe11, 0xf2bc88be
	},{
	0x00000000, 0x2669802c, 0x4cd30058, 0x6aba8074,
	0x99a600b0, 0xbfcf809c, 0xd57500e8, 0xf31c80c4,
	0x2d906e21, 0x0bf9ee0d, 0x61436e79, 0x472aee55,
	0xb4366e91, 0x925feebd, 0xf8e56ec9, 0xde8ceee5,
	0x5b20dc42, 0x7d495c6e, 0x17f3dc1a, 0x319a5c36,
	0xc286dcf2, 0xe4ef5cde, 0x8e55dcaa, 0xa83c5c86,
	0x76b0b263, 0x50d9324f, 0x3a63b23b, 0x1c0a3217,
	0xef16b2d3, 0xc97f32ff, 0xa3c5b28b, 0x85ac32a7,
	0xb641b884, 0x902838a8, 0xfa92b8dc, 0xdcfb38f0,
	0x2fe7b834, 0x098e3818, 0x6334b86c, 0x455d3840,
	0x9bd1d6a5, 0xbdb85689, 0xd702d6fd, 0xf16b56d1,
	0x0277d615, 0x241e5639, 0x4ea4d64d, 0x68cd5661,
	0xed6164c6, 0xcb08e4ea, 0xa1b2649e, 0x87dbe4b2,
	0x74c76476, 0x52aee45a, 0x3814642e, 0x1e7de402,
	0xc0f10ae7, 0xe6988acb, 0x8c220abf, 0xaa4b8a93,
	0x59570a57, 0x7f3e8a7b, 0x15840a0f, 0x33ed8a23,
	0x725f1e49, 0x54369e65, 0x3e8c1e11, 0x18e59e3d,
	0xebf91ef9, 0xcd909ed5, 0xa72a1ea1, 0x81439e8d,
	0x5fcf7068, 0x79a6f044, 0x131c7030, 0x3575f01c,
	0xc66970d8, 0xe000f0f4, 0x8aba7080, 0xacd3f0ac,
	0x297fc20b, 0x0f164227, 0x65acc253, 0x43c5427f,
	0xb0d9c2bb, 0x96b04297, 0xfc0ac2e3, 0xda6342cf,
	0x04efac2a, 0x22862c06, 0x483cac72, 0x6e552c5e,
	0x9d49ac9a, 0xbb202cb6, 0xd19aacc2, 0xf7f32cee,
	0xc41ea6cd, 0xe27726e1, 0x88cda695, 0xaea426b9,
	0x5db8a67d, 0x7bd12651, 0x116ba625, 0x37022609,
	0xe98ec8ec, 0xcfe748c0, 0xa55dc8b4, 0x83344898,
	0x7028c85c, 0x56414870, 0x3cfbc804, 0x1a924828,
	0x9f3e7a8f, 0xb957faa3, 0xd3ed7ad7, 0xf584fafb,
	0x06987a3f, 0x20f1fa13, 0x4a4b7a67, 0x6c22fa4b,
	0xb2ae14ae, 0x94c79482, 0xfe7d14f6, 0xd81494da,
	0x2b08141e, 0x0d619432, 0x67db1446, 0x41b2946a,
	0xe4be3c92, 0xc2d7bcbe, 0xa86d3cca, 0x8e04bce6,
	0x7d183c22, 0x5b71bc0e, 0x31cb3c7a, 0x17a2bc56,
	0xc92e52b3, 0xef47d29f, 0x85fd52eb, 0xa394d2c7,
	0x50885203, 0x76e1d22f, 0x1c5b525b, 0x3a32d277,
	0xbf9ee0d0, 0x99f760fc, 0xf34de088, 0xd52460a4,
	0x2638e060, 0x0051604c, 0x6aebe038, 0x4c826014,
	0x920e8ef1, 0xb4670edd, 0xdedd8ea9, 0xf8b40e85,
	0x0ba88e41, 0x2dc10e6d, 0x477b8e19, 0x61120e35,
	0x52ff8416, 0x7496043a, 0x1e2c844e, 0x38450462,
	0xcb5984a6, 0xed30048a, 0x878a84fe, 0xa1e304d2,
	0x7f6fea37, 0x59066a1b, 0x33bcea6f, 0x15d56a43,
	0xe6c9ea87, 0xc0a06aab, 0xaa1aeadf, 0x8c736af3,
	0x09df5854, 0x2fb6d878, 0x450c580c, 0x6365d820,
	0x907958e4, 0xb610d8c8, 0xdcaa58bc, 0xfac3d890,
	0x244f3675, 0x0226b659, 0x689c362d, 0x4ef5b601,
	0xbde936c5, 0x9b80b6e9, 0xf13a369d, 0xd753b6b1,
	0x96e122db, 0xb088a2f7, 0xda322283, 0xfc5ba2af,
	0x0f47226b, 0x292ea247, 0x43942233, 0x65fda21f,
	0xbb714cfa, 0x9d18ccd6, 0xf7a24ca2, 0xd1cbcc8e,
	0x22d74c4a, 0x04becc66, 0x6e044c12, 0x486dcc3e,
	0xcdc1fe99, 0xeba87eb5, 0x8112fec1, 0xa77b7eed,
	0x5467fe29, 0x720e7e05, 0x18b4fe71, 0x3edd7e5d,
	0xe05190b8, 0xc6381094, 0xac8290e0, 0x8aeb10cc,
	0x79f79008, 0x5f9e1024, 0x35249050, 0x134d107c,
	0x20a09a5f, 0x06c91a73, 0x6c739a07, 0x4a1a1a2b,
	0xb9069aef, 0x9f6f1ac3, 0xf5d59ab7, 0xd3bc1a9b,
	0x0d30f47e, 0x2b597452, 0x41e3f426, 0x678a740a,
	0x9496f4ce, 0xb2ff74e2, 0xd845f496, 0xfe2c74ba,
	0x7b80461d, 0x5de9c631, 0x37534645, 0x113ac669,
	0xe22646ad, 0xc44fc681, 0xaef546f5, 0x889cc6d9,
	0x5610283c, 0x7079a810, 0x1ac32864, 0x3caaa848,
	0xcfb6288c, 0xe9dfa8a0, 0x836528d4, 0xa50ca8f8
	}
};
