// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file calculatorServerImpl.hpp
 * Server implementation for interfaces
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__CALCULATOR_SERVERIMPL_HPP
#define FAST_DDS_GENERATED__CALCULATOR_SERVERIMPL_HPP

#include "calculator.hpp"
#include "calculatorServer.hpp"

namespace calculator_example {

//{ interface Calculator

struct CalculatorServerImplementation :
    public CalculatorServer_IServerImplementation
{

    calculator_example::detail::Calculator_representation_limits_Out representation_limits(
            const eprosima::fastdds::dds::rpc::RpcRequest& info) override
    {
        static_cast<void>(info);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'representation_limits' is not implemented");
    }

    int32_t addition(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ int32_t value1,
            /*in*/ int32_t value2) override
    {
        static_cast<void>(info);
        static_cast<void>(value1);
        static_cast<void>(value2);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'addition' is not implemented");
    }

    int32_t subtraction(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ int32_t value1,
            /*in*/ int32_t value2) override
    {
        static_cast<void>(info);
        static_cast<void>(value1);
        static_cast<void>(value2);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'subtraction' is not implemented");
    }

    void fibonacci_seq(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ uint32_t n_results,
            /*result*/ eprosima::fastdds::dds::rpc::RpcServerWriter<int32_t>& result_writer) override
    {
        static_cast<void>(info);
        static_cast<void>(n_results);
        static_cast<void>(result_writer);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'fibonacci_seq' is not implemented");
    }

    int32_t sum_all(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ eprosima::fastdds::dds::rpc::RpcServerReader<int32_t>& value) override
    {
        static_cast<void>(info);
        static_cast<void>(value);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'sum_all' is not implemented");
    }

    void accumulator(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ eprosima::fastdds::dds::rpc::RpcServerReader<int32_t>& value,
            /*result*/ eprosima::fastdds::dds::rpc::RpcServerWriter<int32_t>& result_writer) override
    {
        static_cast<void>(info);
        static_cast<void>(value);
        static_cast<void>(result_writer);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'accumulator' is not implemented");
    }

    void filter(
            const eprosima::fastdds::dds::rpc::RpcRequest& info,
            /*in*/ eprosima::fastdds::dds::rpc::RpcServerReader<int32_t>& value,
            /*in*/ calculator_example::FilterKind filter_kind,
            /*result*/ eprosima::fastdds::dds::rpc::RpcServerWriter<int32_t>& result_writer) override
    {
        static_cast<void>(info);
        static_cast<void>(value);
        static_cast<void>(filter_kind);
        static_cast<void>(result_writer);
        throw eprosima::fastdds::dds::rpc::RemoteUnsupportedError("Operation 'filter' is not implemented");
    }

};

//} interface Calculator


} // namespace calculator_example


#endif  // FAST_DDS_GENERATED__CALCULATOR_SERVERIMPL_HPP
