/** @file
  Terminal Device Path Vendor Guid.

  Copyright (c) 2006 - 2018, Intel Corporation. All rights reserved.<BR>
  SPDX-License-Identifier: BSD-2-Clause-Patent

  @par Revision Reference:
  GUIDs defined in UEFI 2.0 spec.

**/

#ifndef __PC_ANSI_H__
#define __PC_ANSI_H__

#define EFI_PC_ANSI_GUID \
  { \
    0xe0c14753, 0xf9be, 0x11d2, {0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } \
  }

#define EFI_VT_100_GUID \
  { \
    0xdfa66065, 0xb419, 0x11d3, {0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } \
  }

#define EFI_VT_100_PLUS_GUID \
  { \
    0x7baec70b, 0x57e0, 0x4c76, {0x8e, 0x87, 0x2f, 0x9e, 0x28, 0x08, 0x83, 0x43 } \
  }

#define EFI_VT_UTF8_GUID \
  { \
    0xad15a0d6, 0x8bec, 0x4acf, {0xa0, 0x73, 0xd0, 0x1d, 0xe7, 0x7e, 0x2d, 0x88 } \
  }

#define DEVICE_PATH_MESSAGING_UART_FLOW_CONTROL \
  { \
    0x37499a9d, 0x542f, 0x4c89, {0xa0, 0x26, 0x35, 0xda, 0x14, 0x20, 0x94, 0xe4 } \
  }

#define EFI_SAS_DEVICE_PATH_GUID \
  { \
    0xd487ddb4, 0x008b, 0x11d9, {0xaf, 0xdc, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d } \
  }

extern EFI_GUID  gEfiPcAnsiGuid;
extern EFI_GUID  gEfiVT100Guid;
extern EFI_GUID  gEfiVT100PlusGuid;
extern EFI_GUID  gEfiVTUTF8Guid;
extern EFI_GUID  gEfiUartDevicePathGuid;
extern EFI_GUID  gEfiSasDevicePathGuid;

#endif
