/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * Authors:
 *  Florian Boucault <florian.boucault@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEST_H
#define TEST_H

#include <QtCore/QCoreApplication>
#include <QtCore/QDebug>

#include "deelistmodel.h"

class TestApplication : public QCoreApplication
{
    Q_OBJECT

public:
    TestApplication(int& argc, char** argv) : QCoreApplication(argc, argv) {}

public Q_SLOTS:
    void onSynchronizedChanged(bool synchronized) {
        DeeListModel* model = (DeeListModel*)sender();
        qDebug() << "Number of columns:" << model->roleNames().size();
        qDebug() << "Number of rows:" << model->rowCount();

        for(int i = 0; i < model->rowCount(); ++i) {
            qDebug() << model->data(model->index(i));
        }
    }

    void onRowsInserted() {
        DeeListModel* model = (DeeListModel*)sender();
        qDebug() << "Rows added, current number:" << model->rowCount();
    }
};

#endif // TEST_H
