/* tp-zeitgeist.c generated by valac 0.21.1.1-0d6f, the Vala compiler
 * generated from tp-zeitgeist.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Authors:
 * 	Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <zeitgeist.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <zeitgeist-datamodel.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>


#define FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER (folks_tp_zeitgeist_controller_get_type ())
#define FOLKS_TP_ZEITGEIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistController))
#define FOLKS_TP_ZEITGEIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistControllerClass))
#define FOLKS_TP_ZEITGEIST_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER))
#define FOLKS_TP_ZEITGEIST_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER))
#define FOLKS_TP_ZEITGEIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistControllerClass))

typedef struct _FolksTpZeitgeistController FolksTpZeitgeistController;
typedef struct _FolksTpZeitgeistControllerClass FolksTpZeitgeistControllerClass;
typedef struct _FolksTpZeitgeistControllerPrivate FolksTpZeitgeistControllerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _FolksTpZeitgeistControllerPopulateCountersData FolksTpZeitgeistControllerPopulateCountersData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _FolksTpZeitgeistController {
	GObject parent_instance;
	FolksTpZeitgeistControllerPrivate * priv;
};

struct _FolksTpZeitgeistControllerClass {
	GObjectClass parent_class;
};

typedef void (*FolksTpZeitgeistControllerIncreasePersonaCounter) (FolksPersona* p, GDateTime* converted_datetime);
struct _FolksTpZeitgeistControllerPrivate {
	ZeitgeistLog* _log;
	ZeitgeistMonitor* _monitor;
	gchar* _protocol;
	FolksPersonaStore* _store;
	FolksTpZeitgeistControllerIncreasePersonaCounter _im_interaction_cb;
	FolksTpZeitgeistControllerIncreasePersonaCounter _last_call_interaction_cb;
};

struct _FolksTpZeitgeistControllerPopulateCountersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksTpZeitgeistController* self;
	ZeitgeistLog* _tmp0_;
	ZeitgeistLog* _tmp1_;
	GTimeVal tm;
	gint64 end_timestamp;
	GTimeVal _tmp2_;
	glong _tmp3_;
	gint64 start_timestamp;
	gint64 _tmp4_;
	GPtrArray* events;
	GPtrArray* _tmp5_;
	ZeitgeistResultSet* results;
	ZeitgeistLog* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	ZeitgeistTimeRange* _tmp9_;
	ZeitgeistTimeRange* _tmp10_;
	GPtrArray* _tmp11_;
	ZeitgeistResultSet* _tmp12_;
	ZeitgeistResultSet* _tmp13_;
	ZeitgeistResultSet* _e_it;
	ZeitgeistResultSet* _tmp14_;
	ZeitgeistResultSet* _tmp15_;
	ZeitgeistEvent* e;
	ZeitgeistResultSet* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	ZeitgeistEvent* _tmp18_;
	gchar* interaction_type;
	ZeitgeistEvent* _tmp19_;
	ZeitgeistSubject* _tmp20_;
	ZeitgeistSubject* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gint i;
	gboolean _tmp26_;
	gboolean _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ZeitgeistEvent* _tmp30_;
	gint _tmp31_;
	gchar* id;
	ZeitgeistEvent* _tmp32_;
	gint _tmp33_;
	ZeitgeistSubject* _tmp34_;
	ZeitgeistSubject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gboolean _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp43_;
	FolksPersona* persona;
	FolksPersonaStore* _tmp44_;
	GeeMap* _tmp45_;
	GeeMap* _tmp46_;
	const gchar* _tmp47_;
	gpointer _tmp48_;
	FolksPersona* _tmp49_;
	FolksPersona* _tmp50_;
	FolksPersona* _tmp51_;
	const gchar* _tmp52_;
	ZeitgeistEvent* _tmp53_;
	ZeitgeistResultSet* _vala1__e_it;
	ZeitgeistResultSet* _tmp54_;
	ZeitgeistResultSet* _tmp55_;
	ZeitgeistEvent* _vala1_e;
	ZeitgeistResultSet* _tmp56_;
	ZeitgeistEvent* _tmp57_;
	ZeitgeistEvent* _tmp58_;
	gchar* _vala1_interaction_type;
	ZeitgeistEvent* _tmp59_;
	ZeitgeistSubject* _tmp60_;
	ZeitgeistSubject* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gint _vala1_i;
	gboolean _tmp66_;
	gboolean _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	ZeitgeistEvent* _tmp70_;
	gint _tmp71_;
	gchar* _vala1_id;
	ZeitgeistEvent* _tmp72_;
	gint _tmp73_;
	ZeitgeistSubject* _tmp74_;
	ZeitgeistSubject* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gboolean _tmp80_;
	const gchar* _tmp81_;
	const gchar* _tmp82_;
	gboolean _tmp83_;
	FolksPersona* _vala1_persona;
	FolksPersonaStore* _tmp84_;
	GeeMap* _tmp85_;
	GeeMap* _tmp86_;
	const gchar* _tmp87_;
	gpointer _tmp88_;
	FolksPersona* _tmp89_;
	FolksPersona* _tmp90_;
	ZeitgeistMonitor* _tmp91_;
	GPtrArray* monitor_events;
	GPtrArray* _tmp92_;
	ZeitgeistTimeRange* _tmp93_;
	ZeitgeistTimeRange* _tmp94_;
	GPtrArray* _tmp95_;
	GPtrArray* _tmp96_;
	ZeitgeistMonitor* _tmp97_;
	ZeitgeistMonitor* _tmp98_;
	ZeitgeistLog* _tmp99_;
	ZeitgeistMonitor* _tmp100_;
	GError * _inner_error_;
};


static gpointer folks_tp_zeitgeist_controller_parent_class = NULL;

GType folks_tp_zeitgeist_controller_get_type (void) G_GNUC_CONST;
#define FOLKS_TP_ZEITGEIST_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistControllerPrivate))
enum  {
	FOLKS_TP_ZEITGEIST_CONTROLLER_DUMMY_PROPERTY
};
FolksTpZeitgeistController* folks_tp_zeitgeist_controller_new (FolksPersonaStore* store, const gchar* protocol, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb);
FolksTpZeitgeistController* folks_tp_zeitgeist_controller_construct (GType object_type, FolksPersonaStore* store, const gchar* protocol, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb);
static void folks_tp_zeitgeist_controller_populate_counters_data_free (gpointer _data);
void folks_tp_zeitgeist_controller_populate_counters (FolksTpZeitgeistController* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_tp_zeitgeist_controller_populate_counters_finish (FolksTpZeitgeistController* self, GAsyncResult* _res_);
static gboolean folks_tp_zeitgeist_controller_populate_counters_co (FolksTpZeitgeistControllerPopulateCountersData* _data_);
static GPtrArray* _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (FolksTpZeitgeistController* self);
static void folks_tp_zeitgeist_controller_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (FolksTpZeitgeistController* self, const gchar* uri);
static void _folks_tp_zeitgeist_controller_increase_persona_counter (FolksTpZeitgeistController* self, FolksPersona* persona, const gchar* interaction_type, ZeitgeistEvent* event);
static void _folks_tp_zeitgeist_controller_handle_new_interaction (FolksTpZeitgeistController* self, ZeitgeistTimeRange* timerange, ZeitgeistResultSet* events);
static void __folks_tp_zeitgeist_controller_handle_new_interaction_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void folks_tp_zeitgeist_controller_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return self ? g_object_ref (self) : NULL;
#line 230 "tp-zeitgeist.c"
}


FolksTpZeitgeistController* folks_tp_zeitgeist_controller_construct (GType object_type, FolksPersonaStore* store, const gchar* protocol, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb) {
	FolksTpZeitgeistController * self = NULL;
	FolksPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	FolksTpZeitgeistControllerIncreasePersonaCounter _tmp3_ = NULL;
	FolksTpZeitgeistControllerIncreasePersonaCounter _tmp4_ = NULL;
#line 52 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 52 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_val_if_fail (protocol != NULL, NULL);
#line 52 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self = (FolksTpZeitgeistController*) g_object_new (object_type, NULL);
#line 56 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp0_ = store;
#line 56 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv->_store = _tmp0_;
#line 57 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp1_ = protocol;
#line 57 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 57 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_free0 (self->priv->_protocol);
#line 57 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv->_protocol = _tmp2_;
#line 58 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp3_ = im_interaction_cb;
#line 58 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv->_im_interaction_cb = _tmp3_;
#line 59 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp4_ = last_call_interaction_cb;
#line 59 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv->_last_call_interaction_cb = _tmp4_;
#line 52 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return self;
#line 269 "tp-zeitgeist.c"
}


FolksTpZeitgeistController* folks_tp_zeitgeist_controller_new (FolksPersonaStore* store, const gchar* protocol, FolksTpZeitgeistControllerIncreasePersonaCounter im_interaction_cb, FolksTpZeitgeistControllerIncreasePersonaCounter last_call_interaction_cb) {
#line 52 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return folks_tp_zeitgeist_controller_construct (FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, store, protocol, im_interaction_cb, last_call_interaction_cb);
#line 276 "tp-zeitgeist.c"
}


static void folks_tp_zeitgeist_controller_populate_counters_data_free (gpointer _data) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
	_data_ = _data;
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_slice_free (FolksTpZeitgeistControllerPopulateCountersData, _data_);
#line 287 "tp-zeitgeist.c"
}


void folks_tp_zeitgeist_controller_populate_counters (FolksTpZeitgeistController* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
	FolksTpZeitgeistController* _tmp0_ = NULL;
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_ = g_slice_new0 (FolksTpZeitgeistControllerPopulateCountersData);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_tp_zeitgeist_controller_populate_counters);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_tp_zeitgeist_controller_populate_counters_data_free);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->self = _tmp0_;
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	folks_tp_zeitgeist_controller_populate_counters_co (_data_);
#line 306 "tp-zeitgeist.c"
}


void folks_tp_zeitgeist_controller_populate_counters_finish (FolksTpZeitgeistController* self, GAsyncResult* _res_) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 314 "tp-zeitgeist.c"
}


static void folks_tp_zeitgeist_controller_populate_counters_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksTpZeitgeistControllerPopulateCountersData* _data_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_ = _user_data_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_source_object_ = source_object;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_res_ = _res_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	folks_tp_zeitgeist_controller_populate_counters_co (_data_);
#line 328 "tp-zeitgeist.c"
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return self ? g_ptr_array_ref (self) : NULL;
#line 335 "tp-zeitgeist.c"
}


static void __folks_tp_zeitgeist_controller_handle_new_interaction_zeitgeist_monitor_events_inserted (ZeitgeistMonitor* _sender, ZeitgeistTimeRange* time_range, ZeitgeistResultSet* events, gpointer self) {
#line 145 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_folks_tp_zeitgeist_controller_handle_new_interaction (self, time_range, events);
#line 342 "tp-zeitgeist.c"
}


static gboolean folks_tp_zeitgeist_controller_populate_counters_co (FolksTpZeitgeistControllerPopulateCountersData* _data_) {
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	switch (_data_->_state_) {
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		case 0:
#line 351 "tp-zeitgeist.c"
		goto _state_0;
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		case 1:
#line 355 "tp-zeitgeist.c"
		goto _state_1;
		default:
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_assert_not_reached ();
#line 360 "tp-zeitgeist.c"
	}
	_state_0:
#line 73 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_tmp0_ = NULL;
#line 73 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_tmp0_ = _data_->self->priv->_log;
#line 73 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_data_->_tmp0_ == NULL) {
#line 75 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp1_ = NULL;
#line 75 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp1_ = zeitgeist_log_new ();
#line 75 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (_data_->self->priv->_log);
#line 75 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->self->priv->_log = _data_->_tmp1_;
#line 377 "tp-zeitgeist.c"
	}
	{
#line 82 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_get_current_time (&_data_->tm);
#line 83 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		memset (&_data_->_tmp2_, 0, sizeof (GTimeVal));
#line 83 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp2_ = _data_->tm;
#line 83 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp3_ = 0L;
#line 83 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp3_ = _data_->_tmp2_.tv_sec;
#line 83 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->end_timestamp = (gint64) _data_->_tmp3_;
#line 86 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp4_ = 0LL;
#line 86 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp4_ = _data_->end_timestamp;
#line 86 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->start_timestamp = _data_->_tmp4_ - (86400 * 30);
#line 87 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp5_ = NULL;
#line 87 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp5_ = _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (_data_->self);
#line 87 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->events = _data_->_tmp5_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp6_ = NULL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp6_ = _data_->self->priv->_log;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp7_ = 0LL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp7_ = _data_->start_timestamp;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp8_ = 0LL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp8_ = _data_->end_timestamp;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp9_ = NULL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp9_ = zeitgeist_time_range_new (_data_->_tmp7_ * 1000, _data_->_tmp8_ * 1000);
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp10_ = NULL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp10_ = _data_->_tmp9_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp11_ = NULL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp11_ = _data_->events;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_state_ = 1;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		zeitgeist_log_find_events (_data_->_tmp6_, _data_->_tmp10_, _data_->_tmp11_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 0, ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, NULL, folks_tp_zeitgeist_controller_populate_counters_ready, _data_);
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		return FALSE;
#line 434 "tp-zeitgeist.c"
		_state_1:
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp12_ = NULL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp12_ = zeitgeist_log_find_events_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp13_ = NULL;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (_data_->_tmp10_);
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->results = _data_->_tmp13_;
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		if (_data_->_inner_error_ != NULL) {
#line 89 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_ptr_array_unref0 (_data_->events);
#line 452 "tp-zeitgeist.c"
			goto __catch0_g_error;
		}
		{
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp14_ = NULL;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp14_ = _data_->results;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp15_ = NULL;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp15_ = zeitgeist_result_set_iterator (_data_->_tmp14_);
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_e_it = _data_->_tmp15_;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			while (TRUE) {
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp16_ = NULL;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp16_ = _data_->_e_it;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp17_ = NULL;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp17_ = zeitgeist_result_set_next_value (_data_->_tmp16_);
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_g_object_unref0 (_data_->e);
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->e = _data_->_tmp17_;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp18_ = NULL;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp18_ = _data_->e;
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				if (!(_data_->_tmp18_ != NULL)) {
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
					break;
#line 488 "tp-zeitgeist.c"
				}
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp19_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp19_ = _data_->e;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp20_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp20_ = zeitgeist_event_get_subject (_data_->_tmp19_, 0);
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp21_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp21_ = _data_->_tmp20_;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp22_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp22_ = zeitgeist_subject_get_interpretation (_data_->_tmp21_);
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp23_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp23_ = _data_->_tmp22_;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp24_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp25_ = NULL;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp25_ = _data_->_tmp24_;
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_g_object_unref0 (_data_->_tmp21_);
#line 96 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->interaction_type = _data_->_tmp25_;
#line 522 "tp-zeitgeist.c"
				{
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
					_data_->i = 1;
#line 526 "tp-zeitgeist.c"
					{
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_data_->_tmp26_ = TRUE;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						while (TRUE) {
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp27_ = FALSE;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp27_ = _data_->_tmp26_;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (!_data_->_tmp27_) {
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp28_ = 0;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp28_ = _data_->i;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->i = _data_->_tmp28_ + 1;
#line 544 "tp-zeitgeist.c"
							}
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp26_ = FALSE;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp29_ = 0;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp29_ = _data_->i;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp30_ = NULL;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp30_ = _data_->e;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp31_ = 0;
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp31_ = zeitgeist_event_num_subjects (_data_->_tmp30_);
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (!(_data_->_tmp29_ < _data_->_tmp31_)) {
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								break;
#line 564 "tp-zeitgeist.c"
							}
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp32_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp32_ = _data_->e;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp33_ = 0;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp33_ = _data_->i;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp34_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp34_ = zeitgeist_event_get_subject (_data_->_tmp32_, _data_->_tmp33_);
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp35_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp35_ = _data_->_tmp34_;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp36_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp36_ = zeitgeist_subject_get_uri (_data_->_tmp35_);
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp37_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp37_ = _data_->_tmp36_;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp38_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp38_ = _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (_data_->self, _data_->_tmp37_);
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp39_ = NULL;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp39_ = _data_->_tmp38_;
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_object_unref0 (_data_->_tmp35_);
#line 99 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->id = _data_->_tmp39_;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp41_ = NULL;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp41_ = _data_->id;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (_data_->_tmp41_ == NULL) {
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp40_ = TRUE;
#line 610 "tp-zeitgeist.c"
							} else {
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp42_ = NULL;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp42_ = _data_->interaction_type;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp40_ = _data_->_tmp42_ == NULL;
#line 618 "tp-zeitgeist.c"
							}
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp43_ = FALSE;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp43_ = _data_->_tmp40_;
#line 101 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (_data_->_tmp43_) {
#line 102 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_g_free0 (_data_->id);
#line 102 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								continue;
#line 630 "tp-zeitgeist.c"
							}
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp44_ = NULL;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp44_ = _data_->self->priv->_store;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp45_ = NULL;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp45_ = folks_persona_store_get_personas (_data_->_tmp44_);
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp46_ = NULL;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp46_ = _data_->_tmp45_;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp47_ = NULL;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp47_ = _data_->id;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp48_ = NULL;
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp48_ = gee_map_get (_data_->_tmp46_, _data_->_tmp47_);
#line 104 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->persona = (FolksPersona*) _data_->_tmp48_;
#line 105 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp49_ = NULL;
#line 105 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp49_ = _data_->persona;
#line 105 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (_data_->_tmp49_ == NULL) {
#line 106 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_g_object_unref0 (_data_->persona);
#line 106 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_g_free0 (_data_->id);
#line 106 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								continue;
#line 666 "tp-zeitgeist.c"
							}
#line 108 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp50_ = NULL;
#line 108 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp50_ = _data_->persona;
#line 108 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							g_object_freeze_notify ((GObject*) _data_->_tmp50_);
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp51_ = NULL;
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp51_ = _data_->persona;
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp52_ = NULL;
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp52_ = _data_->interaction_type;
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp53_ = NULL;
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp53_ = _data_->e;
#line 109 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_folks_tp_zeitgeist_controller_increase_persona_counter (_data_->self, _data_->_tmp51_, _data_->_tmp52_, _data_->_tmp53_);
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_object_unref0 (_data_->persona);
#line 97 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_free0 (_data_->id);
#line 692 "tp-zeitgeist.c"
						}
					}
				}
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_g_free0 (_data_->interaction_type);
#line 698 "tp-zeitgeist.c"
			}
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_object_unref0 (_data_->e);
#line 94 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_object_unref0 (_data_->_e_it);
#line 704 "tp-zeitgeist.c"
		}
		{
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp54_ = NULL;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp54_ = _data_->results;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp55_ = NULL;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp55_ = zeitgeist_result_set_iterator (_data_->_tmp54_);
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_vala1__e_it = _data_->_tmp55_;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			while (TRUE) {
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp56_ = NULL;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp56_ = _data_->_vala1__e_it;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp57_ = NULL;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp57_ = zeitgeist_result_set_next_value (_data_->_tmp56_);
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_g_object_unref0 (_data_->_vala1_e);
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_vala1_e = _data_->_tmp57_;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp58_ = NULL;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp58_ = _data_->_vala1_e;
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				if (!(_data_->_tmp58_ != NULL)) {
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
					break;
#line 739 "tp-zeitgeist.c"
				}
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp59_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp59_ = _data_->_vala1_e;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp60_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp60_ = zeitgeist_event_get_subject (_data_->_tmp59_, 0);
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp61_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp61_ = _data_->_tmp60_;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp62_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp62_ = zeitgeist_subject_get_interpretation (_data_->_tmp61_);
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp63_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp63_ = _data_->_tmp62_;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp64_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp64_ = g_strdup (_data_->_tmp63_);
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp65_ = NULL;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_tmp65_ = _data_->_tmp64_;
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_g_object_unref0 (_data_->_tmp61_);
#line 116 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_data_->_vala1_interaction_type = _data_->_tmp65_;
#line 773 "tp-zeitgeist.c"
				{
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
					_data_->_vala1_i = 1;
#line 777 "tp-zeitgeist.c"
					{
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_data_->_tmp66_ = TRUE;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						while (TRUE) {
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp67_ = FALSE;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp67_ = _data_->_tmp66_;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (!_data_->_tmp67_) {
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp68_ = 0;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp68_ = _data_->_vala1_i;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_vala1_i = _data_->_tmp68_ + 1;
#line 795 "tp-zeitgeist.c"
							}
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp66_ = FALSE;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp69_ = 0;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp69_ = _data_->_vala1_i;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp70_ = NULL;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp70_ = _data_->_vala1_e;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp71_ = 0;
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp71_ = zeitgeist_event_num_subjects (_data_->_tmp70_);
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (!(_data_->_tmp69_ < _data_->_tmp71_)) {
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								break;
#line 815 "tp-zeitgeist.c"
							}
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp72_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp72_ = _data_->_vala1_e;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp73_ = 0;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp73_ = _data_->_vala1_i;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp74_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp74_ = zeitgeist_event_get_subject (_data_->_tmp72_, _data_->_tmp73_);
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp75_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp75_ = _data_->_tmp74_;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp76_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp76_ = zeitgeist_subject_get_uri (_data_->_tmp75_);
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp77_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp77_ = _data_->_tmp76_;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp78_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp78_ = _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (_data_->self, _data_->_tmp77_);
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp79_ = NULL;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp79_ = _data_->_tmp78_;
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_object_unref0 (_data_->_tmp75_);
#line 119 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_vala1_id = _data_->_tmp79_;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp81_ = NULL;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp81_ = _data_->_vala1_id;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (_data_->_tmp81_ == NULL) {
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp80_ = TRUE;
#line 861 "tp-zeitgeist.c"
							} else {
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp82_ = NULL;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp82_ = _data_->_vala1_interaction_type;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_data_->_tmp80_ = _data_->_tmp82_ == NULL;
#line 869 "tp-zeitgeist.c"
							}
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp83_ = FALSE;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp83_ = _data_->_tmp80_;
#line 121 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (_data_->_tmp83_) {
#line 122 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_g_free0 (_data_->_vala1_id);
#line 122 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								continue;
#line 881 "tp-zeitgeist.c"
							}
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp84_ = NULL;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp84_ = _data_->self->priv->_store;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp85_ = NULL;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp85_ = folks_persona_store_get_personas (_data_->_tmp84_);
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp86_ = NULL;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp86_ = _data_->_tmp85_;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp87_ = NULL;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp87_ = _data_->_vala1_id;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp88_ = NULL;
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp88_ = gee_map_get (_data_->_tmp86_, _data_->_tmp87_);
#line 124 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_vala1_persona = (FolksPersona*) _data_->_tmp88_;
#line 125 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp89_ = NULL;
#line 125 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp89_ = _data_->_vala1_persona;
#line 125 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							if (_data_->_tmp89_ == NULL) {
#line 126 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_g_object_unref0 (_data_->_vala1_persona);
#line 126 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								_g_free0 (_data_->_vala1_id);
#line 126 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
								continue;
#line 917 "tp-zeitgeist.c"
							}
#line 128 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp90_ = NULL;
#line 128 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_data_->_tmp90_ = _data_->_vala1_persona;
#line 128 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							g_object_thaw_notify ((GObject*) _data_->_tmp90_);
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_object_unref0 (_data_->_vala1_persona);
#line 117 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_free0 (_data_->_vala1_id);
#line 929 "tp-zeitgeist.c"
						}
					}
				}
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				_g_free0 (_data_->_vala1_interaction_type);
#line 935 "tp-zeitgeist.c"
			}
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_object_unref0 (_data_->_vala1_e);
#line 114 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_object_unref0 (_data_->_vala1__e_it);
#line 941 "tp-zeitgeist.c"
		}
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (_data_->results);
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_ptr_array_unref0 (_data_->events);
#line 947 "tp-zeitgeist.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_clear_error (&_data_->_inner_error_);
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_inner_error_ = NULL;
#line 134 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_debug ("tp-zeitgeist.vala:134: Failed to fetch events from Zeitgeist");
#line 958 "tp-zeitgeist.c"
	}
	__finally0:
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_data_->_inner_error_ != NULL) {
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_clear_error (&_data_->_inner_error_);
#line 80 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		return FALSE;
#line 969 "tp-zeitgeist.c"
	}
#line 139 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_tmp91_ = NULL;
#line 139 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_data_->_tmp91_ = _data_->self->priv->_monitor;
#line 139 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_data_->_tmp91_ == NULL) {
#line 141 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp92_ = NULL;
#line 141 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp92_ = _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (_data_->self);
#line 141 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->monitor_events = _data_->_tmp92_;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp93_ = NULL;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp93_ = zeitgeist_time_range_new_from_now ();
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp94_ = NULL;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp94_ = _data_->_tmp93_;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp95_ = NULL;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp95_ = _data_->monitor_events;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp96_ = NULL;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp96_ = _g_ptr_array_ref0 (_data_->_tmp95_);
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp97_ = NULL;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp97_ = zeitgeist_monitor_new (_data_->_tmp94_, _data_->_tmp96_);
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (_data_->self->priv->_monitor);
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->self->priv->_monitor = _data_->_tmp97_;
#line 143 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (_data_->_tmp94_);
#line 145 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp98_ = NULL;
#line 145 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_data_->_tmp98_ = _data_->self->priv->_monitor;
#line 145 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_signal_connect_object (_data_->_tmp98_, "events-inserted", (GCallback) __folks_tp_zeitgeist_controller_handle_new_interaction_zeitgeist_monitor_events_inserted, _data_->self, 0);
#line 1015 "tp-zeitgeist.c"
		{
#line 148 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp99_ = NULL;
#line 148 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp99_ = _data_->self->priv->_log;
#line 148 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp100_ = NULL;
#line 148 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_tmp100_ = _data_->self->priv->_monitor;
#line 148 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			zeitgeist_log_install_monitor (_data_->_tmp99_, _data_->_tmp100_, &_data_->_inner_error_);
#line 148 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1029 "tp-zeitgeist.c"
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			g_clear_error (&_data_->_inner_error_);
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->_inner_error_ = NULL;
#line 152 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			g_warning ("tp-zeitgeist.vala:152: Failed to install monitor for Zeitgeist");
#line 153 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_object_unref0 (_data_->self->priv->_monitor);
#line 153 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_data_->self->priv->_monitor = NULL;
#line 1046 "tp-zeitgeist.c"
		}
		__finally1:
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		if (_data_->_inner_error_ != NULL) {
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_ptr_array_unref0 (_data_->monitor_events);
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			g_clear_error (&_data_->_inner_error_);
#line 146 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			return FALSE;
#line 1059 "tp-zeitgeist.c"
		}
#line 139 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_ptr_array_unref0 (_data_->monitor_events);
#line 1063 "tp-zeitgeist.c"
	}
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_data_->_state_ == 0) {
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1069 "tp-zeitgeist.c"
	} else {
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1073 "tp-zeitgeist.c"
	}
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_object_unref (_data_->_async_result);
#line 71 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return FALSE;
#line 1079 "tp-zeitgeist.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1242 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1242 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1242 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1092 "tp-zeitgeist.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1122 "tp-zeitgeist.c"
				goto __catch2_g_regex_error;
			}
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 1131 "tp-zeitgeist.c"
		}
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1147 "tp-zeitgeist.c"
				goto __catch2_g_regex_error;
			}
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
			return NULL;
#line 1158 "tp-zeitgeist.c"
		}
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		result = _tmp5_;
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1245 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		return result;
#line 1166 "tp-zeitgeist.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1247 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1180 "tp-zeitgeist.c"
	}
	__finally2:
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1243 "/opt/gnome/share/vala-0.22/vapi/glib-2.0.vapi"
		return NULL;
#line 1191 "tp-zeitgeist.c"
	}
}


static gchar* _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (FolksTpZeitgeistController* self, const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* new_uri = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 158 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp0_ = uri;
#line 163 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_tmp0_ == NULL) {
#line 165 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		result = NULL;
#line 165 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		return result;
#line 1218 "tp-zeitgeist.c"
	}
#line 167 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp1_ = uri;
#line 167 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp2_ = string_replace (_tmp1_, "x-telepathy-identifier:", "");
#line 167 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	new_uri = _tmp2_;
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp3_ = self->priv->_protocol;
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp4_ = g_strconcat (_tmp3_, ":", NULL);
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp5_ = _tmp4_;
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp6_ = new_uri;
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp8_ = _tmp7_;
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_free0 (_tmp5_);
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	result = _tmp8_;
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_free0 (new_uri);
#line 168 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return result;
#line 1246 "tp-zeitgeist.c"
}


static void _folks_tp_zeitgeist_controller_increase_persona_counter (FolksTpZeitgeistController* self, FolksPersona* persona, const gchar* interaction_type, ZeitgeistEvent* event) {
	guint timestamp = 0U;
	ZeitgeistEvent* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	GDateTime* converted_datetime = NULL;
	guint _tmp3_ = 0U;
	GDateTime* _tmp4_ = NULL;
	gchar* interpretation = NULL;
	ZeitgeistEvent* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 171 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (persona != NULL);
#line 171 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (interaction_type != NULL);
#line 171 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (event != NULL);
#line 176 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp0_ = event;
#line 176 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp1_ = zeitgeist_event_get_timestamp (_tmp0_);
#line 176 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp2_ = _tmp1_;
#line 176 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	timestamp = (guint) (_tmp2_ / 1000);
#line 177 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp3_ = timestamp;
#line 177 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp4_ = g_date_time_new_from_unix_utc ((gint64) _tmp3_);
#line 177 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	converted_datetime = _tmp4_;
#line 178 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp5_ = event;
#line 178 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp6_ = zeitgeist_event_get_interpretation (_tmp5_);
#line 178 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp7_ = _tmp6_;
#line 178 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 178 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	interpretation = _tmp8_;
#line 181 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp10_ = interaction_type;
#line 181 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (g_strcmp0 (_tmp10_, ZEITGEIST_NMO_IMMESSAGE) == 0) {
#line 1302 "tp-zeitgeist.c"
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 182 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp12_ = interpretation;
#line 182 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		if (g_strcmp0 (_tmp12_, ZEITGEIST_ZG_SEND_EVENT) == 0) {
#line 182 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp11_ = TRUE;
#line 1312 "tp-zeitgeist.c"
		} else {
			const gchar* _tmp13_ = NULL;
#line 183 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp13_ = interpretation;
#line 183 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp11_ = g_strcmp0 (_tmp13_, ZEITGEIST_ZG_RECEIVE_EVENT) == 0;
#line 1319 "tp-zeitgeist.c"
		}
#line 182 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp14_ = _tmp11_;
#line 182 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp9_ = _tmp14_;
#line 1325 "tp-zeitgeist.c"
	} else {
#line 181 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp9_ = FALSE;
#line 1329 "tp-zeitgeist.c"
	}
#line 181 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp15_ = _tmp9_;
#line 181 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_tmp15_) {
#line 1335 "tp-zeitgeist.c"
		FolksTpZeitgeistControllerIncreasePersonaCounter _tmp16_ = NULL;
		FolksPersona* _tmp17_ = NULL;
		GDateTime* _tmp18_ = NULL;
#line 185 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp16_ = self->priv->_im_interaction_cb;
#line 185 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp17_ = persona;
#line 185 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp18_ = converted_datetime;
#line 185 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp16_ (_tmp17_, _tmp18_);
#line 1347 "tp-zeitgeist.c"
	} else {
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 188 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp20_ = interaction_type;
#line 188 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		if (g_strcmp0 (_tmp20_, ZEITGEIST_NFO_AUDIO) == 0) {
#line 1356 "tp-zeitgeist.c"
			const gchar* _tmp21_ = NULL;
#line 189 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp21_ = interpretation;
#line 189 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp19_ = g_strcmp0 (_tmp21_, ZEITGEIST_ZG_LEAVE_EVENT) == 0;
#line 1362 "tp-zeitgeist.c"
		} else {
#line 188 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp19_ = FALSE;
#line 1366 "tp-zeitgeist.c"
		}
#line 188 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp22_ = _tmp19_;
#line 188 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		if (_tmp22_) {
#line 1372 "tp-zeitgeist.c"
			FolksTpZeitgeistControllerIncreasePersonaCounter _tmp23_ = NULL;
			FolksPersona* _tmp24_ = NULL;
			GDateTime* _tmp25_ = NULL;
#line 191 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp23_ = self->priv->_last_call_interaction_cb;
#line 191 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp24_ = persona;
#line 191 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp25_ = converted_datetime;
#line 191 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp23_ (_tmp24_, _tmp25_);
#line 1384 "tp-zeitgeist.c"
		}
	}
#line 171 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_free0 (interpretation);
#line 171 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_date_time_unref0 (converted_datetime);
#line 1391 "tp-zeitgeist.c"
}


static void _folks_tp_zeitgeist_controller_handle_new_interaction (FolksTpZeitgeistController* self, ZeitgeistTimeRange* timerange, ZeitgeistResultSet* events) {
#line 195 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (timerange != NULL);
#line 195 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_if_fail (events != NULL);
#line 1402 "tp-zeitgeist.c"
	{
		ZeitgeistResultSet* _e_it = NULL;
		ZeitgeistResultSet* _tmp0_ = NULL;
		ZeitgeistResultSet* _tmp1_ = NULL;
		ZeitgeistEvent* e = NULL;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp0_ = events;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp1_ = zeitgeist_result_set_iterator (_tmp0_);
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_e_it = _tmp1_;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		while (TRUE) {
#line 1416 "tp-zeitgeist.c"
			ZeitgeistResultSet* _tmp2_ = NULL;
			ZeitgeistEvent* _tmp3_ = NULL;
			ZeitgeistEvent* _tmp4_ = NULL;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp2_ = _e_it;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp3_ = zeitgeist_result_set_next_value (_tmp2_);
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_g_object_unref0 (e);
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			e = _tmp3_;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			_tmp4_ = e;
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			if (!(_tmp4_ != NULL)) {
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				break;
#line 1434 "tp-zeitgeist.c"
			}
			{
				gint i = 0;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
				i = 1;
#line 1440 "tp-zeitgeist.c"
				{
					gboolean _tmp5_ = FALSE;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
					_tmp5_ = TRUE;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
					while (TRUE) {
#line 1447 "tp-zeitgeist.c"
						gboolean _tmp6_ = FALSE;
						gint _tmp8_ = 0;
						ZeitgeistEvent* _tmp9_ = NULL;
						gint _tmp10_ = 0;
						gchar* id = NULL;
						ZeitgeistEvent* _tmp11_ = NULL;
						gint _tmp12_ = 0;
						ZeitgeistSubject* _tmp13_ = NULL;
						ZeitgeistSubject* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						gchar* interaction_type = NULL;
						ZeitgeistEvent* _tmp19_ = NULL;
						ZeitgeistSubject* _tmp20_ = NULL;
						ZeitgeistSubject* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
						gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						gboolean _tmp26_ = FALSE;
						const gchar* _tmp27_ = NULL;
						gboolean _tmp29_ = FALSE;
						FolksPersona* persona = NULL;
						FolksPersonaStore* _tmp30_ = NULL;
						GeeMap* _tmp31_ = NULL;
						GeeMap* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						gpointer _tmp34_ = NULL;
						FolksPersona* _tmp35_ = NULL;
						FolksPersona* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
						ZeitgeistEvent* _tmp38_ = NULL;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp6_ = _tmp5_;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						if (!_tmp6_) {
#line 1486 "tp-zeitgeist.c"
							gint _tmp7_ = 0;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_tmp7_ = i;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							i = _tmp7_ + 1;
#line 1492 "tp-zeitgeist.c"
						}
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp5_ = FALSE;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp8_ = i;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp9_ = e;
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp10_ = zeitgeist_event_num_subjects (_tmp9_);
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						if (!(_tmp8_ < _tmp10_)) {
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							break;
#line 1506 "tp-zeitgeist.c"
						}
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp11_ = e;
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp12_ = i;
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp13_ = zeitgeist_event_get_subject (_tmp11_, _tmp12_);
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp14_ = _tmp13_;
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp15_ = zeitgeist_subject_get_uri (_tmp14_);
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp16_ = _tmp15_;
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp17_ = _folks_tp_zeitgeist_controller_get_iid_from_event_metadata (self, _tmp16_);
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp18_ = _tmp17_;
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_g_object_unref0 (_tmp14_);
#line 201 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						id = _tmp18_;
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp19_ = e;
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp20_ = zeitgeist_event_get_subject (_tmp19_, 0);
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp21_ = _tmp20_;
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp22_ = zeitgeist_subject_get_interpretation (_tmp21_);
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp23_ = _tmp22_;
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp24_ = g_strdup (_tmp23_);
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp25_ = _tmp24_;
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_g_object_unref0 (_tmp21_);
#line 203 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						interaction_type = _tmp25_;
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp27_ = id;
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						if (_tmp27_ == NULL) {
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_tmp26_ = TRUE;
#line 1552 "tp-zeitgeist.c"
						} else {
							const gchar* _tmp28_ = NULL;
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_tmp28_ = interaction_type;
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_tmp26_ = _tmp28_ == NULL;
#line 1559 "tp-zeitgeist.c"
						}
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp29_ = _tmp26_;
#line 204 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						if (_tmp29_) {
#line 205 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_free0 (interaction_type);
#line 205 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_free0 (id);
#line 205 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							continue;
#line 1571 "tp-zeitgeist.c"
						}
#line 207 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp30_ = self->priv->_store;
#line 207 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp31_ = folks_persona_store_get_personas (_tmp30_);
#line 207 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp32_ = _tmp31_;
#line 207 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp33_ = id;
#line 207 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp34_ = gee_map_get (_tmp32_, _tmp33_);
#line 207 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						persona = (FolksPersona*) _tmp34_;
#line 208 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp35_ = persona;
#line 208 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						if (_tmp35_ == NULL) {
#line 209 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_object_unref0 (persona);
#line 209 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_free0 (interaction_type);
#line 209 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							_g_free0 (id);
#line 209 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
							continue;
#line 1597 "tp-zeitgeist.c"
						}
#line 211 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp36_ = persona;
#line 211 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp37_ = interaction_type;
#line 211 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_tmp38_ = e;
#line 211 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_folks_tp_zeitgeist_controller_increase_persona_counter (self, _tmp36_, _tmp37_, _tmp38_);
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_g_object_unref0 (persona);
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_g_free0 (interaction_type);
#line 199 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
						_g_free0 (id);
#line 1613 "tp-zeitgeist.c"
					}
				}
			}
		}
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (e);
#line 197 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (_e_it);
#line 1622 "tp-zeitgeist.c"
	}
}


static void _g_object_unref0_ (gpointer var) {
#line 227 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1630 "tp-zeitgeist.c"
}


static GPtrArray* _folks_tp_zeitgeist_controller_get_zeitgeist_event_templates (FolksTpZeitgeistController* self) {
	GPtrArray* result = NULL;
	gchar* origin = NULL;
	FolksPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ZeitgeistEvent* ev1 = NULL;
	ZeitgeistEvent* _tmp4_ = NULL;
	GPtrArray* templates = NULL;
	GPtrArray* _tmp5_ = NULL;
	ZeitgeistEvent* _tmp6_ = NULL;
#line 216 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 221 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp0_ = self->priv->_store;
#line 221 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp1_ = folks_persona_store_get_id (_tmp0_);
#line 221 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp2_ = _tmp1_;
#line 221 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp3_ = string_replace (_tmp2_, TP_ACCOUNT_OBJECT_PATH_BASE, "x-telepathy-account-path:");
#line 221 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	origin = _tmp3_;
#line 224 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp4_ = zeitgeist_event_new_full ("", "", "dbus://org.freedesktop.Telepathy.Logger.service", NULL, NULL);
#line 224 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	ev1 = _tmp4_;
#line 226 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	zeitgeist_event_set_origin (ev1, origin);
#line 227 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp5_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
#line 227 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	templates = _tmp5_;
#line 228 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp6_ = _g_object_ref0 (ev1);
#line 228 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_ptr_array_add (templates, _tmp6_);
#line 229 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	result = templates;
#line 229 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_object_unref0 (ev1);
#line 229 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_free0 (origin);
#line 229 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	return result;
#line 1680 "tp-zeitgeist.c"
}


static void folks_tp_zeitgeist_controller_class_init (FolksTpZeitgeistControllerClass * klass) {
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	folks_tp_zeitgeist_controller_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	g_type_class_add_private (klass, sizeof (FolksTpZeitgeistControllerPrivate));
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	G_OBJECT_CLASS (klass)->finalize = folks_tp_zeitgeist_controller_finalize;
#line 1691 "tp-zeitgeist.c"
}


static void folks_tp_zeitgeist_controller_instance_init (FolksTpZeitgeistController * self) {
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv = FOLKS_TP_ZEITGEIST_CONTROLLER_GET_PRIVATE (self);
#line 37 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv->_log = NULL;
#line 38 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self->priv->_monitor = NULL;
#line 1702 "tp-zeitgeist.c"
}


static void folks_tp_zeitgeist_controller_finalize (GObject* obj) {
	FolksTpZeitgeistController * self;
	ZeitgeistMonitor* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TP_ZEITGEIST_TYPE_CONTROLLER, FolksTpZeitgeistController);
#line 64 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_tmp0_ = self->priv->_monitor;
#line 64 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	if (_tmp0_ != NULL) {
#line 1716 "tp-zeitgeist.c"
		ZeitgeistLog* _tmp1_ = NULL;
		ZeitgeistMonitor* _tmp2_ = NULL;
		ZeitgeistMonitor* _tmp3_ = NULL;
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp1_ = self->priv->_log;
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp2_ = self->priv->_monitor;
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		zeitgeist_log_remove_monitor (_tmp1_, _tmp3_, &_inner_error_);
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		if (_inner_error_ != NULL) {
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
			g_clear_error (&_inner_error_);
#line 1734 "tp-zeitgeist.c"
		}
#line 67 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		_g_object_unref0 (self->priv->_monitor);
#line 67 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
		self->priv->_monitor = NULL;
#line 1740 "tp-zeitgeist.c"
	}
#line 37 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_object_unref0 (self->priv->_log);
#line 38 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_object_unref0 (self->priv->_monitor);
#line 39 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	_g_free0 (self->priv->_protocol);
#line 35 "/home/treitter/collabora/folks/backends/telepathy/lib/tp-zeitgeist.vala"
	G_OBJECT_CLASS (folks_tp_zeitgeist_controller_parent_class)->finalize (obj);
#line 1750 "tp-zeitgeist.c"
}


/**
 * Zeitgeist code for libfolks-telepathy.la. This is separated out from
 * tpf-persona-store.vala so that it can be conditionally compiled out.
 *
 * See the note in Makefile.am, and
 * [[https://bugzilla.gnome.org/show_bug.cgi?id=701099]].
 */
GType folks_tp_zeitgeist_controller_get_type (void) {
	static volatile gsize folks_tp_zeitgeist_controller_type_id__volatile = 0;
	if (g_once_init_enter (&folks_tp_zeitgeist_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksTpZeitgeistControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_tp_zeitgeist_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksTpZeitgeistController), 0, (GInstanceInitFunc) folks_tp_zeitgeist_controller_instance_init, NULL };
		GType folks_tp_zeitgeist_controller_type_id;
		folks_tp_zeitgeist_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksTpZeitgeistController", &g_define_type_info, 0);
		g_once_init_leave (&folks_tp_zeitgeist_controller_type_id__volatile, folks_tp_zeitgeist_controller_type_id);
	}
	return folks_tp_zeitgeist_controller_type_id__volatile;
}



